/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.jfc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.jfr.Configuration;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.jfc.JFCParser;

public final class JFC {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAXIMUM_FILE_SIZE = 0x100000;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static volatile List<KnownConfiguration> knownConfigurations;

    private JFC() {
    }

    public static Configuration create(String string, Reader reader) throws IOException, ParseException {
        return JFCParser.createConfiguration(string, reader);
    }

    private static String nullSafeFileName(Path path) throws IOException {
        Path path2 = path.getFileName();
        if (path2 == null) {
            throw new IOException("Path has no file name");
        }
        return path2.toString();
    }

    public static String nameFromPath(Path path) throws IOException {
        String string = JFC.nullSafeFileName(path);
        return string.substring(0, string.length() - ".jfc".length());
    }

    public static Configuration createKnown(String string) throws IOException, ParseException {
        Object object;
        String string22;
        for (KnownConfiguration object22 : JFC.getKnownConfigurations()) {
            if (!object22.isNamed(string)) continue;
            return object22.getConfigurationFile();
        }
        SecuritySupport.SafePath safePath = SecuritySupport.JFC_DIRECTORY;
        if (safePath != null && SecuritySupport.exists(safePath)) {
            for (String string22 : Arrays.asList("", ".jfc")) {
                object = new SecuritySupport.SafePath(safePath.toPath().resolveSibling(string + string22));
                if (!SecuritySupport.exists((SecuritySupport.SafePath)object) || SecuritySupport.isDirectory((SecuritySupport.SafePath)object)) continue;
                try (Reader reader = SecuritySupport.newFileReader((SecuritySupport.SafePath)object);){
                    String string3 = JFC.nameFromPath(((SecuritySupport.SafePath)object).toPath());
                    Configuration configuration = JFCParser.createConfiguration(string3, reader);
                    return configuration;
                }
            }
        }
        Path path = Paths.get(string, new String[0]);
        string22 = JFC.nameFromPath(path);
        object = Files.newBufferedReader(path);
        Throwable throwable = null;
        try {
            Configuration configuration = JFCParser.createConfiguration(string22, (Reader)object);
            return configuration;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((Reader)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((Reader)object).close();
                }
            }
        }
    }

    private static String readContent(InputStream inputStream) throws IOException {
        byte[] byArray = JFC.read(inputStream, 8192);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static byte[] read(InputStream inputStream, int n) throws IOException {
        int n2 = n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = inputStream.read(byArray, n3, n2 - n3)) > 0) {
                n3 += n4;
                continue;
            }
            if (n4 < 0 || (n4 = inputStream.read()) < 0) break;
            if (n2 <= 0x7FFFFFF7 - n2) {
                n2 = Math.max(n2 << 1, 8192);
            } else {
                if (n2 == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                n2 = 0x7FFFFFF7;
            }
            byArray = Arrays.copyOf(byArray, n2);
            byArray[n3++] = (byte)n4;
        }
        return n2 == n3 ? byArray : Arrays.copyOf(byArray, n3);
    }

    public static List<Configuration> getConfigurations() {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (KnownConfiguration knownConfiguration : JFC.getKnownConfigurations()) {
            try {
                arrayList.add(knownConfiguration.getConfigurationFile());
            }
            catch (IOException iOException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not load configuration " + knownConfiguration.getName() + ". " + iOException.getMessage());
            }
            catch (ParseException parseException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not parse configuration " + knownConfiguration.getName() + ". " + parseException.getMessage());
            }
        }
        return arrayList;
    }

    private static List<KnownConfiguration> getKnownConfigurations() {
        if (knownConfigurations == null) {
            ArrayList<KnownConfiguration> arrayList = new ArrayList<KnownConfiguration>();
            for (SecuritySupport.SafePath safePath : SecuritySupport.getPredefinedJFCFiles()) {
                try {
                    arrayList.add(new KnownConfiguration(safePath));
                }
                catch (IOException iOException) {}
            }
            knownConfigurations = arrayList;
        }
        return knownConfigurations;
    }

    public static Configuration getPredefined(String string) throws IOException, ParseException {
        for (KnownConfiguration knownConfiguration : JFC.getKnownConfigurations()) {
            if (!knownConfiguration.getName().equals(string)) continue;
            return knownConfiguration.getConfigurationFile();
        }
        throw new NoSuchFileException("Could not locate configuration with name " + string);
    }

    private static final class KnownConfiguration {
        private final String content;
        private final String filename;
        private final String name;
        private Configuration configuration;

        public KnownConfiguration(SecuritySupport.SafePath safePath) throws IOException {
            this.content = KnownConfiguration.readContent(safePath);
            this.name = JFC.nameFromPath(safePath.toPath());
            this.filename = JFC.nullSafeFileName(safePath.toPath());
        }

        public boolean isNamed(String string) {
            return this.filename.equals(string) || this.name.equals(string);
        }

        public Configuration getConfigurationFile() throws IOException, ParseException {
            if (this.configuration == null) {
                this.configuration = JFCParser.createConfiguration(this.name, this.content);
            }
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        private static String readContent(SecuritySupport.SafePath safePath) throws IOException {
            if (SecuritySupport.getFileSize(safePath) > 0x100000L) {
                throw new IOException("Configuration with more than 1048576 characters can't be read.");
            }
            try (InputStream inputStream = SecuritySupport.newFileInputStream(safePath);){
                String string = JFC.readContent(inputStream);
                return string;
            }
        }
    }
}

