/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdDump
extends AbstractDCmd {
    DCmdDump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String string, String string2, Long l, Long l2, String string3, String string4, Boolean bl) throws DCmdException {
        if (LogTag.JFR_DCMD.shouldLog(LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdDump: name=" + string + ", filename=" + string2 + ", maxage=" + l + ", maxsize=" + l2 + ", begin=" + string3 + ", end" + string4 + ", path-to-gc-roots=" + bl);
        }
        if (FlightRecorder.getFlightRecorder().getRecordings().isEmpty()) {
            throw new DCmdException("No recordings to dump from. Use JFR.start to start a recording.", new Object[0]);
        }
        if (l != null) {
            if (string4 != null || string3 != null) {
                throw new DCmdException("Dump failed, maxage can't be combined with begin or end.", new Object[0]);
            }
            if (l < 0L) {
                throw new DCmdException("Dump failed, maxage can't be negative.", new Object[0]);
            }
            if (l == 0L) {
                l = 0x3FFFFFFFFFFFFFFFL;
            }
        }
        if (l2 != null) {
            if (l2 < 0L) {
                throw new DCmdException("Dump failed, maxsize can't be negative.", new Object[0]);
            }
            if (l2 == 0L) {
                l2 = 0x3FFFFFFFFFFFFFFFL;
            }
        }
        Instant instant = this.parseTime(string3, "begin");
        Instant instant2 = this.parseTime(string4, "end");
        if (instant != null && instant2 != null && instant2.isBefore(instant)) {
            throw new DCmdException("Dump failed, begin must preceed end.", new Object[0]);
        }
        Duration duration = null;
        if (l != null) {
            duration = Duration.ofNanos(l);
            instant = Instant.now().minus(duration);
        }
        Recording recording = null;
        if (string != null) {
            recording = this.findRecording(string);
        }
        PlatformRecorder platformRecorder = PrivateAccess.getInstance().getPlatformRecorder();
        try {
            PlatformRecorder platformRecorder2 = platformRecorder;
            synchronized (platformRecorder2) {
                this.dump(platformRecorder, recording, string, string2, l2, bl, instant, instant2);
            }
        }
        catch (IOException | InvalidPathException exception) {
            throw new DCmdException("Dump failed. Could not copy recording data. %s", exception.getMessage());
        }
        return this.getResult();
    }

    public void dump(PlatformRecorder platformRecorder, Recording recording, String string, String string2, Long l, Boolean bl, Instant instant, Instant instant2) throws DCmdException, IOException {
        try (PlatformRecording platformRecording = this.newSnapShot(platformRecorder, recording, bl);){
            Object object;
            platformRecording.filter(instant, instant2, l);
            if (platformRecording.getChunks().isEmpty()) {
                throw new DCmdException("Dump failed. No data found in the specified interval.", new Object[0]);
            }
            WriteableUserPath writeableUserPath = null;
            if (recording != null) {
                object = PrivateAccess.getInstance().getPlatformRecording(recording);
                writeableUserPath = ((PlatformRecording)object).getDestination();
            }
            if (string2 != null || string2 == null && writeableUserPath == null) {
                object = this.resolvePath(recording, string2);
                writeableUserPath = new WriteableUserPath(((SecuritySupport.SafePath)object).toPath());
            }
            platformRecording.dumpStopped(writeableUserPath);
            this.reportOperationComplete("Dumped", string, new SecuritySupport.SafePath(writeableUserPath.getRealPathText()));
        }
    }

    private Instant parseTime(String string, String string2) throws DCmdException {
        if (string == null) {
            return null;
        }
        try {
            return Instant.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(string);
                return ZonedDateTime.of(localDateTime, ZoneId.systemDefault()).toInstant();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    LocalTime localTime = LocalTime.parse(string);
                    LocalDate localDate = LocalDate.now();
                    Instant instant = ZonedDateTime.of(localDate, localTime, ZoneId.systemDefault()).toInstant();
                    Instant instant2 = Instant.now();
                    if (instant.isAfter(instant2) && !instant.isBefore(instant2.plusSeconds(3600L))) {
                        localDate = localDate.minusDays(1L);
                    }
                    return ZonedDateTime.of(localDate, localTime, ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    if (string.startsWith("-")) {
                        try {
                            long l = Utils.parseTimespan(string.substring(1));
                            Duration duration = Duration.ofNanos(l);
                            return Instant.now().minus(duration);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    throw new DCmdException("Dump failed, not a valid %s time.", string2);
                }
            }
        }
    }

    private PlatformRecording newSnapShot(PlatformRecorder platformRecorder, Recording recording, Boolean bl) throws DCmdException, IOException {
        if (recording == null) {
            PlatformRecording platformRecording = platformRecorder.newTemporaryRecording();
            platformRecorder.fillWithRecordedData(platformRecording, bl);
            return platformRecording;
        }
        PlatformRecording platformRecording = PrivateAccess.getInstance().getPlatformRecording(recording);
        return platformRecording.newSnapshotClone("Dumped by user", bl);
    }
}

