/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.Utils;

@Exported
public final class FlightRecorder {
    private static volatile FlightRecorder platformRecorder;
    private static volatile boolean initialized;
    private final PlatformRecorder internal;

    private FlightRecorder(PlatformRecorder platformRecorder) {
        this.internal = platformRecorder;
    }

    public List<Recording> getRecordings() {
        ArrayList<Recording> arrayList = new ArrayList<Recording>();
        for (PlatformRecording platformRecording : this.internal.getRecordings()) {
            arrayList.add(platformRecording.getRecording());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Recording takeSnapshot() {
        Recording recording = new Recording();
        recording.setName("Snapshot");
        this.internal.fillWithRecordedData(recording.getInternal(), null);
        return recording;
    }

    public static void register(Class<? extends Event> clazz) {
        Objects.requireNonNull(clazz);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(clazz);
        MetadataRepository.getInstance().register(clazz);
    }

    public static void unregister(Class<? extends Event> clazz) {
        Objects.requireNonNull(clazz);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(clazz);
        MetadataRepository.getInstance().unregister(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlightRecorder getFlightRecorder() throws IllegalStateException, SecurityException {
        Class<PlatformRecorder> clazz = PlatformRecorder.class;
        synchronized (PlatformRecorder.class) {
            Utils.checkAccessFlightRecorder();
            JVMSupport.ensureWithIllegalStateException();
            if (platformRecorder == null) {
                try {
                    platformRecorder = new FlightRecorder(new PlatformRecorder());
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Can't create Flight Recorder. " + exception.getMessage(), exception);
                }
                initialized = true;
                Logger.log(LogTag.JFR, LogLevel.INFO, "Flight Recorder initialized");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "maxchunksize: " + Options.getMaxChunkSize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "memorysize: " + Options.getMemorySize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "globalbuffersize: " + Options.getGlobalBufferSize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "globalbuffercount: " + Options.getGlobalBufferCount());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "dumppath: " + Options.getDumpPath());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "samplethreads: " + Options.getSampleThreads());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "stackdepth: " + Options.getStackDepth());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "threadbuffersize: " + Options.getThreadBufferSize());
                Logger.log(LogTag.JFR, LogLevel.INFO, "Created repository " + Repository.getRepository().getRepositoryPath().toString());
                PlatformRecorder.notifyRecorderInitialized(platformRecorder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return platformRecorder;
        }
    }

    public static void addPeriodicEvent(Class<? extends Event> clazz, Runnable runnable) throws SecurityException {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(runnable);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(clazz);
        Utils.checkRegisterPermission();
        AccessControlContext accessControlContext = AccessController.getContext();
        RequestEngine.addHook(accessControlContext, EventType.getEventType(clazz).getPlatformEventType(), runnable);
    }

    public static boolean removePeriodicEvent(Runnable runnable) throws SecurityException {
        Objects.requireNonNull(runnable);
        Utils.checkRegisterPermission();
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return RequestEngine.removeHook(runnable);
    }

    public List<EventType> getEventTypes() {
        return Collections.unmodifiableList(MetadataRepository.getInstance().getRegisteredEventTypes());
    }

    public static void addListener(FlightRecorderListener flightRecorderListener) {
        Objects.requireNonNull(flightRecorderListener);
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        PlatformRecorder.addListener(flightRecorderListener);
    }

    public static boolean removeListener(FlightRecorderListener flightRecorderListener) {
        Objects.requireNonNull(flightRecorderListener);
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return PlatformRecorder.removeListener(flightRecorderListener);
    }

    public static boolean isAvailable() {
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return JVM.getJVM().isAvailable();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    PlatformRecorder getInternal() {
        return this.internal;
    }
}

