/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.internal.security.signature.Reference;
import com.sun.org.apache.xml.internal.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.internal.security.signature.VerifiedReference;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Manifest
extends SignatureElementProxy {
    public static final int MAXIMUM_REFERENCE_COUNT = 30;
    private static final Logger LOG = Logger.getLogger(Manifest.class.getName());
    private static Integer referenceCount = AccessController.doPrivileged(() -> Integer.parseInt(System.getProperty("com.sun.org.apache.xml.internal.security.maxReferences", Integer.toString(30))));
    private List<Reference> references;
    private Element[] referencesEl;
    private List<VerifiedReference> verificationResults;
    private Map<String, String> resolverProperties;
    private List<ResourceResolver> perManifestResolvers;
    private boolean secureValidation;

    public Manifest(Document document) {
        super(document);
        this.addReturnToSelf();
        this.references = new ArrayList<Reference>();
    }

    public Manifest(Element element, String string) throws XMLSecurityException {
        this(element, string, true);
    }

    public Manifest(Element element, String string, boolean bl) throws XMLSecurityException {
        super(element, string);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
        this.secureValidation = bl;
        this.referencesEl = XMLUtils.selectDsNodes(this.getFirstChild(), "Reference");
        int n = this.referencesEl.length;
        if (n == 0) {
            Object[] objectArray = new Object[]{"Reference", "Manifest"};
            throw new DOMException(4, I18n.translate("xml.WrongContent", objectArray));
        }
        if (bl && n > referenceCount) {
            Object[] objectArray = new Object[]{n, referenceCount};
            throw new XMLSecurityException("signature.tooManyReferences", objectArray);
        }
        this.references = new ArrayList<Reference>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = this.referencesEl[i];
            Attr attr2 = element2.getAttributeNodeNS(null, "Id");
            if (attr2 != null) {
                element2.setIdAttributeNode(attr2, true);
            }
            this.references.add(null);
        }
    }

    public void addDocument(String string, String string2, Transforms transforms, String string3, String string4, String string5) throws XMLSignatureException {
        Reference reference = new Reference(this.getDocument(), string, string2, this, transforms, string3);
        if (string4 != null) {
            reference.setId(string4);
        }
        if (string5 != null) {
            reference.setType(string5);
        }
        this.references.add(reference);
        this.appendSelf(reference);
        this.addReturnToSelf();
    }

    public void generateDigestValues() throws XMLSignatureException, ReferenceNotInitializedException {
        for (int i = 0; i < this.getLength(); ++i) {
            Reference reference = this.references.get(i);
            reference.generateDigestValue();
        }
    }

    public int getLength() {
        return this.references.size();
    }

    public Reference item(int n) throws XMLSecurityException {
        if (this.references.get(n) == null) {
            Reference reference = new Reference(this.referencesEl[n], this.baseURI, this, this.secureValidation);
            this.references.set(n, reference);
        }
        return this.references.get(n);
    }

    public void setId(String string) {
        if (string != null) {
            this.setLocalIdAttribute("Id", string);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public boolean verifyReferences() throws MissingResourceFailureException, XMLSecurityException {
        return this.verifyReferences(false);
    }

    public boolean verifyReferences(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        if (this.referencesEl == null) {
            this.referencesEl = XMLUtils.selectDsNodes(this.getFirstChild(), "Reference");
        }
        LOG.log(Level.FINE, "verify " + this.referencesEl.length + " References");
        LOG.log(Level.FINE, "I am {} requested to follow nested Manifests", bl ? "" : "not");
        if (this.referencesEl.length == 0) {
            throw new XMLSecurityException("empty", new Object[]{"References are empty"});
        }
        if (this.secureValidation && this.referencesEl.length > referenceCount) {
            Object[] objectArray = new Object[]{this.referencesEl.length, referenceCount};
            throw new XMLSecurityException("signature.tooManyReferences", objectArray);
        }
        this.verificationResults = new ArrayList<VerifiedReference>(this.referencesEl.length);
        boolean bl2 = true;
        for (int i = 0; i < this.referencesEl.length; ++i) {
            Object object;
            Reference reference = new Reference(this.referencesEl[i], this.baseURI, this, this.secureValidation);
            this.references.set(i, reference);
            try {
                boolean bl3 = reference.verify();
                if (!bl3) {
                    bl2 = false;
                }
                LOG.log(Level.FINE, "The Reference has Type " + reference.getType() + "");
                object = Collections.emptyList();
                if (bl2 && bl && reference.typeIsReferenceToManifest()) {
                    LOG.log(Level.FINE, "We have to follow a nested Manifest");
                    try {
                        XMLSignatureInput xMLSignatureInput = reference.dereferenceURIandPerformTransforms(null);
                        Set<Node> set = xMLSignatureInput.getNodeSet();
                        Manifest manifest = null;
                        for (Node node : set) {
                            if (node.getNodeType() != 1 || !((Element)node).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !((Element)node).getLocalName().equals("Manifest")) continue;
                            try {
                                manifest = new Manifest((Element)node, xMLSignatureInput.getSourceURI(), this.secureValidation);
                                break;
                            }
                            catch (XMLSecurityException xMLSecurityException) {
                                LOG.log(Level.FINE, xMLSecurityException.getMessage(), xMLSecurityException);
                            }
                        }
                        if (manifest == null) {
                            throw new MissingResourceFailureException(reference, "empty", new Object[]{"No Manifest found"});
                        }
                        manifest.perManifestResolvers = this.perManifestResolvers;
                        manifest.resolverProperties = this.resolverProperties;
                        boolean bl4 = manifest.verifyReferences(bl);
                        if (!bl4) {
                            bl2 = false;
                            LOG.log(Level.WARNING, "The nested Manifest was invalid (bad)");
                        } else {
                            LOG.log(Level.FINE, "The nested Manifest was valid (good)");
                        }
                        object = manifest.getVerificationResults();
                    }
                    catch (IOException iOException) {
                        throw new ReferenceNotInitializedException(iOException);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new ReferenceNotInitializedException(parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        throw new ReferenceNotInitializedException(sAXException);
                    }
                }
                this.verificationResults.add(new VerifiedReference(bl3, reference.getURI(), (List<VerifiedReference>)object));
                continue;
            }
            catch (ReferenceNotInitializedException referenceNotInitializedException) {
                object = new Object[]{reference.getURI()};
                throw new MissingResourceFailureException(referenceNotInitializedException, reference, "signature.Verification.Reference.NoInput", (Object[])object);
            }
        }
        return bl2;
    }

    public boolean getVerificationResult(int n) throws XMLSecurityException {
        if (n < 0 || n > this.getLength() - 1) {
            Object[] objectArray = new Object[]{Integer.toString(n), Integer.toString(this.getLength())};
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(I18n.translate("signature.Verification.IndexOutOfBounds", objectArray));
            throw new XMLSecurityException(indexOutOfBoundsException);
        }
        if (this.verificationResults == null) {
            try {
                this.verifyReferences();
            }
            catch (Exception exception) {
                throw new XMLSecurityException(exception);
            }
        }
        return ((VerifiedReference)((ArrayList)this.verificationResults).get(n)).isValid();
    }

    public List<VerifiedReference> getVerificationResults() {
        if (this.verificationResults == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.verificationResults);
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        if (resourceResolver == null) {
            return;
        }
        if (this.perManifestResolvers == null) {
            this.perManifestResolvers = new ArrayList<ResourceResolver>();
        }
        this.perManifestResolvers.add(resourceResolver);
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        if (resourceResolverSpi == null) {
            return;
        }
        if (this.perManifestResolvers == null) {
            this.perManifestResolvers = new ArrayList<ResourceResolver>();
        }
        this.perManifestResolvers.add(new ResourceResolver(resourceResolverSpi));
    }

    public List<ResourceResolver> getPerManifestResolvers() {
        return this.perManifestResolvers;
    }

    public Map<String, String> getResolverProperties() {
        return this.resolverProperties;
    }

    public void setResolverProperty(String string, String string2) {
        if (this.resolverProperties == null) {
            this.resolverProperties = new HashMap<String, String>(10);
        }
        this.resolverProperties.put(string, string2);
    }

    public String getResolverProperty(String string) {
        return this.resolverProperties.get(string);
    }

    public byte[] getSignedContentItem(int n) throws XMLSignatureException {
        try {
            return this.getReferencedContentAfterTransformsItem(n).getBytes();
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException(canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException(invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException(xMLSecurityException);
        }
    }

    public XMLSignatureInput getReferencedContentBeforeTransformsItem(int n) throws XMLSecurityException {
        return this.item(n).getContentsBeforeTransformation();
    }

    public XMLSignatureInput getReferencedContentAfterTransformsItem(int n) throws XMLSecurityException {
        return this.item(n).getContentsAfterTransformation();
    }

    public int getSignedContentLength() {
        return this.getLength();
    }

    @Override
    public String getBaseLocalName() {
        return "Manifest";
    }

    public boolean isSecureValidation() {
        return this.secureValidation;
    }
}

