/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage;

import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.SingleCertificateResolver;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageResolver {
    private static final Logger LOG = Logger.getLogger(StorageResolver.class.getName());
    private List<StorageResolverSpi> storageResolvers;

    public StorageResolver() {
    }

    public StorageResolver(StorageResolverSpi storageResolverSpi) {
        this.add(storageResolverSpi);
    }

    public void add(StorageResolverSpi storageResolverSpi) {
        if (this.storageResolvers == null) {
            this.storageResolvers = new ArrayList<StorageResolverSpi>();
        }
        this.storageResolvers.add(storageResolverSpi);
    }

    public StorageResolver(KeyStore keyStore) {
        this.add(keyStore);
    }

    public void add(KeyStore keyStore) {
        try {
            this.add(new KeyStoreResolver(keyStore));
        }
        catch (StorageResolverException storageResolverException) {
            LOG.log(Level.SEVERE, "Could not add KeyStore because of: ", storageResolverException);
        }
    }

    public StorageResolver(X509Certificate x509Certificate) {
        this.add(x509Certificate);
    }

    public void add(X509Certificate x509Certificate) {
        this.add(new SingleCertificateResolver(x509Certificate));
    }

    public Iterator<Certificate> getIterator() {
        return new StorageResolverIterator(this.storageResolvers.iterator());
    }

    static class StorageResolverIterator
    implements Iterator<Certificate> {
        Iterator<StorageResolverSpi> resolvers = null;
        Iterator<Certificate> currentResolver = null;

        public StorageResolverIterator(Iterator<StorageResolverSpi> iterator) {
            this.resolvers = iterator;
            this.currentResolver = this.findNextResolver();
        }

        @Override
        public boolean hasNext() {
            if (this.currentResolver == null) {
                return false;
            }
            if (this.currentResolver.hasNext()) {
                return true;
            }
            this.currentResolver = this.findNextResolver();
            return this.currentResolver != null;
        }

        @Override
        public Certificate next() {
            if (this.hasNext()) {
                return this.currentResolver.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }

        private Iterator<Certificate> findNextResolver() {
            while (this.resolvers.hasNext()) {
                StorageResolverSpi storageResolverSpi = this.resolvers.next();
                Iterator<Certificate> iterator = storageResolverSpi.getIterator();
                if (!iterator.hasNext()) continue;
                return iterator;
            }
            return null;
        }
    }
}

