/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    private static final Logger LOG = Logger.getLogger(X509SKIResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            LOG.log(Level.FINE, "I can't");
            return null;
        }
        XMLX509SKI[] xMLX509SKIArray = null;
        Element[] elementArray = null;
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        if (elementArray == null || elementArray.length <= 0) {
            LOG.log(Level.FINE, "I can't");
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SKI"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                LOG.log(Level.FINE, "", keyResolverException);
                throw keyResolverException;
            }
            xMLX509SKIArray = new XMLX509SKI[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SKIArray[i] = new XMLX509SKI(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509SKI xMLX509SKI = new XMLX509SKI(element.getOwnerDocument(), x509Certificate);
                for (int i = 0; i < xMLX509SKIArray.length; ++i) {
                    if (!xMLX509SKI.equals(xMLX509SKIArray[i])) continue;
                    LOG.log(Level.FINE, "Return PublicKey from " + x509Certificate.getSubjectX500Principal().getName() + "");
                    return x509Certificate;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException(xMLSecurityException);
        }
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

