/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    private static final Logger LOG = Logger.getLogger(RetrievalMethodResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, this.secureValidation);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                if (x509Certificate != null) {
                    return x509Certificate.getPublicKey();
                }
                return null;
            }
            Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput, this.secureValidation);
            if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                if (this.secureValidation) {
                    if (LOG.isLoggable(Level.FINE)) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        LOG.log(Level.FINE, string3);
                    }
                    return null;
                }
                RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, this.secureValidation);
                Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2, this.secureValidation);
                if (element3 == element) {
                    LOG.log(Level.FINE, "Error: Can't have RetrievalMethods pointing to each other");
                    return null;
                }
            }
            return RetrievalMethodResolver.resolveKey(element2, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            LOG.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.log(Level.FINE, "ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LOG.log(Level.FINE, "SAXException", sAXException);
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, this.secureValidation);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                return RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
            }
            Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput, this.secureValidation);
            if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                if (this.secureValidation) {
                    if (LOG.isLoggable(Level.FINE)) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        LOG.log(Level.FINE, string3);
                    }
                    return null;
                }
                RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, this.secureValidation);
                Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2, this.secureValidation);
                if (element3 == element) {
                    LOG.log(Level.FINE, "Error: Can't have RetrievalMethods pointing to each other");
                    return null;
                }
            }
            return RetrievalMethodResolver.resolveCertificate(element2, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            LOG.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.log(Level.FINE, "ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LOG.log(Level.FINE, "SAXException", sAXException);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getX509Certificate(element, string, storageResolver);
        }
        return null;
    }

    private static PublicKey resolveKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getPublicKey(element, string, storageResolver);
        }
        return null;
    }

    private static Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput, boolean bl) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else if (xMLSignatureInput.isNodeSet()) {
            element = RetrievalMethodResolver.getDocumentElement(xMLSignatureInput.getNodeSet());
        } else {
            byte[] byArray = xMLSignatureInput.getBytes();
            element = RetrievalMethodResolver.getDocFromBytes(byArray, bl);
            LOG.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
        }
        return element;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, IOException, CertificateException {
        byte[] byArray = xMLSignatureInput.getBytes();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            return x509Certificate;
        }
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod retrievalMethod, String string, boolean bl) throws XMLSecurityException {
        Attr attr = retrievalMethod.getURIAttr();
        Transforms transforms = retrievalMethod.getTransforms();
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string, bl);
        XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string, bl);
        if (transforms != null) {
            LOG.log(Level.FINE, "We have Transforms");
            xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
        }
        return xMLSignatureInput;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    private static Element getDocumentElement(Set<Node> set) {
        Object object;
        Object object2;
        Iterator<Node> iterator = set.iterator();
        Node node = null;
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 == null || 1 != object2.getNodeType()) continue;
            node = (Element)object2;
            break;
        }
        object2 = new ArrayList();
        while (node != null) {
            object2.add(node);
            object = node.getParentNode();
            if (object == null || 1 != object.getNodeType()) break;
            node = (Element)object;
        }
        object = object2.listIterator(object2.size() - 1);
        Element element = null;
        while (object.hasPrevious()) {
            element = (Element)object.previous();
            if (!set.contains(element)) continue;
            return element;
        }
        return null;
    }
}

