/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openjsse.sun.security.ssl.CipherSuite;
import org.openjsse.sun.security.ssl.DHClientKeyExchange;
import org.openjsse.sun.security.ssl.DHKeyExchange;
import org.openjsse.sun.security.ssl.DHServerKeyExchange;
import org.openjsse.sun.security.ssl.ECDHClientKeyExchange;
import org.openjsse.sun.security.ssl.ECDHKeyExchange;
import org.openjsse.sun.security.ssl.ECDHServerKeyExchange;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.HandshakeProducer;
import org.openjsse.sun.security.ssl.JsseJce;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.RSAClientKeyExchange;
import org.openjsse.sun.security.ssl.RSAKeyExchange;
import org.openjsse.sun.security.ssl.RSAServerKeyExchange;
import org.openjsse.sun.security.ssl.SSLAuthentication;
import org.openjsse.sun.security.ssl.SSLConsumer;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLHandshakeBinding;
import org.openjsse.sun.security.ssl.SSLKeyAgreement;
import org.openjsse.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openjsse.sun.security.ssl.SSLKeyDerivation;
import org.openjsse.sun.security.ssl.SSLPossession;
import org.openjsse.sun.security.ssl.SSLPossessionGenerator;
import org.openjsse.sun.security.ssl.ServerHandshakeContext;
import org.openjsse.sun.security.ssl.SupportedGroupsExtension;
import org.openjsse.sun.security.ssl.X509Authentication;

final class SSLKeyExchange
implements SSLKeyAgreementGenerator,
SSLHandshakeBinding {
    private final SSLAuthentication authentication;
    private final SSLKeyAgreement keyAgreement;

    SSLKeyExchange(X509Authentication authentication, SSLKeyAgreement keyAgreement) {
        this.authentication = authentication;
        this.keyAgreement = keyAgreement;
    }

    SSLPossession[] createPossessions(HandshakeContext context) {
        SSLPossession[] sSLPossessionArray;
        SSLPossession kaPossession;
        SSLPossession authPossession = null;
        if (this.authentication != null) {
            authPossession = this.authentication.createPossession(context);
            if (authPossession == null) {
                return new SSLPossession[0];
            }
            if (context instanceof ServerHandshakeContext) {
                ServerHandshakeContext shc = (ServerHandshakeContext)context;
                shc.interimAuthn = authPossession;
            }
        }
        if (this.keyAgreement == T12KeyAgreement.RSA_EXPORT) {
            SSLPossession[] sSLPossessionArray2;
            X509Authentication.X509Possession x509Possession = (X509Authentication.X509Possession)authPossession;
            if (JsseJce.getRSAKeyLength(x509Possession.popCerts[0].getPublicKey()) > 512) {
                SSLPossession[] sSLPossessionArray3;
                kaPossession = this.keyAgreement.createPossession(context);
                if (kaPossession == null) {
                    return new SSLPossession[0];
                }
                if (this.authentication != null) {
                    SSLPossession[] sSLPossessionArray4 = new SSLPossession[2];
                    sSLPossessionArray4[0] = authPossession;
                    sSLPossessionArray3 = sSLPossessionArray4;
                    sSLPossessionArray4[1] = kaPossession;
                } else {
                    SSLPossession[] sSLPossessionArray5 = new SSLPossession[1];
                    sSLPossessionArray3 = sSLPossessionArray5;
                    sSLPossessionArray5[0] = kaPossession;
                }
                return sSLPossessionArray3;
            }
            if (this.authentication != null) {
                SSLPossession[] sSLPossessionArray6 = new SSLPossession[1];
                sSLPossessionArray2 = sSLPossessionArray6;
                sSLPossessionArray6[0] = authPossession;
            } else {
                sSLPossessionArray2 = new SSLPossession[]{};
            }
            return sSLPossessionArray2;
        }
        kaPossession = this.keyAgreement.createPossession(context);
        if (kaPossession == null) {
            if (this.keyAgreement == T12KeyAgreement.RSA || this.keyAgreement == T12KeyAgreement.ECDH) {
                SSLPossession[] sSLPossessionArray7;
                if (this.authentication != null) {
                    SSLPossession[] sSLPossessionArray8 = new SSLPossession[1];
                    sSLPossessionArray7 = sSLPossessionArray8;
                    sSLPossessionArray8[0] = authPossession;
                } else {
                    sSLPossessionArray7 = new SSLPossession[]{};
                }
                return sSLPossessionArray7;
            }
            return new SSLPossession[0];
        }
        if (this.authentication != null) {
            SSLPossession[] sSLPossessionArray9 = new SSLPossession[2];
            sSLPossessionArray9[0] = authPossession;
            sSLPossessionArray = sSLPossessionArray9;
            sSLPossessionArray9[1] = kaPossession;
        } else {
            SSLPossession[] sSLPossessionArray10 = new SSLPossession[1];
            sSLPossessionArray = sSLPossessionArray10;
            sSLPossessionArray10[0] = kaPossession;
        }
        return sSLPossessionArray;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
        return this.keyAgreement.createKeyDerivation(handshakeContext);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        SSLHandshake[] auHandshakes = this.authentication != null ? this.authentication.getRelatedHandshakers(handshakeContext) : null;
        SSLHandshake[] kaHandshakes = this.keyAgreement.getRelatedHandshakers(handshakeContext);
        if (auHandshakes == null || auHandshakes.length == 0) {
            return kaHandshakes;
        }
        if (kaHandshakes == null || kaHandshakes.length == 0) {
            return auHandshakes;
        }
        SSLHandshake[] producers = Arrays.copyOf(auHandshakes, auHandshakes.length + kaHandshakes.length);
        System.arraycopy(kaHandshakes, 0, producers, auHandshakes.length, kaHandshakes.length);
        return producers;
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        Map.Entry<Byte, HandshakeProducer>[] auProducers = this.authentication != null ? this.authentication.getHandshakeProducers(handshakeContext) : null;
        Map.Entry<Byte, HandshakeProducer>[] kaProducers = this.keyAgreement.getHandshakeProducers(handshakeContext);
        if (auProducers == null || auProducers.length == 0) {
            return kaProducers;
        }
        if (kaProducers == null || kaProducers.length == 0) {
            return auProducers;
        }
        Map.Entry<Byte, HandshakeProducer>[] producers = Arrays.copyOf(auProducers, auProducers.length + kaProducers.length);
        System.arraycopy(kaProducers, 0, producers, auProducers.length, kaProducers.length);
        return producers;
    }

    @Override
    public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
        Map.Entry<Byte, SSLConsumer>[] auConsumers = this.authentication != null ? this.authentication.getHandshakeConsumers(handshakeContext) : null;
        Map.Entry<Byte, SSLConsumer>[] kaConsumers = this.keyAgreement.getHandshakeConsumers(handshakeContext);
        if (auConsumers == null || auConsumers.length == 0) {
            return kaConsumers;
        }
        if (kaConsumers == null || kaConsumers.length == 0) {
            return auConsumers;
        }
        Map.Entry<Byte, SSLConsumer>[] producers = Arrays.copyOf(auConsumers, auConsumers.length + kaConsumers.length);
        System.arraycopy(kaConsumers, 0, producers, auConsumers.length, kaConsumers.length);
        return producers;
    }

    static SSLKeyExchange valueOf(CipherSuite.KeyExchange keyExchange, ProtocolVersion protocolVersion) {
        if (keyExchange == null || protocolVersion == null) {
            return null;
        }
        switch (keyExchange) {
            case K_RSA: {
                return SSLKeyExRSA.KE;
            }
            case K_RSA_EXPORT: {
                return SSLKeyExRSAExport.KE;
            }
            case K_DHE_DSS: {
                return SSLKeyExDHEDSS.KE;
            }
            case K_DHE_DSS_EXPORT: {
                return SSLKeyExDHEDSSExport.KE;
            }
            case K_DHE_RSA: {
                if (protocolVersion.useTLS12PlusSpec()) {
                    return SSLKeyExDHERSAOrPSS.KE;
                }
                return SSLKeyExDHERSA.KE;
            }
            case K_DHE_RSA_EXPORT: {
                return SSLKeyExDHERSAExport.KE;
            }
            case K_DH_ANON: {
                return SSLKeyExDHANON.KE;
            }
            case K_DH_ANON_EXPORT: {
                return SSLKeyExDHANONExport.KE;
            }
            case K_ECDH_ECDSA: {
                return SSLKeyExECDHECDSA.KE;
            }
            case K_ECDH_RSA: {
                return SSLKeyExECDHRSA.KE;
            }
            case K_ECDHE_ECDSA: {
                return SSLKeyExECDHEECDSA.KE;
            }
            case K_ECDHE_RSA: {
                if (protocolVersion.useTLS12PlusSpec()) {
                    return SSLKeyExECDHERSAOrPSS.KE;
                }
                return SSLKeyExECDHERSA.KE;
            }
            case K_ECDH_ANON: {
                return SSLKeyExECDHANON.KE;
            }
        }
        return null;
    }

    static SSLKeyExchange valueOf(SupportedGroupsExtension.NamedGroup namedGroup) {
        T13KeyAgreement ka = T13KeyAgreement.valueOf(namedGroup);
        if (ka != null) {
            return new SSLKeyExchange(null, T13KeyAgreement.valueOf(namedGroup));
        }
        return null;
    }

    private static final class T13KeyAgreement
    implements SSLKeyAgreement {
        private final SupportedGroupsExtension.NamedGroup namedGroup;
        static final Map<SupportedGroupsExtension.NamedGroup, T13KeyAgreement> supportedKeyShares = new HashMap<SupportedGroupsExtension.NamedGroup, T13KeyAgreement>();

        private T13KeyAgreement(SupportedGroupsExtension.NamedGroup namedGroup) {
            this.namedGroup = namedGroup;
        }

        static T13KeyAgreement valueOf(SupportedGroupsExtension.NamedGroup namedGroup) {
            return supportedKeyShares.get((Object)namedGroup);
        }

        @Override
        public SSLPossession createPossession(HandshakeContext hc) {
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                return new ECDHKeyExchange.ECDHEPossession(this.namedGroup, hc.sslContext.getSecureRandom());
            }
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                return new DHKeyExchange.DHEPossession(this.namedGroup, hc.sslContext.getSecureRandom());
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext hc) throws IOException {
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                return ECDHKeyExchange.ecdheKAGenerator.createKeyDerivation(hc);
            }
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                return DHKeyExchange.kaGenerator.createKeyDerivation(hc);
            }
            return null;
        }

        static {
            for (SupportedGroupsExtension.NamedGroup namedGroup : SupportedGroupsExtension.SupportedGroups.supportedNamedGroups) {
                supportedKeyShares.put(namedGroup, new T13KeyAgreement(namedGroup));
            }
        }
    }

    private static enum T12KeyAgreement implements SSLKeyAgreement
    {
        RSA("rsa", null, RSAKeyExchange.kaGenerator),
        RSA_EXPORT("rsa_export", RSAKeyExchange.poGenerator, RSAKeyExchange.kaGenerator),
        DHE("dhe", DHKeyExchange.poGenerator, DHKeyExchange.kaGenerator),
        DHE_EXPORT("dhe_export", DHKeyExchange.poExportableGenerator, DHKeyExchange.kaGenerator),
        ECDH("ecdh", null, ECDHKeyExchange.ecdhKAGenerator),
        ECDHE("ecdhe", ECDHKeyExchange.poGenerator, ECDHKeyExchange.ecdheKAGenerator);

        final String name;
        final SSLPossessionGenerator possessionGenerator;
        final SSLKeyAgreementGenerator keyAgreementGenerator;

        private T12KeyAgreement(String name, SSLPossessionGenerator possessionGenerator, SSLKeyAgreementGenerator keyAgreementGenerator) {
            this.name = name;
            this.possessionGenerator = possessionGenerator;
            this.keyAgreementGenerator = keyAgreementGenerator;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            if (this.possessionGenerator != null) {
                return this.possessionGenerator.createPossession(context);
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            return this.keyAgreementGenerator.createKeyDerivation(context);
        }

        @Override
        public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
            if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec() && this.possessionGenerator != null) {
                return new SSLHandshake[]{SSLHandshake.SERVER_KEY_EXCHANGE};
            }
            return new SSLHandshake[0];
        }

        @Override
        public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case RSA: 
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, RSAClientKeyExchange.rsaHandshakeProducer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, DHClientKeyExchange.DHClientKeyExchangeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, DHClientKeyExchange.dhHandshakeProducer)};
                    }
                    case ECDH: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdhHandshakeProducer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdheHandshakeProducer)};
                    }
                }
            } else {
                switch (this) {
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, RSAServerKeyExchange.rsaHandshakeProducer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, DHServerKeyExchange.dhHandshakeProducer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, ECDHServerKeyExchange.ecdheHandshakeProducer)};
                    }
                }
            }
            return new Map.Entry[0];
        }

        @Override
        public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, RSAServerKeyExchange.rsaHandshakeConsumer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, DHServerKeyExchange.dhHandshakeConsumer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, ECDHServerKeyExchange.ecdheHandshakeConsumer)};
                    }
                }
            } else {
                switch (this) {
                    case RSA: 
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, RSAClientKeyExchange.rsaHandshakeConsumer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, DHClientKeyExchange.DHClientKeyExchangeConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, DHClientKeyExchange.dhHandshakeConsumer)};
                    }
                    case ECDH: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdhHandshakeConsumer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdheHandshakeConsumer)};
                    }
                }
            }
            return new Map.Entry[0];
        }
    }

    private static class SSLKeyExECDHANON {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHANON() {
        }
    }

    private static class SSLKeyExECDHERSAOrPSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA_OR_PSS, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHERSAOrPSS() {
        }
    }

    private static class SSLKeyExECDHERSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHERSA() {
        }
    }

    private static class SSLKeyExECDHEECDSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHEECDSA() {
        }
    }

    private static class SSLKeyExECDHRSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDH);

        private SSLKeyExECDHRSA() {
        }
    }

    private static class SSLKeyExECDHECDSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDH);

        private SSLKeyExECDHECDSA() {
        }
    }

    private static class SSLKeyExDHANONExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHANONExport() {
        }
    }

    private static class SSLKeyExDHANON {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.DHE);

        private SSLKeyExDHANON() {
        }
    }

    private static class SSLKeyExDHERSAExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHERSAExport() {
        }
    }

    private static class SSLKeyExDHERSAOrPSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA_OR_PSS, T12KeyAgreement.DHE);

        private SSLKeyExDHERSAOrPSS() {
        }
    }

    private static class SSLKeyExDHERSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.DHE);

        private SSLKeyExDHERSA() {
        }
    }

    private static class SSLKeyExDHEDSSExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.DSA, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHEDSSExport() {
        }
    }

    private static class SSLKeyExDHEDSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.DSA, T12KeyAgreement.DHE);

        private SSLKeyExDHEDSS() {
        }
    }

    private static class SSLKeyExRSAExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.RSA_EXPORT);

        private SSLKeyExRSAExport() {
        }
    }

    private static class SSLKeyExRSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.RSA);

        private SSLKeyExRSA() {
        }
    }
}

