/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;
import org.openjsse.sun.security.ssl.Alert;
import org.openjsse.sun.security.ssl.ClientHandshakeContext;
import org.openjsse.sun.security.ssl.ConnectionContext;
import org.openjsse.sun.security.ssl.HandshakeConsumer;
import org.openjsse.sun.security.ssl.HandshakeProducer;
import org.openjsse.sun.security.ssl.Record;
import org.openjsse.sun.security.ssl.SSLExtension;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLLogger;
import org.openjsse.sun.security.ssl.SSLStringizer;
import org.openjsse.sun.security.ssl.ServerHandshakeContext;

final class CertificateAuthorityExtension {
    static final HandshakeProducer chNetworkProducer = new CHCertificateAuthoritiesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCertificateAuthoritiesConsumer();
    static final HandshakeConsumer chOnTradeConsumer = new CHCertificateAuthoritiesUpdate();
    static final HandshakeProducer crNetworkProducer = new CRCertificateAuthoritiesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRCertificateAuthoritiesConsumer();
    static final HandshakeConsumer crOnTradeConsumer = new CRCertificateAuthoritiesUpdate();
    static final SSLStringizer ssStringizer = new CertificateAuthoritiesStringizer();

    CertificateAuthorityExtension() {
    }

    private static final class CRCertificateAuthoritiesUpdate
    implements HandshakeConsumer {
        private CRCertificateAuthoritiesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            CertificateAuthoritiesSpec spec = (CertificateAuthoritiesSpec)chc.handshakeExtensions.get(SSLExtension.CR_CERTIFICATE_AUTHORITIES);
            if (spec == null) {
                return;
            }
            chc.peerSupportedAuthorities = spec.getAuthorities();
        }
    }

    private static final class CRCertificateAuthoritiesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRCertificateAuthoritiesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            CertificateAuthoritiesSpec spec;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CR_CERTIFICATE_AUTHORITIES)) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No available certificate_authority extension for client certificate authentication");
            }
            try {
                spec = new CertificateAuthoritiesSpec(buffer);
            }
            catch (IOException ioe) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            chc.handshakeExtensions.put(SSLExtension.CR_CERTIFICATE_AUTHORITIES, spec);
        }
    }

    private static final class CRCertificateAuthoritiesProducer
    implements HandshakeProducer {
        private CRCertificateAuthoritiesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CR_CERTIFICATE_AUTHORITIES)) {
                throw shc.conContext.fatal(Alert.MISSING_EXTENSION, "No available certificate_authority extension for client certificate authentication");
            }
            if (shc.localSupportedAuthorities == null) {
                X509Certificate[] caCerts = shc.sslContext.getX509TrustManager().getAcceptedIssuers();
                ArrayList authList = new ArrayList(caCerts.length);
                for (X509Certificate cert : caCerts) {
                    authList.add(cert.getSubjectX500Principal());
                }
                if (!authList.isEmpty()) {
                    shc.localSupportedAuthorities = authList;
                }
            }
            if (shc.localSupportedAuthorities == null) {
                return null;
            }
            int vectorLen = 0;
            for (X500Principal ca : shc.localSupportedAuthorities) {
                vectorLen += ca.getEncoded().length + 2;
            }
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (X500Principal ca : shc.localSupportedAuthorities) {
                Record.putBytes16(m, ca.getEncoded());
            }
            shc.handshakeExtensions.put(SSLExtension.CR_CERTIFICATE_AUTHORITIES, new CertificateAuthoritiesSpec(shc.localSupportedAuthorities));
            return extData;
        }
    }

    private static final class CHCertificateAuthoritiesUpdate
    implements HandshakeConsumer {
        private CHCertificateAuthoritiesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            CertificateAuthoritiesSpec spec = (CertificateAuthoritiesSpec)shc.handshakeExtensions.get(SSLExtension.CH_CERTIFICATE_AUTHORITIES);
            if (spec == null) {
                return;
            }
            shc.peerSupportedAuthorities = spec.getAuthorities();
        }
    }

    private static final class CHCertificateAuthoritiesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertificateAuthoritiesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            CertificateAuthoritiesSpec spec;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CH_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return;
            }
            try {
                spec = new CertificateAuthoritiesSpec(buffer);
            }
            catch (IOException ioe) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            shc.handshakeExtensions.put(SSLExtension.CH_CERTIFICATE_AUTHORITIES, spec);
        }
    }

    private static final class CHCertificateAuthoritiesProducer
    implements HandshakeProducer {
        private CHCertificateAuthoritiesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CH_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return null;
            }
            if (chc.localSupportedAuthorities == null) {
                X509Certificate[] caCerts = chc.sslContext.getX509TrustManager().getAcceptedIssuers();
                ArrayList authList = new ArrayList(caCerts.length);
                for (X509Certificate cert : caCerts) {
                    authList.add(cert.getSubjectX500Principal());
                }
                if (!authList.isEmpty()) {
                    chc.localSupportedAuthorities = authList;
                }
            }
            if (chc.localSupportedAuthorities == null) {
                return null;
            }
            int vectorLen = 0;
            for (X500Principal ca : chc.localSupportedAuthorities) {
                vectorLen += ca.getEncoded().length + 2;
            }
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (X500Principal ca : chc.localSupportedAuthorities) {
                Record.putBytes16(m, ca.getEncoded());
            }
            chc.handshakeExtensions.put(SSLExtension.CH_CERTIFICATE_AUTHORITIES, new CertificateAuthoritiesSpec(chc.localSupportedAuthorities));
            return extData;
        }
    }

    private static final class CertificateAuthoritiesStringizer
    implements SSLStringizer {
        private CertificateAuthoritiesStringizer() {
        }

        @Override
        public String toString(ByteBuffer buffer) {
            try {
                return new CertificateAuthoritiesSpec(buffer).toString();
            }
            catch (IOException ioe) {
                return ioe.getMessage();
            }
        }
    }

    static final class CertificateAuthoritiesSpec
    implements SSLExtension.SSLExtensionSpec {
        final X500Principal[] authorities;

        CertificateAuthoritiesSpec(List<X500Principal> authorities) {
            if (authorities != null) {
                this.authorities = new X500Principal[authorities.size()];
                int i = 0;
                for (X500Principal name : authorities) {
                    this.authorities[i++] = name;
                }
            } else {
                this.authorities = new X500Principal[0];
            }
        }

        CertificateAuthoritiesSpec(ByteBuffer buffer) throws IOException {
            if (buffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid signature_algorithms: insufficient data");
            }
            int caLength = Record.getInt16(buffer);
            if (buffer.remaining() != caLength) {
                throw new SSLProtocolException("Invalid certificate_authorities: incorrect data size");
            }
            ArrayList<X500Principal> dnList = new ArrayList<X500Principal>();
            while (buffer.remaining() > 0) {
                byte[] dn = Record.getBytes16(buffer);
                X500Principal ca = new X500Principal(dn);
                dnList.add(ca);
            }
            this.authorities = dnList.toArray(new X500Principal[dnList.size()]);
        }

        X500Principal[] getAuthorities() {
            return this.authorities;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"certificate authorities\": '['{0}']'", Locale.ENGLISH);
            if (this.authorities == null || this.authorities.length == 0) {
                Object[] messageFields = new Object[]{"<no supported certificate authorities specified>"};
                return messageFormat.format(messageFields);
            }
            StringBuilder builder = new StringBuilder(512);
            boolean isFirst = true;
            for (X500Principal ca : this.authorities) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append("]; [");
                }
                builder.append(ca);
            }
            Object[] messageFields = new Object[]{builder.toString()};
            return messageFormat.format(messageFields);
        }
    }
}

