/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.openjsse.com.sun.crypto.provider.KeyGeneratorCore;

public final class ChaCha20KeyGenerator
extends KeyGeneratorSpi {
    private final KeyGeneratorCore core = new KeyGeneratorCore("ChaCha20", 256);

    @Override
    protected void engineInit(SecureRandom random) {
        this.core.implInit(random);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.core.implInit(params, random);
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        if (keySize != 256) {
            throw new InvalidParameterException("Key length for ChaCha20 must be 256 bits");
        }
        this.core.implInit(keySize, random);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        return this.core.implGenerateKey();
    }
}

