/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Hashtable;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11PSSSignature
extends SignatureSpi {
    private static final int TRAILER_FIELD_BC = 1;
    private static final boolean DEBUG = false;
    private static final Hashtable<String, Integer> DIGEST_LENGTHS = new Hashtable();
    private final Token token;
    private final String algorithm;
    private static final String KEY_ALGO = "RSA";
    private final CK_MECHANISM mechanism;
    private final int type;
    private P11Key p11Key = null;
    private PSSParameterSpec sigParams = null;
    private boolean isActive = false;
    private final String mdAlg;
    private MessageDigest md = null;
    private Session session;
    private int mode;
    private boolean initialized = false;
    private final byte[] buffer = new byte[1];
    private int bytesProcessed = 0;
    private static final int M_SIGN = 1;
    private static final int M_VERIFY = 2;
    private static final int T_DIGEST = 1;
    private static final int T_UPDATE = 2;

    private static boolean isDigestEqual(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.indexOf("-") != -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (string.equals("SHA-1")) {
            return string2.equalsIgnoreCase("SHA") || string2.equalsIgnoreCase("SHA1");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (string2.regionMatches(true, 0, "SHA", 0, 3)) {
            string2 = stringBuilder.insert(3, "-").toString();
            return string.equalsIgnoreCase(string2);
        }
        throw new ProviderException("Unsupported digest algorithm " + string2);
    }

    P11PSSSignature(Token token, String string, long l) throws NoSuchAlgorithmException, PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = new CK_MECHANISM(l);
        int n = string.indexOf("with");
        this.mdAlg = n == -1 ? null : string.substring(0, n);
        switch ((int)l) {
            case 14: 
            case 67: 
            case 68: 
            case 69: 
            case 71: {
                this.type = 2;
                break;
            }
            case 13: {
                this.type = 1;
                break;
            }
            default: {
                throw new ProviderException("Unsupported mechanism: " + l);
            }
        }
        this.md = null;
    }

    private void ensureInitialized() throws SignatureException {
        this.token.ensureValid();
        if (this.p11Key == null) {
            throw new SignatureException("Missing key");
        }
        if (this.sigParams == null) {
            if (this.mdAlg == null) {
                throw new SignatureException("Parameters required for RSASSA-PSS signature");
            }
            int n = DIGEST_LENGTHS.get(this.mdAlg);
            this.sigParams = new PSSParameterSpec(this.mdAlg, "MGF1", new MGF1ParameterSpec(this.mdAlg), n, 1);
            this.mechanism.setParameter(new CK_RSA_PKCS_PSS_PARAMS(this.mdAlg, "MGF1", this.mdAlg, DIGEST_LENGTHS.get(this.mdAlg)));
        }
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void reset(boolean bl) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (bl && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.mechanism.freeHandle();
            this.session = this.token.releaseSession(this.session);
            this.isActive = false;
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (!this.session.hasObjects()) {
            this.session = this.token.killSession(this.session);
            return;
        }
        if (this.mode == 1) {
            try {
                if (this.type == 2) {
                    this.token.p11.C_SignFinal(this.session.id(), 0);
                }
                byte[] byArray = this.md == null ? new byte[]{} : this.md.digest();
                this.token.p11.C_Sign(this.session.id(), byArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("cancel failed", pKCS11Exception);
            }
        } else {
            try {
                byte[] byArray = new byte[this.p11Key.length() + 7 >> 3];
                if (this.type == 2) {
                    this.token.p11.C_VerifyFinal(this.session.id(), byArray);
                } else {
                    byte[] byArray2 = this.md == null ? new byte[]{} : this.md.digest();
                    this.token.p11.C_Verify(this.session.id(), byArray2, byArray);
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    private void initialize() {
        if (this.p11Key == null) {
            throw new ProviderException("No Key found, call initSign/initVerify first");
        }
        long l = this.p11Key.getKeyID();
        try {
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            if (this.mode == 1) {
                this.token.p11.C_SignInit(this.session.id(), this.mechanism, l);
            } else {
                this.token.p11.C_VerifyInit(this.session.id(), this.mechanism, l);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw new ProviderException("Initialization failed", pKCS11Exception);
        }
        if (this.bytesProcessed != 0) {
            this.bytesProcessed = 0;
            if (this.md != null) {
                this.md.reset();
            }
        }
        this.initialized = true;
        this.isActive = false;
    }

    private void checkKeySize(Key key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals(KEY_ALGO)) {
            throw new InvalidKeyException("Only RSA keys are supported");
        }
        CK_MECHANISM_INFO cK_MECHANISM_INFO = null;
        try {
            cK_MECHANISM_INFO = this.token.getMechanismInfo(this.mechanism.mechanism);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        int n = 0;
        if (cK_MECHANISM_INFO != null) {
            if (key instanceof P11Key) {
                n = ((P11Key)key).length() + 7 >> 3;
            } else if (key instanceof RSAKey) {
                n = ((RSAKey)((Object)key)).getModulus().bitLength() >> 3;
            } else {
                throw new InvalidKeyException("Unrecognized key type " + key);
            }
            if (cK_MECHANISM_INFO.iMinKeySize != 0 && n < cK_MECHANISM_INFO.iMinKeySize >> 3) {
                throw new InvalidKeyException("RSA key must be at least " + cK_MECHANISM_INFO.iMinKeySize + " bits");
            }
            if (cK_MECHANISM_INFO.iMaxKeySize != Integer.MAX_VALUE && n > cK_MECHANISM_INFO.iMaxKeySize >> 3) {
                throw new InvalidKeyException("RSA key must be at most " + cK_MECHANISM_INFO.iMaxKeySize + " bits");
            }
        }
        if (this.sigParams != null) {
            int n2;
            String string = this.sigParams.getDigestAlgorithm();
            int n3 = this.sigParams.getSaltLength();
            int n4 = Math.addExact(Math.addExact(n3, n2 = DIGEST_LENGTHS.get(string).intValue()), 2);
            if (n < n4) {
                throw new InvalidKeyException("Key is too short for current params, need min " + n4);
            }
        }
    }

    private void setSigParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        int n;
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("PSS Parameter required");
        }
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec is supported");
        }
        PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
        if (pSSParameterSpec == this.sigParams) {
            return;
        }
        String string = pSSParameterSpec.getDigestAlgorithm();
        if (this.mdAlg != null && !P11PSSSignature.isDigestEqual(string, this.mdAlg)) {
            throw new InvalidAlgorithmParameterException("Digest algorithm in Signature parameters must be " + this.mdAlg);
        }
        Integer n2 = DIGEST_LENGTHS.get(string);
        if (n2 == null) {
            throw new InvalidAlgorithmParameterException("Unsupported digest algorithm in Signature parameters: " + string);
        }
        if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        String string2 = string;
        AlgorithmParameterSpec algorithmParameterSpec2 = pSSParameterSpec.getMGFParameters();
        if (algorithmParameterSpec2 != null) {
            if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only MGF1ParameterSpec is supported");
            }
            string2 = ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm();
        }
        if (pSSParameterSpec.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        int n3 = pSSParameterSpec.getSaltLength();
        if (this.p11Key != null && ((n = (this.p11Key.length() + 7 >> 3) - n2 - 2) < 0 || n3 > n)) {
            throw new InvalidAlgorithmParameterException("Invalid with current key size");
        }
        try {
            this.mechanism.setParameter(new CK_RSA_PKCS_PSS_PARAMS(string, "MGF1", string2, n3));
            this.sigParams = pSSParameterSpec;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (publicKey != this.p11Key) {
            this.checkKeySize(publicKey);
        }
        this.reset(true);
        this.mode = 2;
        this.p11Key = P11KeyFactory.convertKey(this.token, publicKey, KEY_ALGO);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (privateKey != this.p11Key) {
            this.checkKeySize(privateKey);
        }
        this.reset(true);
        this.mode = 1;
        this.p11Key = P11KeyFactory.convertKey(this.token, privateKey, KEY_ALGO);
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.ensureInitialized();
        this.isActive = true;
        this.buffer[0] = by;
        this.engineUpdate(this.buffer, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInitialized();
        if (n2 == 0) {
            return;
        }
        if (n2 + this.bytesProcessed < 0) {
            throw new ProviderException("Processed bytes limits exceeded.");
        }
        this.isActive = true;
        switch (this.type) {
            case 2: {
                try {
                    if (this.mode == 1) {
                        System.out.println(this + ": Calling C_SignUpdate");
                        this.token.p11.C_SignUpdate(this.session.id(), 0L, byArray, n, n2);
                    } else {
                        System.out.println(this + ": Calling C_VerfifyUpdate");
                        this.token.p11.C_VerifyUpdate(this.session.id(), 0L, byArray, n, n2);
                    }
                    this.bytesProcessed += n2;
                    break;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    this.reset(false);
                    throw new ProviderException(pKCS11Exception);
                }
            }
            case 1: {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                this.md.update(byArray, n, n2);
                this.bytesProcessed += n2;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInitialized();
        }
        catch (SignatureException signatureException) {
            throw new ProviderException(signatureException);
        }
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        this.isActive = true;
        switch (this.type) {
            case 2: {
                if (!(byteBuffer instanceof DirectBuffer)) {
                    super.engineUpdate(byteBuffer);
                    return;
                }
                long l = ((DirectBuffer)((Object)byteBuffer)).address();
                int n2 = byteBuffer.position();
                try {
                    if (this.mode == 1) {
                        System.out.println(this + ": Calling C_SignUpdate");
                        this.token.p11.C_SignUpdate(this.session.id(), l + (long)n2, null, 0, n);
                    } else {
                        System.out.println(this + ": Calling C_VerifyUpdate");
                        this.token.p11.C_VerifyUpdate(this.session.id(), l + (long)n2, null, 0, n);
                    }
                    this.bytesProcessed += n;
                    byteBuffer.position(n2 + n);
                    break;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    this.reset(false);
                    throw new ProviderException("Update failed", pKCS11Exception);
                }
            }
            case 1: {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                this.md.update(byteBuffer);
                this.bytesProcessed += n;
                break;
            }
            default: {
                this.reset(false);
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.ensureInitialized();
        boolean bl = true;
        try {
            byte[] byArray;
            byte[] byArray2;
            if (this.type == 2) {
                byArray2 = this.token.p11.C_SignFinal(this.session.id(), 0);
            } else {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                byArray = this.md.digest();
                byArray2 = this.token.p11.C_Sign(this.session.id(), byArray);
            }
            bl = false;
            byArray = byArray2;
            return byArray;
        }
        catch (PKCS11Exception pKCS11Exception) {
            bl = false;
            throw new ProviderException(pKCS11Exception);
        }
        catch (ProviderException providerException) {
            throw providerException;
        }
        finally {
            this.reset(bl);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        this.ensureInitialized();
        boolean bl = true;
        try {
            if (this.type == 2) {
                this.token.p11.C_VerifyFinal(this.session.id(), byArray);
            } else {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                byte[] byArray2 = this.md.digest();
                this.token.p11.C_Verify(this.session.id(), byArray2, byArray);
            }
            bl = false;
            boolean bl2 = true;
            return bl2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            bl = false;
            long l = pKCS11Exception.getErrorCode();
            if (l == 192L) {
                boolean bl3 = false;
                return bl3;
            }
            if (l == 193L) {
                boolean bl4 = false;
                return bl4;
            }
            if (l == 33L) {
                boolean bl5 = false;
                return bl5;
            }
            throw new ProviderException(pKCS11Exception);
        }
        catch (ProviderException providerException) {
            throw providerException;
        }
        finally {
            this.reset(bl);
        }
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (this.isActive) {
            throw new ProviderException("Cannot set parameters during operations");
        }
        this.setSigParams(algorithmParameterSpec);
        if (this.type == 1) {
            try {
                this.md = MessageDigest.getInstance(this.sigParams.getDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
            }
        }
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams != null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("RSASSA-PSS");
                algorithmParameters.init(this.sigParams);
                return algorithmParameters;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException(generalSecurityException);
            }
        }
        return null;
    }

    static {
        DIGEST_LENGTHS.put("SHA-1", 20);
        DIGEST_LENGTHS.put("SHA", 20);
        DIGEST_LENGTHS.put("SHA1", 20);
        DIGEST_LENGTHS.put("SHA-224", 28);
        DIGEST_LENGTHS.put("SHA224", 28);
        DIGEST_LENGTHS.put("SHA-256", 32);
        DIGEST_LENGTHS.put("SHA256", 32);
        DIGEST_LENGTHS.put("SHA-384", 48);
        DIGEST_LENGTHS.put("SHA384", 48);
        DIGEST_LENGTHS.put("SHA-512", 64);
        DIGEST_LENGTHS.put("SHA512", 64);
        DIGEST_LENGTHS.put("SHA-512/224", 28);
        DIGEST_LENGTHS.put("SHA512/224", 28);
        DIGEST_LENGTHS.put("SHA-512/256", 32);
        DIGEST_LENGTHS.put("SHA512/256", 32);
    }
}

