/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.PrivateKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sun.security.ssl.EllipticCurvesExtension;
import sun.security.util.KeyUtil;

final class SignatureAndHashAlgorithm {
    static final int SUPPORTED_ALG_PRIORITY_MAX_NUM = 240;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Map<Integer, SignatureAndHashAlgorithm> supportedMap = Collections.synchronizedSortedMap(new TreeMap());
    private static final Map<Integer, SignatureAndHashAlgorithm> priorityMap = Collections.synchronizedSortedMap(new TreeMap());
    private final String name;
    private final String curve;
    private final SignatureAlgorithm signature;
    private HashAlgorithm hash;
    private int id;
    private String algorithm;
    private int priority;

    private SignatureAndHashAlgorithm(String string, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string2, String string3, int n) {
        this.name = string;
        this.hash = hashAlgorithm;
        this.signature = signatureAlgorithm;
        this.algorithm = string2;
        this.id = (hashAlgorithm.value & 0xFF) << 8 | signatureAlgorithm.value & 0xFF;
        this.curve = string3;
        this.priority = n;
    }

    private SignatureAndHashAlgorithm(String string, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string2, int n) {
        this(string, hashAlgorithm, signatureAlgorithm, string2, null, n);
    }

    private SignatureAndHashAlgorithm(String string, int n, int n2) {
        this.name = "unknown";
        this.hash = HashAlgorithm.valueOf(n >> 8 & 0xFF);
        this.signature = SignatureAlgorithm.valueOf(n & 0xFF);
        this.algorithm = string;
        this.id = n;
        this.curve = null;
        this.priority = 240 + n2 + 1;
    }

    static SignatureAndHashAlgorithm valueOf(int n, int n2, int n3) {
        int n4 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = supportedMap.get(n4);
        if (signatureAndHashAlgorithm == null) {
            signatureAndHashAlgorithm = new SignatureAndHashAlgorithm("Unknown (hash:0x" + Integer.toString(n, 16) + ", signature:0x" + Integer.toString(n2, 16) + ")", n4, n3);
        }
        return signatureAndHashAlgorithm;
    }

    int getHashValue() {
        return this.id >> 8 & 0xFF;
    }

    int getSignatureValue() {
        return this.id & 0xFF;
    }

    String getAlgorithmName() {
        return this.algorithm;
    }

    static int sizeInRecord() {
        return 2;
    }

    private boolean isPermitted(AlgorithmConstraints algorithmConstraints) {
        return algorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.name, null) && algorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.signature.name, null) && algorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.algorithm, null) && (this.curve == null || EllipticCurvesExtension.isPermitted(this.curve, algorithmConstraints));
    }

    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(AlgorithmConstraints algorithmConstraints) {
        ArrayList<SignatureAndHashAlgorithm> arrayList = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : priorityMap.values()) {
            if (signatureAndHashAlgorithm.priority > 240 || !signatureAndHashAlgorithm.isPermitted(algorithmConstraints)) continue;
            arrayList.add(signatureAndHashAlgorithm);
        }
        return arrayList;
    }

    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(AlgorithmConstraints algorithmConstraints, Collection<SignatureAndHashAlgorithm> collection) {
        ArrayList<SignatureAndHashAlgorithm> arrayList = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
            if (signatureAndHashAlgorithm.priority > 240 || !signatureAndHashAlgorithm.isPermitted(algorithmConstraints)) continue;
            arrayList.add(signatureAndHashAlgorithm);
        }
        return arrayList;
    }

    static String[] getAlgorithmNames(Collection<SignatureAndHashAlgorithm> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (collection != null) {
            for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
                arrayList.add(signatureAndHashAlgorithm.algorithm);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    static Set<String> getHashAlgorithmNames(Collection<SignatureAndHashAlgorithm> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        if (collection != null) {
            for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
                if (signatureAndHashAlgorithm.hash.value <= 0) continue;
                hashSet.add(signatureAndHashAlgorithm.hash.standardName);
            }
        }
        return hashSet;
    }

    static String getHashAlgorithmName(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return signatureAndHashAlgorithm.hash.standardName;
    }

    private static void supports(String string, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string2, int n) {
        SignatureAndHashAlgorithm.supports(string, hashAlgorithm, signatureAlgorithm, string2, null, n);
    }

    private static void supports(String string, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string2, String string3, int n) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(string, hashAlgorithm, signatureAlgorithm, string2, string3, n);
        if (supportedMap.put(signatureAndHashAlgorithm.id, signatureAndHashAlgorithm) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, id: " + signatureAndHashAlgorithm.id);
        }
        if (priorityMap.put(signatureAndHashAlgorithm.priority, signatureAndHashAlgorithm) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, priority: " + signatureAndHashAlgorithm.priority);
        }
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> collection, AlgorithmConstraints algorithmConstraints, String string) {
        return SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, algorithmConstraints, string, null);
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> collection, AlgorithmConstraints algorithmConstraints, String string, PrivateKey privateKey) {
        int n = SignatureAndHashAlgorithm.getMaxDigestLength(privateKey);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
            if (!signatureAndHashAlgorithm.isPermitted(algorithmConstraints)) continue;
            int n2 = signatureAndHashAlgorithm.id & 0xFF;
            if (!(string == null || string.equalsIgnoreCase("rsa") && n2 == SignatureAlgorithm.RSA.value || string.equalsIgnoreCase("dsa") && n2 == SignatureAlgorithm.DSA.value || string.equalsIgnoreCase("ecdsa") && n2 == SignatureAlgorithm.ECDSA.value) && (!string.equalsIgnoreCase("ec") || n2 != SignatureAlgorithm.ECDSA.value) || signatureAndHashAlgorithm.priority > 240 || signatureAndHashAlgorithm.hash.length > n) continue;
            return signatureAndHashAlgorithm;
        }
        return null;
    }

    private static int getMaxDigestLength(PrivateKey privateKey) {
        int n = Integer.MAX_VALUE;
        if (privateKey != null && "rsa".equalsIgnoreCase(privateKey.getAlgorithm())) {
            int n2 = KeyUtil.getKeySize(privateKey);
            if (n2 >= 768) {
                n = HashAlgorithm.SHA512.length;
            } else if (n2 >= 512 && n2 < 768) {
                n = HashAlgorithm.SHA256.length;
            } else if (n2 > 0 && n2 < 512) {
                n = HashAlgorithm.SHA1.length;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Integer, SignatureAndHashAlgorithm> map = supportedMap;
        synchronized (map) {
            int n = 240;
            SignatureAndHashAlgorithm.supports("rsa_md5", HashAlgorithm.MD5, SignatureAlgorithm.RSA, "MD5withRSA", --n);
            SignatureAndHashAlgorithm.supports("dsa_sha1", HashAlgorithm.SHA1, SignatureAlgorithm.DSA, "SHA1withDSA", --n);
            SignatureAndHashAlgorithm.supports("rsa_pkcs1_sha1", HashAlgorithm.SHA1, SignatureAlgorithm.RSA, "SHA1withRSA", --n);
            SignatureAndHashAlgorithm.supports("ecdsa_sha1", HashAlgorithm.SHA1, SignatureAlgorithm.ECDSA, "SHA1withECDSA", --n);
            if (Security.getProvider("SunMSCAPI") == null) {
                SignatureAndHashAlgorithm.supports("dsa_sha224", HashAlgorithm.SHA224, SignatureAlgorithm.DSA, "SHA224withDSA", --n);
                SignatureAndHashAlgorithm.supports("rsa_sha224", HashAlgorithm.SHA224, SignatureAlgorithm.RSA, "SHA224withRSA", --n);
                SignatureAndHashAlgorithm.supports("ecdsa_sha224", HashAlgorithm.SHA224, SignatureAlgorithm.ECDSA, "SHA224withECDSA", --n);
            }
            SignatureAndHashAlgorithm.supports("dsa_sha256", HashAlgorithm.SHA256, SignatureAlgorithm.DSA, "SHA256withDSA", --n);
            SignatureAndHashAlgorithm.supports("rsa_pkcs1_sha256", HashAlgorithm.SHA256, SignatureAlgorithm.RSA, "SHA256withRSA", --n);
            SignatureAndHashAlgorithm.supports("ecdsa_secp256r1_sha256", HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, "SHA256withECDSA", "secp256r1", --n);
            SignatureAndHashAlgorithm.supports("rsa_pkcs1_sha384", HashAlgorithm.SHA384, SignatureAlgorithm.RSA, "SHA384withRSA", --n);
            SignatureAndHashAlgorithm.supports("ecdsa_secp384r1_sha384", HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, "SHA384withECDSA", "secp384r1", --n);
            SignatureAndHashAlgorithm.supports("rsa_pkcs1_sha512", HashAlgorithm.SHA512, SignatureAlgorithm.RSA, "SHA512withRSA", --n);
            SignatureAndHashAlgorithm.supports("ecdsa_secp521r1_sha512", HashAlgorithm.SHA512, SignatureAlgorithm.ECDSA, "SHA512withECDSA", "secp521r1", --n);
        }
    }

    static enum SignatureAlgorithm {
        UNDEFINED("undefined", -1),
        ANONYMOUS("anonymous", 0),
        RSA("rsa", 1),
        DSA("dsa", 2),
        ECDSA("ecdsa", 3);

        final String name;
        final int value;

        private SignatureAlgorithm(String string2, int n2) {
            this.name = string2;
            this.value = n2;
        }

        static SignatureAlgorithm valueOf(int n) {
            SignatureAlgorithm signatureAlgorithm = UNDEFINED;
            switch (n) {
                case 0: {
                    signatureAlgorithm = ANONYMOUS;
                    break;
                }
                case 1: {
                    signatureAlgorithm = RSA;
                    break;
                }
                case 2: {
                    signatureAlgorithm = DSA;
                    break;
                }
                case 3: {
                    signatureAlgorithm = ECDSA;
                }
            }
            return signatureAlgorithm;
        }
    }

    static enum HashAlgorithm {
        UNDEFINED("undefined", "", -1, -1),
        NONE("none", "NONE", 0, -1),
        MD5("md5", "MD5", 1, 16),
        SHA1("sha1", "SHA-1", 2, 20),
        SHA224("sha224", "SHA-224", 3, 28),
        SHA256("sha256", "SHA-256", 4, 32),
        SHA384("sha384", "SHA-384", 5, 48),
        SHA512("sha512", "SHA-512", 6, 64);

        final String name;
        final String standardName;
        final int value;
        final int length;

        private HashAlgorithm(String string2, String string3, int n2, int n3) {
            this.name = string2;
            this.standardName = string3;
            this.value = n2;
            this.length = n3;
        }

        static HashAlgorithm valueOf(int n) {
            HashAlgorithm hashAlgorithm = UNDEFINED;
            switch (n) {
                case 0: {
                    hashAlgorithm = NONE;
                    break;
                }
                case 1: {
                    hashAlgorithm = MD5;
                    break;
                }
                case 2: {
                    hashAlgorithm = SHA1;
                    break;
                }
                case 3: {
                    hashAlgorithm = SHA224;
                    break;
                }
                case 4: {
                    hashAlgorithm = SHA256;
                    break;
                }
                case 5: {
                    hashAlgorithm = SHA384;
                    break;
                }
                case 6: {
                    hashAlgorithm = SHA512;
                }
            }
            return hashAlgorithm;
        }
    }
}

