/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Unzip;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.ConfigFileManager;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.Version;
import ca.infodata.launcher3.config.VersionDiff;
import ca.infodata.launcher3.config.VersionSynchronizer;
import ca.infodata.launcher3.config.command.AbstractCommand;
import ca.infodata.launcher3.config.command.BuildBatCommand;
import ca.infodata.launcher3.config.command.BuildProxyCommand;
import ca.infodata.launcher3.config.command.ChangeLanguageCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand2;
import ca.infodata.launcher3.config.command.CreateShortCutCommand;
import ca.infodata.launcher3.config.command.HelpCommand;
import ca.infodata.launcher3.config.command.HelpCommand2;
import ca.infodata.launcher3.config.command.KnowInstallCommand;
import ca.infodata.launcher3.config.command.LaunchCommand;
import ca.infodata.launcher3.config.command.NeedNormalStreamCommand;
import ca.infodata.launcher3.config.command.NoFlushCommand;
import ca.infodata.launcher3.config.command.NoShortCutCommand;
import ca.infodata.launcher3.config.command.SkipValidationCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherRetroCommand;
import ca.infodata.launcher3.config.command.UpdateOfysCommand;
import ca.infodata.launcher3.config.command.WaitCommand;
import ca.infodata.launcher3.download.DownloadSite;
import ca.infodata.launcher3.download.MultiSiteResourceDownload;
import ca.infodata.launcher3.download.Resource;
import ca.infodata.launcher3.download.SiteProvider;
import ca.infodata.launcher3.download.StringDownload;
import ca.infodata.launcher3.download.UrlUtil;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class Config {
    public static final String JAR_NAME = "OfysLauncher.jar";
    public static final String JAR_NAME_EXT = "launcher/OfysLauncher.jar";
    public static final String LANG_PROP_KEY = "osgi.nl";
    private static Config instance;
    private static boolean haveBeenInit;
    public static List<AbstractCommand> commandsRegister;
    private List<AbstractCommand> commands = new ArrayList<AbstractCommand>();
    private LauncherLogger logger;
    public Properties ofysProperties = new Properties();
    public Properties proxyProperties;
    public File installFolder;
    public File rootFolder;
    public File ofysFolder;
    public File launcherFolder;
    public File updateFolder;
    public File oldUpdateFolder;
    public SiteProvider ofysSiteProvider;
    public SiteProvider launcherSiteProvider;
    public ConfigFileManager configFileManager;
    public boolean updateOfysCommand;
    private Version ofysInstalledVersion;
    private List<Version> ofysRemoteVersions;
    private Version launcherRemoteVersion;

    public static Config getInstance() {
        return instance;
    }

    public static Config init(String[] args) throws Exception {
        if (haveBeenInit) {
            throw new Exception("Config have already been instanciated.");
        }
        commandsRegister = new ArrayList<AbstractCommand>();
        commandsRegister.add(new HelpCommand());
        commandsRegister.add(new HelpCommand2());
        commandsRegister.add(new ChangeLanguageCommand());
        commandsRegister.add(new BuildBatCommand());
        commandsRegister.add(new BuildProxyCommand());
        commandsRegister.add(new CreateShortCutCommand());
        commandsRegister.add(new KnowInstallCommand());
        commandsRegister.add(new CheckVersionCommand());
        commandsRegister.add(new CheckVersionCommand2());
        commandsRegister.add(new WaitCommand());
        commandsRegister.add(new LaunchCommand());
        commandsRegister.add(new UpdateLauncherCommand());
        commandsRegister.add(new UpdateLauncherRetroCommand());
        commandsRegister.add(new NoFlushCommand());
        commandsRegister.add(new NeedNormalStreamCommand());
        commandsRegister.add(new SkipValidationCommand());
        commandsRegister.add(new NoShortCutCommand());
        commandsRegister.add(new UpdateOfysCommand());
        instance = new Config(args);
        instance.finishInit();
        return Config.getInstance();
    }

    private Config(String[] args) throws Exception {
        this.logger = LauncherLogger.getInstance();
        this.listCommands(args);
    }

    private void finishInit() throws Exception {
        this.logger.init();
        this.logger.log("---- Parameter used for the launcher ----");
        for (AbstractCommand ac : this.commands) {
            this.logger.log(ac.toString());
        }
        this.initGeneralConfig();
        this.initInstallFolder();
        this.rootFolder = new File(this.installFolder, "Ofys");
        this.ofysFolder = new File(this.rootFolder, "Ofys");
        this.launcherFolder = new File(this.rootFolder, "launcher");
        this.updateFolder = new File(this.rootFolder, "temp");
        this.oldUpdateFolder = new File(this.rootFolder, "update");
        this.initProxyInfo();
        UrlUtil.configureHttpsTrustStore();
        this.initLanguage();
        this.initGeneralConfigWithDistantURL();
        this.initProvider();
        this.configFileManager = new ConfigFileManager(new File(this.installFolder, "Ofys"));
        this.configFileManager.setConfigPropFromFoundFiles();
        this.configFileManager.logConfigFiles();
    }

    private void initProvider() throws Exception {
        LauncherLogger.getInstance().log("Init download site providers...");
        String[] ops = this.ofysProperties.getProperty("ofys.download").split(";");
        this.ofysProperties.remove("ofys.download");
        ArrayList<DownloadSite> ds = new ArrayList<DownloadSite>();
        for (String op : ops) {
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  Ofys site: " + op);
        }
        this.ofysSiteProvider = new SiteProvider(ds);
        ops = this.ofysProperties.getProperty("launcher.download").split(";");
        this.ofysProperties.remove("launcher.download");
        ds = new ArrayList();
        for (String op : ops) {
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  Launcher site: " + op);
        }
        this.launcherSiteProvider = new SiteProvider(ds);
    }

    private void initLanguage() {
        File lgFile = new File(this.rootFolder, "ofys.lang");
        String lg = "fr_ca";
        if (lgFile.exists()) {
            lg = Util.readFile(lgFile);
        }
        this.ofysProperties.put(LANG_PROP_KEY, lg);
        LauncherLogger.getInstance().log("->Choosen langage: " + lg);
    }

    private void initProxyInfo() throws Exception {
        File lgFile = new File(this.rootFolder, "proxy.prop");
        LauncherLogger.getInstance().log("->Check for proxy... (" + lgFile.getAbsolutePath() + ")");
        if (lgFile.exists()) {
            this.proxyProperties = new Properties();
            LauncherLogger.getInstance().log("\tProxy exist : loading properties.  If nothing happen after, remove the proxy file.");
            Properties p = new Properties();
            FileInputStream sras = new FileInputStream(lgFile);
            p.load(sras);
            this.proxyProperties.putAll((Map<?, ?>)p);
            for (Map.Entry<Object, Object> set : p.entrySet()) {
                if (set.getValue() == null || ((String)set.getValue()).trim().length() <= 0) continue;
                System.setProperty((String)set.getKey(), (String)set.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                this.logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initInstallFolder() throws Exception {
        block25: {
            block24: {
                this.logger.log("Init Install Folder");
                if (!this.ofysProperties.containsKey("gmf-install")) break block24;
                this.logger.log("It's a gmf install.");
                File f = new File("C://infodata/");
                if (!this.isOfysInstallThere(f)) {
                    this.logger.log("Ofys is not install gmf in : " + f + ".");
                    this.logger.log("Is " + f + " base folder exist?");
                    if (!f.exists()) {
                        this.logger.log("No he don't: ask user if he want to create the folder:");
                        int response = JOptionPane.showConfirmDialog(null, "Ofys n'est pr\u00e9sentement pas install\u00e9 et d\u00e9sire cr\u00e9er le dossier C://Infodata/ pour poursuivre.\n\nVoulez-vous permettre \u00e0 Ofys de cr\u00e9er le dossier?");
                        System.out.println("REPONSE: " + response);
                        if (response == 0) {
                            this.logger.log("User want OfysLauncher to create the folder.");
                            f.mkdir();
                            if (!f.exists()) {
                                this.logger.log(Level.SEVERE, "Ofys failed to create folder " + f);
                                throw new PopupInformationException("Vous avez lanc\u00e9 Ofys en mode 'GMF' et demand\u00e9 \u00e0 Ofys de cr\u00e9er le dossier " + f + ".  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                            }
                            this.logger.log("OfysLauncher has created " + f + " successful!");
                        } else {
                            this.logger.log(Level.WARNING, "User don't want to create the folder. It will throw an error.");
                        }
                    } else {
                        this.logger.log("Yes, he exist!");
                    }
                    if (!Config.isFolderHasRight(f)) {
                        throw new PopupInformationException("Vous avez lanc\u00e9 Ofys en mode 'GMF'.  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droits d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                    }
                    this.installFolder = f;
                    break block25;
                } else {
                    this.logger.log("Ofys is install.");
                    if (!Config.isFolderHasRight(f)) throw new PopupInformationException("Ofys est install\u00e9 dans " + f + " mais ne poss\u00e8de pas les droits suffisants pour se lancer correctement. Corrigez ce probl\u00e8me et relancez Ofys.");
                    this.installFolder = f;
                }
                break block25;
            }
            this.logger.log("It's a normal (user profile) install.");
            String homePath = System.getProperty("user.home");
            boolean canBeJH = false;
            File homeOfysFile = new File(homePath);
            if (this.isOfysInstallThere(homeOfysFile)) {
                this.logger.log("Ofys is install.");
                if (!Config.isFolderHasRight(homeOfysFile)) throw new PopupInformationException("Ofys est install\u00e9 dans " + homeOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                this.installFolder = homeOfysFile;
            } else {
                this.logger.log("Ofys is not install.");
                if (Config.isFolderHasRight(homeOfysFile)) {
                    this.logger.log("K");
                    canBeJH = true;
                }
            }
            boolean canBeWH = false;
            File wOfysFile = null;
            if (this.installFolder == null && Util.isWindows()) {
                this.logger.log("On windows, check for the other home file.");
                wOfysFile = new File(System.getenv().get("USERPROFILE"));
                if (this.isOfysInstallThere(wOfysFile)) {
                    this.logger.log("Ofys is install.");
                    if (!wOfysFile.exists()) throw new PopupInformationException("Ofys est install\u00e9 dans " + wOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                    if (!Config.isFolderHasRight(wOfysFile)) throw new PopupInformationException("Ofys est install\u00e9 dans " + wOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                    this.installFolder = wOfysFile;
                } else if (!canBeJH) {
                    this.logger.log("Ofys is not install.");
                    if (wOfysFile.exists() && Config.isFolderHasRight(wOfysFile)) {
                        canBeWH = true;
                    }
                }
            }
            if (this.installFolder == null) {
                this.logger.log("Ofys is definitively not install, so we gonna look what is the best way to install.");
                if (canBeJH) {
                    this.installFolder = homeOfysFile;
                } else if (canBeWH) {
                    this.installFolder = wOfysFile;
                } else {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Vous avez tentez de lancer Ofys dans votre r\u00e9pertoire utilisateur (").append(homeOfysFile.getAbsolutePath());
                    if (wOfysFile == null) {
                        string = "";
                        throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                    }
                    string = ", " + wOfysFile.getAbsolutePath();
                    throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                }
            }
        }
        if (!this.installFolder.exists()) {
            this.logger.log("Install folder '" + this.installFolder.getAbsolutePath() + "' doesn't exist. We gonna create it.");
            this.installFolder.mkdirs();
        }
        this.logger.log("Dossier d'installation : " + this.installFolder.getAbsolutePath() + " : " + this.installFolder.isDirectory());
    }

    public static boolean isFolderHasRight(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            String tt;
            File fTest = new File(folder, "accesTestFile");
            Util.saveToFile(fTest, "test");
            if (fTest.exists() && "test".equals(tt = Util.readFile(fTest))) {
                fTest.delete();
                if (!fTest.exists()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isOfysInstallThere(File folder) {
        File vFile = new File(folder, "Ofys/Ofys/ofys.version");
        this.logger.log("Is ofys installed here? " + vFile.exists() + " : " + vFile.getAbsolutePath());
        return vFile.exists();
    }

    public AbstractCommand getCommand(String command) {
        for (AbstractCommand ac : this.commands) {
            if (!ac.getCommandName().equals(command)) continue;
            return ac;
        }
        return null;
    }

    private void initGeneralConfig() throws Exception {
        this.logger.log("---- Init ofys launch config ----");
        Properties p = new Properties();
        InputStream sras = this.getClass().getClassLoader().getResourceAsStream("ca/infodata/launcher3/ressources/config.properties");
        p.load(sras);
        this.ofysProperties.putAll((Map<?, ?>)p);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            this.logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    private void initGeneralConfigWithDistantURL() throws Exception {
        this.logger.log("---- Init ofys launch config with distanct URL----");
        String relais = this.ofysProperties.getProperty("relais");
        this.logger.log("*** relais = " + relais);
        if (Util.isNotBlank(relais)) {
            String[] rels;
            for (String r : rels = relais.split(";")) {
                URL url = new URL(r);
                Properties props = this.readPropertiesFromUrl(url);
                if (props != null) {
                    this.logger.log("Relais file found to " + url);
                    String isActive = props.getProperty("active");
                    this.logger.log("  *isActive?" + isActive);
                    if (!"true".equalsIgnoreCase(isActive)) break;
                    this.ofysProperties.putAll((Map<?, ?>)props);
                    this.logger.log(Level.WARNING, "Server is down or Relais config simply activated to launch ofys at :" + url);
                    this.logger.log("  Properties overridden:");
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        this.logger.log("    -" + entry.getKey() + "\t:\t" + entry.getValue());
                    }
                    break;
                }
                this.logger.log("Relais file NOT found (" + url + ")");
            }
        }
        this.logger.log("FINAL RESULT: ");
        for (Map.Entry<Object, Object> entry : this.ofysProperties.entrySet()) {
            this.logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    private void listCommands(String[] args) throws NotToSendException {
        ArrayList<String> params;
        for (int index = 0; index < args.length; index += params.size() + 1) {
            String param;
            String sA = args[index];
            AbstractCommand ac = null;
            for (AbstractCommand act : commandsRegister) {
                if (!act.getCommandName().equals(sA)) continue;
                ac = act;
                break;
            }
            if (ac == null) {
                throw new NotToSendException("No commands exist for '" + sA + "'.  User -h or -help.");
            }
            params = new ArrayList<String>();
            while (index + 1 + params.size() < args.length && ac.isValidParameter(param = args[index + 1 + params.size()])) {
                params.add(param);
            }
            ac.setParameters(params);
            this.commands.add(ac);
        }
    }

    public Properties readPropertiesFromUrl(URL url) throws Exception {
        Properties prop = null;
        try {
            this.logger.log("Read index of : " + url);
            StringDownload download = new StringDownload(url, "propertiesFromUrl");
            download.setMonitor(new SyncProgressMonitor());
            download.run();
            String text = download.getString();
            Properties propTemp = new Properties();
            propTemp.load(new StringReader(text));
            if (propTemp.size() > 0) {
                prop = propTemp;
            }
        }
        catch (Exception e) {
            this.logger.log("Exception readPropertiesFromUrl: " + e.getMessage());
        }
        return prop;
    }

    public String readInstalledOfysDotVersion() {
        try {
            File file = Util.findFileRecursive(this.ofysFolder, "ofys.version");
            if (file != null) {
                return Util.readFile(file);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Failed to read installed ofys.version cause of " + e.getMessage());
        }
        return null;
    }

    public Version getOfysInstalledVersion() throws Exception {
        if (this.ofysInstalledVersion == null) {
            this.ofysInstalledVersion = this.getInstalledVersion(this.ofysFolder);
        }
        return this.ofysInstalledVersion;
    }

    private Version getInstalledVersion(File root) throws Exception {
        List<File> localFiles = Util.listFilesFromDirectoryRecursive(root);
        Version version = new Version();
        version.name = "installed";
        version.root = root;
        version.index = new ArrayList<Resource>();
        for (File file : localFiles) {
            Resource resource = new Resource();
            resource.setPath(file.getAbsolutePath().substring(version.root.getAbsolutePath().length() + 1).replace("\\", "/"));
            resource.setMd5(Util.computeMd5(file));
            resource.setLength(file.length());
            resource.setFile(file);
            version.index.add(resource);
        }
        return version;
    }

    public List<Version> getOfysRemoteVersions() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.ofysRemoteVersions == null) {
            this.ofysRemoteVersions = this.getRemoteVersions(this.ofysSiteProvider);
            if (this.ofysRemoteVersions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version de ofys n'est disponible");
            }
        }
        return this.ofysRemoteVersions;
    }

    private List<Version> getRemoteVersions(SiteProvider siteProvider) throws NoMoreDownloadProdiderException {
        LauncherLogger logger = LauncherLogger.getInstance();
        MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
        String versionsTextPlain = download.downloadString(new Resource("versions.txt"));
        String[] versionNames = Util.splitByLine(versionsTextPlain);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (String name : versionNames) {
            if (!Util.isNotBlank(name) || name.startsWith("#")) continue;
            try {
                versions.add(this.readVersion(siteProvider, name));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to get version " + name + ". Version will be ignored.");
            }
        }
        logger.log("Retrieved versions : ");
        for (Version version : versions) {
            logger.log(version.name);
        }
        return versions;
    }

    private Version readVersion(SiteProvider siteProvider, String name) throws Exception {
        LauncherLogger logger = LauncherLogger.getInstance();
        Version version = new Version();
        try {
            version.name = name;
            version.index = new ArrayList<Resource>();
            MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
            String indexTextPlain = download.downloadString(new Resource(name + "/index.txt"));
            String[] lines = Util.splitByLine(indexTextPlain);
            for (int i = 0; i < lines.length; ++i) {
                Resource e = new Resource();
                e.setPath(lines[i].trim());
                e.setMd5(lines[++i].trim());
                e.setLength(Long.valueOf(lines[++i].trim()));
                version.index.add(e);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to read index.txt of version " + name);
            throw e;
        }
        return version;
    }

    public Version getLauncherInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.launcherFolder);
    }

    public Version getLauncherTempInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.updateFolder);
    }

    public Version getLauncherRemoteVersion() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.launcherRemoteVersion == null) {
            List<Version> versions = this.getRemoteVersions(this.launcherSiteProvider);
            if (versions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version du lanceur n'est disponible");
            }
            this.launcherRemoteVersion = versions.get(versions.size() - 1);
        }
        return this.launcherRemoteVersion;
    }

    public void installOfys(SyncProgressMonitor monitor, Version versionToInstall) throws Exception {
        VersionDiff diff = new VersionDiff(this.getOfysInstalledVersion(), versionToInstall);
        this.ofysInstalledVersion = null;
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.ofysSiteProvider);
        synchronizer.sync();
        this.createShortCut();
        this.configFileManager.tryToFlushAllConfigs();
    }

    public void installLauncher(SyncProgressMonitor monitor) throws Exception {
        Version remote = this.getLauncherRemoteVersion();
        VersionDiff diff = new VersionDiff(this.getLauncherInstalledVersion(), remote);
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.launcherSiteProvider);
        synchronizer.sync();
    }

    public void sync(VersionDiff diff, SiteProvider siteProvider, SyncProgressMonitor monitor) throws Exception {
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(siteProvider);
        synchronizer.sync();
    }

    public void saveLangageFile() {
        File lgFile = new File(this.rootFolder, "ofys.lang");
        boolean mustSave = false;
        if (lgFile.exists()) {
            String lg = Util.readFile(lgFile);
            if (!lg.equals(this.ofysProperties.get(LANG_PROP_KEY))) {
                mustSave = true;
                lgFile.delete();
            }
        } else {
            mustSave = true;
        }
        if (mustSave) {
            Util.saveToFile(lgFile, (String)this.ofysProperties.get(LANG_PROP_KEY));
        }
        LauncherLogger.getInstance().log("->Save new choosen langage: " + this.ofysProperties.get(LANG_PROP_KEY));
    }

    public void createShortCut() throws Exception {
        this.logger.log(Level.INFO, "####################");
        this.logger.log(Level.INFO, "---->create shortcut");
        this.logger.log(Level.INFO, "####################");
        File avoidShortcutFile = new File(this.rootFolder, "no-shortcut.flag");
        if (avoidShortcutFile.exists()) {
            this.logger.log(Level.INFO, "\tNo shortcut flag found : wont create the shortcut.");
        } else if (Util.isWindows()) {
            String vbs = " Dim WSHShell\n Set WSHShell = _\n    WScript.CreateObject(\"WScript.Shell\")\n Dim MyShortcut, MyDesktop, DesktopPath\n ' Read desktop path using WshSpecialFolders object\n DesktopPath = _\n    WSHShell.SpecialFolders(\"Desktop\")\n ' Create a shortcut object on the desktop\n Set MyShortcut = _\n    WSHShell.CreateShortcut( _\n    DesktopPath & \"\\Ofys.lnk\")\n ' Set shortcut object properties and save it\n MyShortcut.TargetPath = _\n    WSHShell.ExpandEnvironmentStrings( _\n    \"\"\"" + this.launcherFolder.getAbsolutePath() + "\\" + JAR_NAME + "\"\"\")\n" + " MyShortcut.WorkingDirectory = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.ofysFolder.getAbsolutePath() + "\")\n" + " MyShortcut.WindowStyle = 4\n" + " MyShortcut.IconLocation = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.ofysFolder.getAbsolutePath() + "\\appIcon.ico\")\n" + " MyShortcut.Save\n";
            File f = new File(this.installFolder, "shortcut.vbs");
            Util.saveToFile(f, vbs);
            this.logger.log(Level.INFO, "---->createShortCut Windows");
            try {
                String cmd = "wscript \"" + f.getAbsolutePath() + "\"";
                this.logger.log("CMD :" + cmd);
                Process proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                f.deleteOnExit();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e);
            }
        } else {
            this.logger.log(Level.INFO, "---->createShortCut Mac");
            File fAppZip = new File(this.ofysFolder, "ofysApp.zip");
            if (fAppZip.exists()) {
                Unzip.unzip(fAppZip, this.rootFolder);
            }
            File fApp = new File(this.rootFolder, "ofys.app");
            File desktopFile = new File(System.getProperty("user.home", ""), "Desktop");
            this.logger.log(Level.INFO, "From " + fApp + " to " + desktopFile);
            if (fApp.exists() && desktopFile.exists()) {
                try {
                    File macosxFolder;
                    this.logger.log(Level.INFO, "COPY");
                    Util.copyDirectory(fApp, new File(desktopFile, "ofys.app"));
                    this.logger.log(Level.INFO, "AJUST RIGHTS");
                    String[] cmd1 = new String[]{"chmod", "-R", "777", fApp.getAbsolutePath()};
                    String[] cmd2 = new String[]{"chmod", "-R", "777", new File(desktopFile, "ofys.app").getAbsolutePath()};
                    this.logger.log(Level.INFO, "CMD1 :" + Config.getStringOfTableCmd(cmd1));
                    Process proc = Runtime.getRuntime().exec(cmd1);
                    proc.waitFor();
                    this.logger.log(Level.INFO, "CMD2 :" + Config.getStringOfTableCmd(cmd2));
                    Process proc2 = Runtime.getRuntime().exec(cmd2);
                    proc2.waitFor();
                    File olPathFile = new File(desktopFile, "ofys.app/Contents/Resources/script");
                    if (olPathFile.exists()) {
                        String contains = Util.readFile(olPathFile);
                        contains = contains.replace("PATH_OFYS_LAUNCHER", this.rootFolder.getAbsolutePath() + "/" + JAR_NAME_EXT);
                        Util.saveToFile(olPathFile, contains);
                    }
                    if ((macosxFolder = new File(this.rootFolder, "__MACOSX")).exists()) {
                        String[] cmd3 = new String[]{"chmod", "-R", "777", macosxFolder.getAbsolutePath()};
                        this.logger.log(Level.INFO, "CMD3 :" + Config.getStringOfTableCmd(cmd3));
                        Process proc3 = Runtime.getRuntime().exec(cmd3);
                        proc3.waitFor();
                        Util.deleteDirectory(macosxFolder);
                    }
                    this.logger.log(Level.INFO, "DELETE");
                    Util.deleteFile(fApp);
                }
                catch (Exception e) {
                    this.logger.log(Level.INFO, e);
                }
            } else {
                this.logger.log(Level.SEVERE, "Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ":" + fAppZip.exists() + "/" + fApp.exists() + "/" + desktopFile.exists());
                throw new Exception("Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ".");
            }
        }
    }

    private static String getStringOfTableCmd(String[] t) {
        String s = "";
        for (String ss : t) {
            s = s + " " + ss;
        }
        return s;
    }

    static {
        haveBeenInit = false;
    }
}

