(function(){
	var patient = angular.module('patient', ['patientForm']);

	patient.constant('ModificationStatus',
	{
		STATUS_CHILDREN_UPDATED : "STATUS_CHILDREN_UPDATED",
		STATUS_DELETED : "STATUS_DELETED",
		STATUS_NEUTRAL : "STATUS_NEUTRAL",
		STATUS_NEW : "STATUS_NEW" ,
		STATUS_NEW_UPDATED : "STATUS_NEW_UPDATED",
		STATUS_NON_EXISTING : "STATUS_NON_EXISTING",
		STATUS_UPDATED : "STATUS_UPDATED",
		STATUS_UPDATED_ORDER : "STATUS_UPDATED_ORDER"
	});

	patient.run(function ($templateCache, $http) {
			$http.get('/dashboard/resources/ofys/pat/pat_data/patientDataFilter.html?v=bl').then(
				function(res){
					$templateCache.put('/dashboard/resources/ofys/pat/pat_data/patientDataFilter.html?v=bl', res.data);
				}
			);
			$http.get('/dashboard/resources/ofys/pat/profil/patientInfoFilter.html?v=bl').then(
				function(res){
					$templateCache.put('/dashboard/resources/ofys/pat/profil/patientInfoFilter.html?v=bl', res.data);
				}
			);
	});

	patient.directive('searchPatientDialog', ['model','PatientAccessor',
		function(model, PatientAccessor){
		return {
			restrict: 'E',
			scope: {
				query: '=?',
				onSelect:'=?',
				focus: '=?',
				model: '=?',
                filter: '=?',
                options: '=?',
			},
			templateUrl:'/dashboard/resources/ofys/pat/search_patient_dialog.html?v=bl',
			link: function(scope, element, attrs){
				scope.query = "";
				scope.focusable = {};
				scope.list = [];
				scope.patientListPlaceholder = 'noPatientsFound';

				scope.selectPatient = function(pat){
					if(scope.onSelect){
						scope.onSelect(pat);
					}
				}

				scope.updatePatientList = function(){
					scope.list.length = 0;
					scope.isLoadingPatientList = true;
					var inSearch = angular.isDefined(scope.query) && scope.query != "";
					var listcb = function mySucces(response){
						scope.list= response.data;//PatientAccessor.removeDupesPatient(response.data);
						scope.searchResolved = inSearch;
						scope.isLoadingPatientList = false;
						model.searchPtUpdated(true);
						// scope.updateListPlaceHolder();
						// checkIfActivePatientIsInList();
					};
					var error = function(response) {
						scope.isLoadingPatientList = false;
					};
					if(inSearch){
						var nbLetters = scope.query.replace(' ', '');
						var isOk = nbLetters.length>3;
						if (isOk) {
							var queries = scope.query.split(' ');
							for (var i = 0; i < queries.length; i++) {
								if(queries[i].trim().length < 2){
									isOk=false; break;
								}
							}
						} else {
							isOk = nbLetters.match(/\d{1}/)!=null;
						}
						if(isOk){
							scope.invalidSearch = false;
							var queryObj = {q:b64EncodeUnicode(scope.query)}
							if(model.prefSettings("user_settings_SitePatients")){
								queryObj.sites = [{id: model.user().session.workSite.id}];
							}
							PatientAccessor.searchAdvanced(queryObj, listcb, error);
						} else {
							scope.isLoadingPatientList = false;
							scope.invalidSearch = true;
							model.searchPtUpdated(true);
							// model.notice().warn($filter('translate')('SearchPtMin4lettersMin2'));							
						}
					}else if (scope.patientIds!=undefined) {
						if(scope.patientIds.length > 0){
							PatientAccessor.getByIds(scope.patientIds, listcb, error);
						}else{
							scope.isLoadingPatientList = false;
						}
					}else{
						PatientAccessor.lastSeen(listcb, error);
					}
				};
			}
        }
	}]);

	patient.directive('searchPatient', ['$filter','$q','PatientAccessor','utils',
		function($filter, $q, PatientAccessor, utils){
		return {
			restrict: 'E',
			scope: {
				select: '=?',
				focus: '=?',
				model: '=?',
                filter: '=?',
                options: '=?',
				smallContainer: '=?',
			},
			template:'<input type="text" first-change="firstChangeMade" data-dyna-assist="patientSearchAssist" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				function getName(pat){
					return pat.lastName + ', '+ pat.firstName;
				}
				scope.getGenderi18n = function(gender){
					if(gender === 'M'){
						return 'SGenderM';
					}else if(gender === 'F'){
						return 'SGenderF';
					}else{
						return 'GenderI';
					}
				}

				scope.firstChangeMade = function(){
					if(scope.options && scope.options.firstChange){
						scope.options.firstChange();
					}
				}
				var patientSearchTemplate = '/dashboard/resources/ofys/pat/profil/patient_searchItem.html?v=bl';
				var patientSearchItemHtml;
				utils.getTemplate(patientSearchTemplate, function(html){
					patientSearchItemHtml = html;
				});
				scope.patientSearchAssist = {
					nextTabOnTab: true,
					hasDetails: true,
					hasHeader: true,
					descWidth: scope.smallContainer ? 350 : undefined,
					helpText: $filter('translate')('SearchPtMin4lettersMin2'),
					trigger: 'focus',
					onOpen:function(dxA){
						if(scope.options && scope.options.fixPositioning){
							scope.options.fixPositioning(dxA);
						}
					},
					onEnterAction:function(assist){
						if(assist.search.elems == null || assist.search.elems.length < 1){
							assist.doSearch = true;
							assist.updateDataSource();
						}
					},
					getAsyncData: function(query, assist){
						query = query.replace(',', '');//make sure that composed names with commas are searchable too
						return $q(function(resolve, reject) {
							var nbLetters = query.replace(' ', '');
							var isOk = nbLetters.length>3;
							if (isOk) {
								var queries = query.trim().split(' ');
								for (var i = 0; i < queries.length; i++) {
									if(queries[i].trim().length < 2){
										isOk=false; break;
									}
								}
							} else {
								isOk = nbLetters.match(/\d{1}/)!=null;
							}
							
							if(isOk && assist.doSearch){
								assist.config.emptyListText = "";
								PatientAccessor.search(b64EncodeUnicode(query.trim()), function(res){
									if(res && res.data && res.data.length > 0 && scope.options && scope.options.onFetch ){
										res.data = scope.options.onFetch(res.data);
									}
									resolve(res.data);
								}, angular.noop);
							}else{
								assist.config.emptyListText = $filter('translate')(query && isOk ? "PatientSearchEnterToSearch": "PatientSearchInvalid");
								// model.notice().warn($filter('translate')('SearchPtMin4lettersMin2'));								
								resolve([]);
							}
							assist.doSearch = false;
						});
					},
					getDescription: PatientAccessor.generatePatientSearchDescription,
					getKey: function(recipient) {
						var newScope = scope.$new();
						newScope.item = recipient;
						newScope.hideGenderIcon = true;
						var res =  utils.compile(newScope, patientSearchItemHtml);
						// $timeout(function(){
						// 	if(!newScope.$$phase) {
						// 		newScope.$digest();
						// 	}
						// },0);
						return res;
					},
					selection: function(pat, assistObject) {
						if(!scope.select){
							scope.select = getName
						}
						return scope.select(pat, assistObject);
					}
				};
			}
        }
	}]);

	patient.factory('Rights', ['model', function(model) {
		var accessor = {
			cannotLoadClinicalData: function(pt) {
				var user = model.user();
				// console.log(user);
				return (pt.isSensible===true && (user.isProf!==true || pt.treatingProfessionnal!==user.profil.id));
			},
			limitations: //Order is very important, buildRightsBool and buildRightsInt require the order to correspond with the binary values
			[
				'Billing',//0
				'Appointment',//1
				'Forms',//2
				'Documents',//3
				'LabResults',//4
				'ClinicalFile',//5
				'NonCliData',//6
				'Address',//7
				'ContactMeans',//8
				'ClientSection',//9
			],
			buildRightsString: function(rights){
				//valeur binnaire en string
				var binRights = rights.toString(2);
				//faire du padding avec 0 du resultat binnaire
				binRights = binRights.length < accessor.limitations.length ? '0'.repeat(accessor.limitations.length - binRights.length)+ binRights: binRights;
				return binRights;
			},
			buildRightsBool: function(rights){
				var i;
				var limit = {};
				//valeur binnaire en string
				var binRights = accessor.buildRightsString(rights);

				for(i = 0; i < accessor.limitations.length; i++){
					limit[accessor.limitations[i]] = binRights[i]=='1'; //Valeur boolean de tous les chiffres binaire
				}
				return limit;
			},
			buildRightsInt: function(limit){
				var rights='', res;
				for(var i = 0; i < accessor.limitations.length; i++){
					rights += limit[accessor.limitations[i]]?'1':'0';
				}
				res = parseInt(rights, 2);
				return res;
			},
			hasRight : function( user, patient, right ){
				var rightValid = false, i = 0 ;

				if(patient.lstConsentement && patient.lstConsentement.length > 0){
					while( i < patient.lstConsentement.length && !rightValid){
						rightValid = right ? //default check is user has limit
							patient.lstConsentement[i][right] === true :
							patient.lstConsentement[i].idUserAnchor === user.id ;
						i++;
					}
				}else{
					rightValid = true;
				}
				return rightValid;
			},
			userHasRight : function(patient, right){
				return accessor.hasRight(model.user().sessionUser.user, patient, right);
			},
			getSessionUserConsent: function(patient){
				return accessor.getConsent(patient, model.user().sessionUser.user)
			},
			getConsent: function(patient, user){
				var res = {};
				var defaultConsent = !(patient && patient.lstConsentement && patient.lstConsentement.length > 0);
				if(!defaultConsent){
					var consent = patient.lstConsentement.find(function(e){return e.idUserAnchor == user.id});
					if(consent){
						return accessor.buildRightsBool(consent.droits)
					}
				}
				accessor.limitations.forEach(function(e){res[e]= defaultConsent});
				return res;
			},
			updateLimitationTypes: function(rights){
				var i;
				var types = [];
				//valeur binnaire en string
				var binRights = accessor.buildRightsString(rights);

				for(i = 0; i < accessor.limitations.length; i++){
						if(binRights[i]=='1'){
							types.push(accessor.limitations[i]);
					}
				}
				return types;
			}
		};

		return accessor;
	}]);

	patient.factory('PatientUtils', [function() {
		var utils = {
			getCleanPatient : function(p){
				return _.omit(p, ['viewbag', 'title_html']);
			},
			getSuperCleanPatient : function(p){
				var pat = _.omit(p,
						['viewbag','title_html','lstConsentement','lstPatientIdentifier','lstPatientProfessionnal','bloodType','messageAppointment','lastVerificationDate','lastActivityDate',
							'expirationCAM','fatherName','spouseName','motherName','motherHin','fatherHin','tutorName','lastProfileVersion','treatingProfessionnal','txProfName',
							'isSensible','isScanned','custodyTerms','lstPatientAlerts','mother','father','tutor','inactiveDate','inactiveRaison',
							'b2bInformation','sofyAuthorized','className','user','searchLastName','searchFirstName','race','maritalStatus','note',
							'age','oAge','ageStr','citizenship','decorators','lstContactInformation','lstAddress','lstSites']);
				return pat;
			},
			getPatientIdString: function(usr){
				if(usr){
					var separator = usr.firstName && usr.lastName?', ': '';
					var res = [
						usr.lastName+ separator + usr.firstName,
						usr.birthDate?usr.birthDate: null,
						usr.healthInsuranceNumber?"["+usr.healthInsuranceNumber +"]":null,
					].filter(function(e){return e != null;});
					return res.join(" ");
				}
				return "";
			}
		}
		return utils;
	}]);

	patient.factory('PatientAccessor', ['DashAPI', 'MessageLink','$filter','utils', '$q', function(DashAPI, MessageLink, $filter,utils,$q) {

		function hasContact(t){
			if (t.email) return t.email;
			if (t.emailAutre) return t.emailAutre;
			return;
		}
		function hasEmail(t){
			return !!(t.email || t.emailAutre);
		}
		function hasMainEmail(t){
			return !!(t.email)
		}
		function getContact(t){
			if(hasContact(t)){
				if(t.email ) return t.email;
				if(t.emailAutre) return t.emailAutre;
				if(t.cell) return t.cell;
			}
		}
		function getCellContact(t){
			if(t.cell){
				if(t.cell) return t.cell;
			}
		}
		
		var accessor = {
			sortOnDate: function (a, b) {
				var d1 = '9999-99-99';	// pour tri adéquat si compare with datetime. Et si deja dt = pas grave.
				var d2 = '9999-99-99';
				if (a.className==='CEncounter') {
					d1 = a.lstProf[0].entryDateS;
				} else if(a.className === "CLaboFile" || a.className === "CLaboResultsProfessionnal"){
					d1 = a.entryDate;
				} else if (a.date) {
					d1 = a.date.length===10 ? a.date + ' 00:00':a.date;
				} else if (a.className==='CPatientRecall'){
					if (a.dateRecall) {
						d1 = a.dateRecall.length===10 ? a.dateRecall + ' 00:00':a.dateRecall;
					} else if (a.dateCreated) {
						d1 = a.dateCreated.length===10 ? a.dateCreated + ' 00:00':a.dateCreated;
					}
				} else if (a.dateTimeStart) {
					d1 = new moment(a.dateTimeStart).format("YYYY-MM-DD HH:mm");
				}

				if (b.className==='CEncounter') {
					d2 = b.lstProf[0].entryDateS;
				} else if(b.className === "CLaboFile" || b.className === "CLaboResultsProfessionnal"){
					d2 = b.entryDate;
				} else if (b.date) {
					d2 = b.date.length===10 ? b.date + ' 00:00':b.date;
				} else if (b.className==='CPatientRecall'){
					if (b.dateRecall) {
						d2 = b.dateRecall.length===10 ? b.dateRecall + ' 00:00':b.dateRecall;
					} else if (b.dateCreated) {
						d2 = b.dateCreated.length===10 ? b.dateCreated + ' 00:00':b.dateCreated;
					}
				} else if (b.dateTimeStart) {
					d2 = new moment(b.dateTimeStart).format("YYYY-MM-DD HH:mm");
				}
				// d1 = dateStrToLong(d1);
				// d2 = dateStrToLong(d2);
				if (d1 > d2) {
					return -1;
				}
				if (d2 > d1) {
					return 1;
				}
				var compId = a.id>b.id ? -1 : 1;	// inverse du l'id si date ==
				if (b.className==='CEncounter') {
					// console.log('enc: ' + a.id + '/' + b.id + '\ndate:' + d1 + "/" + d2);
				}
				return compId;
			},
			b2bVulnerabilityCodes : {
				C00 : [1,"00", "00000","AUCUNE PATHOLOGIE"],
				C01 : [2,"01", "99500","PROBLÈMES DE SANTÉ MENTALE CHRONIQUES ET RÉCIDIVANTS (DSM-V): TROUBLES D'ANXIÉTÉ GÉNÉRALISÉE, TROUBLES DU COMPORTEMENT ALIMENTAIRE (ANOREXIE, BOULIMIE)"],
				C02 : [3,"02", "99501","MPOC - ASTHME - PNEUMOPATHIES PROFESSIONNELLES"],
				C03 : [4,"03", "99502","MALADIE CARDIAQUE ARTERIO-SCLEROTIQUE, INS CARD, HTA (gr 3)"],
				C04 : [5,"04", "99503","CANCER EN TX ACTIF OU PROJETE OU EN PHASE PALLIATIVE"],
				C05 : [7,"05", "99504","DIABÈTE AVEC HÉMOGLOBINE A1C À 6,5 OU PLUS AU MOMENT DU DIAGNOSTIC EXCLUANT LE DIABÈTE DE GROSSESSE"],
				C06 : [6,"06", "99505","TOXICOMANIE OU ALCOOLISME EN COURS DE SEVRAGE OU AYANT DONNÉ LIEU À UNE CURE DE DÉSINTOXICATION DE DROGUES DURES OU D'ALCOOL AU COURS DES CINQ DERNIÈRES ANNÉES, TOXICOMANIE SOUS TRAITEMENT DE MÉTHADONE OU DE BUPRÉNORPHINE"],
				C07 : [8,"07", "99506","VIH/SIDA, HEPATITE C"],
				C08 : [9,"08", "99507","MMALADIES DÉGÉNÉRATIVES DU SYSTÈME NERVEUX, DÉMENCE AVEC MMSE DE 26 ET MOINS, BLESSÉS MÉDULLAIRES AVEC SÉQUELLES PERMANENTES ENTRAÎNANT UNE INVALIDITÉ ET DES TRAUMATISMES CRÂNIENS AVEC SÉQUELLES PERMANENTES ENTRAÎNANT UNE INVALIDITÉ"],
				C09 : [12,"09", "99510","MALADIES INFLAMMATOIRES CHRONIQUES: PAR, PSORIASIS SYST, LUPUS, SCLERODERMIE, COL ULC, CROHN"],
				C10 : [13,"10", "99511","TROUBLES DÉPRESSIFS MAJEURS AIGUS, PREMIER ÉPISODE OU TROUBLES ANXIEUX AIGUS, PREMIER ÉPISODE"],
				C11 : [14,"11", "99512","TROUBLES DEPRESSIFS MAJEURS RECIDIVANTS"],
				C12 : [15,"12", "99513","INSUFFISANCE RÉNALE CHRONIQUE AVEC UNE CLAIRANCE DE LA CRÉATINE, INFÉRIEURE À 30 ML PAR MINUTE, INSUFFISANCE HÉPATIQUE"],
				C13 : [16,"13", "99514","MALADIES THROMBOGÈNES NÉCESSITANT UNE ANTICOAGULATION À VIE, FIBRILLATION AURICULAIRE AVEC CHADS À 2 ET PLUS"],
				// C14 : [17,"14", "99515","FIBRILLATION AURICULAIRE SOUS ACO A VIE AVEC INR"],
				C15 : [19,"15", "99516","TROUBLES DE DÉFICIT DE L'ATTENTION AVEC OU SANS HYPERACTIVITÉ POUR LES PATIENTS < 18 ANS"],
				C16 : [20,"16", "99517","DEF INTELLECTUELLE PATIENTS AVEC TR IMPORTANTS D'EXPRESSION ET DE COMPREHENSION"],
				C17 : [21,"17", "99518","DEF AUDITIVE: COMMUNICATION GESTUELLE OU PAR ECRIT. DEF VISUELLE: BESOIN D'UN ACCOMPAGNATEUR"],
				C18 : [22,"18", "99519","DOUL CHRON>6 MS A/A MAL CHRON ET INCAPACITE FONCT OU BESOIN RX EN CONTINUE POUR ETRE FONCTIONNEL"],
				C19 : [23,"19", "99520","AVC ENTRAINANT DES TR GRAVES DE MOBILITE, DE COMPORTEMENT, D'EXPRESSION OU DE COMPREHENSION"],
				C20 : [24,"20", "99521","PROB SANTE (DSM-IV): TR. PSYCH., BIPOL., ENVAHIS. DE DEVELOP. (SPECTRE DE L'AUTISME, ASPERGER)"]
			},
			sortVersion: function(data){
				var formVersion = {};
				for(var i = 0; i < data.length; i++){
					if(!data[i].isModifiable){
						formVersion[data[i].idForm] = formVersion[data[i].idForm] || [];
						formVersion[data[i].idForm].push(data[i]);
						if(i != -1){
							data.splice(i, 1);
							i--
						}
					}
				}
				return formVersion;
			},
			getPatientEmail: function(pat){
				var res = {};
				if(pat && pat.lstContactInformation){
					for (var i = 0; i < pat.lstContactInformation.length; i++) {
						var contact = pat.lstContactInformation[i];
						if(contact.typeContact === 1 ){
							res.email = contact;
						} else if(contact.typeContact === 4){
							res.emailAutre = contact;
						}
					}
				}
				res.hasAnEmail = hasEmail(res);
				res.hasMainEmail = hasMainEmail(res);
				res.useContact = getContact(res);
				return res;
			},
			getPatientTexto: function(pat){
				var res = {};
				if(pat && pat.lstContactInformation){
					for (var i = 0; i < pat.lstContactInformation.length; i++) {
						var contact = pat.lstContactInformation[i];
						if(contact.typeContact === 5){
							res.cell = contact;
						}
					}
				}
				res.hasCell = !!(res.cell);
				res.useContact = getCellContact(res);
				return res;
			},
			hasSofyAccess: function(fromPatient, pat){
				return (fromPatient.id != null && 
					(
						((pat.motherId == fromPatient.id && pat.motherSofyAccess ) ||
						(pat.fatherId == fromPatient.id  && pat.fatherSofyAccess) ||
						(pat.tutorId == fromPatient.id  && pat.tutorSofyAccess)) &&
						(pat.age <= 14 || pat.permanentSofyAccess)
					)
				)
			},
			getPatientsWithSofyAccess:function(pat){
				var lst = [];
				return $q.all([accessor.sofyAccessLoadPatient("mother", pat, pat.motherId, pat.motherSofyAccess, lst),
				accessor.sofyAccessLoadPatient("father", pat, pat.fatherId, pat.fatherSofyAccess, lst),
				accessor.sofyAccessLoadPatient("tutor", pat, pat.tutorId, pat.tutorSofyAccess, lst)]).then(function(){
					return lst;
				});
			},
			sofyAccessLoadPatient: function(guardianType, patient, id, access, lst){
				
				return $q(function(resolve, reject){
					if(id != null && access ){
						if(!patient[guardianType]){
							accessor.getPatient(id, function(res){
								lst.push(res.data);
								resolve(lst);
							}, reject);
						}else{
							lst.push(patient[guardianType]);
							resolve(lst);
						}
					}else{
						resolve(lst);
					}
				})
			},
			getB2BCode:function (index, b2bInformation){
				var discode = "C00";
				if(angular.isDefined(b2bInformation) &&
					angular.isDefined( b2bInformation.vulnerabilities[index]) &&
					angular.isDefined(b2bInformation.vulnerabilities[index].disCode)){
					discode = b2bInformation.vulnerabilities[index].disCode;
				}
				return discode;
			},
			generatePatientSearchDescription: function(pat) {
				var description = "<ul style='list-style-type:disc;-webkit-padding-start:12px;margin-bottom:0px;line-height:1.5'>";
				var adrss = "";
				if (angular.isDefined(pat.lstAddress) && pat.lstAddress.length>0) {
					var a = pat.lstAddress[0];
					var arr = [];
					if (OfysUtils.isNotEmpty(a.street)) {
						arr.push(a.street)
					}
					if (OfysUtils.isNotEmpty(a.city)) {
						arr.push(a.city.name)
					}
					if (OfysUtils.isNotEmpty(a.postalCode)) {
						arr.push(a.postalCode)
					}
					adrss = arr.join(', ');
				}
				var cont = "";
				if (angular.isDefined(pat.lstContactInformation) && pat.lstContactInformation.length>0) {
					var arr = [];
					for (var i = 0; i< pat.lstContactInformation.length; i++) {
						var a = pat.lstContactInformation[i];
						if (OfysUtils.isNotEmpty(a.contact)) {
							var c = $filter('tel')(a.contact) + (OfysUtils.isNotEmpty(a.note) ? ": " + a.note : "");
							arr.push(c)
						}
					}
					cont = arr.join(', ');
				}
				var contact = cont.length===0 ? "" : cont;
				var vuln = "";
				var inscrit = "";
				if (pat.b2bInformation) {
					if (pat.b2bInformation.status && pat.b2bInformation.status==2) {
						inscrit = $filter("translate")("B2BINSCRIT_CONFIRME");;
					} else {
						inscrit = $filter("translate")("B2BNON_INSCRIT");;
					}
					if (pat.b2bInformation.vulnerabilities) {
						var arr = []
						for (var i = 0; i< pat.b2bInformation.vulnerabilities.length; i++) {
							if (pat.b2bInformation.vulnerabilities[i] && OfysUtils.isNotEmpty(pat.b2bInformation.vulnerabilities[i].disCode)) {
								arr.push(pat.b2bInformation.vulnerabilities[i].disCode);
							}
						}
						vuln = arr.join(', ');
					}
				}
				var hinDos = (pat.healthInsuranceNumber ? pat.healthInsuranceNumber : "") +
				((pat.patientRecordNumber && pat.patientRecordNumber.charAt(0)!='#') ? (' [' + pat.patientRecordNumber + ']') : '');
				var mdfam = OfysUtils.isNotEmpty(pat.txProfName) ? ' MD Fam: ' + pat.txProfName : '';
				description +=
				(hinDos.length===0 ? '' : "<li style='margin-bottom:3px'>" + hinDos + "</li>") +
				(mdfam.length===0 ? '' : "<li style='margin-bottom:3px'>" + mdfam + "</li>")+
				(contact.length===0 ? "" : "<li style='margin-bottom:3px'>" + contact + "</li>") +
				(adrss.length===0 ? "" : "<li style='margin-bottom:3px'>" + adrss + "</li>") +
				"<li style='margin-bottom:3px'>" + inscrit + (vuln.length===0 ? '' : ': ' + vuln) + "</li>" +
				"</ul>";
				description += "</ul>";
				return description;
			},
			getB2BText: function(b2bInformation){
				var res = ""
				if(b2bInformation){
					if(b2bInformation.vulnerabilities){

						res += " "
						for (var i = 0; i < b2bInformation.vulnerabilities.length; i++) {
							if(i === 0){
								res += $filter("translate")("B2BVulCode");
							}
							var vul = this.b2bVulnerabilityCodes[this.getB2BCode(i, b2bInformation)];
							if(vul){
								res += vul[1]+" "
							}
						}
					}
					if(b2bInformation.status === 2 || b2bInformation.status === 0){
						res += $filter("translate")("B2BRegistration")+ $filter("translate")("B2B" + b2bInformation.status);
					}
				}
				return res;
			},
			namExpired: function(date){
				if(date && date.length == 4){
					var d = moment(date,"YYMM");
					var n = moment();
					var res = d.isBefore(n, 'month') || d.isSame(n, "month");
					return res;
				}
				return false;
			},
			//Should not be necessary but is required because of probable concurency issue.
			//Patients lastSeen returns patients duplicate object in some cases.
			//it is possible to have a patient in lastSeen list with different seen dates multiple times
			//(probably dashboard related: accessing the patient in the web view and setting the currentPatient in swt Ofys may be the cause of this).
			//No time to properly fix.
			removeDupesPatient: function (patientList){
				var res = [], ids = [];
				if(patientList){
					for(var i = 0; i < patientList.length; i++){
						if(ids.indexOf(patientList[i].id) < 0){
							res.push(patientList[i]);
							ids.push(patientList[i].id);
						}
					}
				}
				return res;
			},

			lastSeen : function (callback, error){
				return DashAPI.get('/dashboard/Patients/ws/lastseen', callback, error);
			},
			// n'est plus appelé auto par toutes les méthodes de changement de pt.
			setCurrent : function (id, callback, error){
				return DashAPI.get('/dashboard/Patients/ws/curr?idPatient='+id, callback, error);
			},
			getPatient : function (id, callback, error){
				return DashAPI.get('/dashboard/Patients/ws/get?idPatient='+id, callback, error);
			},
			getFusionPatient : function (id, callback, error){
				return DashAPI.get('/dashboard/Patients/ws/getFusionPatient?idPatient='+id, callback, error);
			},
			getByIds : function (ids, callback, error){
				return DashAPI.get('/dashboard/Patients/ws/getByIds?ids='+_.unique(ids), callback, error);
			},
			setAsUsed : function (id, callback, error){
				return DashAPI.get('/dashboard/Patients/ws/setAsUsed?idPatient='+id, callback, error);
			},
			save : function (patient, callback, error){
				var query = "";
				if(patient.askQuestion !== undefined){
					query += "?askQuestion="+ patient.askQuestion
				}
				return DashAPI.post('/dashboard/Patients/ws/save'+query,patient, callback, error);
			},
			saveFusion : function (patient, callback, error){
				var config = {
					showErrors : false
				};
//				if(patient.askQuestion !== undefined){
//					query += "?askQuestion="+ patient.askQuestion
//				}
				return DashAPI.post('/dashboard/Patients/ws/saveFusion', patient,callback, error, config);
			},
			print : function (patient, callback, error){
				patientPrint = cleanPatToPrint(patient)
				return DashAPI.post('/dashboard/Patients/ws/print', patientPrint, angular.noop, error);
			},
			getDSQHtml: function(patient, callback, error){
				return DashAPI.post('/dashboard/dsq/ws/html', patient, callback, error);
			},
			getDSQConsent: function(patient, callback, error){
				return DashAPI.post('/dashboard/dsq/ws/getConsent', patient, callback, error);
			},
			newReminder : function (patient, callback, error){
				return DashAPI.post('/dashboard/Patients/ws/newReminder',patient, angular.noop, error);
			},
			getIdentifiers : function (patient, callback, error){
				return DashAPI.post('/dashboard/Patients/ws/identifiers',null, callback, error);
			},
			open : function (id, callback, error){
				return DashAPI.get('/dashboard/Patients/editPatient?idPatient=' + id, callback, error);
			},
			newPatient : function (callback, error){
				return DashAPI.get("/dashboard/Patients/ws/new", callback, error);
			},
			search : function (q, callback, error){
				return DashAPI.get("/dashboard/Patients/ws/search?q="+ q, callback, error);
			},
			searchAdvanced : function (queryObject, callback, error){
				return DashAPI.post("/dashboard/Patients/ws/searchAdvanced",queryObject, callback, error);
			},
			findPatientExactNoDossier : function (noDossier, callback, error){
				return DashAPI.get("/dashboard/Patients/ws/findPatientExactNoDossier?noDossier="+ noDossier, callback, error);
			},
			patientDependents : function (idPatient, callback, error){
				return DashAPI.get("/dashboard/Patients/ws/patientDependents?idPatient="+idPatient, callback, error);
			},
			telmedemail : function (queryObject, callback, error){
				var q = '?idPatient='+queryObject.idPatient + '&idClient='+ queryObject.idClient + '&email='+ queryObject.email + '&with=' + queryObject.with + '&room=' + queryObject.room;
				return DashAPI.get("/dashboard/Patients/ws/telmedemail" + q, callback, error);
			},
			telmedtexto : function (queryObject, callback, error){
				var q = '?idPatient='+queryObject.idPatient + '&idClient='+ queryObject.idClient + '&cell='+ queryObject.cell + '&room=' + queryObject.room;
				return DashAPI.get("/dashboard/Patients/ws/telmedtexto" + q, callback, error);
			},
// PatientSurvey calls - ne semble pas être appelé. Pas utile vraiment.
			listOfPatientSurveysForClient : function (callback, error){
				return DashAPI.get('/dashboard/PatientSurvey/ws/getListOfPatientSurveysForClient', callback, error);
			},
			patientsurvey : function (patient, callback, error){
				return DashAPI.get('/dashboard/PatientSurvey/ws/getPatientSurveysByIdPatient?idPatient='+patient.id, callback, error);
			},
			patientAptsurvey : function (param, callback, error){
				return DashAPI.get('/dashboard/PatientSurvey/ws/getPatientSurveysByIdPatientIdApt?idPatient='+param.idPatient + '&idApt=' + param.idApt, callback, error);
			},
			responsePatientSurvey : function (survey, callback, error){
				return DashAPI.get('/dashboard/PatientSurvey/ws/getResponsePatientSurveys?idQuest='+survey.idQuest + '&idResp=' + survey.idResp, callback, error);
			},
			sendSurveyToEmail : function (survey, callback, error){
				return DashAPI.get('/dashboard/PatientSurvey/ws/sendSurveyToEmail?idQuest='+survey.idQuest + '&idPatient=' + survey.idPatient, callback, error);
			},
			popoverApiInit: function(scope){
				scope.patientEditPopover = {
					activeEditWindow: true,
					onShow: function(api){
						scope.patientEditPopover.api = api;
						utils.showPopoverOverlay(true);
					},
					onHide:function(){
						utils.showPopoverOverlay(false);
					},
					close:function(){
						scope.patientEditPopover.api && 
						scope.patientEditPopover.api.hide && 
						scope.patientEditPopover.api.hide();
					}
				}

				return scope.patientEditPopover;
			},
			updateMessageLink: function (pat,scope){
				if (MyNamespace.helpers.isEmpty(pat)) {
					if (accessor.messageLinkKey) delete accessor.messageLinkKey;
				} else {
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: pat.id,
						linkType: MessageLink.linkTypes.patient,
						id: pat.id,
						pat: pat
					}, scope);
				}
			},
		};
		function cleanPatToPrint(item) {
			// Sert à régler un problème de "circular structure to JSON""
			if(item.currItem){
				delete item.currItem;
			}
			return item;
		}

		return accessor;
	}]);

	patient.controller('PatientController',
		['Markdown','$scope', 'model', 'PatientAccessor', '$log', '$state', 'patientShowTitles', 'FlView', '$popover',
		'$q','$timeout','hotkeys','Rights','QValidation','$filter', 'AppointmentAccessor',
		function (Markdown, $scope, model, PatientAccessor, $log, $state, patientShowTitles, FlView, $popover,
			$q, $timeout, hotkeys, Rights, QValidation, $filter, appointmentAccessor) {

		model.activeController('pt');
		model.activeMenu('Patients');
		$scope.focusable = {};
		model.patient().q = "";
		$scope.patientListPlaceholder =  "findPatient";

		$scope.updateListPlaceHolder = function(){
			if(model.patient().q.length > 0 && model.patient().q.length < 3){
				$scope.patientListPlaceholder = 'invalidSearch3Chars';
			} else {
				$scope.patientListPlaceholder = 'noPatients';
			}
		};

		$scope.testMd = {
// 			md: `≖# Hello

// **January** was the one
// *February* came to pass
// <span style="color:#008efa">March</span> was litt up
// Months:

// 1. January
// 2. February
// 3. March 
// 4. April
// 5. June

// * [ ]  Jingle bells
// * [ ] Ring worms`
// 		}

md: '≖emploi<mais après 27 ans de travail pr la cie, a eu un très bon plan de retraite ( 2 ans payés idem, puis aura droit à 1 an chômage, puis retraite'
// md: `≖
// # Ceci est tritre premier
// **Ceci est en gras**
// *Ceci italique*
// <span style="color:  #cd2828;">Ca c'est couleur</span>
// Une ligne

// * Liste à puce
// * item 2

// 1. Liste numéroté
// 2. item 2

// Tableau

// | Mon | tableau | est |
// | --- | ------- | --- |
// | 3 | si je savais | Alors |
// | 4 | Maintenant | Mais |
// `


// 			md: Markdown.txtToMd(`≖# Hello

// **January** was the one
// *February* came to pass
// <span style="color:#008efa">March</span> was litt up
// Months:

// 1. January
// 2. February
// 3. March 
// 4. April
// 5. June

// * [ ]  Jingle bells
// * [ ] Ring worms`)
// 		}
// 		$scope.tuiOptions = {

		}

		$scope.testMdToText = function () {
			console.log(Markdown.mdToTxt($scope.testMd.md));
// 			console.log(Markdown.mdToTxt(`≖# Hello

// **January** was the one
// *February* came to pass
// <span style="color:#008efa">March</span> was litt up
// Months:

// 1. January
// 2. February
// 3. March 
// 4. April
// 5. June
// * fasdfasdf
// * [x] asdf
// * [ ] Jingle bells
// * [ ] Ring worms`))
		}

		hotkeys.add({
			combo: 'alt+r',
			description: 'Rechercher un rendez-vous par date',
			callback: function() {
				$scope.focusable.focusSearchInput();
			}
		});

		$timeout(function(){
			if($scope.focusable.focusSearchInput){
				$scope.focusable.focusSearchInput();
			}
			model.fosucSearchTimeout = 0;
		}, model.fosucSearchTimeout=== 0?0:600); //for first page load anything less than 500ms doesn't seem to work

		$scope.newPatientOptions = {
			showExit: true,
			exit: function(){
				model.patient().currPatient = {};
			},
			onSave: function(p){
				var index = model.patient().currList.findIndex(function(e){
					return e.id == p.id;
				});
				if(index == -1){
					model.patient().currList.push(p);
				}
			}
		};
		$scope.patientViewMode=function(mode){
//			if(model.patientViewMode==1)
//				model.patientViewMode=0;
//			else
				model.patientViewMode = mode;
		};
		$scope.listSize = function() {
			return model.listPatSize();
		};

		$scope.editPatientPopoverOptions = {
			showExit: true,
			exit:function(){
				$timeout(function() {
					angular.element('#btn-edit-patient').triggerHandler('click');
					$scope.popoverEdit = false;
				});
			}
		};

		$scope.popoverEdit = false;
		$scope.popoverEditMode = function(mode){
//			if($scope.editPatientPopoverOptions.dirty && $scope.editPatientPopoverOptions.dirty()){
//			 	$scope.editPatientPopoverOptions.close();
//			}
//			else{
				$scope.popoverEdit = !$scope.popoverEdit;
//			}
		};


		$scope.isLoadingPatientList = false;
		$scope.searchResolved = false;
		$scope.showRecemmentConsultes = function() {
			return $scope.searchResolved===false && model.patient().currList.length>0;
		};
		$scope.hasFoundToMany = function() {
			var clientPref = model.clientPreferences();
			return $scope.searchResolved===true && clientPref.returnListLength<=model.patient().currList.length;
		};

		function checkIfActivePatientIsInList() {
			if (angular.isDefined(model.patient().currPatient) && model.patient().currPatient.id) {
				var lstPt = model.patient().currList.filterFast(function(a){return a.id===model.patient().currPatient.id;});
				if (lstPt.length===0) {
					model.patient().currPatient={};
				}
			}
		}
		checkIfActivePatientIsInList();

		$scope.$on("$destroy", function handler() {
	        $log.log("PatientController destroy");
	    });

		$scope.addNewPatient = function(){
			var newPatient = {isNew: true, className: "CPatient", viewbag: {limitations:Rights.getConsent()}};
			$scope.viewOptions.selectPatient(newPatient);
		};

		$scope.updatePatientList = function(){
			model.patient().currList.length = 0;
			$scope.isLoadingPatientList = true;
			var inSearch = angular.isDefined(model.patient().q) && model.patient().q != "";
			var listcb = function mySucces(response) {
				if (response.data.ms) {
					model.notice().warn(response.data.ms);
				} else {
					model.patient().currList= response.data;//PatientAccessor.removeDupesPatient(response.data);
					$scope.searchResolved = inSearch;
					model.searchPtUpdated(true);
					$scope.updateListPlaceHolder();
					checkIfActivePatientIsInList();
					//*DELETECODE*
					// $scope.selectPatient(model.patient().currList[0]);
					// $timeout(function(){
					// 	angular.element('#btn-edit-patient').triggerHandler('click');
					// }, 300)
					//*DELETECODE*
				}
				$scope.isLoadingPatientList = false;
			};
			var error = function(response) {
				$scope.isLoadingPatientList = false;
			};
			if(inSearch){
				var nbLetters = model.patient().q.replace(' ', '');
				var isOk = nbLetters.length>3;
				if (isOk) {
					var queries = model.patient().q.split(' ');
					for (var i = 0; i < queries.length; i++) {
						if(queries[i].trim().length < 2){
							isOk=false; break;
						}
					}
				} else {
					isOk = nbLetters.match(/\d{1}/)!=null;
				}
				if(isOk){
					$scope.invalidSearch = false;
					var queryObj = {q:b64EncodeUnicode(model.patient().q)}
					if(model.prefSettings("user_settings_SitePatients")){
						queryObj.sites = [{id: model.user().session.workSite.id}];
					}
					PatientAccessor.searchAdvanced(queryObj, listcb, error);
				} else {
					$scope.isLoadingPatientList = false;
					$scope.invalidSearch = true;
					model.searchPtUpdated(true);
					// model.notice().warn($filter('translate')('SearchPtMin4lettersMin2'));
				}
				// PatientAccessor.search(b64EncodeUnicode(model.patient().q), listcb, error);
			}else if ($scope.patientIds!=undefined) {
				if(Array.isArray($scope.patientIds) && $scope.patientIds.length > 0){
					PatientAccessor.getByIds($scope.patientIds, listcb, error);
				}else{
					$scope.isLoadingPatientList = false;
				}
			}else{
				PatientAccessor.lastSeen(listcb, error);
			}
		};

		$scope.focusable.onListReady = function(){
			$timeout(function(){
				$scope.focusable.patientsListFocus(true);
			}, 150);
		};

		$scope.forceReload = function() {
			$scope.patientIds = undefined;
			$scope.updatePatientList();

		};
		// optimisation. je ne load pas une liste inutilement.
//		if(model.patient().currList.length == 0) {
//			// donc nouvelle ouverture. Je veux updater la liste.
//			$scope.updatePatientList();
//		}
		$timeout(function() {
			if(model.patient() && model.patient().currPatient && model.patient().currPatient.lstScroll){
				model.patient().currPatient.lstScroll()
			}
		}, 400)

		//This function sets a lock and has a timeout to ensure that the ui updates
		// The lockForUpdate hides all the patients data and onces that is hidden the patient can be updated.
		// This makes sure the user can't open data during the transition which causes mix up of patient's data.
		function securePatientUpdate(pat){
			return $q(function(resolve, reject){
				if(model.patient().currPatient){
					model.patient().currPatient.lockForUpdate = true;
				// model.patient().currPatient = null;
					$timeout(function(){
						model.patient().currPatient.lockForUpdate = false;
						model.patient().currPatient = pat;
						resolve();
					}, 0)
				}else{
					model.patient().currPatient = pat;
					resolve();
				}
			});
		}
		
		$scope.viewOptions = {
			selectPatient: function(patient){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
						if($scope.popoverEdit){
							$scope.editPatientPopoverOptions.exit();
						}
						// if($scope.)
						$scope.patientConsentBlock = !Rights.userHasRight(patient);

						if($scope.patientConsentBlock){
							model.patient().currPatient = {};
							return;
						}

						// if(patient.lstConsentement && patient.lstConsentement.length > 0){
						// 	var dontBlock = false;
						// 	for(var i = 0 ; i < patient.lstConsentement.length; i++){
						// 		if(patient.lstConsentement[i].idUserAnchor === model.user().sessionUser.id){
						// 			dontBlock = true;
						// 			break;
						// 		}
						// 	}
						// 	 = !dontBlock;
						// }else{
						// 	$scope.patientConsentBlock = false;
						// }
						if(!patient.isNew && model.patient().currPatient.id != patient.id) {
							$scope.model.patientAllDataTabs().activeTab='PatientData';
		//					PatientAccessor.getPatient(patient.id, function(res){
		//					res.data.contacts = res.data.lstContactInformation;
		//					res.data.adress = res.data.lstAddress;
		//					model.patient().currPatient = res.data;
		//					});
							securePatientUpdate(patient).then(function(){
								model.searchPtUpdated(true);
								PatientAccessor.setAsUsed(patient.id);
						
								if(model.summaryExternalViewer && patient.viewbag && patient.viewbag.patData && patient.viewbag.patData.sum){
									patientShowTitles.externalSummary(patient);
								}
							})
						}else if(patient.isNew){
							securePatientUpdate(patient).then(function(){
								model.patientUpdated(true);
								model.searchPtUpdated(true);
							})
						}
					}
				});
			}
		};

		$scope.selectPatient = function(patient){
			$scope.viewOptions.selectPatient(patient);
		};
	
		var menu;
		$scope.getFuturPatAppt = function(patient, e){
			if(menu)menu.destroy();
			appointmentAccessor.findFuturAppointmentPatient(patient.id, function(res){
				menu = $popover($(e.currentTarget),{
		            trigger:"focus",
		            autoClose: true,
		            placement: "auto right",
		            keyboard: false,
		            animation: "am-flip-x",
		            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
		            onShow: function(){
		            },
		        });
				menu.$scope.apptList = res.data.sort(function(a,b){
					return a.when-b.when;
				})
				menu.$scope.futur = true
				$timeout(function(){
					menu.show();
				}, 100)
			})
		}
		
		$scope.getPastPatAppt = function(patient, e){
			if(menu)menu.destroy();
			appointmentAccessor.findPastAppointmentPatient(patient.id, function(res){
				menu = $popover($(e.currentTarget),{
		            trigger:"focus",
		            autoClose: true,
		            placement: "auto right",
		            keyboard: false,
		            animation: "am-flip-x",
		            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
		            
		        });
				menu.$scope.apptList = res.data.sort(function(a,b){
					return b.when-a.when;
				})
				menu.$scope.futur = false
				$timeout(function(){
					menu.show();
				}, 100)
			})
		}

		$scope.showStringsFromObjArray = function(a, v, sep) {
			return _.pluck(a, v).join(sep);
		};
		$scope.showPatientHtml = function(pat) {
			return patientShowTitles.showPatientHtml(pat);
		};
		$scope.isActive = function(patient){
			 return angular.isDefined(model.patient().currPatient) && model.patient().currPatient.id === patient.id;
		};
		var mergedData;
		$scope.patientIds = undefined;
		if ($state.params.rev_ids!==undefined ||
			$state.params.edits_ids!==undefined ||
			$state.params.date_edits_ids!==undefined ||
			$state.params.term_ids!==undefined ||
			$state.params.rappel_ids!==undefined ||
			$state.params.attente_ids!==undefined 
			) {
			mergedData = _.clone($state.params.rev_ids ? $state.params.rev_ids : []);
			mergedData = $.merge(mergedData, _.clone($state.params.edits_ids ? $state.params.edits_ids : []));
			mergedData = $.merge(mergedData, _.clone($state.params.date_edits_ids ? $state.params.date_edits_ids : []));
			mergedData = $.merge(mergedData, _.clone($state.params.term_ids ? $state.params.term_ids : []));
			mergedData = $.merge(mergedData, _.clone($state.params.rappel_ids ? $state.params.rappel_ids : []));
			mergedData = $.merge(mergedData, _.clone($state.params.attente_ids ? $state.params.attente_ids : []));
			$scope.patientIds = mergedData;	// les id des patients à loader, séparés par ,
			model.patient().currList.length = 0;	// pour forcer une nouvelle liste.
			if (model.patient().q) model.patient().q = '';
			$scope.updatePatientList();
			cleanUpRouteIds();
		}

		//*DELETECODE*
		// $scope.patientIds = [3050113];	// les id des patients à loader, séparés par ,
		// model.patient().currList.length = 0;	// pour forcer une nouvelle liste.
		// if (model.patient().q) model.patient().q = '';
		// $scope.updatePatientList();
		//*DELETECODE*


		function cleanUpRouteIds(){
			$state.go('.', {
				rev_ids: undefined,
				edits_ids: undefined,
				date_edits_ids: undefined,
				term_ids: undefined,
				rappel_ids: undefined,
				attente_ids: undefined,
				cleared: true,
			});
			// delete $state.params.term_ids;
			// $stateParams.cleared = true;
			// delete $stateParams.rev_ids
			// delete $stateParams.edits_ids
			// delete $stateParams.date_edits_ids
			// delete $stateParams.term_ids
			// delete $stateParams.rappel_ids
			delete $state.params.rev_ids
			delete $state.params.edits_ids
			delete $state.params.date_edits_ids
			delete $state.params.term_ids
			delete $state.params.rappel_ids
			delete $state.params.attente_ids
		}
		model.callDashBoardCount();

	}]);

	patient.filter('hyphennam', function ($sce) {
		return function (val) {
			return moment(val, 'YYMM').format("YY-MM");
		};
	});

	patient.directive('patientResume',["model", "PatientAccessor","$filter","patientShowTitles","B2BAccessor", "Notification", "DashWebSocket","DashAPI", 
					"AppointmentAccessor", "$popover", "$timeout", "RessourceAccessor", "FlView", "QValidation",
		function(model, PatientAccessor, $filter, patientShowTitles, B2BAccessor, Notification, DashWebSocket, DashAPI, 
					appointmentAccessor, $popover, $timeout, ressourceAccessor, FlView, QValidation){
		return {
			restrict: 'E',
			templateUrl:  '/dashboard/resources/ofys/pat/patient_resume.html?v=bl',
			scope: {
				p: '=',
				newappt:'=',
				options:'='
			},
			link: function(scope, element, attrs){

                scope.centerInPage = true;
				B2BAccessor.popoverApiInit(scope);
				
				scope.isProf = function(){
					return model.user().isProf;
				};

				scope.fileOpenActive = function(){
					return scope.options && scope.options.fileOpenActive && scope.options.fileOpenActive();
				}
				scope.onAdhocPatientSave = function(p){
					return scope.options && scope.options.onAdhocPatientSave && scope.options.onAdhocPatientSave(p);
				}
				scope.openLastEncounter = function(patient){
					patientShowTitles.openActivity(patient, {mode: 'n', minimize: false, openLastEncounter:true}, patient, scope)
				};
				scope.openPatientFile = function(patient, fromPtResume){
					patient.fromAppointment = fromPtResume;
					patientShowTitles.openActivity(patient, {mode: 'n', minimize: false}, patient)
				};
				scope.openExternal = _.throttle(function(patient){
					if(scope.quickViewData !== scope.$parent.quickViewData){
						scope.quickViewData = scope.$parent.quickViewData
					}
					patientShowTitles.openActivity(patient, {mode: 'ext', minimize: false, setExternal:true, canPopBack: false}, patient, scope)
				}, 500, {trailing: false});
				
				var menu;
				scope.getFuturPatAppt = function(patient, e){
					if(menu)menu.destroy();
					appointmentAccessor.findFuturAppointmentPatient(patient.id, function(res){
						menu = $popover($(e.currentTarget),{
				            trigger:"focus",
				            autoClose: true,
				            placement: "auto left",
				            keyboard: false,
				            animation: "am-flip-x",
				            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
				            onShow: function(){
				            },
				        });
						menu.$scope.apptList = res.data.sort(function(a,b){
							return a.when-b.when;
						})
						menu.$scope.futur = true
						menu.$scope.smallContainer = scope.newappt
						$timeout(function(){
							menu.show();
						}, 100)
					})
				}
				
				scope.getPastPatAppt = function(patient, e){
					if(menu)menu.destroy();
					appointmentAccessor.findPastAppointmentPatient(patient.id, function(res){
						menu = $popover($(e.currentTarget),{
				            trigger:"focus",
				            autoClose: true,
				            placement: "auto left",
				            keyboard: false,
				            animation: "am-flip-x",
				            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
				            
				        });
						menu.$scope.apptList = res.data.sort(function(a,b){
							return b.when-a.when;
						})
						menu.$scope.futur = false
						menu.$scope.smallContainer = scope.newappt
						$timeout(function(){
							menu.show();
						}, 100)
					})
				}
				
				scope.notEmpty = OfysUtils.isNotEmpty
				scope.isTelNumber = function(i){
					return i == 0 ||
							i === 2 ||
							i === 3 ||
							i === 5 ||
							i === 6 ;
				}
				scope.contactTypes=[
					$filter("translate")("Phone"),
					$filter("translate")("Courriel"),
					$filter("translate")("Fax"),
					$filter("translate")("Pager"),
					$filter("translate")("OtherEmail"),
					$filter("translate")("Cellphone"),
					$filter("translate")("OtherCellphone"),
					$filter("translate")("Iphone"),
					$filter("translate")("OtherPhone")];
				scope.languages=["Francais","Anglais","Espagnol","Autre"];
				scope.races=[
					$filter("translate")("Caucasian"),
					$filter("translate")("African"),
					$filter("translate")("Native"),
					$filter("translate")("Latino"),
					$filter("translate")("Asian"),
					$filter("translate")("Chinese"),
					$filter("translate")("Filipino"),
					$filter("translate")("Arab"),
					$filter("translate")("Japanese"),
					$filter("translate")("Korean")];
				scope.civils=[
					$filter("translate")("N/A"),
					$filter("translate")("Single"),
					$filter("translate")("Partnership"),
					$filter("translate")("Married"),
					$filter("translate")("Divorced"),
					$filter("translate")("Widowed")];

				scope.allSites = model.user().sites;
				scope.expired = PatientAccessor.namExpired;

				function update(){
					if(scope.p){
						scope.patient = scope.p;
						if(scope.p.lstPatientProfessionnal && scope.p.lstPatientProfessionnal.length > 0){
							scope.p.lstPatientProf = [];
							for (var i = 0; i < scope.p.lstPatientProfessionnal.length; i++) {
								model.store.profs.get(scope.p.lstPatientProfessionnal[i].idProfessionnal, function(prof, loadedFromServer){
									scope.p.lstPatientProf.push(prof);
								});
							}
						}
						if(scope.p.treatingProfessionnal){
							model.store.profs.get(scope.p.treatingProfessionnal, function(prof, loadedFromServer){
								scope.p.treating = prof;
								var workSites = _.values(model.user().sites).filter(e=>e.isWorkSite);
								// console.log(workSites)
							});
						}
						if(scope.p.note !== undefined){
							scope.p.wrappednote = scope.p.wrappednote = OfysUtils.wordWrap(scope.p.note, 40, '<br/>')
						}
						if(scope.p.b2bInformation){
							scope.p.b2btxt = PatientAccessor.getB2BText(scope.p.b2bInformation)
						}
						if(scope.p.lstSites && scope.p.lstSites.length > 0){
							scope.p.pharmacies = $filter('filter')(scope.p.lstSites, {addedAs:"DRUG_STORE"});
						}
						ressourceAccessor.getRessBilled(scope.p, function(res){
							scope.listInvoice = res
						}, function(errors){
							scope.listInvoice = [];
		                    console.error(errors);
		                })
					}
				}
				scope.showStringsFromObjArray = function(a, v, sep) {
					return _.pluck(a, v).join(sep);
				};
				
				// Méthodes DSQ copiées de la directive principale de recherche dsq
				scope.neededSignFirst = false;
				scope.searchCriteria = {};
				
				scope.sendingDsqPtSearchRequest = false;
				var dsqPtSearchHandlerId = Notification.registerHandler('dsqCandidateSearch', function(msg){
					scope.sendingDsqPtSearchRequest = false;
					var statusError = DashAPI.handleReturnObject(msg.data.status);
					if (statusError=='ERROR') {
					} else if (statusError=='WARNING') {
						// signature demandé? Si oui et succès, on aura OK ensuite
						scope.neededSignFirst = true;
					} else if (statusError=='OK') {
						if (scope.neededSignFirst==true) {
							// donc a réussi le call, incluant l'obtention des signature
							scope.searchDsqPt();
						} else {
							// donc a reçu un Ok avec un niu dans l'objet du returnObject
							scope.patient.niu = msg.data.obj;
							scope.patient.viewbag.dsqActive = !!(scope.patient.niu);
							model.patientAllDataTabs()[2].disabled = !scope.patient.viewbag.dsqActive;
						}
					}
				}, scope);

				scope.searchDsqPt = function(currPatient) {
					if (scope.sendingDsqPtSearchRequest===false) {	// il faut empêcher les call répétés quand un est actif
						scope.sendingDsqPtSearchRequest = true;
						scope.neededSignFirst = false;
						scope.searchCriteria.patientId = scope.patient.id;
						DashWebSocket.sendRequest("/dashboard/dsq/ws/candidate/resolveNiu", scope.searchCriteria);
					}
				};
				
				scope.invoiceEdit = false;
				scope.openBillAndInvoice = function(currPatient){
					scope.invoiceEdit = true;
					ressourceAccessor.getRessBilled(currPatient, function(res){
						FlView.open(
							{
								templateUrl: "/dashboard/resources/ofys/ress/invoice.html?v=ay", 
								pat: currPatient, list: res,
								beforeCancel: function(e, obj){
									return QValidation.closeContext($filter('translate')('UnsavedChanges'), "invoice").then(function(successful){
										if(!successful){
											e.prevent();
										}
										scope.invoiceEdit = false;
										return successful;
									});
								},
								fl:{}
							}, 
							{
								backdrop: 'static',windowClass: "top-modal1"
							}
						)
					})
				}
				
				scope.getBilling = function(){
					return model.user().hasBilling
				}
				
				scope.hasUnpaid = function(){
					return scope.listInvoice ? scope.listInvoice.some(e => e.status == "NON_PAYE" || e.status == "PMT_PARTIEL") : false
				}

				scope.$watch(function (){
					//check if the patient change or ther is a patient modification
					return scope.p.id+model.patientUpdated().val;
				}, update);
			}
		}

	}]);

	patient.directive('patientDataSelector', ['model', function(model){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/pat_data/patient_data_selector.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				scope.model = model;
				scope.patsOptions = {
						updatePatient: false,
				};

				scope.commitSelection = function(){
					if(scope.selectorOptions && scope.selectorOptions.api &&
						scope.selectorOptions.api.getSelected){
						var seleted = scope.selectorOptions.api.getSelected();
						if(scope.saveSelection){
							scope.saveSelection(seleted)
						}
					}
					close();
				}


				scope.selectorOptions = {
					mode:'n',
					selectActive: true,
					registerApi: function(api){
						this.api = api;
						if(scope.activeCategories){
							this.api.setActiveCategories(scope.activeCategories);
						}
					}
				};

				scope.cancelSelection = function(){
					close();
				}

				function close(){
					// on supprime de la cache slm si pas patient actif
					if (scope.patient) {
						if (model.patient() && model.patient().currPatient && scope.patient.id===model.patient().currPatient.id) {
							// on ne del pas de la cache car patient actif.
						} else {
							model.patientsInQv(''+scope.patient.id, null);
						}
					}
					if(scope.$parent && scope.$parent.$hide){
						scope.$parent.$hide();
					}
				}
				function updatepatients(nv, ov, scope){
					var ovCliPatId;
					var nvCliPatId;
					if (ov && ov.id) {
							ovCliPatId = ov.id;
					}
					scope.pats = nv;
					if (nv && nv.id && !cachePatientUpdate(nv, ov)) {
						scope.patient = nv;
						nvCliPatId = nv.id;
					}
					if (scope.patient) {

						updateOptions(scope.$eval(attrs.options));
					}
					model.patientUpdated(true);
				}

				function cachePatientUpdate(nv){
					return scope.patient && nv.id === scope.patient.id && (scope.patient.viewbag && scope.patient.viewbag.patData)
				}

				function updateOptions (newOptions){
					excuteOptionAction(scope.patsOptions, newOptions);
				}

				function excuteOptionAction(oldOptions, newOptions){
					if(newOptions && newOptions.updatePatient){
//						scope.refreshPatient();
					}
				}

				scope.$watch(attrs.patient, updatepatients);

			}
		};
	}]);

	patient.directive('patientView', ['PatientAccessor', 'EncounterAccessor', 'model', 'B2BAccessor', 'patientShowTitles','MessageLink','PatientUtils', 
										'FlView','PrintAccessor', 'RessourceAccessor', 'QValidation', '$filter',
		                                  function(PatientAccessor, EncounterAccessor, model, B2BAccessor, patientShowTitles, MessageLink, PatientUtils, 
		                                  			FlView, PrintAccessor, ressourceAccessor, QValidation, $filter){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/patient.html?v=bl',
			//scope: true,
			link: function(scope, element, attrs){
				scope.centerInPage = true;
				scope.expired = PatientAccessor.namExpired;
				scope.model = model;
				scope.quickSavePlan = {
						save: function(p){
							//console.log("Save plan : " + p.note);
							if (p.isPrivate===true) {
								p.idUserAnchor = scope.model.user().sessionUser.user.id;
							} else if (p.idUserAnchor) {
								delete p.idUserAnchor;
							}
							EncounterAccessor.savePlan(p, function(o) {
								if (o.status===200) { // succès.
									angular.copy(o.data, p);
									scope.model.patientSumUpdated(true);
								}
							}, function(e){

							});
						},
						cancel: function(){
							// console.log("Cancel plan modification");
						}
				};
				
				B2BAccessor.popoverApiInit(scope);
				PatientAccessor.popoverApiInit(scope);

				scope.printPatient = function(currPatient) {
					PatientAccessor.print(PatientUtils.getCleanPatient(currPatient));
				};
				
				scope.getReports = function(currPatient){
					model.print().type.id = currPatient.id
					model.print().type.type = "patient"
					
					PrintAccessor.getAvailableReports(model.print().type, function(res){
						res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						for(list of res.data){
							list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						}
						model.print().currList = res.data;
						FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html?v=bl", list: res.data, type: currPatient}, {
							backdrop: 'static',windowClass: "printmodal"})
					});
				}
				
				scope.canPrint = function(){
					if(scope.patient && scope.patient.viewbag && scope.patient.viewbag.limitations){
						return scope.patient.viewbag.limitations.Address && scope.patient.viewbag.limitations.ContactMeans
					}else{
						return false;
					}
				}
				
				scope.invoiceEdit = false;
				scope.openBillAndInvoice = function(currPatient){
					scope.invoiceEdit = true;
					ressourceAccessor.getRessBilled(currPatient, function(res){
						FlView.open(
							{
								templateUrl: "/dashboard/resources/ofys/ress/invoice.html?v=ay", 
								pat: currPatient, list: res,
								beforeCancel: function(e, obj){
									return QValidation.closeContext($filter('translate')('UnsavedChanges'), "invoice").then(function(successful){
										if(!successful){
											e.prevent();
										}
										scope.invoiceEdit = false;
										return successful;
									});
								},
								fl:{}
							}, 
							{
								backdrop: 'static',windowClass: "top-modal1"
							}
						)
					})
				}
				
				scope.hasUnpaid = function(){
					return scope.listInvoice ? scope.listInvoice.some(e => e.status == "NON_PAYE" || e.status == "PMT_PARTIEL") : false
				}

				scope.openNewReminder = function(currPatient){
					PatientAccessor.newReminder(PatientUtils.getCleanPatient(currPatient));
				};

				scope.patsOptions = {
						updatePatient: false,
				};

				scope.keepDown = function(){
					patientShowTitles.openActivity(scope.patient, {mode: 'n', minimize: true}, scope.patient);
				};
				scope.updateModelPatient = function(patient){
					patientShowTitles.openActivity(scope.patient.viewbag.patData, {mode: 'n', minimize: false}, scope.patient);
				};

				function updatepatients(nv, ov, scope){
					var ovCliPatId;
					var nvCliPatId;
					if (ov && ov.id) {
							ovCliPatId = ov.id;
					}
					scope.pats = nv;
					if (nv && nv.id) {
						scope.patient = nv;
						nvCliPatId = nv.id;
					}
					if (scope.patient && !scope.patient.viewOnly) {
						model.patient().currPatient = scope.patient;

						if (ovCliPatId) {
							if (ovCliPatId!==nvCliPatId) {
								model.patientsInQv(''+ovCliPatId, null);
								// on doit retirer une réf.
							}
						}
						ressourceAccessor.getRessBilled(nv, function(res){
							scope.listInvoice = res
						}, function(errors){
							scope.listInvoice = [];
		                    console.error(errors);
		                });
						// PatientAccessor.setCurrent(scope.patient.id);	// pour setter current dans Ofys-swt

						updateOptions(scope.$eval(attrs.options));
					}else if (scope.patient && scope.patient.viewOnly) {
						if(model.activeController()=='actions'){
							model.research().currPatient =  scope.patient;
						}else{
							model.research().currPatient = scope.patient;
	
							if (ovCliPatId) {
								if (ovCliPatId!==nvCliPatId) {
									model.patientsInQv(''+ovCliPatId, null);
									// on doit retirer une réf.
								}
							}
							// PatientAccessor.setCurrent(scope.patient.id);	// pour setter current dans Ofys-swt
	
							updateOptions(scope.$eval(attrs.options));
							}
					}
					addMessageLink()
					model.patientUpdated(true);
				}

				function updateOptions (newOptions){
					excuteOptionAction(scope.patsOptions, newOptions);
				}

				function excuteOptionAction(oldOptions, newOptions){
					if(newOptions && newOptions.updatePatient){
//						scope.refreshPatient();
					}
				}

				scope.$watch(attrs.patient, updatepatients);

				function clearMessageLink(){
					if(angular.isDefined(PatientAccessor.messageLinkKey) && PatientAccessor.messageLinkKey !== ""){
						MessageLink.removeLinkType(PatientAccessor.messageLinkKey);
						delete PatientAccessor.messageLinkKey
					}
				}
				function addMessageLink(){
					clearMessageLink();
					PatientAccessor.updateMessageLink(scope.patient);
					scope.$on('$destroy', clearMessageLink);
				}
			}
		};
	}]);

	patient.directive('telmedofys', ['model','PatientAccessor', function(model, PatientAccessor){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				scope.telmed = getTelmedContact();
				scope.patient.viewbag.sendingTelMed = false;
				scope.isMobile = OfysUtils.isDesktop===false;
				var useJitsiApp = false;
				scope.modelVar = {
					useJitsiApp: function (val) {
						if (arguments.length) {
							useJitsiApp = val;
						} else {
							return useJitsiApp;
						}
					}
				};
				var cli = model.user().session.client.id;
				var sessId = model.user().session.id;
				var idPat = scope.patient.id;
				var name = scope.patient.lastName.replace(/\s/g,'').toLowerCase().removeAccentsLc().replace(/[^a-zA-Z0-9-_]/g, '');
				var room = OfysUtils.daysFrom1970() + '|' + idPat + '|' + sessId;
				var roomName = name.charAt(0).toUpperCase() + name.substring(1) + "-" + Math.abs(room.hashCode());
				scope.start = function(){
					var protocole = useJitsiApp===true ? 'org.jitsi.meet' : 'https'; // TODO https si pas iOS ou Android
					var url = protocole + '://tm.ofys.biz/'+roomName;
					openLink(url);
				};
				function openLink(url){
					if (typeof openExternalBroswer === "function") {
						openExternalBroswer(url);
						// safe to use the function
					} else {
						window.open(url,'_blank');
					}
				}
				function hasContact(t){
					return t.email || t.cell;
				}
				function getContact(t){
					if(hasContact(t)){
						if(t.email ) return t.email;
						if(t.cell) return t.cell;
					}
				}
				function getTelmedContact(){
					scope.patient.lstContactInformation
					var res = {}
					if(scope.patient && scope.patient.lstContactInformation){
						for (var i = 0; i < scope.patient.lstContactInformation.length; i++) {
							var contact = scope.patient.lstContactInformation[i];
							if(contact.typeContact === 1 ){
								res.email = contact;
							} else if(contact.typeContact === 4){
								res.emailAutre = contact;
//							} else if(contact.typeContact === 5){
//								res.cell = contact;
							}
						}
					}
					res.hasContact = hasContact(res);
					res.useContact = getContact(res);
					return res;
				}
				scope.sendByMail = function(){
					if(scope.patient && scope.patient.viewbag &&
						scope.patient.viewbag.sendingTelMed !== 1){
						scope.patient.viewbag.sendingTelMed = 1;
						var myName = model.user().profil.firstName + " " +model.user().profil.lastName;
						PatientAccessor.telmedemail({idPatient:idPat , idClient:cli , email: scope.telmed.email.contact, with: myName, room: roomName}, function(){
							scope.patient.viewbag.sendingTelMed = 2;// Send success
							// model.notice().success($filter("translate")("ENVOI_REUSSI"))
						});
					}
				};
				scope.sendByTexto = function(){
					if(scope.patient && scope.patient.viewbag &&
						scope.patient.viewbag.sendingTelMed !== 1){
						scope.patient.viewbag.sendingTelMed = 1;
						PatientAccessor.telmedtexto({idPatient:idPat , idClient:cli , cell: scope.telmed.cell.contact, room: roomName}, function(){
							scope.patient.viewbag.sendingTelMed = 2;// Send success
							// model.notice().success($filter("translate")("ENVOI_REUSSI"))
						});
					}
				};
			}
		};
	}]);

	patient.directive('sofypatient', ['CourrielAccessor','PatientAccessor', function(CourrielAccessor, PatientAccessor){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				scope.sofypatient = getSofypatientContact(scope.patient);

				scope.sendToPatient = function(){
					CourrielAccessor.openNewToPatient(scope.patient);
					scope.$hide();
				};

				function guardianSofyAccessWithContact(pat, childComStatus){
					PatientAccessor.getPatientsWithSofyAccess(pat).then(function(guardians){
						if(guardians.length > 0){
							for (let i = 0; i < guardians.length; i++) {
								var comStatus = getSofypatientContact(guardians[i]);
								if(comStatus.hasAnEmail){
									childComStatus.guardiansStatus = comStatus;
									if(guardians[i].idSofyLink){
										childComStatus.guardianSofyLink = guardians[i].idSofyLink;
									}
								}
							}
						}
					});
				}
				function getSofypatientContact(pat){
					var res = PatientAccessor.getPatientEmail(pat);
					res.idSofyLink = pat.idSofyLink;
					guardianSofyAccessWithContact(pat, res);
					return res;
				}
			}
		};
	}]);

	patient.directive('patientAllData', [function(){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/patientAllData.html?v=bl',
			scope: true
		};
	}]);

	patient.directive('patientDataItem', ['DashAPI','model','patientShowTitles','Rights','$timeout', 'Markdown', '$filter', 'TaskAccessor', 'FormAccessor', 'ModificationStatus',
		function(DashAPI, model, patientShowTitles,Rights, $timeout, Markdown, $filter, TaskAccessor, FormAccessor, ModificationStatus){
		return {
			restrict: 'E',
			scope: {
				quickViewData: '=?',
				qv: '=',
				actData: '=',
				actOptions: "=",
				patient: "=actPat",
				actLabel: '@',
				useIcon: '@',
				inLinked: '@?',
				actIndex: '=',
				onselect: '=',
				type:'@',
				categoryName:'=',
			},
			templateUrl: '/dashboard/resources/ofys/pat/pat_data/patientData_item.html?v=bl',
			link: function (scope, element, attrs) {
				scope.patientShowTitles = patientShowTitles;
				scope.model = model;
				if (typeof scope.inLinked == 'undefined') {
					scope.inLinked = false;
				}
				scope.getCopy = function(o) {
					return angular.copy(o);
				}
				scope.filterNoteToSee = function(item) {
					if (item.idNextModificationEntry===undefined) return true;
					return true;
				};
				scope.filterTodayApp = function(v) {
					return function(a) {
						return a.when===0;
					};
				};
				scope.sortTodayApp = function(a,b) {
					return a.startTime-b.startTime;
				};
				scope.filterFuturApp = function(v) {
					return function(a) {
						return a.when>0;
					};
				};
				scope.sortFuturApp = function(a,b) {
					return a.when-b.when;
				};
				scope.showBillRamq = function(enc) {
					var user = model.user().session.user;
					return enc.profEnc!=undefined && user.factTypeI && user.factTypeI>0;
				};
				
				scope.markdownToHtml = function (n, delParaTag) {
					if (n !== undefined && n.length > 0 && n.charAt(0) === Markdown.MD) {
						var m = Markdown.toHTML(n.substring(1));//del markdown marker
						if (delParaTag===true) {
							m = m.substring(0,3)==='<p>' ?  m.substring(3, m.length-5): m;// del <p>  et </p> car ça fait sauter une ligne
						}
						return m;
					}
					return n;
				}
				scope.getProgress = function(p) {
					var d = TaskAccessor.taskProgress[p];
					// console.log(p + "=" + d);
					return d;
				}
				scope.getStatPref = function(p) {
					var v = TaskAccessor.taskProgress[p];
					if (v>2 && v<100) {
						var fromTranslate = $filter('translate')('task_st' + v);
						var fromPref = model.prefSettings('task_settings_st'+v);
						var t;
						if (fromTranslate==fromPref || fromPref==null) {
							t = fromTranslate; 
						} else {
							t = fromTranslate + ': ' + fromPref;
						}
						return t;
					}				
					return p;
				};
				
				scope.getAttenteCopy = function(attente) {
					return angular.copy(attente);
				}
				scope.addResultat = function(attente) {
					attente.status = 100;
					attente.isLate=false;
					addNoteToAttente(attente)
				};
				scope.addUnResultat = function(attente) {
					attente.status = attente.status+1;
					addNoteToAttente(attente)
				};
				scope.addTousResultats = function(attente) {
					attente.status = 90;
					attente.isLate=false;
					addNoteToAttente(attente)
				};
				function addNoteToAttente(attente) {
					if (scope.actData) {
						var debut = _.isEmpty(attente.note) ? '' : attente.note + '\n';
						if (scope.actData.req) {
							attente.note = debut + scope.actData.date + ': ' + scope.actData.req;
						} else if (scope.actData.name) {
							attente.note = debut + scope.actData.date + ': ' + scope.actData.name;							
						}
					}
				}
				scope.cancelAttente = function() {
					model.actUpdated(true);
				}
				scope.saveAttente = function(act, newAttente) {
					newAttente.modificationStatus = ModificationStatus.STATUS_UPDATED;
					FormAccessor.saveAttenteResultats(newAttente, function(data){
						if (act.attentes) {
							act.attentes.forEach(function(att){
								if (att.id==newAttente.id) {
									att.note = newAttente.note;
									att.status = newAttente.status;
								}
							});
						} else {
							act.attente = angular.copy(data);							
						}
						model.actUpdated(true);
						model.notice().success($filter('translate')('RESULT_ATTENDUS_RECU_SAVED'));
					}, function(err) {
						model.notice().warn($filter('translate')('error') + ": " + err);										
					});
				}
				scope.popupView = function (dataviewerPopover) {
					if(!dataviewerPopover || dataviewerPopover.open === false){
						clearPopups();
					}
					if(dataviewerPopover){
						dataviewerPopover.open = !dataviewerPopover.open;
					}else{
						scope.actData.viewbag
						scope.dataviewerPopover = {
							popupdata: patientShowTitles.getQVPayLoad(scope.actData, {hasHeader: false}, scope.patient),
							hideCloseBtn: true,
							open: true
						}
						scope.data = scope.dataviewerPopover.popupdata.quickViewData
						scope.titleNoTranslate = scope.actData['surveyTitle_'+ DashAPI.lang];
					}
					scope.dataviewerPopover.open ? openPopup(scope.dataviewerPopover) : closePopup(scope.dataviewerPopover)

				}
				var OPENEDDATAVIEWERS = ".popupViewData.open";
				function clearPopups(removeClass) {
					var els = $(OPENEDDATAVIEWERS)
					function clear(){
						for (var i = 0; i < els.length; i++) {
							angular.element(els[i]).triggerHandler("click")
						}
					}
					$timeout(clear)
				}

				function openPopup(pop){
					function hideOnClickOutside(selector) {
						pop.listener = (event) => {
						  $target = $(event.target);
						  if (!$target.closest(selector).length && $(selector).is(':visible')) {
							  clearPopups()
							  pop.removeClickListener();
						  }
						}

						pop.removeClickListener = function() {
						  document.removeEventListener('click', pop.listener)
						}

						document.addEventListener('click', pop.listener)
					}
					hideOnClickOutside('.dataviewerpopover');
				}

				function closePopup(pop){
					if(pop.removeClickListener){
						pop.removeClickListener()
					}
				}

				scope.mustShowPointer = function() {
					var b = false;
					if (scope.actOptions && scope.actOptions.mode==='n') {
						b = true;
					} else if (scope.quickViewData && scope.quickViewData.linkModeOn>0) {
						b = true;
					}
					return b;
				};

				scope.crdsMissingFiles = function(ida) {
					return _.indexOf(model.dayData().cnts.saf_prer_id, ida, true)>-1;	// de Underscore, recherche triée en passant true = binarySearch (donc ++++ vite).
				};
				scope.showAddLinkButton = function() {
					var b = false;
					if (scope.quickViewData && angular.isDefined(scope.quickViewData.linkModeOn)) {
						b = scope.quickViewData.linkModeOn > 0;
					}
					return b;
				};
				function getActivity(){
					if(scope.quickViewData.qvActData.delegateActivity){
						return scope.quickViewData.qvActData.delegateActivity();
					}else{
						return scope.quickViewData.qvActData;
					}
				}
				// le add item est dans la méthode scope.openActivity
				scope.removeItemFromLinks = function(itemToMod) {
					var eformAct = getActivity()
					if (scope.quickViewData && scope.quickViewData.linkModeOn>0) {
						var iToMod = itemToMod.t +'Į'+(itemToMod.id?itemToMod.id:'')+'Į'+ itemToMod.d;
						var idx;
						if (scope.inLinked) {	// appelé de la liste des links - slm possibilité ici.
							if (angular.isDefined(eformAct.sumAddedLinks)) {
								if (angular.isDefined(scope.actIndex)) {
									idx = scope.actIndex;
									eformAct.sumAddedLinks.splice(idx,1);
								} else {
									idx = $.inArray(itemToMod, eformAct.sumAddedLinks);
									if (idx>-1) {
										eformAct.sumAddedLinks.splice(idx,1);
									}
								}
							}
							if (angular.isDefined(eformAct.addedLinksUid)) {
								idx = $.inArray(iToMod, eformAct.addedLinksUid);
								if (idx>-1) {
									eformAct.addedLinksUid.splice(idx,1);
								}
							}
							// il faut mettre à jour le sum de addedLinks
							for(var i=0;i<eformAct.addedLinks.length; i++) {
								if ('sum'==eformAct.addedLinks[i].substr(0, 3)) {
									eformAct.addedLinks[i] = eformAct.addedLinks[i].replace(iToMod,'').replace('˜˜','˜').replace('ı˜','ı');
									if (eformAct.addedLinks[i]=='sumı') {	// donc ne reste plus de data dans sum. il faut l'effacer
										eformAct.addedLinks.splice(i, 1);
									}
									break;
								}
							}
							model.formLinkUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
						}
					}
				};

				// les descr qu'on veut dans la description qui sera le nom du lien ajouté. On n'a pas tjrs de id...
				scope.getAll = function() {
					return [1,2,3];
				};
				scope.getRx = function() {
					return [1];
				};
				scope.getDx = function() {
					return [1];
				};
				scope.getIt = function() {
					return [1];
				};
				scope.getImm = function() {
					return [1,2];
				};
				scope.getRap = function() {
					return [1];
				};
				// pour qu'un tri sur le type soit le meme ordre qu'affiché.
//				al: allergie, getAll
//				ao: intolérance getAll
//				bx: prescription getRx
//				db: problèmes getDx
//				dx: atcd médicaux getDx
//				fx: ATCD_CX getId
//				hm: Medical History
//				im: IMMUNISATIONS getImm
//				ir: Rappel/Historique  getRap
//				sf: Family History
//				sh: social history

				var descrMethod = {'ak':scope.getMs, 'al':scope.getAll, 'ao':scope.getAll, 'bx':scope.getRx, 'by':scope.getRx, 'dx':scope.getDx, 'db':scope.getDx,'fx':scope.getIt, 'im':scope.getIm, 'ir':scope.getRap};
				scope.updatePatientWithLimitation = function(){
					if(scope.patient && !scope.patient.viewbag){
						scope.patient.viewbag = {};
						scope.patient.viewbag.limitations = Rights.getSessionUserConsent(scope.patient);
						model.searchPtUpdated(true);
					}
				}
				scope.updatePatientWithLimitation();
				scope.openLastEncounter = _.throttle(function(patient, ev){
					// if(ev && ev.ctrlKey){
					// 	OfysUtils.ctrlKeyPressed = ev.ctrlKey
					// }
					if(scope.quickViewData !== scope.$parent.quickViewData){
						scope.quickViewData = scope.$parent.quickViewData
					}
					patientShowTitles.openActivity(patient, {mode: 'n', minimize: false, openLastEncounter:true}, patient, scope)
				}, 500, {trailing: false});

				scope.openExternal = _.throttle(function(patient, ev){
					// if(ev && ev.ctrlKey){
					// 	OfysUtils.ctrlKeyPressed = ev.ctrlKey
					// }
					if(scope.quickViewData !== scope.$parent.quickViewData){
						scope.quickViewData = scope.$parent.quickViewData
					}
					patientShowTitles.openActivity(patient, {mode: 'ext', minimize: false, setExternal:true, canPopBack: false}, patient, scope)
				}, 500, {trailing: false});

				scope.openActivity = _.throttle(function(act, ev){
					if(scope.onselect){
						scope.onselect(scope.categoryName, act);
					}else{
						// if(ev && ev.ctrlKey){
						// 	OfysUtils.ctrlKeyPressed = ev.ctrlKey
						// }
						if(scope.quickViewData !== scope.$parent.quickViewData){
							scope.quickViewData = scope.$parent.quickViewData
						}
						clearPopups(true);

						patientShowTitles.open(act, scope);
					}
				}, 500, {trailing: false});

				// function filterNotInArray(a) {
				// 	var b = true;
				// 	if (scope.quickViewData.addedLinksUid) {
				// 		b = $.inArray(a.uid, scope.quickViewData.addedLinksUid)>-1;
				// 	}
				// 	return b;
				// }

			},
		};
	}]);

	/**
	 * COMMENT: PAT PATSHOWTITLE @Factory
	 */
	patient.factory('patientShowTitles', ['model', 'QuickView', '$filter', 'PatientAccessor', 'Markdown', '$timeout','QValidation',
		function (model, QuickView, $filter, PatientAccessor, Markdown, $timeout,QValidation) {

		// tableau de x colonnes égale au descrTitle.length
		var contactTypes=[$filter("translate")("Phone"),$filter("translate")("Courriel"),$filter("translate")("Fax"),$filter("translate")("Pager"),$filter("translate")("OtherEmail"),$filter("translate")("Cellphone"),$filter("translate")("OtherCellphone"),$filter("translate")("Iphone"),$filter("translate")("OtherPhone")];
		var languages=["Francais","Anglais","Espagnol","Autre"];
		var races=[$filter("translate")("Caucasian"),$filter("translate")("Native"),$filter("translate")("African"),$filter("translate")("Latino"),$filter("translate")("Asian"),$filter("translate")("Chinese"),$filter("translate")("Filipino"),$filter("translate")("Arab"),$filter("translate")("Japanese"),$filter("translate")("Korean"),$filter("translate")("Unspecified")];
		var civils=[$filter("translate")("N/A"),$filter("translate")("Single"),$filter("translate")("Married"),$filter("translate")("Partnership"),$filter("translate")("Divorced"),$filter("translate")("Widowed")];
		var boolToString =function(bool){
			if(bool)
				return "Oui";
			else
				return "Non";
		};

		function handleEncounterAttachementLinking(act, scope){
			if(scope.quickViewData && scope.quickViewData.qvActData &&
				scope.quickViewData.qvActData.attachDocument){
					scope.quickViewData.qvActData.attachDocument(act);
			}
		}
		function isDirtyOrSameAsCurrentForm(act, scope){
			if(act.prop && act.prop.readonly===false){
				return true;
			}else if(scope && scope.quickViewData &&
				scope.quickViewData.qvActData &&
				scope.quickViewData.qvActData.id &&
				act.id === scope.quickViewData.qvActData.id){
				return true;
			}
			return false;
		}
		function handleEformAttachementLinking(act, scope){
			if(isDirtyOrSameAsCurrentForm(act, scope) ){
				return;
			}

			var idx, t;
			var eformAct = scope.quickViewData.qvActData;
			if(eformAct.delegateActivity){
				eformAct = eformAct.delegateActivity()
			}
			if (scope.inLinked) {	// appelé de la liste des links
				// bon pour les doc liés. Pour le sommaire, voir modSumLink et autres dans la directive patientMedSummary
				if (angular.isDefined(eformAct.objAddedLinks)) {
					idx = $.inArray(act, eformAct.objAddedLinks);
					if (idx>-1) {
						eformAct.objAddedLinks.splice(idx,1);
					}
				}
				if (angular.isDefined(eformAct.addedLinksUid)) {
					idx = $.inArray(act.uid, eformAct.addedLinksUid);
					if (idx>-1) {
						eformAct.addedLinksUid.splice(idx,1);
					}
				}
				t = "";
				if(act.className === "CLaboFile" || act.className === "CLaboResultsProfessionnal"){
					t="lab";
				}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
					t="doc";
				}else if(act.className === "CEncounter"){
					t="enc";
				}else if(act.className === "CFormData"){
					t="form";
				}
				OfysUtils.removeStartsWith(t+'ı'+act.id, eformAct.addedLinks);
				model.formLinkUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.

			} else {
				if (eformAct.disableSelectFormLinks && eformAct.disableSelectFormLinks()) {
					return;	// crds sans données manquantes. on ne permet plus de modifier;
				}
				//console.log("add to the list");
				if (angular.isUndefined(eformAct.objAddedLinks)) {
					eformAct.objAddedLinks = [];
				}
				if (angular.isUndefined(eformAct.addedLinksUid)) {
					eformAct.addedLinksUid = [];
				}
				idx = $.inArray(act.uid, eformAct.addedLinksUid);
				if (idx==-1) {
					eformAct.addedLinksUid.push(act.uid);
					eformAct.objAddedLinks.push(act);
					t = "";
					if(act.className === "CLaboFile" || act.className === "CLaboResultsProfessionnal"){
						t="lab";
					}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
						t="doc";
					}else if(act.className === "CEncounter"){
						t="enc";
					}else if(act.className === "CFormData"){
						t="form";
					}
					eformAct.addedLinks.push(t+'ı'+act.id);
					// je ne peux assigner ici car je n'ai pas accès à la méthode scope.changeLinkedDocsAssignment qui assigne les valeurs à addedCrdsKey
					// eformAct.selectedDV[act.uid] = {key:''+93};	// slm pour form.type===3, val defaut doc radio et autres
					model.formLinkUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
				}
				$timeout(function() {
					act.scrollToBottom();
				}, 300)
			}
		}

		function handleAttachementLinking(act, scope){
			if(scope.quickViewData.linkModeOn === 1){
				handleEformAttachementLinking(act, scope);
			}else if(scope.quickViewData.linkModeOn === 2){
				handleEncounterAttachementLinking(act, scope);
			}
		}

		var service =  {
			externalSummary: function (patient) {
				function updateModel(modalObject) {
					model.summaryExternalViewer = modalObject;
					// console.log(model.summaryExternalViewer);
				}
				function externaliseCurrentpatient() {
					service.openActivity(patient.viewbag.patData.sum,
						{mode: 'ext', minimize: false, setExternal:true, noList: true, canPopBack: false}, patient).then(updateModel);
				}
				function resetZombieActivies() {
					var windowNotAvailable = !(model.summaryExternalViewer &&
							model.summaryExternalViewer.qv &&
							model.summaryExternalViewer.qv.externalViewer &&
							!model.summaryExternalViewer.qv.externalViewer.closed);
					if(model.summaryExternalViewer && windowNotAvailable ){
						model.summaryExternalViewer.qv.isExternal = false;
						QuickView.close(model.summaryExternalViewer);
						delete model.summaryExternalViewer;
						return true;
					}
					return false;
				}
				//Zombie summary activities are closed external windows that have not been full cleaned
				//This happens when the close event was not called adequately.
				//in this case closing the zombie and exiting makes sure that the next time the patient is opened no errors occur
				if(resetZombieActivies()){
					return;
				}
				if(model.summaryExternalViewer){
					var nSummary = QuickView.add(service.getQVPayLoad(patient.viewbag.patData.sum,
						{mode: 'ext', minimize: false, noList: true, canPopBack: false}, patient));
					if(model.summaryExternalViewer.quickViewData.qvActData.editMode &&
						model.summaryExternalViewer.quickViewData.qvActData.close){
						model.summaryExternalViewer.quickViewData.qvActData.close();
					}
					QuickView.external(nSummary, model.summaryExternalViewer)
					QuickView.close(model.summaryExternalViewer)
					model.summaryExternalViewer = nSummary;
				}else{
					externaliseCurrentpatient();
				}
			},
			/**
			 * COMMENT: PAT PATSHOWTITLE @function
			 *
			 * Permet d'ouvrir une nouvelle quickview avec une nouvelle activity (tel que forms, encounter, labo, ect)
			 * Pour ouvrir directement dans la "view", voir la function: open
			 * 		
			 * @param act: l'activity passé pour ouvrir dans le "view"
			 * @param opt: options d'ouverture
			 * @param pat: le patient
			 */
			openActivity: function(act, opt, pat, scope){
				function executeOpen(){
					if(opt.mode === "n" || opt.mode === "t" ||opt.mode === "ext" || ( opt.mode === "qv" && opt.newAct===true)){
						// if (act.encounterType && act.encounterType<10) return;	// on ne permet pas d'ouvrir dans qv une rencontre de ces types
						$('.tooltip-inner').hide();
						$('.popover').hide();
						if(opt.minimize){
							//Add activity and keep it minimized(don't open the modal)
							return QuickView.add(service.getQVPayLoad(act, opt, pat));
							// console.log("Activity Added");
						}else{
							//Open activity modal and add it to quickview list
							return QuickView.open(service.getQVPayLoad(act, opt, pat));
							// console.log("Activity Opened");
						}
					}
				}
				if(model.activeMenu() !== 'Appointments' && model.activeMenu() !== 'Patients' ){
					return QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
						if(successful){
							return executeOpen();
						}
					});
				}else{
					return executeOpen();
				}
			},
			/**
			 * COMMENT: PAT PATSHOWTITLE @function
			 *
			 * Permet d'ouvrir une nouvelle activity dans la quickview
			 * 		
			 * @param act: l'activity passé pour ouvrir dans le "view"
			 */
			open: function(act, scope){
				if(scope.quickViewData && scope.quickViewData.qvActData &&
					scope.quickViewData.qvActData.uid === act.uid){
					return;// The quickview is already opened dont reopen the same
				}
				if (scope.quickViewData && scope.quickViewData.linkModeOn > 0) {
					handleAttachementLinking(act, scope);
				} else if (scope.inLinked=='true') {
					// a cliqué sur un item dans le patientDataFormLinks alors que n'était pas en édition (sinon aurait été true au if précédent). ne rien faire.
				} else if (scope.actOptions !== undefined && scope.actOptions.mode ==='qv' && scope.actOptions.newAct!==true) {
					//si l'evenement de changer l'activité réussie, un boolean true est retourné
					if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (act)){
						model.actUpdated(true);
					}
				} else if (scope.actOptions !== undefined && scope.actOptions.fct) {
					scope.actOptions.fct(act);
				} else if(scope.patient !== undefined) {
					// scope.actOptions.minimize = (!!OfysUtils.ctrlKeyPressed);
					service.openActivity(act, scope.actOptions, scope.patient);
				} else if(scope.quickViewData && scope.quickViewData.user !== undefined) {
//					scope.actOptions.minimize = (!!OfysUtils.ctrlKeyPressed);
					if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (act)){
						model.actUpdated(true);
					}

//					QuickView.open(QuickView.getUserQVPayLoad(act, {}, scope.quickViewData.user));
					// service.openActivity(act, scope.actOptions, scope.patient);
				}
			},
			updateQVHash: function(oldAct, newAct){
				QuickView.updateQVHashOldNew(oldAct, newAct);
			},
			getQVPayLoad: function(act, opt, pat){
				var patTitle = this.showPatientHtml(pat);
				return QuickView.getQVPayLoad(act, opt, pat, patTitle);
			},
			showTitleHtml: function(l, showSmallNote) {
				if (l===undefined || l.length===0) return '';
				var len = l[0].descrTitle ? l[0].descrTitle.length : 0;
				var all = '<span class="act-section-title">' + l[0].title +'</span>';
				all += '<table><thead><tr>';
				for (var int = 0; int < len; int++) {
					all += '<th scope="col" class="nowrapws">' + l[0].descrTitle[int] + '</th>';
				}
				all += '</tr></thead><tbody>';
				var maxItem=9;
				for (var i = 0; i < l.length; i++) {
					all += "<tr>";
					if (i>maxItem) {
						all += '<td>...</td>';
						all += "</tr>";
						break;
					}
					var classDel = l[i].deleted===true ? "deleted" : "";
					for (var j = 0; j < len; j++) {
						var vo = l[i];
						if (vo.descr) {
							var vv = vo.descr[j];
							all += '<td class="nowrapws ' + classDel + '">' + ((showSmallNote===true) ? this.showNoteHtml(vv, '') : this.showLongNoteHtml(vv, null, 45)) + "</td>";
						}
					}
					all += "</tr>";
				}
				all += "</tbody></table>";
				return all;
			},
			showPatientHtml:function(p){
				var len;
				//since the html is cached only execute the code if the viewbag has been set.
				if (angular.isUndefined(p) || angular.isUndefined(p.viewbag)) return '';
				if (p.title_html) return p.title_html;
//				$log.log('Création title pour ' + p.firstName+' '+p.lastName);
				var all = '<span class="act-section-title">Résumé Patient</span>';
				all +='<div class="patient-file div-table-container">';
				all +='<div class="div-table-row">';
				all +='<div class="div-table-col">';
				all +='<div class="div-table">';
				all +='<div class="div-table-row">';
				all +='<div class="div-table-col-right-bord">';
				all += '<p class="">'+$filter("translate")("Name")+' : '+p.firstName+' '+p.lastName+'</p>';
				if(OfysUtils.isNotEmpty(p.birthDate))
					all +='<p class="">'+$filter("translate")("DOB")+' : '+p.birthDate+'</p>';
				if(OfysUtils.isNotEmpty(p.patientRecordNumber))
					all += '<p class="">'+$filter("translate")("File")+ ' : '+p.patientRecordNumber+'</p>';
				if(OfysUtils.isNotEmpty(p.languageCode))
					all +='<p class="">'+$filter("translate")("Language")+' : '+languages[p.languageCode]+'</p>';
				if(OfysUtils.isNotEmpty(p.healthInsuranceNumber))
					all += '<p class="">'+$filter("translate")("NAM")+' : '+$filter('nam')(p.healthInsuranceNumber)+'</p>';
				if(OfysUtils.isNotEmpty(p.expirationCAM))
					all +='<p class="">Exp. :'+moment(p.expirationCAM, 'YYMM').format("YY-MM")+'</p>';
				if(OfysUtils.isNotEmpty(p.gender))
					all += '<p class="">'+$filter("translate")("Gender")+' : '+p.gender+'</p>';
				if(OfysUtils.isNotEmpty(p.isScanned))
					all +='<p class="">'+$filter("translate")("Numerised")+' : '+boolToString(p.isScanned)+'</p>';
				if(OfysUtils.isNotEmpty(p.isSensible))
					all += '<p class="">'+$filter("translate")("Sensible")+' : '+boolToString(p.isSensible)+'</p>';
				if(OfysUtils.isNotEmpty(p.sofyAuthorized))
					all +='<p class="">'+$filter("translate")("Sofy")+' : '+boolToString(p.sofyAuthorized)+'</p>';
				all +='</div>';
				all +='<div class="div-table-col">';
				if(OfysUtils.isNotEmpty(p.treatingProfessionnal)){
					var treating = model.store.profs.get(p.treatingProfessionnal);
					if(treating){
						all += '<p class="">'+$filter("translate")("Professional")+' : '+treating.firstName+' '+treating.lastName;
					}
				}
				if(OfysUtils.isNotEmpty(p.spouseName))
						all += '</p><p class="">'+$filter("translate")("Partner")+' : '+p.spouseName+'</p>';
				if(OfysUtils.isNotEmpty(p.fatherName))
					all += '<p class="">'+$filter("translate")("Father")+' : '+p.fatherName+'</p>';
				if(OfysUtils.isNotEmpty(p.motherName))
					all +='<p class="">'+$filter("translate")("Mother")+' : '+p.motherName+'</p>';
				if(OfysUtils.isNotEmpty(p.nationality))
					all += '<p class="">'+$filter("translate")("Nationality")+' : '+p.nationality+'</p>';
				if(OfysUtils.isNotEmpty(p.race))
					all +='<p class="">'+$filter("translate")("Race")+' : '+races[p.race]+'</p>';
				if(OfysUtils.isNotEmpty(p.maritalStatus))
					all += '<p class="">'+$filter("translate")("Civil")+' : '+civils[p.maritalStatus]+'</p>';

				if(OfysUtils.isNotEmpty(p.tutorName))
					all +='<p class="">'+$filter("translate")("Tutor")+' : '+p.tutorName+'</p>';
				if(OfysUtils.isNotEmpty(p.note))
					all +='<p class="">'+$filter("translate")("Note")+' : '+OfysUtils.wordWrap(p.note, 40, '<br/>') +'</p>';
				if(OfysUtils.isNotEmpty(p.lastActivityDate))
					all += '<p class="">'+$filter("translate")("LastActivity")+' : '+p.lastActivityDate+'</p>';
				if(OfysUtils.isNotEmpty(p.lastVerificationDate))
					all +='<p class="">'+$filter("translate")("LastVerif")+' : '+p.lastVerificationDate+'</p>';
				all +='</div>';
				all +='</div>';
				all +='</div>';
				all +='</div>';
				all +='</div>';
				all +='<div class="div-table-row">';
				all +='<div class="div-table-col">';
				if(OfysUtils.isNotEmpty(p.messageAppointment))
					all +='<p class="">'+$filter("translate")("AppointmentMsg")+' : '+p.messageAppointment+'</p>';
				if(OfysUtils.isNotEmpty(p.custodyTerms))
					all +='<p class="">'+$filter("translate")("ChildcareMsg")+' : '+p.custodyTerms+'</p>';
				all += '</div>';
				all += '</div>';
				//contacts
				if(OfysUtils.isNotEmpty(p.lstContactInformation) && p.lstContactInformation.length>0 && p.viewbag && p.viewbag.limitations.ContactMeans){
					all += '<span class="act-section-title">'+$filter('translate')('Contacts')+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';
					len = p.lstContactInformation.length;
					(function()
						{
							for(var j = 0 ; j < len ;j++){
							all += '<p>';
							if(OfysUtils.isNotEmpty(p.lstContactInformation[j].typeContact))
								all +=contactTypes[p.lstContactInformation[j].typeContact];
							if(OfysUtils.isNotEmpty(p.lstContactInformation[j].contact))
								all += ': '+$filter('tel')(p.lstContactInformation[j].contact);
							if(OfysUtils.isNotEmpty(p.lstContactInformation[j].note))
								all += ' ' + p.lstContactInformation[j].note;
							all +='</p>';
						}
					})();
					all += '</div>';
					all += '</div>';
				}
				if(OfysUtils.isNotEmpty(p.lstPatientAlerts) && p.lstPatientAlerts.length>0){
					all += '<span class="act-section-title">'+$filter('translate')('alertPatientTitle')+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';
					len = p.lstPatientAlerts.length;
					(function() {
						for(var j = 0 ; j < len ;j++){
							all += '<p>';
								all += p.lstPatientAlerts[j].value;
							all +='</p>';
						}
					})();
					all += '</div>';
					all += '</div>';					
				}
				// TODO Patrice Drolet: tenter d'avoir les mêmes données via RDV et recherche patients
				// autres disp.
				if(OfysUtils.isNotEmpty(p.lstPatientProfessionnal) && p.lstPatientProfessionnal.length>0){
					all += '<span class="act-section-title">'+$filter('translate')('OtherProf')+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';
					all += '<div class="columns2">';
					var prof;
					len = p.lstPatientProfessionnal.length;
					for(var i = 0;i<len;i++){
						prof = model.store.profs.get(p.lstPatientProfessionnal[i].idProfessionnal, function(prof, loadedFromServer){
							if(loadedFromServer && p.title_html){
								delete p.title_html;
								model.patientUpdated(true);
							}
							if (prof) {
								all += '<p class="">';
								all += prof.firstName+' '+prof.lastName;
								all +='</p>';
							}
						});
					}
					all += '</div>';
					all += '</div>';
					all += '</div>';
				}
				//B2B
				if(OfysUtils.isNotEmpty(p.b2bInformation) && p.b2bInformation.id){
					all += '<span class="act-section-title">'+$filter("translate")("b2bRegisteration")+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';
					all += '<div class="">';
					all += PatientAccessor.getB2BText(p.b2bInformation);
					all += '</div>';
					all += '</div>';
					all += '</div>';
				}
				//Identificatuers
				if(p.lstPatientIdentifier && p.lstPatientIdentifier.length > 0){
					all += '<span class="act-section-title">'+$filter("translate")("Idents")+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';

					all += '<div class="">';
					all += getIdentifiersHtml(p.lstPatientIdentifier);
					all += '</div>';
					all += '</div>';
					all += '</div>';
				}
				function getIdentifiersHtml(lst){
					var res = "";
					for(var iI = 0; iI < lst.length; iI++){
						res += '<div class="">';
						res += lst[iI].type.name + " : "+lst[iI].identifier
						res += '</div>';
					}
					return res;
				}

				//Pharmacies
				if(OfysUtils.isNotEmpty(p.lstSites)){
					var hasDrugStore = false;
					var pharmaInsta;
					for(var i = 0;i < p.lstSites.length; i++){
						if(p.lstSites[i].addedAs === "DRUG_STORE"){
							pharmaInsta = model.user().sites[p.lstSites[i].idSite]
							if(pharmaInsta){
								if(!hasDrugStore){
									all += '<span class="act-section-title">'+$filter("translate")("Pharmacy")+'</span>';
									all +='<div class="div-table-row">';
									all +='<div class="div-table-col">';
									all += '<div class="">';
									hasDrugStore = true;
								}
								// console.log(pharmaInsta)
								all += '<p class="">' + pharmaInsta.nameCommon;
								if(pharmaInsta.phonenumber1){
									all += ' ' + $filter("translate")("Tel") + ': '+$filter("tel")(pharmaInsta.phonenumber1)
								}
								if(pharmaInsta.phonenumber2){
									all += ' ' + $filter("translate")("Fax") + ': '+$filter("tel")(pharmaInsta.phonenumber2)
								}
								all += '</p>';
								all += '<p class="">';
								if(pharmaInsta.street || (pharmaInsta.city && pharmaInsta.city.name) || pharmaInsta.postalCode){
									all += "&nbsp;&nbsp;&nbsp;&nbsp;"
								}
								if(pharmaInsta.street){
									all += ' ' + pharmaInsta.street;
								}
								if(pharmaInsta.city && pharmaInsta.city.name){
									all +=', '+ pharmaInsta.city.name;
								}
								if(pharmaInsta.postalCode){
									all +=', '+$filter('cp')(pharmaInsta.postalCode);
								}
								all += '</p>';
							}
						}
					}

					if(hasDrugStore){
						all += '</div>';
						all += '</div>';
						all += '</div>';
					}
				}
				//adresses
				if(OfysUtils.isNotEmpty(p.lstAddress) && p.lstAddress.length>0 && p.viewbag && p.viewbag.limitations.Address){
					all += '<span class="act-section-title">'+$filter('translate')('Addresss')+'</span>';
					all +='<div class="div-table-row">';
					all +='<div class="div-table-col">';
					len=p.lstAddress.length;
					for(i=0;i<len;i++){
						all +='<p>';
						if(OfysUtils.isNotEmpty(p.lstAddress[i].street))
							all += p.lstAddress[i].street;
						if(OfysUtils.isNotEmpty(p.lstAddress[i].city))
							all +=', '+p.lstAddress[i].city.name;
						if(OfysUtils.isNotEmpty(p.lstAddress[i].postalCode))
							all +=', '+$filter('cp')(p.lstAddress[i].postalCode);
						if(OfysUtils.isNotEmpty(p.lstAddress[i].province))
							all +=', '+p.lstAddress[i].province.name;
						if(OfysUtils.isNotEmpty(p.lstAddress[i].country))
							all +=', '+p.lstAddress[i].country.name;
						all +='</p>';
					}
					all += '</div>';
					all += '</div>';
				}
				// TODO autres sections à ajouter
				all += '</div>';
				p.title_html = all;
				return all;
			},
			showLongNoteHtml: function(v, titre, l) {
				var all = "";
				if (OfysUtils.isNotEmpty(titre)) {
					all = '<span class="act-section-title">' + titre +'</span>';
				}
				var nbChar = 70;
				var vs;
				if (l) nbChar = l;
				if (v.charAt(0)==='≖') {
					vs = Markdown.toHTML(v.substring(1)).split(/\n/g);
				} else {
					vs = v.split(/\n/g);
				}
				var newV = [];
				for(var ii=0;ii<vs.length;ii++) {
					var ww = OfysUtils.wordWrap(vs[ii],nbChar, '<br/>');
					newV.push(ww);
				}
				var str = '';
				for(var ii=0;ii < newV.length;ii++) {
					str += '<p>' + newV[ii] + '</p>';
				}
				all += '<div class="columns2 toasthtml">' + str + "</div>";
				return all;
			},
			showNoteHtml: function(v, noteTitle) {
				var all = '';
				v= v? v: "";
				var vs;
				if (v.charAt(0)==='≖') {
					v = Markdown.toHTML(v.substring(1));
				} else {
					v = v.replace(/\n/g, "<br>");
				}
				if (arguments.length===2) {
					if (OfysUtils.isNotEmpty(noteTitle)) {
						all += '<span class="act-section-title toasthtml">' + noteTitle +'</span>';
					} else {
						// pas de noteTitle, donc slm une donnée. On ne met pas de table dans ce cas
						return v;//.replace(/\n/g, "<br>");
					}
				} else {
					all += '<span class="act-section-title toasthtml">' + 'Note' +'</span>';
				}
				all += '<table>';
				all += "<td>" + v + "</td>";
				all += "</table>";
				return all;
			},
			showLaboTitleHtml: function(l) {
				if (angular.isUndefined(l)) return;
				if (l.title_html) return l.title_html;
					var allTest = "";

					var nt = "";
					var hasNVal = false;
					var vv;
					if (l.lstNs && l.lstNs.length>0) {
						l.lstNs.sort(function (a, b) {
						    return a.n.toLowerCase().localeCompare(b.n.toLowerCase());
						});
						hasNVal = true;
						if (l.lstNs.length>10) {
							var midnt = Math.ceil(l.lstNs.length/2);
							var ntItem = [[0,midnt], [midnt,l.lstNs.length]];
							for (var ii=0; ii<2; ii++) {
								if (ii===0) {
									// FIXME le padding top 0 ne fonctionne pas.
									nt +='<div class="div-table-col-right-bord" style="padding-top: 0px !important;">';
								} else {
									nt += '<div class="div-table-col" style="padding-top: 0px !important;">';
								}
								nt += '<table class="no-spacing"><thead><tr><th scope="col">Noms des tests</th><th scope="col">Valeurs</th></tr></thead></tbody>';
								for (var int = ntItem[ii][0]; int < ntItem[ii][1]; int++) {
									vv = l.lstNs[int];
									nt += "<tr class='set-height-no-padding'>";
									nt += "<td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
									nt += "</tr>";
								}
								nt += "</tbody></table>";
								nt +='</div>';
							}
						} else {
							nt +='<div class="div-table-col-right-bord" style="padding-top: 0px !important;">';
							nt += '<table class="no-spacing"><thead><tr><th scope="col">Noms des tests</th><th scope="col">Valeurs</th></tr></thead></tbody>';
							for (var int = 0, len=l.lstNs.length; int < len; int++) {
								vv = l.lstNs[int];
								nt += "<tr class='set-height-no-padding'>";
								nt += "<td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
								nt += "</tr>";
							}
							nt += "</tbody></table>";
							nt +='</div>';
						}
					}
					if (!hasNVal) {
						nt = "";
					}

					var tt = '<div class="div-table-col" style="padding-top: 0px !important;">';
//					tt += '<table class="no-spacing"><thead><tr><th scope="col"></th><th scope="col">Noms des tests</th><th scope="col">Valeurs</th></tr></thead></tbody>';
					tt += '<table class="no-spacing"><thead><tr><th scope="col">Noms des tests</th><th scope="col">Valeurs</th></tr></thead></tbody>';
					var hasVal = false;
					if (l.lstVeryAbns && l.lstVeryAbns.length>0) {
						l.lstVeryAbns.sort(function (a, b) {
						    return a.n.toLowerCase().localeCompare(b.n.toLowerCase());
						});
						hasVal = true;
						for (var int = 0, len=l.lstVeryAbns.length; int < len; int++) {
							vv = l.lstVeryAbns[int];
							tt += "<tr class='set-height-no-padding act-tres-anormal'>";
//							tt += "<td><i class='fa fa-exclamation-triangle' aria-hidden='true'></i></td><td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
							tt += "<td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
							tt += "</tr>";
						}
					}
					if (l.lstAbns && l.lstAbns.length>0) {
						l.lstAbns.sort(function (a, b) {
						    return a.n.toLowerCase().localeCompare(b.n.toLowerCase());
						});
						hasVal = true;
						for (var int = 0, len=l.lstAbns.length; int < len; int++) {
							vv = l.lstAbns[int];
							tt += "<tr class='set-height-no-padding act-anormal'>";
//							tt += "<td><i class='fa fa-exclamation-circle' aria-hidden='true'></i></td><td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
							tt += "<td class='nowrapws'>" + vv.n + "</td><td>" + vv.v + "</td>";
							tt += "</tr>";
						}
					}
					tt += "</tbody></table>";
					if (hasVal) {
						tt +='</div>';
					} else {
						tt = "";
					}

					allTest += '<span class="act-header">';
					var ptData = '';
					if (l.patient) {
						ptData = ' : ' + model.getPatNameDdn(l.patient);
					}
					allTest += '<span style="padding-left: 10px !important;">' + l.entryDate + ' (version: ' + l.date + ')' + ptData + '</span>';
					allTest += '</span>';

					allTest +='<div class="div-table-container">';
					allTest +='<div class="div-table-row">';
					allTest +='<div class="div-table-col">';
					if (hasNVal && hasVal) {
						allTest +='<div class="div-table">';
						allTest +='<div class="div-table-row">';
						allTest +='<div class="div-table-col-right-bord">';
						allTest += tt;
						allTest +='</div>';
						allTest +='<div class="div-table-col">';
						allTest += nt;
						allTest +='</div>';
						allTest +='</div>';
						allTest +='</div>';
					} else {
						if (hasVal) {
							allTest += tt;
						} else if (hasNVal) {
							allTest += nt;
						}
					}
					allTest +='</div>';
					allTest +='</div>';
					allTest +='</div>';

					var nn = '<table class="no-spacing"><thead><tr><th scope="col">Commentaires</th></tr></thead></tbody>';
					var hasComment = false;
					if (l.profs && l.profs.length>0) {
						for (var int = 0; int < l.profs.length; int++) {
							vv = l.profs[int];
							if (vv.note && vv.note!='') {
								hasComment = true;
								var ww = OfysUtils.wordWrap(vv.note, 90, '<br/>');
								nn += "<tr class='set-height-no-padding'>";
								nn += '<td>' + ww + "</td>";
								nn += "</tr>";
							}
						}
					}
					nn += "</tbody></table>";
					if (!hasComment) {
						nn = "";
					}
					var allResult = '';
					if (hasComment || hasVal || hasNVal) {
						allResult = allTest + nn;
					}
					l.title_html = allResult;
					return allResult;
			},
			showLaboComments: function(l) {
				if (angular.isUndefined(l)) return;
				var nn = '';
				var hasComment = false;
				if (l.profs && l.profs.length>0) {
					for (var int = 0; int < l.profs.length; int++) {
						vv = l.profs[int];
						if (vv.note && vv.note!='') {
							hasComment = true;
							var ww = vv.note;
							if(vv.descr !== undefined){
								nn += vv.descr[0] + ": ";
							}
							nn += ww + "\n";
						}
					}
				}
				if (!hasComment) {
					nn = "";
				}
				return nn;
			},
			showDocNoteTitleHtml: function(l) {
				if (angular.isUndefined(l)) return;
				var nn = '<table><thead><tr><th scope="col">Notes</th></tr></thead></tbody>';
				var hasComment = false;
				if (l.profs && l.profs.length>0) {
					for (var int = 0; int < l.profs.length; int++) {
						var vv = l.profs[int];
						if (vv.note && vv.note!='') {
							hasComment = true;
							var ww = OfysUtils.wordWrap(vv.note, 90, '<br/>');
							nn += "<tr>";
							if(vv.descr !== undefined){
								nn += "<td> - - - " + vv.descr[0] + " - - -";
							}
							nn += "<br/>" + ww + "</td>";
							nn += "</tr>";
						}
					}
				}
				nn += "</tbody></table>";
				if (hasComment) {
					return nn;
				}
				return;
			},
			showDocComments: function(l) {
				if (angular.isUndefined(l)) return;
				var nn = '';
				var hasComment = false;
				if (l.profs && l.profs.length>0) {
					for (var int = 0; int < l.profs.length; int++) {
						var vv = l.profs[int];
						if (vv.note && vv.note!='') {
							hasComment = true;
							var ww = vv.note;
							if(vv.descr !== undefined){
								nn += vv.descr[0] + ": ";
							}
							nn += ww + "\n";
						}
					}
				}
				if (hasComment) {
					return nn;
				}
				return;
			}

		};

		return service;

		}]);


	/**
	 * COMMENT: PAT DATA @directive
	 *
	 * Sert à gérer les informations de la fiche du patient.
	 */
	patient.directive('patientData',
	['PatientAccessor','PatientUtils','EncounterAccessor','TaskAccessor', 'CourrielAccessor', 'RessourceAccessor','SuiviPrevAccessor',
	'DocAccessor', 'LabAccessor','AppointmentAccessor','FormAccessor','CrdsAccessor','FaxAccessor','model','Notification','DashAPI',
	'utils','patientShowTitles','$timeout', 'Rights','$log','ModificationStatus','$filter','rxvigilance','DashWebSocket','IaLinkType',
	function(PatientAccessor,PatientUtils, EncounterAccessor, TaskAccessor, CourrielAccessor, RessourceAccessor,SuiviPrevAccessor,
		 DocAccessor, LabAccessor, AppointmentAccessor, FormAccessor, CrdsAccessor, FaxAccessor, model,Notification,DashAPI,
		 utils, patientShowTitles, $timeout, Rights, $log, ModificationStatus, $filter, rxvigilance,DashWebSocket,IaLinkType){

		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/pat/pat_data/patientData.html?v=bl',
			link: function(scope, element, attrs){
				// scope.quickViewData = scope.$parent.quickViewData;
				var dateFrmt = 'YYYY-MM-DD';
				scope.eventsMax = 999;
				var eventBeforeDate = {};

				var isInPt = model.activeController()=='pt';
				var isInAppt = model.activeController()=='rv';
				var isInRess = model.activeController()=='ress';
				scope.serv = {
						viewMode:{normal: "n",qv:"qv"}
				};
				scope.utils = utils;
				scope.updateByDate = function(val){
					model.prefSettings('eventByDate', val);
					model.prefSettings('nbEvents', scope.eventsMax-1);
					scope.resetLimits();
				};
				scope.updateNbEvent = function(val){
					model.prefSettings('nbEvents', val);
					model.prefSettings('eventByDate', 0);
					scope.resetLimits();
				};

				scope.def = {
					show_deleted_form: function(val) {
						if (arguments.length) {
							model.prefSettings('showDeletedForm', val);
							var pd = scope.patient.viewbag && scope.patient.viewbag.patData ? scope.patient.viewbag.patData:undefined;
							if (pd!=undefined) {
								scope.resetFormFilter(pd);
								scope.resetLimits();
							}
						} else {
							return model.prefSettings('showDeletedForm');
						}
					}
				};
				function hasDirtyElement(){
					if(scope.quickViewData &&
						scope.quickViewData.qvActData &&
						scope.quickViewData.qvActData.isDirty){
						return true
					}
					var dirtyQuickview = false;
					_.each(model.qv().items, function(e){
						if(e.quickViewData.pat.id !== scope.patient.id){
							return;
						}
						if(e.quickViewData &&
							e.quickViewData.qvActData &&
							e.quickViewData.qvActData.isDirty){
							dirtyQuickview = true;
						}
					});

					return dirtyQuickview;
				}
				// appelé par le  bouton refresh ds patientData.html
				scope.reloadPatData = function(patient) {
					if(hasDirtyElement()){
						model.notice().warn($filter("translate")("saveBeforePatReload"))
						return;
					}
					var mustLoadEnc =  scope.patient.viewbag && scope.patient.viewbag.patData
						&& scope.patient.viewbag.patData.loaded && scope.patient.viewbag.patData.loaded.enc===1;
					clearCache(patient);
					if (scope.patient && scope.patient.viewbag) {
						delete scope.patient.viewbag;
					}
					scope.resetData(patient, true, mustLoadEnc);
				};

				// Méthodes DSQ copiées de la directive principale de recherche dsq
				// scope.sendingDsqPtSearchRequest = false;
				scope.neededSignFirst = false;
				scope.searchCriteria = {};

				scope.sendingDsqPtSearchRequest = false;
				var dsqPtSearchHandlerId = Notification.registerHandler('dsqCandidateSearch', function(msg){
					scope.sendingDsqPtSearchRequest = false;
					var statusError = DashAPI.handleReturnObject(msg.data.status);
					if (statusError=='ERROR') {
					} else if (statusError=='WARNING') {
						// signature demandé? Si oui et succès, on aura OK ensuite
						scope.neededSignFirst = true;
					} else if (statusError=='OK') {
						if (scope.neededSignFirst==true) {
							// donc a réussi le call, incluant l'obtention des signature
							scope.searchDsqPt();
						} else {
							// donc a reçu un Ok avec un niu dans l'objet du returnObject
							scope.patient.niu = msg.data.obj;
							scope.patient.viewbag.dsqActive = !!(scope.patient.niu);
							model.patientAllDataTabs()[2].disabled = !scope.patient.viewbag.dsqActive;
						}
					}
				}, scope);

				scope.searchDsqPt = function(currPatient) {
					if (scope.sendingDsqPtSearchRequest===false) {	// il faut empêcher les call répétés quand un est actif
						scope.sendingDsqPtSearchRequest = true;
						scope.neededSignFirst = false;
						scope.searchCriteria.patientId = scope.patient.id;
						DashWebSocket.sendRequest("/dashboard/dsq/ws/candidate/resolveNiu", scope.searchCriteria);
					}
				};

				scope.scrollTo = function(p) {
					var o = $(p)[0];
					if (o) {
				    	o.scrollIntoView(true);
					}
				};

				scope.isEditMode = function() {
					var b = false;
					if (scope.quickViewData && angular.isDefined(scope.quickViewData.editMode)) {
						b = scope.quickViewData.editMode===true;
						if (b && angular.isDefined(scope.quickViewData.linkModeOn)) {
							b = b && scope.quickViewData.linkModeOn===0;	// si en mode linkModeOn, il faut permettre la séleciton
						}
					}
					return b;
				};

				var counts={
					encToBeCompleted: 0,
					encToBeRevised: 0,
					encNotifCount: 0,
					appToday: 0,
					appFutur: 0,
					appTodayAndFutur: 0,
					appHasOnlyToday: false,
					appHasOnlyFutur: false,
					appHasTodayAndFutur: false,
					laboNotValidCount: 0,
					laboToSeeCount: 0,
					laboToResolveCount: 0,
					laboToAutoOpenCount: 0,
					laboNotifCount: 0,
					docNotValidCount: 0,
					docToSeeCount: 0,
					docToResolveCount: 0,
					docToAutoOpenCount: 0,
					docNotifCount: 0,
					sumActReminders: 0
				};

				scope.searchText = "";

				scope.showOptions = {activePlan: true, groupForm:false,groupTask:false, groupLab:false,groupDoc:false,groupFax:false,toCompleteAndReview:false,modifSumary:false};
				scope.showOptions.allRessources = false;

				scope.filterLaboToValidate = function(v) {
					return function(l) {
						return l.notValidated==='UNSEEN' && (v || scope.filterLabo(l));
					};
				};

				function filterOnDate(newDate) {
					try {
						return function(l) {
							if (l.date) {
								var d = l.date.slice(0,10);
								return d >= newDate;
							} else if (l.className==='CPatientRecall'){
								return (l.dateCreated && l.dateCreated>=newDate) || (l.dateRecall && l.dateRecall>=newDate);
							} else if (l.dateTimeStart) {
								return new moment(l.dateTimeStart).format(dateFrmt)>newDate;
							}
						};
					} catch (e) {
						$log.log(e);
					}
				}

				scope.resetLimits = function() {
					if (scope.patient && scope.patient.viewbag && scope.patient.viewbag.patData) {
						if (model.prefSettings().eventByDate===0) {
							scope.categoryOrder.forEach(function(categoryName){
								scope.categories[categoryName].limit = model.prefSettings().nbEvents;
							})
							// scope.limitN = scope.limitL = scope.limitD = scope.limitE1 = scope.limitE2 = scope.limitE3 = scope.limitM = scope.limitR = scope.limitS = scope.limitT = scope.limitA = scope.limitX = scope.limitF = model.prefSettings().nbEvents;
						} else {
								var pd = scope.patient.viewbag.patData;
								scope.categoryOrder.forEach(function(categoryName){
									scope.categories[categoryName].limit = scope.categories[categoryName].limitByDate = pd.enc.filterLength(filterOnDate(eventBeforeDate));
								})
						}
						model.actUpdated(true);
					}
				};

				scope.groupShowAllToggle = function(g) {
					g.showAll = g.showAll==undefined ? true : !g.showAll;
					model.actUpdated(true);
				};
				scope.groupShowAll = function(g) {
					return g.showAll==undefined ? false : g.showAll;
				};

				scope.addNewPatientRecall = function(){
					var defaultPatientRecall = {
							"className": "CPatientRecall",
							"priority": "NORMAL",
							"preferredTime": "NONE",
							"status": "NORMAL",
							"patient": _.omit(scope.patient, 'viewbag'),
							editMode: true,
							uid: UUID.atomic(),
							viewbag: {}
					};

					if(scope.patient.viewbag.patData.rem.length > 0){
						scope.patient.viewbag.patData.rem.unshift(defaultPatientRecall);
					}else{
						scope.patient.viewbag.patData.rem.push(defaultPatientRecall);
					}
					patientShowTitles.openActivity(defaultPatientRecall, {mode: 'n', minimize: false}, scope.patient);
				};

				scope.isMessagesCollapsed = false;

				scope.openLabDocToAutoOpen = function(pat) {
					// pat.viewbag.patData.counts.laboToAutoOpenCount+pat.viewbag.patData.counts.docToAutoOpenCount
					var labs = pat.viewbag.patData.lab.filterFast(scope.filterLaboToOpen(true));
					var docs = pat.viewbag.patData.doc.filterFast(scope.filterDocToOpen(true));
					// var min = labs.length+docs.length === 1 ? false:true;	// on ouvre non minimize si un seul.
					var min = false;	// on ouvre non minimize slm le premier
					for (var i=0;i<labs.length;i++) {
						patientShowTitles.openActivity(labs[i], {mode: 'n', minimize: min}, pat);
						if (!min) min=true;
					}
					for (var i=0;i < docs.length;i++) {
						patientShowTitles.openActivity(docs[i], {mode: 'n', minimize: min}, pat);
						if (!min) min=true;
					}
				};

				function setActOptions(){
					scope.actOptions = scope.$eval(attrs.options);
					if(scope.actOptions.registerApi){
						scope.actOptions.registerApi(api);
					}
					if(scope.actOptions.selectActive){
						scope.actOptions.onActSelect = function(categoryName, act){
							var actSelectionIdentifier = scope.getActSelectionId(categoryName,act)
							scope.selectedActs.checked[actSelectionIdentifier] = !scope.selectedActs.checked[actSelectionIdentifier];
							scope.setSelected(actSelectionIdentifier, act)
						}
					}
					scope.ressActOptions = {};
					$.extend(scope.ressActOptions, scope.actOptions,
						{
							addPatient : function(act){
								act.patient = PatientUtils.getSuperCleanPatient(scope.patient)
							},
							resourceEnd: function (act) {
								act.dateTimeEnd = moment().valueOf();
								act.autoRepeat = false;
								this.addPatient(act);
								RessourceAccessor.saveRessourceBilling(act);
							},
							resourceStart: function (act) {
								delete act.dateTimeEnd;
								act.autoRepeat = true;
								this.addPatient(act);
								RessourceAccessor.saveRessourceBilling(act);
							}
						}
					);
					return
				}

				var taskGroupe;
				var formGroupe;
				scope.resetData = function(patFromPatientsInQv, mustLoad, mustLoadEnc){
					scope.isResettingData = true;
					var openLastEncounter = false;
					var mustLoadEncounter = mustLoadEnc==undefined?false:mustLoadEnc;
					if (scope.quickViewData && scope.quickViewData.options) {
						openLastEncounter = scope.quickViewData.options.openLastEncounter===true;
					}
					if (openLastEncounter===true) {
						mustLoadEncounter = true;
					}
					taskGroupe = undefined;
					formGroupe = undefined;
					setActOptions();
					scope.quickViewData = scope.$eval(attrs.quickViewData);
					if(angular.isUndefined(scope.quickViewData)){
						scope.quickViewData = angular.noop;
					}
					if(!scope.quickViewData.linkModeOn){
						scope.quickViewData.linkModeOn = 0;
					}
					if(angular.isUndefined(scope.quickViewData.options)){
						scope.quickViewData.options = {};
					}
					if (angular.isUndefined(scope.quickViewData.options.openLastEncounter)) {
						scope.quickViewData.options.openLastEncounter =  openLastEncounter;
					}
					scope.quickViewData.options.mustLoadEncounter = mustLoadEncounter;
					var actController = model.activeController();	// on veut forcer un load si dans controlleur pt ou rv
					var mustLoadData = (mustLoad||isInAppt||isInRess||isInPt||scope.quickViewData.options.openLastEncounter===true) ? true : false;
					//console.time("patient.resetData");

					if (patFromPatientsInQv && patFromPatientsInQv.viewbag && patFromPatientsInQv.viewbag.patData) {
						var emptyPatientAlreadyInCache = scope.patient && (scope.patient.id === patFromPatientsInQv.id && scope.patient.viewbag !== patFromPatientsInQv.viewbag)
						if (angular.isUndefined(scope.patient) ||
							scope.patient.id!==patFromPatientsInQv.id) {
							scope.patient = patFromPatientsInQv;
							scope.resetLimits();
						}
						//In specific cases where the patient is already in cache and loaded but the patient
						//eceived is not the already loaded one, the patient must be updated.
						//e.g
						// 1. Open a patient in the patient tab. Open his external summary and then close his external summary
						// 2. Go to the task tab and open another patient from attachement (not the same patient as in step 1), Open his external summary
						// 3. Close the attachement of step 2
						// 4. Open an attachement of patient1 in step 1. still from the task tab
						// 5. Notice that this patient is already in the cache from step one but is empty since he is passed from the task tab.
						if(emptyPatientAlreadyInCache){
							// this seems to be the better way to update the patient. changing the whole object does not propagate to other directives (patientMedSummary is empty)
							$.extend(scope.patient, patFromPatientsInQv);
							// scope.quickViewData.pat = scope.patient
						}
						if(model.summaryExternalViewer && model.summaryExternalViewer.quickViewData && scope.patient &&
							model.summaryExternalViewer.quickViewData.pat.id !== scope.patient.id
							){
								var p;
								if(scope.actOptions.mode === 'e' && scope.origPatient){
									p = scope.origPatient
								}else{
									p = scope.patient;
								}
								patientShowTitles.externalSummary(p);// for task & msgs the if the patient is already in the cache
						}
					} else {
						if(scope.patient && !scope.patient.viewbag && model.patient() && model.patient().currPatient && model.patient().currPatient.viewbag && scope.patient.id===model.patient().currPatient.id){
							scope.patient = model.patient().currPatient;
						}
						if (scope.quickViewData) {	// donc on a ouvert un quickview - scope.patient déjà setté dans quickview.js
//							if (scope.quickViewData.viewerType=='form' && angular.isUndefined(scope.patient.viewbag)) {
							if (scope.patient && (angular.isUndefined(scope.patient.viewbag)||angular.isUndefined(scope.patient.viewbag.patData))) {
								// doit toujours loader le viewbag et ses listes
								mustLoadData = true;
							}
						} else {
							scope.quickViewData = angular.noop;
						}
					}
					//Si le load est dans un quickview ne pas loader les data du viewbag sf si mustLoadData = true.
//					if( (patFromPatientsInQv && scope.quickViewData.pat && angular.isUndefined(scope.patient.viewbag)) || (angular.isUndefined(scope.quickViewData.pat) && angular.isUndefined(scope.patient.viewbag))){
					if(scope.patient && (angular.isUndefined(scope.patient.viewbag) || angular.isUndefined(scope.patient.viewbag.patData))  && mustLoadData){
						if (angular.isUndefined(scope.patient.id)) {
							scope.patient = model.patient().currPatient;
						}
						// scope.lastVersionForms = [];
						// il suffit de mettre un 0 ici dans loaded pour que la liste en question ne se charge pas automatiquement
						// TODO prod: mettre 0 pour app, ffApp task et msg. Valeurs possibles slm 0 et 2
						var today = moment().format('YYYY-MM-DD');
						// var isInRess = actController=='ress';
						var currApptDate = model.appointment().currDate;
						var loadEnc = isInRess || (isInAppt===true && today==currApptDate) || scope.quickViewData.options.mustLoadEncounter===true ? 2 : 0;
						var loadTask = 2;// isInRess ? 2 : 0;	// toujours loader pour ress
						var loadRess = isInRess ? 2 : 0;
						var loadAppt = isInRess ? 0 : 2;
						scope.patient.viewbag = {
							patData:{fax:[],app:[],ffApp:[],msg:[],msgpat:[],srvy:[],docofys:[],doc:[],lab:[],labofys:[],rem:[],ress:[],task:[],form:[],frm1:[],frm2:[],frm3:[],enc:[],encLast5Last3y:[],sum:{}, hxrx:[],
								loaded:{fax:0,app:loadAppt,ffApp:0,msg:0,msgpat:0,srvy:2,doc:2,lab:2,rem:2,ress:loadRess,task:loadTask,form:2, encLast5Last3y: 2, enc:loadEnc,presaveenc:2,suiviPrev:2,sum:2,doneLoaded:0, dsqlab: 0,dsqsommhosp:0, dsqdoc:0, hxrx:0},
								counts:{},
								docs:{labels:[]}
							}
						};
						scope.patient.viewbag.limitations = Rights.getSessionUserConsent(scope.patient);
						scope.patient.viewbag.dsqActive = !!(scope.patient.niu);
						model.patientAllDataTabs()[2].disabled = !scope.patient.viewbag.dsqActive;
						angular.extend(scope.patient.viewbag.patData.counts, counts);
						var l = scope.patient.viewbag.patData.loaded;
						// un var watch dans chrono pour savoir quand a tout fini de loader les lists pertinentes afin de lancer le tri des données
						// l.sum non mis ici car ne participe pas à chrono
						scope.patient.viewbag.patData.requestedLoad = (l.fax+l.app+l.ffApp+l.msg+l.msgpat+l.srvy+l.doc+l.lab+l.ress+l.rem+l.task+l.form+l.enc)/2;
						if(scope.quickViewData.pat && !scope.quickViewData.patData){
							scope.quickViewData.patData = scope.patient.viewbag.patData;
						}
						scope.updateData(scope.patient);
						model.patientsInQv(''+scope.patient.id, scope.patient);
					} else if (angular.isUndefined(scope.quickViewData)) {	// car on ne veut pas relancer chrono ici
						model.patient().currPatient = scope.patient;

					} else {
						if(scope.quickViewData.pat && !scope.quickViewData.patData){
							scope.quickViewData.patData = scope.patient.viewbag.patData;
						}
						scope.updateData(scope.patient);
//						model.patientsInQv(''+scope.patient.id, scope.patient);
					}
					model.actUpdated(true);
					model.patientDataUpdated(true);
					model.patientChronoUpdated(true);
					model.patientSumUpdated(true);
				};

				scope.notSearching = function() {
					return angular.isUndefined(scope.searchTextRegExp);
				};

				scope.searchUpdated = function(v) {
					if (v==undefined || !v.length || v.length<2) {
						delete scope.searchTextRegExp;
					} else {
						scope.searchTextRegExp = [];
						if (v==='FR' || v==='BR' || v==='BP' || v==='TA' || v==='FC' || v==='HR') {
							scope.searchTextRegExp.push(new RegExp(v+'~'));
						} else if (v.length>2) {
							var x = v.split(' '); var len = x.length;
							for(var i=0;i<len;i++) {
								if (x[i].length===2 && (x[i]==='FR' || x[i]==='BR' || x[i]==='BP' || x[i]==='TA' || x[i]==='FC' || x[i]==='HR')) {
									scope.searchTextRegExp.push(new RegExp(x[i]+'~'));
								} else {
									scope.searchTextRegExp.push(new RegExp(x[i], 'i'));
								}
							}
						} else {
							delete scope.searchTextRegExp;
						}
					}
					model.actUpdated(true);
				};

				// *** les filtres selon searchText. Ces fonctions sont évaluée dans tous les filtres, sauf en post update qui calcule les length
				scope.filterEnc = function(l) {
					var b = true;
					var i2;
					if (scope.searchTextRegExp) {
						var lRx = "";
						if (l.lstPrescription && l.lstPrescription.length && l.lstPrescription.length>0) {
							lRx += 'prescription~ordonnance~';
							for (i2 = 0; i2 < l.lstPrescription.length; i2++) {
								lRx += l.lstPrescription[i2].entryDateSD + '~'+ l.lstPrescription[i2].baseDrugName + '~'+ l.lstPrescription[i2].name + '~';
							}
						}
						var lDv = "";
						if (l.lstDevice && l.lstDevice.length && l.lstDevice.length>0) {
							lDv += 'device~fourniture~';
							for (i2 = 0; i2 < l.lstDevice.length; i2++) {
								lDv += l.lstDevice[i2].entryDateSD + '~'+ l.lstDevice[i2].name + '~';
							}
						}
						var lDx = "";
						if (l.lstDx && l.lstDx.length && l.lstDx.length>0) {
							for (i2 = 0; i2 < l.lstDx.length; i2++) {
								lDx += l.lstDx[i2].entryDateSD + '~'+ l.lstDx[i2].descr[0].toString()+ '~';
							}
						}
						var lPx = "";
						if (l.lstProb && l.lstProb.length && l.lstProb.length>0) {
							for (i2 = 0; i2 < l.lstProb.length; i2++) {
								lPx += l.lstProb[i2].entryDateSD + '~'+ l.lstProb[i2].descr[0].toString()+ '~';
							}
						}
						var lNote = "";
						if (l.lstNote && l.lstNote.length && l.lstNote.length>0) {
							for (i2 = 0; i2 < l.lstNote.length; i2++) {
								lNote += l.lstNote[i2].entryDateS + '~'+ l.lstNote[i2].note+ '~';
							}
						}
						var lRaison = "";
						if (l.lstRaison && l.lstRaison.length && l.lstRaison.length>0) {
							for (i2 = 0; i2 < l.lstRaison.length; i2++) {
								lRaison += l.lstRaison[i2].reason+ '~';
							}
						}
						lRaison += l.encounterTypeS+ '~';

						var lSocHisto = l.socialHistoryObj?l.socialHistoryObj.note:"";
						var lFamHisto = l.familyHistoryObj?l.familyHistoryObj.note:"";
						var lOtherRx = l.otherMedicationsObj?l.otherMedicationsObj.note:"";
						var lRxHisto = l.medicalHistoryObj?l.medicalHistoryObj.note:"";
						var lOngConc = l.ongoingConcernsObj?l.ongoingConcernsObj.note:"";
						var lRem = l.remindersObj?l.remindersObj.note:"";
						var lProf = "";
						if (l.lstProf && l.lstProf.length && l.lstProf.length>0) {
							for (i2 = 0; i2 < l.lstProf.length; i2++) {
								lProf += l.lstProf[i2].entryDateS + '~'+ l.lstProf[i2].profNom+ '~';
							}
						}
						var lAll = "";
						if (l.lstAllergy && l.lstAllergy.length && l.lstAllergy.length>0) {
							lAll +=  'allergie~allergy~';
							for (i2 = 0; i2 < l.lstAllergy.length; i2++) {
								lAll +=  l.lstAllergy[i2].descr.toString()+ '~';
							}
						}
						var lInt = "";
						if (l.lstIntolerance && l.lstIntolerance.length && l.lstIntolerance.length>0) {
							lInt += 'intolerance~';
							for (i2 = 0; i2 < l.lstIntolerance.length; i2++) {
								lInt += l.lstIntolerance[i2].descr.toString()+ '~';
							}
						}
						var lIntv = "";
						if (l.lstIntervention && l.lstIntervention.length && l.lstIntervention.length>0) {
							lIntv += 'intervention~surgery~chirurgie~';
							for (i2 = 0; i2 < l.lstIntervention.length; i2++) {
								lIntv += l.lstIntervention[i2].descr.toString()+ '~';
							}
						}
						var lImm = "";
						if (l.lstImmunization && l.lstImmunization.length && l.lstImmunization.length>0) {
							lImm += 'vaccine~immunisation~immunization~';
							for (i2 = 0; i2 < l.lstImmunization.length; i2++) {
								lImm += l.lstImmunization[i2].descr.toString()+ '~';
							}
						}
						var lPrev = "";
						if (l.lstPrevent && l.lstPrevent.length && l.lstPrevent.length>0) {
							lPrev += 'prevention~';
							for (i2 = 0; i2 < l.lstPrevent.length; i2++) {
								lPrev += l.lstPrevent[i2].descr.toString()+ '~';
							}
						}
//						private List<Rappels> lstRappel;
						var lRapp = "";
						if (l.lstRappel && l.lstRappel.length && l.lstRappel.length>0) {
							lRapp += 'rappel~reminder~';
							for (i2 = 0; i2 < l.lstRappel.length; i2++) {
								lRapp += l.lstRappel[i2].descr.toString()+ '~';
							}
						}
//						private List<Docs> lstDoc;
						var lDoc = "";
						if (l.lstDoc && l.lstDoc.length && l.lstDoc.length>0) {
							lDoc += 'document~';
							for (i2 = 0; i2 < l.lstDoc.length; i2++) {
								lDoc += l.lstDoc[i2].descr ? l.lstDoc[i2].descr.toString()+ '~' : '~';
							}
						}
//						private List<BloodPres> lstBloodPres;
						var lBp = "";
						if (l.lstBloodPres && l.lstBloodPres.length && l.lstBloodPres.length>0) {
							lBp += 'bloodpressure~tensionarterielle~TA~BP~FC~HR~';
							for (i2 = 0; i2 < l.lstBloodPres.length; i2++) {
								lBp += l.lstBloodPres[i2].descr ? l.lstBloodPres[i2].entryDateS + '~'+ l.lstBloodPres[i2].descr.toString()+ '~' : '~';
							}
						}
//						private List<BodyTemp> lstBodyTemp;
						var lTemp = "";
						if (l.lstBodyTemp && l.lstBodyTemp.length && l.lstBodyTemp.length>0) {
							lTemp += 'temperature~';
							for (i2 = 0; i2 < l.lstBodyTemp.length; i2++) {
								lTemp += l.lstBodyTemp[i2].descr ? l.lstBodyTemp[i2].entryDateS + '~'+ l.lstBodyTemp[i2].descr.toString()+ '~' : '~';
							}
						}
//						private List<Freq> lstFreq;
						var lFreq = "";
						if (l.lstFreq && l.lstFreq.length && l.lstFreq.length>0) {
							lFreq += 'frequencerespiratoire~breathingfrequency~FR~BR~';
							for (i2 = 0; i2 < l.lstFreq.length; i2++) {
								lFreq += l.lstFreq[i2].descr ? l.lstFreq[i2].entryDateS + '~'+ l.lstFreq[i2].descr.toString()+ '~' : '~';
							}
						}
//						private List<Measurement> lstMeasurement;
						var lMeas = "";
						if (l.lstMeasurement && l.lstMeasurement.length && l.lstMeasurement.length>0) {
							lMeas += 'mesure~poids~taille~height~weight~';
							for (i2 = 0; i2 < l.lstMeasurement.length; i2++) {
								lMeas += l.lstMeasurement[i2].descr ? l.lstMeasurement[i2].entryDateS + '~'+ l.lstMeasurement[i2].descr.toString()+ '~' :'~';
							}
						}
//						private List<PhysicalExam> lstPhysicalExam;
						var lPhEx = "";
						if (l.lstPhysicalExam && l.lstPhysicalExam.length && l.lstPhysicalExam.length>0) {
							lPhEx += 'examenphysique~physicalexamination~';
							for (i2 = 0; i2 < l.lstPhysicalExam.length; i2++) {
								lPhEx += l.lstPhysicalExam[i2].descr ? l.lstPhysicalExam[i2].entryDateS + '~'+ l.lstPhysicalExam[i2].descr.toString()+ '~' : '~';
							}
						}
//						private List<Consult> lstConsult;
						var lCons = "";
						if (l.lstConsult && l.lstConsult.length && l.lstConsult.length>0) {
							lCons += 'consultation~';
							for (i2 = 0; i2 < l.lstConsult.length; i2++) {
								lCons += l.lstConsult[i2].descr.toString()+ '~';
							}
						}
//						private List<CustMeasure> lstCustMeasure;
						var lCustMes = "";
						if (l.lstCustMeasure && l.lstCustMeasure.length && l.lstCustMeasure.length>0) {
							lCustMes += 'mesure~';
							for (i2 = 0; i2 < l.lstCustMeasure.length; i2++) {
								lCustMes += l.lstCustMeasure[i2].entryDateS + '~'+ l.lstCustMeasure[i2].descr.toString()+ '~';
							}
						}
// TODO add lstRaison (.reason et visitReason.descr...), enc labels,
						b = matchInArray(lRx+'~'+lDv+'~'+lRaison+'~'+lNote+'~'+lSocHisto+'~'+lFamHisto+'~'+lOtherRx +
							'~'+lRxHisto+'~'+lOngConc+'~'+lRem+'~'+lDx+'~'+lPx+'~'+lProf+'~'+lAll+'~'+lInt+'~'+lIntv+
							'~'+lImm+'~'+lPrev+'~'+lRapp+'~'+lDoc+'~'+lBp+'~'+lTemp+'~'+lFreq+'~'+lMeas+'~'+lPhEx+'~'+lCons+'~'+lCustMes);
						return b;
					}
					if (scope.showOptions.toCompleteAndReview===true) {
						return b && l.encounterType>9 && ((l.tbcObj && !l.tbcObj.deleted) || (l.tbrObj && !l.tbrObj.deleted));
					} else if (scope.showOptions.modifSumary===true) {
						return b && l.encounterType<10;	// type 1 modif somm et 2 import rx dsq
					} else {
						return b && l.encounterType>9;
					}
				};
				function matchInArray(string) {
					if (scope.searchTextRegExp) {
						var len = scope.searchTextRegExp.length, i=0;
						for (; i < len; i++) {
							if (scope.searchTextRegExp[i].length==2) {
								if (!scope.searchTextRegExp[i].test(string)) {
									return false;
								}
							} else if (!scope.searchTextRegExp[i].test(string)) {
								return false;
							}
						}
						return true;
					}
					return true;
				}
				scope.filterLabo = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var dsqText = '';
						if (l.res) {
							var prescriber = '';
							if (l.res.laboRequest) {
								if (l.res.laboRequest.author) {
									prescriber = l.res.laboRequest.author.firstName + '~' + l.res.laboRequest.author.lastName + '~';
								}
							}
							var codeText = '';
							if (l.res.laboReportHeader) {
								if (l.res.laboReportHeader.reportType) {
									codeText = l.res.laboReportHeader.reportType.text + '~';
								}
							}
							var keywords = '';
							if (l.viewbag) {
								keywords = l.viewbag.keywords + '~';
							}
							dsqText = prescriber+codeText+keywords;
						}

						b = matchInArray(l.date+'~'+l.req+'~'+dsqText);
					}
					return b;
				};
				scope.filterDoc = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var lbls = "";
						if (l.labels) {
							for (var i2 = 0; i2 < l.labels.length; i2++) {
								lbls += l.labels[i2].name + '~';
							}
						}
						var dsqText = '';
						if (l.res) {
							var prescriber = '';
							if (l.res.prescriber) {
								prescriber = l.res.prescriber.firstName + '~' + l.res.prescriber.lastName + '~';
							}
							var codeText = '';
							if (l.res.code) {
								codeText = l.res.code.text + '~';
							}
							var performer = '';
							if (l.res.performerODS) {
								performer = l.res.performerODS.name + '~';
							}
							dsqText = performer+prescriber+codeText;
						}
						b = matchInArray(l.date+'~'+lbls+'~'+l.scanUserName+'~'+l.name+'~'+dsqText);
					}
					return b;
				};

				scope.filterFax = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var dsqText = '';
						if (l.res) {
							var prescriber = '';
							if (l.res.prescriber) {
								prescriber = l.res.prescriber.firstName + '~' + l.res.prescriber.lastName + '~';
							}
							var codeText = '';
							if (l.res.code) {
								codeText = l.res.code.text + '~';
							}
							var performer = '';
							if (l.res.performerODS) {
								performer = l.res.performerODS.name + '~';
							}
							dsqText = performer+prescriber+codeText;
						}
						b = matchInArray(l.date+'~'+l.scanUserName+'~'+l.name+'~'+dsqText);
					}
					return b;
				};
				scope.filterForm = function(l) {
					var b = true;
					var patate;
					if(l.presave){
						patate = l.presave
					}
					if (scope.searchTextRegExp) {
						b = matchInArray(l.date+'~'+l.author+'~'+l.form.name+'~'+l.description+'~'+l.resumeValue);
					}
					return b;
				};
				scope.filterRapHisto = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						b = matchInArray();
					}
					return b;
				};
				scope.filterRess = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var from = (l.nameFr?l.nameFr:"") + '~' + (l.nameEn?l.nameEn:"");
						b = matchInArray(from);
					}
					return b;
				};
				scope.filterTask = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var from = (l.fromUserNMd?l.fromUserNMd:"") + (l.fromUserNClin?l.fromUserNClin:"") + (l.fromUserNEmp?l.fromUserNEmp:"");
						var to = (l.toGroupN?l.toGroupN:"") + (l.toUserN?l.toUserN:"");
						b = matchInArray(from+'~'+to+'~'+l.date);
					}
					return b;
				};
				scope.filterSrvy = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var from = (l.surveyTitle_fr?l.surveyTitle_fr:"") + (l.surveyTitle_en?l.surveyTitle_en:"");
						b = matchInArray(from);
					}
					return b;
				};
				scope.filterMsg = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						var from = (l.fromUserNMd?l.fromUserNMd:"") + (l.fromUserNClin?l.fromUserNClin:"") + (l.fromUserNEmp?l.fromUserNEmp:"");
						b = matchInArray(from+'~'+l.toUserN+'~'+l.dataText);
					}
					return b;
				};
				scope.filterApp = function(l) {
					var b = true;
					if (scope.searchTextRegExp) {
						b = matchInArray(l.date+'~'+l.statusNote+'~'+l.profNom+'~'+l.note);
					}
					return b;
				};

				scope.groupByUniqueFormName = function(lstForms) {
					if (formGroupe) return formGroupe;
					formGroupe = _.groupBy(lstForms, function(v) {
						return v.form.name;
					});
					return formGroupe;
				};
				scope.groupByProgress = function(lstTask) {
					if (taskGroupe) return taskGroupe;
					taskGroupe = _.groupBy(lstTask, function(t) {
						// un chiffre ajouté pour forcer un tri logique, indépendamment du nom.
						if (t.completionDatetime!==undefined) {
							return '4. ' + $filter('translate')('pd_task_complet');
						} else if (t.progress==='RECU') {
							return '2. ' + $filter('translate')('pd_task_recus');
						} else if (t.progress==='SO') {
							return '1. ' + $filter('translate')('pd_task_uncomplet');
						} else {
							return '3. ' + $filter('translate')('TASK_PROGRESS_EN_COURS2');
						}
					});
					function sortObject(o) {
					    return Object.keys(o).sort().reduce((r, k) => (r[k] = o[k], r), {});
					}
//					var ordered = {};
//					Object.keys(taskGroupe).sort().forEach(function(key) {
//					  ordered[key] = taskGroupe[key];
//					});
//					taskGroupe = ordered;
					taskGroupe = sortObject(taskGroupe);
					return  taskGroupe;
				};
				scope.filterLaboToValidate = function(v) {
					return function(l) {
						return l.notValidated==='UNSEEN' && (v || scope.filterLabo(l));
					};
				};
				scope.filterLaboToSee = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b1 = l.notValidated!=='UNSEEN';
							var b2 = $.inArray('UNSEEN',l.selectedProf.st)!=-1;
							return b1 && b2 && (v || scope.filterLabo(l));
						}
						return false;
					};
				};
				scope.filterAllLaboToSee = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b2 = $.inArray('UNSEEN',l.selectedProf.st)!=-1;
							return b2 && (v || scope.filterLabo(l));
						}
						return false;
					};
				};
				scope.filterLaboToResolve = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b = $.inArray('TO_RESOLVE',l.selectedProf.st)!=-1;
							return b && (v || scope.filterLabo(l));
						}
						return false;
					};
				};
				scope.filterLaboToOpen = function(v) {
					return function(l) {
						if (l.profs) {
							for (var i = 0; i < l.profs.length; i++) {
								var prof = l.profs[i]
								var b = $.inArray('OPEN_WITH_FILE',prof.st)!=-1;
								if (b===true) break;
							}
							return b && (v || scope.filterLabo(l));
						}
						return false;
					};
				};
				scope.filterLaboOnlyToOpen = function(v) {
					return function(l) {
						if (l.selectedProf) {
							// ici, je ne veux que les auto-ouvrir qui n'ont pas été retournés dans le filter toResolve
							var b = $.inArray('OPEN_WITH_FILE',l.selectedProf.st)!=-1 && $.inArray('TO_RESOLVE',l.selectedProf.st)==-1;
							return b && (v || scope.filterLabo(l));
						}
						return false;
					};
				};
				scope.filterLaboOnlyDsq = function(v) {
					return function(l) {
						if (l.res && l.res.laboResultId) {
							return true;
						}
						return false;
					};
				};
				scope.filterLaboOnlyVeryAbns = function(v) {
					return function(l) {
						return l.lstVeryAbns && l.lstVeryAbns.length>0 && (v || scope.filterLabo(l));
					};
				};
				scope.filterLaboOnlyAbns = function(v) {
					return function(l) {
						var hasVAbn = l.lstVeryAbns && l.lstVeryAbns.length>0;
						return !hasVAbn && l.lstAbns && l.lstAbns.length>0 && (v || scope.filterLabo(l));
					};
				};
				scope.filterLaboOnlyNorm = function(v) {
					return function(l) {
						if (l.res && l.res.laboResultId) {
							return false;
						}
						var hasVAbn = l.lstVeryAbns && l.lstVeryAbns.length>0;
						var hasAbn = l.lstAbns && l.lstAbns.length>0;
						return !(hasVAbn||hasAbn) && (v || scope.filterLabo(l));
					};
				};

				scope.filterDocToValidate = function(v) {
					return function(l) {
						return l.notValidated==='UNSEEN' && (v || scope.filterDoc(l));
					};
				};
				scope.filterAllDocToSee = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b2 = $.inArray('UNSEEN',l.selectedProf.st)!=-1;
							return b2 && (v || scope.filterDoc(l));
						}
						return false;
					};
				};
				scope.filterDocToSee = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b1 = l.notValidated!=='UNSEEN';
							var b2 = $.inArray('UNSEEN',l.selectedProf.st)!=-1;
							return b1 && b2 && (v || scope.filterDoc(l));
						}
						return false;
					};
				};
				scope.filterDocToResolve = function(v) {
					return function(l) {
						if (l.selectedProf) {
							var b = $.inArray('TO_RESOLVE',l.selectedProf.st)!=-1;
							return b && (v || scope.filterDoc(l));
						}
						return false;
					};
				};
				scope.filterDocToOpen = function(v) {
					return function(l) {
						if (l.profs) {
							for (var i = 0; i < l.profs.length; i++) {
								var prof = l.profs[i]
								var b = $.inArray('OPEN_WITH_FILE',prof.st)!=-1;
								if (b===true) break;
							}
							return b && (v || scope.filterDoc(l));
						}
						return false;
					};
				};
				scope.filterDocOnlyToOpen = function(v) {
					return function(l) {
						if (l.selectedProf) {
							// ici, je ne veux que les auto-ouvrir qui n'ont pas été retournés dans le filter toResolve
							var b = $.inArray('OPEN_WITH_FILE',l.selectedProf.st)!=-1 && $.inArray('TO_RESOLVE',l.selectedProf.st)==-1;
							return b && (v || scope.filterDoc(l));
						}
						return false;
					};
				};

				scope.filterDocLabel = function(etiq, v) {
					return function(doc) {
						var b = false;
						if(doc.labels){
							for (var i2 = 0; i2 < doc.labels.length; i2++) {
								var lbl = doc.labels[i2].name;
								b = etiq===lbl;
								if (b) break;
							}
						}
						return b && (v || scope.filterDoc(doc));
				    };
				};
				scope.filterNoDocLabel = function(v) {
					return function(doc) {
						if (doc.res && doc.res.id) {
							return false;
						}
						return (angular.isUndefined(doc.labels) || doc.labels.length===0) && (v || scope.filterDoc(doc));
					};
				};
				scope.filterDocOnlyDsq = function(v) {
					return function(l) {
						if (l.className && l.className === 'CImagingResultExam' && l.res && l.res.id) {
							return true;
						}
						return false;
					};
				};

				scope.filterDocOnlyDsqSommhosp = function(v) {
					return function(l) {
						if (l.className && l.className === 'CPatientDischargeCareSummary') {
							return true;
						}
						return false;
					};
				};

				scope.filterAllDoc = function(v) {
					return function(a) {
						return (v || scope.filterDoc(a));
					};
				};

				scope.filterAllForm = function(v) {
					return function(a) {
						return (v || scope.filterForm(a));
					};
				};

				scope.filterAllRapHisto = function(v) {
					return function(a) {
						return (v || scope.filterRapHisto(a));
					};
				};

				scope.filterAllRess = function(v) {
					return function(a) {
						return (v(a) && scope.filterRess(a));
					};
				};
				scope.filterActiveRess = function(v) {
					if (scope.showOptions.allRessources===true) return true;
					return v.dateTimeEnd===undefined;
				}
				scope.filterAllTask = function(v) {
					return function(a) {
						return (v || scope.filterTask(a));
					};
				};

				scope.filterAllSrvy = function(v) {
					return function(a) {
						return (v || scope.filterSrvy(a));
					};
				};
				scope.filterAllMsg = function(v) {
					return function(a) {
						return (v || scope.filterMsg(a));
					};
				};

				scope.filterTodayApp = function(v) {
					return function(a) {
						return a.when===0 && (v || scope.filterApp(a));
					};
				};
				scope.sortTodayApp = function(a,b) {
					return a.startTime-b.startTime;
				};
				scope.filterFuturApp = function(v) {
					return function(a) {
						return a.when>0 && (v || scope.filterApp(a));
					};
				};
				scope.filterPastApp = function(v) {
					return function(a) {
						return a.when<0 && (v || scope.filterApp(a));
					};
				};
				scope.filterAllFax = function(v) {
					return function(a) {
						return (v || scope.filterFax(a));
					};
				};


				scope.sortFuturApp = function(a,b) {
					return a.when-b.when;
				};
				scope.sortPastApp = function(a,b) {
					return b.when-a.when;
				};


				function getPatient(pt){
					return pt;
				}

				function getPatientData(pt){
					if(pt && pt.id && pt.viewbag && pt.viewbag.patData){
						return pt.viewbag.patData;
					}
				}

				scope.updateData = function(pt){
					pt = getPatient(pt);
					var pd = getPatientData(pt);
					var isClinical = model.user().hasClinicalRights();

					if (pd != undefined) {
						//Summary
						if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};

						// form
						if (pd.loaded.form===2) {
							updateForms(pt, pd);
						}
						if (isClinical) {
							
							if (pd.loaded.suiviPrev===2) {
								updateSuiviPrev(pt, pd);
							}
							
							if (pd.loaded.sum===2 && !isLimited("ClinicalFile")) {
								updateSum(pt, pd);	// upateLabs sera appelé après la réception de sum car besoin de measure pour creat cl.
							} else {
								//Laboratory
								if (pd.loaded.lab===2 && !isLimited("LabResults")) {
									updateLabs(pt, pd);
								}
							}
							//Encounters
							if (pd.loaded.enc===2 && !isLimited("ClinicalFile")) {
								updateEncs(pt, pd);
							} else if (pd.loaded.enc===1 && !isLimited("ClinicalFile")) {
								if (scope.quickViewData.options.openLastEncounter===true) {
									var firstStandardEnc = pd.enc.filterFastFirst(function(a){return a.encounterType>10;});
									if(firstStandardEnc.length>0) {
										patientShowTitles.open(firstStandardEnc[0], scope);
									}
									delete scope.quickViewData.options.openLastEncounter;
								}
							} else if (pd.loaded.encLast5Last3y===2  && !isLimited("ClinicalFile")) {
								updateEncs(pt, pd, true); // true = load last 5 in last 3y,
							}

							//Presaved Encounters
							if (pd.loaded.presaveenc===2 && !isLimited("ClinicalFile")) {
								updatePresaveEncs(pt, pd);
							}
							//Document
							if (pd.loaded.doc===2 && !isLimited("Documents")) {
								updateDocs(pt, pd);
							}
						} else {
							pd.loaded.suiviPrev=1;
							pd.loaded.sum=1;
							pd.loaded.lab=1;
							pd.loaded.enc=1;
							pd.loaded.presaveenc=1;
							pd.loaded.doc=1;
							pd.loaded.fax=1;
						}
						//Reminder
						if (pd.loaded.rem===2 && !isLimited("NonCliData")) {
							updateReminders(pt, pd);
						}
						//Task
						if (pd.loaded.ress===2) {
							updateRess(pt, pd);
						}
						//Task
						if (pd.loaded.task===2 && !isLimited("NonCliData")) {
							updateTasks(pt, pd);
						}
						//Messages
						if (pd.loaded.msg===2 && !isLimited("NonCliData")) {
							updateMsgs(pt, pd);
						}
						//Messages Patient
						if (pd.loaded.msgpat===2 && !isLimited("NonCliData")) {
							updatePatientMsgs(pt, pd);
						}
						//Patient Survey
						if (pd.loaded.srvy===2 && !isLimited("NonCliData")) {
							updatePatientSurvey(pt, pd);
						}
						//Appointments
						if (pd.loaded.app===2 && !isLimited("Appointment")) {
							updateApps(pt, pd);
						}
						if (isClinical) {
							if (pd.loaded.fax===2 && !isFaxLimited()) {
								updateFax(pt, pd);
							}
						}
						//Future Family Appointments
						if (pd.loaded.ffApp===2 && !isLimited("Appointment")) {
							updateFFApps(pt, pd);
						}
					}
				};
				function isFaxLimited(){
					return isLimited("Documents") || isLimited("ClinicalFile") || isLimited("LabResults") || isLimited("Forms");
				}
				scope.manualUpdateData = function(update, t){
					var pt = scope.patient;
					var pd = getPatientData(pt);
					if (pt.id) {
						pd.loaded[t]=2;
						pd.requestedLoad++;	// pour aviser chrono
						model.actUpdated(true);
						var fn = eval(update);	// une des fonctions d'update.
						fn(pt, pd)
					}
				};
				
				function getUnsavedFiles(unsaved){
					var forms = [];
					for(const form of unsaved){
						if(form.editMode && form.editMode === true){
							forms.push(form)
						}
					}
					return forms
				}
				
				/**
				 * COMMENT: PAT DATA @function
				 *
				 * Permet de recentrer l'ajout de document dans la fiche du patient lorsqu'un utilisateur est zoom in
				 * 
				 */
				scope.recenterDoc = function(){
					$timeout(function() {
						var anchor = angular.element('#docMobileAnchor');
						if(OfysUtils.isSafariBrowser()){
							anchor[0].scrollIntoView();
						}else{
							anchor[0].scrollIntoView({
								behavior: "smooth",
								block: "end",
								inline: "nearest"
							});
						}
					}, 350);
				}
				
				/**
				 * COMMENT: PAT DATA @function
				 *
				 * Vérifie si il y a des forms en édition, si oui, retourne false
				 */
				function checkFormFiles(pt, pd){
					var proceed = false;
					var form = [];
					form.push(...getUnsavedFiles(pd.form));
					form.push(...getUnsavedFiles(pd.frm1));
					form.push(...getUnsavedFiles(pd.frm2));
					form.push(...getUnsavedFiles(pd.frm3));
					if (form.length === 0){
						proceed = true
					}
					return proceed;
				}
				
				/**
				 * COMMENT: PAT DATA @function
				 *
				 * Sert à aller chercher les forms provenant du CRDS externe. La funciton vérifie si il y a des forms en
				 * édition et ensuite vérifie si il y a besoin de reloader la liste
				 */
				scope.isCrdsLoading = 0;
				scope.getCrdsFile = function(){
					var pt = scope.patient;
					var pd = pt.viewbag.patData;
					var canProceed = checkFormFiles(pt, pd)
					if (canProceed){
						scope.isCrdsLoading = 1;
						CrdsAccessor.listRequestByPatient(pt.id, function(res){
							var needCrdsReload = res;
							if (needCrdsReload){
//								var pt = scope.patient;
//								var pd = pt.viewbag.patData;
								updateForms(pt, pd);
							}
							else{
								model.notice().success($filter('translate')('CRDS_ALREADY_UPDATED'));
							}
						}).then(function(){
							scope.isCrdsLoading = 0;
						})	
					} else {
						model.notice().fail($filter('translate')('FORM_IN_EDITION'));
					}	
				}

				var api = {
					getSelected : function(){
						return scope.selectedActs.data;
					},
					setActiveCategories:function(categories){
						if(categories && categories.length > 0){
							scope.categoryOrder = categories;
						}
					},
					resetCategories:function(categories){
						if(categories && categories.length > 0){
							scope.categoryOrder = defaultCategoryOrder;
						}
					}
				}

				scope.selectedActs = { checked:{}, data:{}, };

				scope.setSelected = function(key, data){
					if(scope.selectedActs.checked[key]){
						scope.selectedActs.data[key] = data;
					}else{
						delete scope.selectedActs.data[key];
					}
				}

				scope.getActSelectionId = function(categoryName, act){
					return categoryName +"_"+ act.uid;
				}
				
//				scope.getAllSuiviPrev = function() {
//					SuiviPrevAccessor.suiviPrevsPat(scope.patient.id);
//					return SuiviPrevAccessor.suiviPrevsBase();
//				}
				
				function updateSuiviPrev(pt, pd){
					var idProf;
					if (model.user().profil) {
						idProf = model.user().profil.id;
					} else {
						idProf = pt.treatingProfessionnal;
					}
					SuiviPrevAccessor.suiviPrevsPat(pt.id);	// juste pour charger la liste
					if (idProf!=undefined) {
						SuiviPrevAccessor.suiviPrevPatProf({idPat:pt.id, idProf:idProf} , function(res){
							pd.sum.suiviPrev = res.data;
							pd.sum.suiviPrevToDo = res.data.filter(function(a) {return a.toDo===true;});
							pd.loaded.suiviPrev=1;
							model.patientSumUpdated(true);
						}, function(ms) {
							console.log(ms);
						});
					}
				}

				function updateSum(pt, pd){
					EncounterAccessor.sum(pt.id, function(res){
						$.extend(pd.sum, res.data);
						if(pd.sum.lstMeasurement && pd.sum.lstMeasurement.length>0){
							pd.sum.lastMesure = pd.sum.lstMeasurement.reduce(function(acc, ms){
								if(acc.timeVitalSign > ms.timeVitalSign){
									return acc;
								}else{
									return ms
								}
							});
							pd.sum.lastMesureByEntryDate = pd.sum.lstMeasurement.reduce(function(acc, ms){
								if(acc.entryDate > ms.entryDate){
									return acc;
								}else{
									return ms
								}
							});
							// pour les courbes de croissance, il faut le id avec last entryDate pour le select du backend.
							pd.sum.lastMesure.id = pd.sum.lastMesureByEntryDate.id;
						}
						if(pd.sum.lastMesure){
							var tvs = moment(pd.sum.lastMesure.timeVitalSignS);
							var ddn = moment(pt.birthDate);
							pd.sum.lastMesure.entryDateNoTimeS = tvs.format("YYYY-MM-DD");
							pd.sum.lastMesure.showGrowthChart = tvs.diff(ddn, 'months', true) < 300;
						}
						if(pd.sum.lstBloodPres && pd.sum.lstBloodPres.length>0){
							pd.sum.lastBloodPres = pd.sum.lstBloodPres.reduce(function(acc, ms){
								if(acc.timeVitalSign > ms.timeVitalSign){
									return acc;
								}else{
									return ms;
								}
							});
						}
						if(pd.sum.lastBloodPres){
							pd.sum.lastBloodPres.timeVitalSignS = moment(pd.sum.lastBloodPres.timeVitalSignS).format("YYYY-MM-DD");
						}
						if(pd.sum.lstIaData) {
							pd.sum.iaSum = pd.sum.lstIaData.filter(function(e) {return e.linkType==IaLinkType.PATIENT_SUM;});
							pd.sum.iaEnc3y = pd.sum.lstIaData.filter(function(e) {return e.linkType==IaLinkType.RENCONTRE3Y;});
						}
						pd.counts.sumActReminders = pd.sum && pd.sum.lstRappel ? pd.sum.lstRappel.filterLength(function(dx){return dx.isResolve===0;}) : 0;
						pd.loaded.sum = 1;
						model.patientSumUpdated(true);
						if (pd.loaded.lab===2) {
							updateLabs(pt, pd);
						}
						if(model.summaryExternalViewer){
							patientShowTitles.externalSummary(pt);
						}
					});
				}

				function getIMC(item){
					function commaToPoint(s){
						return s.replace(/,/g, '.');
					}
					var w = commaToPoint(item.weightS2)*1;
					var hM = (commaToPoint(item.heightS1)*1/100) //taille en mettre
					var imc = w /(hM*hM);
					return Math.round( imc * 10 ) / 10;//Un chiffre après le 0;
				}
				
				function initEncs(encList, isOkBill, idProf){
					encList.forEach(function(enc){
						if(enc.lstNote){
							enc.lstNote = $filter('orderBy')(enc.lstNote, ['noteType', 'entryDate']);
						}
						if (isOkBill===true) {
							var encProf = enc.lstProf.filter(function(e) {return e.idProfessionnalAnchor==idProf;}).sort(function(f, g) {return  f.entryDate>g.entryDate ? 1 : -1;});
							if (encProf.length>0) {
								enc.profEnc = encProf[0];
							}
						}
//						if(e.lstMeasurement){
//							e.lstMeasurement.forEach(function(m){
//								if(m.weightS2 && m.heightS1){
//									m.IMC = getIMC(m);
//								}
//							})
//						}
					});
				}

				function updateEncs(pt, pd, last5last3y){

					if (Rights.cannotLoadClinicalData(pt)) {
						pd.loaded.doneLoaded++;
						pd.loaded.enc = 1;
					} else if (last5last3y===true){
						EncounterAccessor.listLast5Last3y(pt.id, mergeEnc, function(err){
							$log.log(err);
						});
					} else {
						EncounterAccessor.list(pt.id, mergeEnc, function(err){
							pd.loaded.enc = 3;
						});
					}

					function mergeEnc(res) {
						if (res) {
							var prof = model.user().profil;
							var session = model.user().session;
							var user = session.user;
							var isBilling = user.factType && user.factTupe != 'AUCUN';
							var apiKey = isBilling===true ? session.apiKeyOrToken : undefined;
							var xacteUserName = user.factUsername;
							var isOkBill = prof!==undefined && prof.code!==undefined && apiKey!==undefined && xacteUserName!==undefined;

							// fix changing uid bug.
							fixChangingUid(res,'id', 'uid');

							//console.log(moment() + ': isLoading Encounters');
							if (last5last3y === true) {
								pd.encLast5Last3y = res.sort(sortOnDate);
								pd.loaded.encLast5Last3y = 1;
							}else{
								pd.encLast5Last3y = [];
								pd.loaded.enc = 1;
							}
							pd.enc = res.sort(sortOnDate);
							initEncs(pd.enc, isOkBill, prof.id);	// add profEnc pour billing aussi. enc.profEnc.factType==0 // red no bill, enc.profEnc.factType>0 // green bill
							pd.counts.encToBeCompleted = pd.enc.filterLength(function (l) {
								return l.tbcObj && l.tbcObj.deleted !== true;
							});
							pd.counts.encToBeRevised = pd.enc.filterLength(function (l) {
								return l.tbrObj && l.tbrObj.deleted !== true;
							});
							pd.counts.encNotifCount = pd.counts.encToBeCompleted + pd.counts.encToBeRevised;
							mergePresaved(pd);

							if (scope.quickViewData.options.openLastEncounter === true) {
								var firstStandardEnc = pd.enc.filterFastFirst(function (a) {
									return a.encounterType > 10;
								});
								if (firstStandardEnc.length > 0) {
									patientShowTitles.open(firstStandardEnc[0], scope);
								}
								delete scope.quickViewData.options.openLastEncounter;
							}
							if(pd.form && pd.form.length>0){
								var allFormsInEnc = {};
								if (pd.enc && pd.enc.length>0) {
									for(var i = 0; i < pd.enc.length; i++) {
										if (pd.enc[i].lstDoc && pd.enc[i].lstDoc.length>0) {
											for(var j = 0; j <  pd.enc[i].lstDoc.length; j++) {
												var fDoc = pd.enc[i].lstDoc[j];
												if (fDoc.atype===2) {
													allFormsInEnc[fDoc.idDocument] = fDoc;
												}
											}
										}
									}
								}
								for(var i = 0; i < pd.form.length; i++){
									if (allFormsInEnc[pd.form[i].id]) {
										if (allFormsInEnc[pd.form[i].id].description!=pd.form[i].form.name) {
											pd.form[i].description = ' (' + allFormsInEnc[pd.form[i].id].description + ')';
										}
									} else {
										pd.form[i].description = '';
									}
								}
							}
						}
						pd.loaded.doneLoaded++;
						scope.categories.enc.resetLimit();
						// resetLimitIndividually(pd.enc, 'N');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					}
				}

				function mergePresaved(pd){
					if(pd.presaveenc){
						var merged = false;
						for (var i = 0; i < pd.enc.length; i++) {
							var e = pd.enc[i];
							if(e.id === pd.presaveenc[0].id){
								e.editMode = true;
								e.guid = pd.presaveenc[0].guid;
								e.viewbag = {editEnc: pd.presaveenc[0]};
								merged = true;
								break;
							}
						}
						if(!merged){
							pd.enc = _.union(pd.presaveenc, pd.enc);
						}
					}
				}

				//This function fixes uid changes to make sure that on refresh the open quickview uid remains the same.
				// The bug it fixes occurs only when a refresh of the patients documents, encounters, appointments etc are refreshed while the element is still open.
				// since the elements uid changes(regenerated by the backend) the quickview cannont keep track of the element.
				function fixChangingUid(list, stableIdName, unstableName){
					var qvuidByGuid = {};
					_.each(model.qv().items, function(e){
						if(e.quickViewData &&
							e.quickViewData.qvActData &&
							e.quickViewData.qvActData[stableIdName] !== undefined){
								qvuidByGuid[e.quickViewData.qvActData[stableIdName]] = e.quickViewData.qvActData.uid;
							}
					});
					if(!_.isEmpty(qvuidByGuid)){
						list.forEach(function(it){
							// this code corrects a rare bug where the refresh of a patient's file changes the uid of the edit encounter.
							// by making sure that the current in browser uid stays the same, then we ensure that presave encounters cannot have zombie presaves.
							if(qvuidByGuid[it[stableIdName]] !== undefined ){
								it[unstableName] = qvuidByGuid[it[stableIdName]];
							}
						})
					}
				}


				function updatePresaveEncs(pt, pd){
					EncounterAccessor.getPresaved(pt.id, function(res){
						if(res){
							res = _.isArray(res)? res: [res];

							// fix changing uid bug.
							fixChangingUid(res,'guid', 'uid');

							//Remove deleted items
							res.forEach(function(enc){
								_.each(EncounterAccessor.allEncSections, function(e){
									if(enc[e]){
										enc[e] = _.reject(enc[e], function(ei){
											return (ei.modificationStatus === ModificationStatus.STATUS_DELETED && ei.id === undefined)
										})
										if(enc[e].length === 0){
											delete enc[e];
										}
									}
								});

							})


							pd.presaveenc = res;
							mergePresaved(pd)
							pd.loaded.doneLoaded++;
							scope.categories.enc.resetLimit();
							// resetLimitIndividually(pd.enc, 'N');
							model.actUpdated(true);
						}
						pd.loaded.presaveenc = 1;
					}, function(err){
						pd.loaded.presaveenc = 3;
					});
				}

				function updateLabs(pt, pd){
					if (Rights.cannotLoadClinicalData(pt)) {
						pd.loaded.doneLoaded++;
						pd.loaded.lab = 1;
					} else {
						LabAccessor.byPatient(pt.id, function(res){
							var labStructCreat = res.data[0]; // LaboStructureDate
							//var labStructCrit = res.data[1]; // LaboStructureDate
							var lstAbnLab4Rxv = res.data[1]; // lstAbnLab4Rxv
							var lstRSOS = res.data[2]; // lstAbnLab4Rxv
							var lstHbA1c = res.data[3]; // lstAbnLab4Rxv
							var lstPsa = res.data[4]; // lstAbnLab4Rxv
							var lstCho = res.data[5]; // lstAbnLab4Rxv
							var lstLaboFilter = res.data[6]; // lstLaboFilter
							var lstLaboFollow = res.data[7]; // lstLaboFollow
							res.data.splice(0,8);
							if (pt.viewbag===undefined) pt.viewbag = {};
							if (labStructCreat.date) {
								// on a une creat. Mettre dans patient.
								pt.viewbag.creatinine_date = labStructCreat.date;
								pt.viewbag.creatinine = labStructCreat.laboStructure.v;
								pt.viewbag.creatinine_unit = ' mmol/L';
								// MDRD
								var ageInt = Math.pow(pt.age, -.203);
								var cr = Math.pow(labStructCreat.laboStructure.v / 88.4, -1.154);
								var race = 1;
								var sex = 1;
								if (pt.race == 2) {race = 1.21;}
								if (pt.gender == 'F') {sex = .742;}
								var valueCr = 3.1 * cr * ageInt * sex * race * 60;
								pt.viewbag.creatinine_cl = valueCr.toFixed(0);
							}
							if (lstRSOS.date) {
								// on a une RSOS. Mettre dans patient.
								pt.viewbag.rsos = {date: lstRSOS.date, value:lstRSOS.laboStructure.v, name:lstRSOS.laboStructure.n};
							}
							if (lstHbA1c.date) {
								// on a une HbA1v. Mettre dans patient.
								pt.viewbag.hba1c = {date: lstHbA1c.date, value:lstHbA1c.laboStructure.v, name:lstHbA1c.laboStructure.n};
							}
							if (lstPsa.date) {
								// on a une HbA1v. Mettre dans patient.
								pt.viewbag.psa = {date: lstPsa.date, value:lstPsa.laboStructure.v, name:lstPsa.laboStructure.n};
							}
							if (lstCho.date) {
								// on a une HbA1v. Mettre dans patient.
								pt.viewbag.chol = {date: lstCho.date, value:lstCho.laboStructure.v, name:lstCho.laboStructure.n};
							}
							//VIEW CALL STACK TO DETERMINE WHICH CALL CAUSED THE EMPTY VIEWBAG
							if (lstAbnLab4Rxv && lstAbnLab4Rxv.length>0) {
								pt.viewbag.lstAbnLab4Rxv = lstAbnLab4Rxv;
							}
							pd.labofys = res.data;
							if(pd.labdsq && pd.labdsq.length>0){
								res.data = res.data.concat(pd.labdsq);
							}
							pd.lab = res.data.sort(sortOnDate);
							var allLabs = [];
							// voir si on a des valeurs critiques
							var hasValCrit = false;
							var less5y = moment().subtract(5, 'years').format(OfysUtils.DATEFORMAT);
							for (var i = 0; i < pd.lab.length; i++) {
								var l = pd.lab[i];
								hasValCrit = l.flag===2;
								if (l.date<less5y || hasValCrit) {
									break;
								}
							}
							
							var uniqueResult = [];
							for (var i = 0; i < pd.lab.length; i++) {
								var l = pd.lab[i];
								if (l.hasUnRes===true) {
									// trouver le résultat unique
									uniqueResult = uniqueResult.concat(l.lstNs?l.lstNs:[], l.lstAbns?l.lstAbns:[], l.lstVeryAbns?l.lstVeryAbns:[]).filter(function(o){return o.un===true});
								}
							}
							var idProf = model.user().profil.id;
							if (lstLaboFollow && idProf) {
								lstLaboFollow = _.filter(lstLaboFollow, function(o){return o.idPf===idProf;});
							} else {
								lstLaboFollow = [];
							}
							if (hasValCrit || lstLaboFollow.length>0) {
								
								// je pense qu'il faudrait concaténer les listes de labstruct. triés sur date inverse... 
								for (var i = 0; i < pd.lab.length; i++) {
									var l = pd.lab[i];
									if (l.date>less5y) {
										allLabs = allLabs.concat(l.lstNs?l.lstNs:[], l.lstAbns?l.lstAbns:[], l.lstVeryAbns?l.lstVeryAbns:[]);
									} else {
										break;
									}
								}
								if (allLabs.length>0) {								
									allLabs = allLabs.sort(function(a, b) {if (a.c>b.c) {return 1;} else if (a.c<b.c) {return -1;} else {if (a.d > b.d) { return -1; } else if (a.d < b.d) {return 1;} return 0;}});
									allLabs = _.uniq(allLabs, true, _.iteratee(function(n) { return n.c; }));							
								}
								
								var labCrit = _.filter(allLabs, function(o){ return o.f===2});
								if (labCrit.length>0 && lstLaboFilter) {
									var ids = _.uniq(_.pluck(lstLaboFilter, 'idLs'));							
									labCrit = _.filter(labCrit, function(o){ return !_.contains(ids, o.id); });
								}
								if (uniqueResult.length>0 && lstLaboFilter) {
									var ids = _.uniq(_.pluck(lstLaboFilter, 'idLs'));							
									uniqueResult = _.filter(uniqueResult, function(o){ return !_.contains(ids, o.id); });
								}
	
								if (lstLaboFollow.length>0) {
									var labTypeCodes = _.uniq(_.pluck(lstLaboFollow, 'idLtc'));
									var loincIds = _.uniq(_.pluck(lstLaboFollow, 'idLc'));
									// iterate in the list 
									var ptLF = _.filter(allLabs, function(o){ return _.contains(labTypeCodes, o.c) || _.contains(loincIds, o.l)});
									labCrit = _.difference(labCrit, ptLF);
									for (var i = 0; i < ptLF.length; i++) {
										ptLF[i].lf = true;
									}
									pt.viewbag.laboFollow = _.union(labCrit, ptLF, uniqueResult);
									// si un labo crit est aussi suivi, il faut le retirer de la liste des critiques
									// TODO ds html, mettre rouge si critique. Garder ds objet si est suivi pour savoir si 
									// on doit avoir le delete ou si on doit avoir un 'suivre'. 
									// donc pas besoin de 2 listes - juste une. 
								} else {
									pt.viewbag.laboFollow = _.union(labCrit, uniqueResult);								
								}
							} else if (uniqueResult.length>0) {
								if (lstLaboFilter) {
									var ids = _.uniq(_.pluck(lstLaboFilter, 'idLs'));							
									uniqueResult = _.filter(uniqueResult, function(o){ return !_.contains(ids, o.id); });
								}
								pt.viewbag.laboFollow = uniqueResult;
							}
							pd.counts.laboNotValidCount = pd.lab.filterLength(scope.filterLaboToValidate(true));
							pd.counts.laboToSeeCount = pd.lab.filterLength(scope.filterAllLaboToSee(true));
							pd.counts.laboToResolveCount = pd.lab.filterLength(scope.filterLaboToResolve(true));
							pd.counts.laboToAutoOpenCount = pd.lab.filterLength(scope.filterLaboToOpen(true));
							pd.counts.laboNotifCount = pd.counts.laboNotValidCount+pd.counts.laboToSeeCount+pd.counts.laboToResolveCount+pd.counts.laboToAutoOpenCount;
							pd.loaded.lab = 1;
							pd.loaded.doneLoaded++;
							scope.categories.labo.resetLimit();
							// resetLimitIndividually(pd.lab, 'L');
							model.actUpdated(true);
							model.patientDataUpdated(true);
							model.patientChronoUpdated(true);
							model.patientSumUpdated(true);
							if (rxvigilance.isActive()) {
								if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};
								pt.viewbag.analyseRxv.isWorking = true;
								rxvigilance.openRxViglanceService(rxvigilance.engineQueryJson, pt, undefined, pt.viewbag.analyseRxv);
							}
						});
					}
				}

				function updateDocs(pt, pd){
					if (Rights.cannotLoadClinicalData(pt)) {
						pd.loaded.doneLoaded++;
						pd.loaded.doc = 1;
					} else {
						DocAccessor.byPatient(pt.id, function(res){
							// fix changing uid bug.
							fixChangingUid(res.data,'id', 'uid');

							var summaryDocs = [];
							pd.docofys = res.data;

							// // garder les etiquettes
							for (var int = 0; int < pd.docofys.length; int++) {
								var doc = pd.docofys[int];
								if(doc.labels){
									for (var i2 = 0; i2 < doc.labels.length; i2++) {
										var lbl = doc.labels[i2];
										if(lbl.id === -1){ //check if label is summary, aka -1 obvious
											summaryDocs.push(doc)
										}
										pd.docs.labels.push(lbl.name);
									}
								}
							}
							pd.docs.labels = pd.docs.labels.filter(function (x, i, a) {
							    return a.indexOf(x) == i;
							});
							if(summaryDocs.length > 0){
								pd.summaryDocs = summaryDocs;
								model.patientSumUpdated(true);
							}
							pd.docs.labels.sort();
							pd.counts.docNotValidCount = pd.docofys.filterLength(scope.filterDocToValidate(true));
							pd.counts.docToSeeCount = pd.docofys.filterLength(scope.filterAllDocToSee(true));
							pd.counts.docToResolveCount = pd.docofys.filterLength(scope.filterDocToResolve(true));
							pd.counts.docToAutoOpenCount = pd.docofys.filterLength(scope.filterDocToOpen(true));
							pd.counts.docNotifCount = pd.counts.docNotValidCount+pd.counts.docToSeeCount+pd.counts.docToResolveCount+pd.counts.docToAutoOpenCount;
							pd.loaded.doc = 1;

							DocAccessor.utils.updateAllDocs(pd);

							pd.loaded.doneLoaded++;
							scope.categories.doc.resetLimit();
							// resetLimitIndividually(pd.docofys, 'D');
							model.actUpdated(true);
							model.patientDataUpdated(true);
							model.patientChronoUpdated(true);
						});
					}
				}

				/**
				 * COMMENT: PAT DATA @function
				 *
				 * Sert à gérer les formes de la fiche du patient. Réarrange ensuite par date et version
				 */
				function updateForms(pt, pd){
					if (Rights.cannotLoadClinicalData(pt)) {
						pd.loaded.doneLoaded++;
						pd.loaded.form = 1;
					} else {
						FormAccessor.patientFormData(pt.id, function(resData){
							// fix changing uid bug.
							fixChangingUid(resData,'id', 'uid');
							pd.formVersion = PatientAccessor.sortVersion(resData)
							for(key in pd.formVersion){
								if(pd.formVersion[key].length > 1){
									pd.formVersion[key].sort(sortOnDate)
								}
							}
							pd.form = resData.sort(sortOnDate);	// tous les form sont là.
							if (scope.showOptions.groupForm===true) {
								formGroupe = undefined;
								scope.groupByUniqueFormName(pd.form);
							}
							scope.resetFormFilter(pd);
							model.actUpdated(true);
							model.patientDataUpdated(true);
							model.patientChronoUpdated(true);
						});
					}
				}

				scope.resetFormFilter = function(pd){
					var filterDeleted = model.prefSettings('showDeletedForm')===true ? true: false;
					pd.frm1 = pd.form.filterFast(function(a){return a.form.type===1 && (filterDeleted?true:a.deleted===false);});
					pd.frm2 = pd.form.filterFast(function(a){return a.form.type===2 && (filterDeleted?true:a.deleted===false);});
					pd.frm3 = pd.form.filterFast(function(a){return a.form.type===3 && (filterDeleted?true:a.deleted===false);});
					pd.loaded.form = 1;
					pd.loaded.doneLoaded++;
					scope.categories.form.resetLimit();
					// resetLimitIndividually(pd.frm1, 'E1');
					scope.categories.formCRDS.resetLimit();
					// resetLimitIndividually(pd.frm2, 'E2');
					scope.categories.formCNESST.resetLimit();
					// resetLimitIndividually(pd.frm3, 'E3');
				};

				function updateReminders(pt,pd){
					AppointmentAccessor.recall({patientId:pt.id}, function(res){
						// fix changing uid bug.
						fixChangingUid(res.data,'id', 'uid');

						pd.rem = res.data.sort(sortOnDate);
						pd.rem.forEach(function(rem){
							rem.patient = _.omit(pt, 'viewbag');
						});
						pd.loaded.rem = 1;
						pd.loaded.doneLoaded++;
						scope.categories.rappel.resetLimit();
						// resetLimitIndividually(pd.rem, 'R');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updateRess(pt,pd){
					RessourceAccessor.patientlist({id:pt.id}, function(res){
						// fix changing uid bug.
						fixChangingUid(res.data,'id', 'uid');

						pd.ress = res.data.sort(sortOnDate);
						pd.loaded.ress = 1;
						pd.loaded.doneLoaded++;
						scope.categories.ress.resetLimit();
						// resetLimitIndividually(pd.ress, 'S');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}
				function updateTasks(pt,pd){
					TaskAccessor.patientlist({id:pt.id}, function(res){
						// fix changing uid bug.
						fixChangingUid(res.data,'id', 'uid');
						pd.task = res.data.sort(sortOnDate);
						if (scope.showOptions.groupTask===true) {
							taskGroupe = undefined;
							scope.groupByProgress(pd.task);
						}
						pd.counts.taskNotCompleted = pd.task && pd.task.length>0 ? pd.task.filterLength(function (l) {
								return l.completionDatetime === undefined;
							}) : 0;
						pd.loaded.task = 1;
						pd.loaded.doneLoaded++;
						scope.categories.task.resetLimit();
						// resetLimitIndividually(pd.task, 'T');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updateMsgs(pt, pd){
					CourrielAccessor.bypat({id:pt.id}, function(res){
						pd.msg = res.data.sort(sortOnDate);
						pd.loaded.msg = 1;
						pd.loaded.doneLoaded++;
						scope.categories.msg.resetLimit();
						// resetLimitIndividually(pd.msg, 'M');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updatePatientMsgs(pt, pd){
					CourrielAccessor.frompat({id:pt.id}, function(res){
						pd.msgpat = res.data.sort(sortOnDate);
						pd.loaded.msgpat = 1;
						pd.loaded.doneLoaded++;
						scope.categories.msgpat.resetLimit();
						// resetLimitIndividually(pd.msg, 'M');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updatePatientSurvey(pt, pd){
					PatientAccessor.patientsurvey({id:pt.id}, function(res){
						if (res.data && res.data.success==undefined && res.data.success!=false) {
							pd.srvy = res.data.sort(sortOnDate);
							pd.loaded.srvy = 1;
							pd.loaded.doneLoaded++;
							scope.categories.srvy.resetLimit();
							model.actUpdated(true);
							model.srvyDataUpdated(true);
							model.patientDataUpdated(true);
							model.patientChronoUpdated(true);
						}
					});
				}

				function updateApps(pt, pd){
					AppointmentAccessor.list({patient:pt.id}, function(res){
						// fix changing uid bug.
						fixChangingUid(res.data,'id', 'uid');
						pd.app = res.data.sort(sortOnDate);
						pd.counts.appToday = pd.app.filterLength(scope.filterTodayApp(true));
						pd.counts.appFutur = pd.app.filterLength(scope.filterFuturApp(true));
						pd.counts.appTodayAndFutur = pd.counts.appToday+pd.counts.appFutur;
						pd.counts.appHasOnlyToday = pd.counts.appToday>0 && pd.counts.appFutur===0;
						pd.counts.appHasOnlyFutur = pd.counts.appToday===0 && pd.counts.appFutur>0;
						pd.counts.appHasTodayAndFutur = pd.counts.appToday>0 && pd.counts.appFutur>0;
						pd.loaded.app = 1;
						pd.loaded.doneLoaded++;
						scope.categories.app.resetLimit();
						// resetLimitIndividually(pd.app, 'A');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updateFax(pt, pd){
					FaxAccessor.patientlist({id:pt.id}, function(res){
						pd.fax = res.data.sort(sortOnDate);
						pd.loaded.fax = 1;
						pd.loaded.doneLoaded++;
						scope.categories.fax.resetLimit();
						// resetLimitIndividually(pd.fax, 'X');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				function updateFFApps(pt, pd){
					AppointmentAccessor.list({patient:pt.id, type:'FF'}, function(res){
						// fix changing uid bug.
						fixChangingUid(res.data,'id', 'uid');
						pd.ffApp = res.data.sort(sortOnDate);
						pd.loaded.ffApp = 1;
						pd.loaded.doneLoaded++;
						scope.categories.ffApp.resetLimit();
						// resetLimitIndividually(pd.ffApp, 'F');
						model.actUpdated(true);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
					});
				}

				var sortOnDate = PatientAccessor.sortOnDate;
				function dateStrToLong(d){
					var frmt = 'YYYY-MM-DD';
					if(d.length > 16){
						frmt = 'YYYY-MM-DD HH:mm:ss';
					}else if(d.length > 10){
						frmt = 'YYYY-MM-DD HH:mm';
					}
					return moment(d,frmt ).valueOf();
				}
				scope.patientDataFilterOptions = {
						trigger: 'click',
						closeOnMouseleave: true,
						templateUrl: '/dashboard/resources/ofys/pat/pat_data/patientDataFilter.html?v=bl',
						position: {
							x: 'right',
							y: 'center'
						},
						outside: 'x',
						onClose: function(){
							scope.updateData(scope.patient);
						}
				};

				function clearCache(pat){
					if (pat && pat.id) {
						model.patientsInQv(pat.id, null);
					}
				}

				function patientIdUpdated(nv, ov, scope) {
					if (nv!==0 && nv!=ov) {
						clearCache(ov);
						scope.resetData(model.patientsInQv(''+nv, {}));
					} else{
						scope.resetData(model.patientsInQv(''+nv));
					}
				}

				function getViewLabList(){
					//En linkmode ou quand la selection des items et active (joindre l'element dans courriel)
					if( scope.quickViewData.linkModeOn > 0 || scope.actOptions.selectActive){
						return scope.patient.viewbag.patData.labofys;
					}else{
						return scope.patient.viewbag.patData.lab
					}
				}

				function getViewDocList(){
					//En linkmode ou quand la selection des items et active (joindre l'element dans courriel)
					if( scope.quickViewData.linkModeOn > 0 || scope.actOptions.selectActive){
						return scope.patient.viewbag.patData.docofys;
					}else{
						return scope.patient.viewbag.patData.doc
					}
				}

				model.formLinkUpdated(true);	// il faut caller l'update ici au cas ou en mode true et qu'a changé de tab
				var defaultCategoryOrder = ['ress','enc', 'labo','doc', 'form','formCRDS','formCNESST','rappel', 'task', 'msg','msgpat', 'srvy','app', 'ffApp', 'fax'];
				var clinicalRightSections = ['enc', 'labo','doc','fax'];
				scope.categoryOrder = defaultCategoryOrder;
				if(!model.user().hasClinicalRights()){
					scope.categoryOrder = scope.categoryOrder.filter(function(e){return clinicalRightSections.indexOf(e) === -1})
				}
				scope.openPatientMsg = function(){
					CourrielAccessor.openNewToPatient(scope.patient);
				}

				var dataTypeToLimitationMap = {lab: "LabResults", doc: "Documents", form:"Forms",enc: "ClinicalFile", task:"NonCliData",app:"Appointment", rap:"NonCliData",courriel:"NonCliData",fax:["Documents","ClinicalFile","LabResults"]}
				function isLimited(limitation){
					if(limitation == undefined && this && this.dataType && dataTypeToLimitationMap[this.dataType]){
						if(this.dataType == 'fax'){//Fax special case verify array.
							return !(scope.patient.viewbag.limitations.Documents && 
								scope.patient.viewbag.limitations.ClinicalFile && 
								scope.patient.viewbag.limitations.Forms && 
								scope.patient.viewbag.limitations.LabResults);
						}
						limitation = dataTypeToLimitationMap[this.dataType];
					}
					if(limitation){
						if(scope.patient &&
							scope.patient.viewbag && 
							scope.patient.viewbag.limitations){
							return !scope.patient.viewbag.limitations[limitation];
						}
					}
					return false;
				}


				var defaultCategory = {
					hide: false,
					isLimited: isLimited,
					resetLimit: function () {
						if (model.prefSettings().eventByDate===0) {
							this.limit = model.prefSettings().nbEvents;
						} else if(this.getList){
							var lst = this.getList();
							eventBeforeDate = moment().subtract(model.prefSettings().eventByDate,'year').format(dateFrmt);
							this.limit = this.limitByDate = lst.filterLength(filterOnDate(eventBeforeDate));
						}
						model.actUpdated(true);
					},
					limit: model.prefSettings().nbEvents,
					limitByDate: model.prefSettings().nbEvents,
				};

				/** COMMENT: PAT DATA @array
				 * 
				 * Description: Permet de créer une de nouvelle catégorie dans le "patient.data"
				 * les boutons pour "actionBtnsUrl" se retrouve dans index.html'
				 *
				 * Constructeur:
				 * Object.assign({
				 *		namei18n: "TRANSLATIONSTRING",
				 * 		actionBtnsUrl: "id.html"
				 *	}, angular.copy(defaultCategory)),
				 */
				scope.categories = {
					ress:Object.assign(angular.copy(defaultCategory), {
						dataType: 'ress',
						namei18n: "RESS",
						icon: 'fa-building-o',
						hide: !model.ress().isActive(),
						actionBtnsUrl: 'ress_actionbtns_index.html',
						actOptions: function(){
							return scope.ressActOptions;
						},
						manualUpdate: function(){
							scope.manualUpdateData('updateRess');
						},
						getList: function(){
							return scope.patient.viewbag.patData.ress.filterFast(scope.filterAllRess(scope.filterActiveRess));
						},
					}),
					enc: Object.assign(angular.copy(defaultCategory), {
						dataType: 'enc',
						icon: 'fa-folder-o',
						actionBtnsUrl: 'enc_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateEncs','enc');
						},
						namei18n: function(){
							if(scope.actOptions.mode==='qv'){
								return scope.showOptions.modifSumary===true?'ENC_MODSOM':'ENC'
							}else{
								return scope.showOptions.modifSumary===true?'ENC_MODIFSOM':'ENCOUNTERS';
							}
						},
						getList: function(){
							return scope.patient.viewbag.patData.enc.filterFast(scope.filterEnc);
						},
					}),
					labo: Object.assign(angular.copy(defaultCategory), {
						dataType: 'lab',
						getActType: function(act){
							if (act.res) {
								return 'labdsq';
							} else if (model.prefSettings('user_settings_labOneLine')==true) {
								return 'lab_simple';
							}
							return 'lab';
						},
						icon: 'fa-flask',
						namei18n: 's_Laboratories',
						actionBtnsUrl: 'lab_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateLabs');
						},
						getList: function(){
							return getViewLabList().filterFast(scope.filterLabo)
						},
						showGroups: function(){
							return scope.showOptions.groupLab;
						},
						groups:[
							{
								namei18n:'NOT_VALIDATED',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboToValidate(false));
								}
							},
							{
								namei18n:'UNSEEN',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboToSee(false));
								}
							},
							{
								namei18n:'TO_RESOLVE',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboToResolve(false));
								}
							},
							{
								namei18n:'OPEN_WITH_FILE',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboOnlyToOpen(false));
								}
							},
							{
								namei18n:'LES_TRES_ANORMAUX',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboOnlyVeryAbns(false));
								}
							},
							{
								namei18n:'LES_ANORMAUX',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboOnlyAbns(false));
								}
							},
							{
								namei18n:'NORMAUX',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboOnlyNorm(false));
								}
							},
							{
								namei18n:'DSQ',
								getList: function(){
									return getViewLabList().filterFast(scope.filterLaboOnlyDsq(false)) ;
								}
							},
						]
					}),
					doc: Object.assign(angular.copy(defaultCategory), {
						dataType: 'doc',
						getActType: function(act, group){
							if(act.className === "CImagingResultExam"){
								return 'docdsq'
							}
							if(act.className === "CPatientDischargeCareSummary"){
								return 'sommhospdsq';
							}
							if (group===true || model.prefSettings('user_settings_docOneLine')==true) {
								return 'doc_simple';
							}
							return 'doc';
						},
						icon: 'fa-file-text-o',
						namei18n: 's_Documents',
						actionBtnsUrl: 'doc_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateDocs');
						},
						getList: function(){
							return getViewDocList().filterFast(scope.filterAllDoc(false))
						},
						showGroups: function(){
							return scope.showOptions.groupDoc;
						},
						recenterDoc: function(){
							return scope.recenterDoc();
						},
						groups:[
							{
								namei18n:'NOT_VALIDATED',
								getList: function(){
									return getViewDocList().filterFast(scope.filterDocToValidate(false));
								}
							},
							{
								namei18n:'UNSEEN',
								getList: function(){
									return getViewDocList().filterFast(scope.filterDocToSee(false));
								}
							},
							{
								namei18n:'TO_RESOLVE',
								getList: function(){
									return getViewDocList().filterFast(scope.filterLaboToResolve(false)) ;
								}
							},
							{
								namei18n:'OPEN_WITH_FILE',
								getList: function(){
									return getViewDocList().filterFast(scope.filterDocToOpen(false));
								}
							},
							function(){
								return scope.patient.viewbag.patData.docs.labels.map(function(actLabel){
									return {
										namei18n:actLabel,
										actLabel: actLabel,
										getList: function(){
											return getViewDocList().filterFast(scope.filterDocLabel(actLabel, false));
										}
									};
								});
							},
							{
								namei18n:'NO_LABELS',
								getList: function(){
									return getViewDocList().filterFast(scope.filterNoDocLabel(false));
								}
							},
							{
								namei18n:'DSQ',
								getList: function(){
									return getViewDocList().filterFast(scope.filterDocOnlyDsq(false));
								}
							},
							{
								namei18n:'Sommhosp',
								getList: function(){
									return getViewDocList().filterFast(scope.filterDocOnlyDsqSommhosp(false));
								}
							}
						]
					}),
					form:Object.assign(angular.copy(defaultCategory), {
						dataType: 'form',
						namei18n: "Forms",
						icon: 'fa-list-alt',
						hide: false,
						actionBtnsUrl: 'forms_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateForms');
						},
						getList: function(){
							return scope.patient.viewbag.patData.frm1.filterFast(scope.filterAllForm(false));
						},
						showGroups: function(){
							return scope.showOptions.groupForm;
						},
						groups: [
							function(){
								var formGroups = scope.groupByUniqueFormName(scope.patient.viewbag.patData.frm1.filterFast(scope.filterAllForm(false)))
								return Object.keys(formGroups).map(function(name){
									return {
										namei18n: name,
										getList:function(){
											return formGroups[name];
										}
									}
								})
							}
						]
					}),
					formCRDS:Object.assign(angular.copy(defaultCategory), {
						dataType: 'form',
						namei18n: "FORMS_CRDS",
						icon: 'fa-list-alt',
						hide: false,
						actionBtnsUrl: 'forms_crds_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateFormsCrds');
						},
						getCrdsFile: function(){
							scope.getCrdsFile()
						},
						getList: function(){
							return scope.patient.viewbag.patData.frm2.filterFast(scope.filterAllForm(false));
						},
					}),
					formCNESST:Object.assign(angular.copy(defaultCategory), {
						dataType: 'form',
						namei18n: "FORMS_CNESST",
						icon: 'fa-list-alt',
						hide: false,
						actionBtnsUrl: 'forms_cnesst_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateFormsCnesst');
						},
						getList: function(){
							return scope.patient.viewbag.patData.frm3.filterFast(scope.filterAllForm(false));
						},
					}),
					rappel:Object.assign(angular.copy(defaultCategory), {
						dataType: 'rap',
						namei18n: "RemindersNotClin",
						icon: 'fa-bell-o',
						hide: false,
						actionBtnsUrl: 'rappels_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateReminders');
						},
						getList: function(){
							return scope.patient.viewbag.patData.rem.filterFast(scope.filterAllRapHisto(false));
						},
					}),
					task:Object.assign(angular.copy(defaultCategory), {
						dataType: 'task',
						namei18n: "Tasks",
						icon: 'fa-check-circle',
						hide: false,
						actionBtnsUrl: 'tasks_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateTasks');
						},
						getList: function(){
							return scope.patient.viewbag.patData.task.filterFast(scope.filterAllTask(false));
						},
						showGroups: function(){
							return scope.showOptions.groupTask;
						},
						groups: [
							function(){
								var grouped = scope.groupByProgress(scope.patient.viewbag.patData.task.filterFast(scope.filterAllTask(false)))
								return Object.keys(grouped).map(function(name){
									return {
										namei18n: name,
										getList:function(){
											return grouped[name];
										}
									}
								})
							}
						]
					}),
					msg:Object.assign(angular.copy(defaultCategory), {
						dataType: 'courriel',
						namei18n: "Messages",
						icon: 'fa-envelope-o',
						hide: false,
						actionBtnsUrl: 'msg_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateMsgs');
						},
						getList: function(){
							return scope.patient.viewbag.patData.msg.filterFast(scope.filterAllMsg(false))
						},
					}),
					msgpat:Object.assign(angular.copy(defaultCategory), {
						dataType: 'courriel',
						namei18n: "MessagePatient",
						icon: 'fa-envelope-o',
						hide: false,
						actionBtnsUrl: 'msgpat_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updatePatientMsgs');
						},
						getList: function(){
							return scope.patient.viewbag.patData.msgpat.filterFast(scope.filterAllMsg(false))
						},
					}),
					srvy:Object.assign(angular.copy(defaultCategory), {
						dataType: 'survey',
						namei18n: "PatientSurvey",
						icon: 'fa-quora',
						hide: false,
						actionBtnsUrl: 'srvy_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updatePatientSurvey');
						},
						getList: function(){
							return scope.patient.viewbag.patData.srvy.filterFast(scope.filterAllSrvy(false))
						},
					}),
					app:Object.assign(angular.copy(defaultCategory), {
						dataType: 'app',
						namei18n: "Appointments",
						icon: 'fa-calendar',
						hide: false,
						actionBtnsUrl: 'app_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateApps');
						},
						// getList: function(){
						// 	return scope.patient.viewbag.patData.task.filterFast(scope.filterAllTask(false));
						// },
						showGroups: function(){
							return true;
						},
						groups: [
							{
								namei18n: 'TODAY',
								getList:function(){
									return scope.patient.viewbag.patData.app.filterFast(scope.filterTodayApp(false)).sort(scope.sortTodayApp);
								}
							},
							{
								namei18n: 'FUTUR_RV',
								getList:function(){
									return scope.patient.viewbag.patData.app.filterFast(scope.filterFuturApp(false)).sort(scope.sortFuturApp);
								}
							},
							{
								namei18n: 'PAST_RV',
								getList:function(){
									return scope.patient.viewbag.patData.app.filterFast(scope.filterPastApp(false)).sort(scope.sortPastApp);
								}
							},
						]
					}),
					ffApp:Object.assign(angular.copy(defaultCategory), {
						dataType: 'app',
						namei18n: "FF_Appointments",
						icon: 'fa-calendar',
						hide: false,
						actionBtnsUrl: 'ffApp_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateFFApps');
						},
						getList: function(){
							return scope.patient.viewbag.patData.ffApp.filterFast(scope.filterFuturApp(false)).sort(scope.sortFuturApp)
						},
					}),
					fax:Object.assign(angular.copy(defaultCategory), {
						dataType: 'fax',
						namei18n: "s_Fax",
						icon: 'fa-fax',
						actionBtnsUrl: 'fax_actionbtns_index.html',
						manualUpdate: function(){
							scope.manualUpdateData('updateFax');
						},
						getList: function(){
							return scope.patient.viewbag.patData.fax.filterFast(scope.filterAllFax(false))
						},
						showGroups: function(){
							return scope.showOptions.groupFax;
						},
						groups: [
							{
								namei18n: 'ERROR',
								getList:function(){
									return scope.patient.viewbag.patData.fax.filterFast( scope.filterFaxError(false));
								}
							},
							{
								namei18n: 'INPROGRESS',
								getList:function(){
									return scope.patient.viewbag.patData.fax.filterFast( scope.filterFaxInprogress(false));
								}
							},
							{
								namei18n: 'TO_RESOLVE',
								getList:function(){
									return scope.patient.viewbag.patData.fax.filterFast( scope.filterFaxSent(false));
								}
							},
						]
					}),
				};

				var linkModeShowSection = {
					'enc':{0:true,1:true},'rappel': {0:true}, 'task': {0:true}, 'msg': {0:true}, 'msgpat': {0:true}, 'srvy': {0:true}, 'app': {0:true}, 'ffApp': {0:true}
				}
				// 	0: ['enc','reminder', 'task', 'msg', 'appointment', 'futureAppointements'],
				// 	1: ['enc']
				// }
				function linkModeUpdate(){
					if (scope.quickViewData && scope.quickViewData.linkModeOn !== undefined) {
						var arrSections = Object.keys(linkModeShowSection);
						arrSections.forEach(function(e){
							scope.categories[e].hide = !(linkModeShowSection[e][scope.quickViewData.linkModeOn])
						});
						model.patientDataUpdated(true);
					}

				}

				scope.$watch(function (scope) {
					if (scope.quickViewData && scope.quickViewData.linkModeOn !== undefined) {
						return scope.quickViewData.linkModeOn;
					}
				}, linkModeUpdate);

				scope.$watch(function (scope) {
					if (scope.patient) {
						return scope.patient.id;
					} else if (model.patient()) {
						return model.patient().currPatient.id;
					}
				}, patientIdUpdated);

				scope.$watch(function (scope) {
					return scope.patient&&scope.patient.viewbag&&scope.patient.viewbag.patData?scope.patient.viewbag.patData.loaded.doneLoaded:0;
				}, function(nv, ov, scope) {
					if (scope.patient&&scope.patient.viewbag&&scope.patient.viewbag.patData && nv>=scope.patient.viewbag.patData.requestedLoad) {
						scope.resetLimits();
					}
				});

			}
		};
	}]);

	patient.directive('patientDataCategory',['model', '$timeout', '$log', function(model, $timeout, $log){
		return{
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/pat_data/patientData_category.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				scope.vb = {};
				var dateFrmt = 'YYYY-MM-DD';
				function callIfFn(fn){
					return isFunction(fn) ? fn(): fn;
				}
				function isFunction(fn){
					return fn instanceof Function;
				}
				scope.getName = function(name){
					name = arguments.length > 0 ? name: scope.category;
					if(name.namei18n){
						return callIfFn(name.namei18n);
					}
				}
				scope.showGroups = function(){
					if(scope.category && scope.category.showGroups !== undefined){
						return callIfFn(scope.category.showGroups);
					}
					return false;
				}

				scope.getActLable = function(label){
					return label ? label: "__"
				}

				scope.getSelectAction = function(act){
					var options = scope.getActOptions();
					if(options && options.onActSelect){
						return options.onActSelect;
					}
				}

				scope.allGroups = [];
				function getAllGroups(){
					var all = [];
					if(scope.category && scope.category.groups){
						scope.category.groups.forEach(function(group){
							if(isFunction(group)){
								var fnGroups = group();
								fnGroups.forEach(function(fnGroup){
									all.push(fnGroup)
								});
							}else{
								all.push(group);
							}
						})
					}
					scope.allGroups = all;
				}
				function filterOnDate(newDate) {
					try {
						return function(l) {
							if (l.date) {
								var d = l.date.slice(0,10);
								return d >= newDate;
							} else if (l.className==='CPatientRecall'){
								return (l.dateCreated && l.dateCreated>=newDate) || (l.dateRecall && l.dateRecall>=newDate);
							} else if (l.dateTimeStart) {
								return new moment(l.dateTimeStart).format(dateFrmt)>newDate;
							}
						};
					} catch (e) {
						$log.log(e);
					}
				}

				scope.$watch(function(){
					if(scope.showGroups()){
						return model.patientDataUpdated().val;
					}else{
						return -1;
					}
				},getAllGroups);

				var eventBeforeDate = undefined;
				var eventByDate = 0;
				scope.eventsMax = 999;
				scope.limitf = function(group) {
					if (angular.isDefined(scope.searchTextRegExp) || !angular.isDefined(scope.category.limit)) {
						return scope.eventsMax;
					} else if (group) {
						if (group.showAll===true) {
							return scope.eventsMax;
						} else {
							if (model.prefSettings().eventByDate===0) {
								eventByDate = 0;
								eventBeforeDate = undefined;
								return model.prefSettings().nbEvents;
							} else {
								updateEventBeforeDate();
								return group.getList().filterLength(filterOnDate(eventBeforeDate));
							}
						}
					} else{
						return scope.nbEventsToShow();
					}
				};

				function updateEventBeforeDate(){
					if (eventBeforeDate == undefined || eventByDate!=model.prefSettings().eventByDate) {
						eventByDate = model.prefSettings().eventByDate;
						eventBeforeDate = moment().subtract(eventByDate,'year').format(dateFrmt);
					}
				}

				scope.nbEventsToShow = function() {
					if (model.prefSettings().eventByDate===0) {
						eventByDate = 0;
						eventBeforeDate = undefined;
						return model.prefSettings().nbEvents;
					} else {
						updateEventBeforeDate();
						return scope.category.getList().filterLength(filterOnDate(eventBeforeDate));
					}
				};

				scope.getDataType = function(act, groups){
					return isFunction(scope.category.getActType) ? scope.category.getActType(act, groups): scope.category.dataType;
				}

				scope.getActOptions = function(){
					if(scope.category.actOptions){
						return callIfFn(scope.category.actOptions);
					}else if(scope.actOptions){
						return scope.actOptions;
					}
				}

				scope.showCategoryFooter = function(){
					return scope.notSearching() && scope.patient.viewbag.patData &&
						(scope.patient.viewbag.patData.loaded[scope.category.dataType]===0 ||
							scope.category.getList().length > scope.nbEventsToShow())
				}

				scope.toggleLimitView = function(){
					if(scope.patient.viewbag.patData.loaded[scope.category.dataType]===0 ){
						scope.category.manualUpdate && scope.category.manualUpdate();
						return;
					}
					if(scope.category.limit === undefined){
						if (model.prefSettings().eventByDate===0) {
							scope.category.limit = model.prefSettings().nbEvents;
							// $timeout(function() {
							// 	scope.vb.scrollToCategoryHeader && scope.vb.scrollToCategoryHeader()
							// }, 300);
						} else {
							scope.category.limit = scope.category.limitByDate;
							// $timeout(function() {
							// 	scope.vb.scrollToCategoryHeader && scope.vb.scrollToCategoryHeader()
							// }, 300);
						}
						model.actUpdated(true);
						return scope.category.limit;
						// il faut revenir au contrôle +
					}else {
						delete scope.category.limit;
						model.actUpdated(true);
					}
				};

				scope.$watch(attrs.category, function(){
					scope.category = scope.$eval(attrs.category);
				})
			}
		}
	}]);

	patient.directive('patientChrono', [ 'PatientAccessor','QuickView', 'PrefAccessor', 'model','$log',
		function(PatientAccessor, QuickView, PrefAccessor, model, $log){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/pat/patientChrono.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				scope.serv = {
					viewMode:{timeline:"t", qv:"qv"}
				};

				var dateFrmt = 'YYYY-MM-DD';
				scope.activityDurationPickerOptions = {
					//la date le plus recente que le picker peut fournir. moment() par defaut.
					pickerEndDate: moment().add(1,'day').startOf('day'),

					unit: moment.duration(3, 'months'),
					//miliseconds to call duration changed
					debounce: 500,
					group: {
						groupCount: 5,	// correspond  au nombre d'années affichées précédents le pickerEndDate
						roundTo: 'year',
						key: function(yearDateTime){
							return yearDateTime.year() + "";
						},
					},
					//Donne access à l'api de manipulation du picker.
					// avec l'api on peut setter la date desirer e.g:
					//activityDurationPickerApi.setDateRange(dateDebut, dateFin)
					onRegisterApi: function(api){
						//api du picker pour acceder à des fonctionnalités de manipulation du picker.
						scope.activityDurationPickerApi = api;

						//Pour setter la durée par défaut ou pour la changer plus tard.
						scope.activityDurationPickerApi.setDateRange(moment(scope.chronoStart, dateFrmt), moment(scope.chronoEnd, dateFrmt));
					},
					//Appellé lorsque la durée change avec les nouvelles valeurs.
					onDurationChanged : function(start, end){
						if (start && end) {
//								$log.log("onDurationChanged - Start: "+ start.format(dateFrmt) + ", End: "+ end.format(dateFrmt));
							scope.chronoStart = start.format(dateFrmt);
							scope.chronoEnd = end.format(dateFrmt);
							var durMois = end.diff(start, 'month');
							model.prefSettings('periodShown', durMois/12);
						}
					}
				};

//				scope.patient = {};
				var preChronoVals='_';
				var allFilteredData = [];

				scope.periodeToShow = function(val){
					if (model.prefSettings().periodShown!=val) {
						model.prefSettings('periodShown', val);
					}
					model.prefSettings().periodShown = val;
					var start;
					var end;
					var newStart;
					if (scope.activityDurationPickerApi && scope.activityDurationPickerApi.currentDuration) {
						var currDur = scope.activityDurationPickerApi.currentDuration;
						start = moment(currDur.start);
						end = moment(currDur.end);
						newStart = end.subtract(model.prefSettings().periodShown,'year');
						scope.activityDurationPickerApi.setDateRange(newStart, currDur.end);
						scope.chronoStart = newStart.format(dateFrmt);
					} else {
						newStart = moment().subtract(model.prefSettings().periodShown,'year');
						end = moment().add(1,'day');
						newStart = moment(end).subtract(model.prefSettings().periodShown,'year');
						scope.chronoStart = newStart.format(dateFrmt);
						scope.chronoEnd = end.format(dateFrmt);
					}
				};

				scope.filteredData = function() {
					if (preChronoVals===(scope.patient.id+""+scope.chronoStart + scope.chronoEnd)) {
						return allFilteredData;
					}
					preChronoVals=scope.patient.id+""+scope.chronoStart + scope.chronoEnd;
					allFilteredData = scope.allData.filterFast(filterAllData);
					return allFilteredData;
				};

				function filterAllData(a) {
					var d;
					try {
						if (a.date) {
							d = a.date.slice(0,10);
						} else if (a.className==='CPatientRecall'){
							if (a.dateRecall) {
								d = a.dateRecall.slice(0,10);
							} else if (a.dateCreated) {
								d = a.dateCreated.slice(0,10);
							}
						} else if (a.dateTimeStart) {
							d = new moment(a.dateTimeStart).format("YYYY-MM-DD HH:mm");
						}
						if (d) {
							return scope.chronoStart <= d && d <= scope.chronoEnd;
						}
					} catch (e) {
						$log.log(a);
					}
				}

				scope.updateactivites = function(){
					preChronoVals='_';
					scope.activityHeaderData = {start:((scope.byYear - 1)*12), end:scope.byYear * 12};
				};

				scope.activitiesOptions = {
						trigger: 'click',
						closeOnMouseleave: true,
						templateUrl: 'activities_settings_index.html',
						position: {
							x: 'right',
							y: 'center'
						},
						outside: 'x',
						onClose: function(){
							// console.log("Test settings");
						}
				};

				scope.resetactivities = function(){
//					scope.patient = model.patient().currPatient;
					scope.allData = [];
					setActOptions()
					//scope.patient.viewbag.patData.loaded.doneLoaded = 0;
					if(scope.actOptions.mode === scope.serv.viewMode.timeline){
						scope.byYear = 1;
					}
				};

				function setActOptions(){
					scope.actOptions = scope.$eval(attrs.options);
					// ressActOptions
				}

				function transformArr(orig) {
				    var newArr = [], days = {}, newItem, i, j, cur, day;
				    for (i = 0, j = orig.length; i < j; i++) {
				        cur = orig[i];
				        day = moment(cur.activityDate).format("YYYY-MM-DD");
				        if (!(day in days)) {
				        	days[day] = {day: day, activities: []};
				            newArr.push(days[day]);
				        }
				        days[day].activities.push(cur);
				    }
				    return newArr;
				}

				function iaDataUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("enc loaded... " + scope.patient.viewbag.patData.enc.length);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function encUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("enc loaded... " + scope.patient.viewbag.patData.enc.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.enc.filterFast(function(a){return a.encounterType>9;}));
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function encPreSaveUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("enc loaded... " + scope.patient.viewbag.patData.enc.length);
//						$.merge(scope.allData, scope.patient.viewbag.patData.enc.filterFast(function(a){return a.encounterType>9;}));
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function labUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("lab loaded... " + scope.patient.viewbag.patData.lab.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.lab);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function docUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("doc loaded... " + scope.patient.viewbag.patData.doc.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.doc);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function formUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("form loaded... " + scope.patient.viewbag.patData.form.length);
						var showDeleted = model.prefSettings('showDeletedForm')===true ? true: false;
						var formList = scope.patient.viewbag.patData.form;
						if (showDeleted===false) {
							formList = formList.filterFast(function(a){return a.deleted===false;});
						}
						$.merge(scope.allData, formList);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function remUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("rem loaded... " + scope.patient.viewbag.patData.rem.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.rem);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function ressUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("task loaded... " + scope.patient.viewbag.patData.task.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.ress);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function taskUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("task loaded... " + scope.patient.viewbag.patData.task.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.task);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function msgUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("msg loaded..." + scope.patient.viewbag.patData.msg.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.msg);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function msgpatUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("msg loaded..." + scope.patient.viewbag.patData.msgpat.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.msgpat);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function srvyUpdated(nv, ov, scope) {
					if (nv===1) {
//						$log.log("msg loaded..." + scope.patient.viewbag.patData.srvy.length);
						$.merge(scope.allData, scope.patient.viewbag.patData.srvy);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function appUpdated(nv, ov, scope) {
					if (nv===1) {
						$.merge(scope.allData, scope.patient.viewbag.patData.app);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
						scope.patient.viewbag.patData.loaded.doneLoaded++;	// pour tenir compte de ffApp qu'on n'a pas besoin ici.
					}
				}
				function faxUpdated(nv, ov, scope) {
					if (nv===1) {
						$.merge(scope.allData, scope.patient.viewbag.patData.fax);
						scope.patient.viewbag.patData.loaded.doneLoaded++;
					}
				}
				function allDataUpdated(nv, ov, scope) {
					if (scope.patient.viewbag && nv>=scope.patient.viewbag.patData.requestedLoad) {
						scope.periodeToShow(model.prefSettings().periodShown);

						scope.allData.sort(function (a, b) {
							var d1 = '9999-99-99';	// pour tri adéquat si compare with datetime. Et si deja dt = pas grave.
							var d2 = '9999-99-99';
							if (a.date) {
								d1 = a.date.length===10 ? a.date + ' 00:00':a.date;
							} else if (a.className==='CPatientRecall'){
								if (a.dateRecall) {
									d1 = a.dateRecall.length===10 ? a.dateRecall + ' 00:00':a.dateRecall;
								} else if (a.dateCreated) {
									d1 = a.dateCreated.length===10 ? a.dateCreated + ' 00:00':a.dateCreated;
								}
							} else if (a.dateTimeStart) {
								d1 = new moment(a.dateTimeStart).format("YYYY-MM-DD HH:mm");
							}
							if (b.date) {
								d2 = b.date.length===10 ? b.date + ' 00:00':b.date;
							} else if (b.className==='CPatientRecall'){
								if (b.dateRecall) {
									d2 = b.dateRecall.length===10 ? b.dateRecall + ' 00:00':b.dateRecall;
								} else if (b.dateCreated) {
									d2 = b.dateCreated.length===10 ? b.dateCreated + ' 00:00':b.dateCreated;
								}
							} else if (b.dateTimeStart) {
								d2 = new moment(b.dateTimeStart).format("YYYY-MM-DD HH:mm");
							}

						    if (d1 > d2) {
						        return -1;
						    }
						    if (d2 > d1) {
						        return 1;
						    }
						    return a.id>b.id ? -1 : 1;	// inverse du l'id si date ==
						});
//						for(var i=0;i<scope.allData.length;i++){
//							$log.log(scope.allData[i].date);
//						}
//						$log.log("allDataUpdated sorted... " + scope.allData.length);
						scope.updateactivites();
//						$log.log('watchersCount = ' +scope.$$watchersCount);
						model.patientDataUpdated(true);
						model.patientChronoUpdated(true);
						model.patientSumUpdated(true);
					}
				}

				scope.$watch(attrs.patId, scope.resetactivities);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.iaData:0;}, iaDataUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.enc:0;}, encUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.presaveenc:0;}, encPreSaveUpdated); // non ajouté car fait doublons et non pertinent ds chrono
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.lab:0;}, labUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.doc:0;}, docUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.form:0;}, formUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.rem:0;}, remUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.ress:0;}, ressUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.task:0;}, taskUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.msg:0;}, msgUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.msgpat:0;}, msgpatUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.srvy:0;}, srvyUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.app:0;}, appUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.fax:0;}, faxUpdated);
				scope.$watch(function (scope) {return scope.patient.viewbag?scope.patient.viewbag.patData.loaded.doneLoaded:0;}, allDataUpdated);
			}
		};
	}]);

	patient.directive('dsqSommhosp', ['$timeout', 'Notification','DashWebSocket', 'DashAPI', 'model','PatientUtils','$filter','PatientAccessor', 'DocAccessor',
		function($timeout, Notification, DashWebSocket, DashAPI, model, PatientUtils, $filter, PatientAccessor, DocAccessor){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){

				function getPatientData() {
					var patData = scope.patient.viewbag.patData;
					return patData;
				}

				scope.closeView = function(){
					$timeout(function() {
						angular.element('#search-dsq-sommhosp').triggerHandler('click');
					});
				};

				scope.getListCount = function(){
					return scope.getList().length;
				};

				scope.getList = function() {
					var patData = getPatientData();
					if (patData.dsqSommhospList == undefined) {
						patData.dsqSommhospList = [];
					}
					return patData.dsqSommhospList;
				};

				function setList(newlist){
					var pd = getPatientData();
					pd.dsqSommhospList = newlist;
					computeItemsTooltip(newlist);
					DocAccessor.utils.updateAllDocs(pd);
				};

				function computeItemsTooltip(list) {
					if (list != undefined) {
						for(var i = 0; i < list.length; i++){
							var d = list[i];
							d.tooltip = computeItemTooltip(d);
						}
					}
				}

				function computeItemTooltip(item) {
					var s = "";
					s += $filter('translate')('dataFromDSQ');
					s += "\n";
					s += $filter('translate')('DSQResultsobtainedOn', {received : item.timeOfDsqRequest });
					return s;
				}

				scope.getLoaded = function() {
					var patData = getPatientData();
					if (patData.loaded.dsqSommhosp == undefined) {
						patData.loaded.dsqSommhosp = 0;
					}
					return patData.loaded.dsqSommhosp;
				};

				function setLoaded(v, pd) {
					pd.loaded.dsqSommhosp = v;
				}

				scope.getStatus = function() {
					var patData = getPatientData();
					if (patData.dsqSommhospStatus == undefined) {
						patData.dsqSommhospStatus = DashAPI.newSimpleStatus();
					}
					return patData.dsqSommhospStatus;
				};

				function setStatus(v, pd) {
					pd.dsqSommhospStatus = v;
				}

				scope.getSearchCriteria = function() {
					var patData = getPatientData();
					if (patData.dsqSommhospSearchCriteria == undefined) {
						patData.dsqSommhospSearchCriteria = {
							start: moment().subtract(2, 'years').format("YYYY-MM-DD"),
							end: moment().format("YYYY-MM-DD"),
							timeOfDsqRequest: undefined
						};
					}
					return patData.dsqSommhospSearchCriteria;
				};

				scope.search = function(){
					scope.getSearchCriteria().timeOfDsqRequest = undefined;
					var pd = getPatientData();
					var searchCriteria = Object.assign({}, scope.getSearchCriteria());
					searchCriteria.patientId = scope.patient.id;
					searchCriteria.mostRecentByTypeIndicator = true; //always true

					setLoaded(2, pd);
					setStatus(undefined, pd);
					setList([], pd);

					DashWebSocket.sendRequest("/dashboard/dsq/ws/sommhosp/search", searchCriteria);
					// scope.closeView();
					model.actUpdated(true);
				};

				var dsqSommhospSearchHandlerId = Notification.registerHandler('dsqSommhospSearch', function(msg){
					var status = DashAPI.getSimpleStatus(msg.data.status);
					var pat = scope.patient;
					var pd = pat.viewbag.patData;
					if(msg && msg.data && msg.data.obj && pat.id == msg.data.obj.idPatient){
						setStatus(status, pd);
						if (status.severity=='OK' || status.severity=='WARNING') {
							var searchCriteria = scope.getSearchCriteria();
							searchCriteria.start = msg.data.obj.start;
							searchCriteria.end = msg.data.obj.end;
							if (msg.data.obj.timeOfDsqRequest === undefined) {
								searchCriteria.timeOfDsqRequest = undefined;
							} else {
								searchCriteria.timeOfDsqRequest = $filter('translate')('DSQResultsobtainedOn', {received : msg.data.obj.timeOfDsqRequest });
							}

							setList(OfysUtils.addViewbag(msg.data.obj.list, function(elem, viewbag){
								elem.date = elem.departureDate;
								return viewbag;
							}), pd);
							setLoaded(1, pd);
						} else {
							setLoaded(0, pd);
							//fail
						}
						model.actUpdated(true);
					}
				}, scope);

				var dsqSearchConsentHandlerId = Notification.registerHandler('dsqDocSearchConsent', function(msg){
					var status = DashAPI.handleReturnObject(msg.data.status);
				}, scope);
			}
		};
	}]);

	patient.directive('dsqdoc', ['$timeout', 'Notification','DashWebSocket', 'DashAPI', 'model','PatientUtils','$filter','PatientAccessor', 'DocAccessor',
		function($timeout, Notification, DashWebSocket, DashAPI, model, PatientUtils, $filter, PatientAccessor, DocAccessor){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){

				scope.closeView = function(){
					$timeout(function() {
						angular.element('#search-dsq-doc').triggerHandler('click');
					});
				}

				function getPatientData() {
					var patData = scope.patient.viewbag.patData;
					return patData;
				}

				scope.getListCount = function(){				
					return scope.getList().length;
				};

				scope.getList = function() {
					var patData = getPatientData();
					if (patData.docdsq === undefined) {
						patData.docdsq = [];
					}
					return patData.docdsq;
				};

				function setList(newlist, pd){
					pd.docdsq = newlist;
					computeItemsTooltip(newlist);
					DocAccessor.utils.updateAllDocs(pd);
				};

				function computeItemsTooltip(list) {
					if (list != undefined) {
						for(var i = 0; i < list.length; i++){
							var d = list[i];
							d.tooltip = computeItemTooltip(d);
						}
					}
				}

				function computeItemTooltip(item) {
					var tooltip = "";
					tooltip += $filter('translate')('dataFromDSQ');
					tooltip += "\n";
					tooltip += $filter('translate')('DSQResultsobtainedOn', {received : item.timeOfDsqRequest });
					return tooltip;
				}

				scope.getLoaded = function() {
					var patData = getPatientData();
					if (patData.loaded.dsqdoc === undefined) {
						patData.loaded.dsqdoc = 0;
					}
					return patData.loaded.dsqdoc;
				};

				function setLoaded(v, pd) {
					pd.loaded.dsqdoc = v;
				}

				scope.getSearchCriteria = function() {
					var patData = getPatientData();
					if (patData.dsqdocSearchCriteria === undefined) {
						patData.dsqdocSearchCriteria = {
							start: moment().subtract(2, 'years').format("YYYY-MM-DD"),
							end: moment().format("YYYY-MM-DD"),
							timeOfDsqRequest: undefined
						};
					}
					return patData.dsqdocSearchCriteria;
				};

				scope.hasStatusMessages = function() {					
					var status = scope.getStatus();
					return status !== undefined && (status.warnings.length > 0 || status.errors.length > 0 || status.infos.length > 0);
				}
				
				scope.getStatus = function() {
					var patData = getPatientData();
					if (patData.dsqdocStatus === undefined) {
						patData.dsqdocStatus = DashAPI.newSimpleStatus();
					}
					return patData.dsqdocStatus;
				};

				function setStatus(v, pd) {
					pd.dsqdocStatus = v;
				}

				Notification.registerHandler('dsqDocSearch', function(msg){
					var status = DashAPI.getSimpleStatus(msg.data.status);
					var pat = scope.patient;
					var pd = pat.viewbag.patData;
					if(msg && msg.data && msg.data.obj && pat.id == msg.data.obj.idPatient){
						setStatus(status, pd);
						if (status.severity=='OK' || status.severity=='WARNING') {
							var searchCriteria = scope.getSearchCriteria();
							searchCriteria.start = msg.data.obj.start;
							searchCriteria.end = msg.data.obj.end;
							if (msg.data.obj.timeOfDsqRequest === undefined) {
								searchCriteria.timeOfDsqRequest = undefined;
							} else {
								searchCriteria.timeOfDsqRequest = $filter('translate')('DSQResultsobtainedOn', {received : msg.data.obj.timeOfDsqRequest });
							}
	
							setList(OfysUtils.addViewbag(msg.data.obj.list, function(elem, viewbag){
								viewbag.status = {};
								viewbag.effectiveTime = $filter('date')(elem.res.effectiveTime, 'yyyy-MM-dd HH:mm');
								if (elem.res.prescriber) {
									viewbag.prescriber = elem.res.prescriber.firstName + ' ' + elem.res.prescriber.lastName;									
								}	else {
									viewbag.prescriber = $filter('translate')('NotIdentified');
								}
								viewbag.status[elem.res.status.code] = true;
								
								viewbag.modalityString = OfysUtils.joinArray(elem.res.modality, ", ", function(e) {
									return e.code;
								});
								
								//should be sorted by date desc
								elem.res.report.reverse();
								if (elem.res.report !== undefined && elem.res.report.length > 0) {
									viewbag.mostRecentStatus = elem.res.report[0].code.code;
								} else {
									viewbag.mostRecentStatus = undefined;
								}
	
								elem.date = $filter('date')(elem.res.effectiveTime, 'yyyy-MM-dd HH:mm');
								return viewbag;
							}), pd);
							setLoaded(1, pd);
						} else {
							setLoaded(0, pd);
							//fail
						}
						model.actUpdated(true);
					}
				}, scope)

				Notification.registerHandler(
					'dsqDocSearchConsent', 
					function(msg) {
						DashAPI.handleReturnObject(msg.data.status);
					}, 
					scope
				)

				// function updateDoc(dsqList){
				// 	if(dsqList){
				// 		// PatientUtils.clearPreviousDsqList(scope.patient.viewbag.patData, 'doc');
				// 		var pd = scope.patient.viewbag.patData;
				// 		pd.docdsq = dsqList;
				// 		pd.doc = pd.doc.concat(dsqList).sort(PatientAccessor.sortOnDate);
				// 		model.actUpdated(true);
				// 	}
				// 	var showList = scope.patient.viewbag.patData.doc.filterFast(scope.filterAllDoc(false));
				// }


				// scope.getDsqDocCount = function(){
				// 	var count = 0;
				// 	if(scope.patient.viewbag.patData.docdsq){
				// 		count = scope.patient.viewbag.patData.docdsq.length;
				// 	}
				// 	return count;
				// }

				scope.printSearchResult = function(){
					var criteria = {
						patientId: scope.patient.id,
						patientName: model.getPatIdTitle2(scope.patient),
						printColumns: [
							'Status',
							'Code',
							'Description',
							'Date/heure',
							'ODS',
							'Prescripteur',
							'Modalités',
							'Statut du rapport le plus récent',
						],
					};
					criteria.printTable = getListForPrint(scope.patient.viewbag.patData.docdsq);
					DashWebSocket.sendRequest("/dashboard/dsq/ws/doc/printSearch", criteria);
					scope.closeView();
				};

				function getListForPrint(list){
					var t = [];
					for(var i = 0; i < list.length; i++){
						var it = [
							getStatusForPrint(list[i]),
							list[i].res.code.code ,
							list[i].res.code.text ,
							list[i].viewbag.effectiveTime ,
							list[i].res.performerODS.name ,
							list[i].viewbag.prescriber ,
							list[i].viewbag.modalityString ,
							$filter('translate')('dsqImageReport' + list[i].viewbag.mostRecentStatus)
						];
						t.push(it);
					}
					return t;
				}

				function getStatusForPrint(i){
					if('completed' === i.res.status.code){
						return 'C';
					}else{
						return '';
					}
				}

				scope.search = function(){
					scope.getSearchCriteria().timeOfDsqRequest = undefined;
					var pd = getPatientData();
					var searchCriteria = Object.assign({}, scope.getSearchCriteria());
					searchCriteria.patientId = scope.patient.id;

					setLoaded(2, pd);
					setStatus(undefined, pd);
					setList([], pd);

					DashWebSocket.sendRequest("/dashboard/dsq/ws/doc/search", searchCriteria);
					// scope.closeView();
					model.actUpdated(true);
				};

			}
		};
	}]);

	patient.directive('dsqlab', ['$timeout', '$filter', 'Notification','DashWebSocket', 'DashAPI', 'model','PatientUtils','PatientAccessor', 'LabAccessor',
		function($timeout, $filter, Notification, DashWebSocket, DashAPI, model, PatientUtils, PatientAccessor, LabAccessor){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){

				scope.closeView = function(){
					$timeout(function() {
						angular.element('#search-dsq-lab').triggerHandler('click');
					});
				};

				function getPatientData() {
					var patData = scope.patient.viewbag.patData;
					return patData;
				}

				scope.getListCount = function(){
					return scope.getList().length;
				};

				scope.getList = function() {
					var patData = getPatientData();
					if (patData.labdsq === undefined) {
						patData.labdsq = [];
					}
					return patData.labdsq;
				};

				function setList(newlist, pd){
					pd.labdsq = newlist;
					computeItemsTooltip(newlist);
					LabAccessor.utils.updateAllLabs(pd);
				};

				function computeItemsTooltip(list) {
					if (list != undefined) {
						for(var i = 0; i < list.length; i++){
							var d = list[i];
							d.tooltip = computeItemTooltip(d);
						}
					}
				}

				function computeItemTooltip(item) {
					var tooltip = "";
					tooltip += $filter('translate')('dataFromDSQ');
					tooltip += "\n";
					tooltip += $filter('translate')('DSQResultsobtainedOn', {received : item.timeOfDsqRequest });
					return tooltip;
				}

				scope.getLoaded = function() {
					var patData = getPatientData();
					if (patData.loaded.dsqlab === undefined) {
						patData.loaded.dsqlab = 0;
					}
					return patData.loaded.dsqlab;
				};

				function setLoaded(v,pd) {
					pd.loaded.dsqlab = v;
				}

				scope.getSearchCriteria = function() {
					var patData = getPatientData();
					if (patData.dsqlabSearchCriteria === undefined) {
						patData.dsqlabSearchCriteria = {
							start: moment().subtract(2, 'years').format("YYYY-MM-DD"),
							end: moment().format("YYYY-MM-DD"),
							timeOfDsqRequest: undefined
						};
					}
					return patData.dsqlabSearchCriteria;
				};

				scope.hasStatusMessages = function() {
					var status = scope.getStatus();
					return status !== undefined && (status.warnings.length > 0 || status.errors.length > 0 || status.infos.length > 0);
				}

				scope.getStatus = function() {
					var patData = getPatientData();
					if (patData.dsqlabStatus === undefined) {
						patData.dsqlabStatus = DashAPI.newSimpleStatus();
					}
					return patData.dsqlabStatus;
				};

				function setStatus(v, pd) {
					pd.dsqlabStatus = v;
				}

				function getKeywordsString(orig){
					var k = orig.replaceAll('[', '').split(']');
					var keys = [];
					k.forEach(function(s){
						keys.push(s.trim().toLowerCase());
					});
					return keys.join('; ');
				}

				function getStatus(e){
					if (e.laboReportHeader.reportType && "SURGP" === e.laboReportHeader.reportType.code) {
						//pathology report - always s/o
						return "s/o";
					}
					if ("completed" === e.laboResultStatus.code) {
						return "Final";
					} else if ("active" === e.laboResultStatus.code) {
						return "Partiel";
					} else {
						return "s/o";
					}
				}
				
				function getAuthorsName(e){
					return e.laboRequest.author.firstName + ', '+e.laboRequest.author.lastName;
				}

				var dsqSearchHandlerId = Notification.registerHandler('dsqLabSearch', function(msg){
					var status = DashAPI.getSimpleStatus(msg.data.status);
					var pat = scope.patient;
					var pd = pat.viewbag.patData;
					if(msg && msg.data && msg.data.obj && pat.id == msg.data.obj.idPatient){
						setStatus(status, pd);
						if (status.severity=='OK' || status.severity=='WARNING') {
							var searchCriteria = scope.getSearchCriteria();
							searchCriteria.start = msg.data.obj.start;
							searchCriteria.end = msg.data.obj.end;
							if (msg.data.obj.timeOfDsqRequest === undefined) {
								searchCriteria.timeOfDsqRequest = undefined;
							} else {
								searchCriteria.timeOfDsqRequest = $filter('translate')('DSQResultsobtainedOn', {received : msg.data.obj.timeOfDsqRequest });
							}

							setList(OfysUtils.addViewbag(msg.data.obj.list, function(elem, viewbag){
								elem.date = moment(elem.res.laboReportHeader.specimenCollectionStartDatetime).format('YYYY-MM-DD HH:mm');
								viewbag.status = getStatus(elem.res);
								viewbag.authorsName = getAuthorsName(elem.res);
								viewbag.keywords = getKeywordsString(elem.res.laboReportHeader.title);
								return viewbag;
							}),pd);
							setLoaded(1,pd);
						} else {
							setLoaded(0,pd); //fail
						}
						model.actUpdated(true);
					}
				}, scope);

				scope.search = function(){
					scope.getSearchCriteria().timeOfDsqRequest = undefined;
					var pd = getPatientData();
					var searchCriteria = Object.assign({}, scope.getSearchCriteria());
					searchCriteria.patientId = scope.patient.id;

					setLoaded(2, pd);
					setStatus(undefined, pd);
					setList([], pd);

					DashWebSocket.sendRequest("/dashboard/dsq/ws/lab/search", searchCriteria);
					model.actUpdated(true);
				};

			}
		};
	}]);

	patient.directive('patientDsq', [ 'PatientAccessor','QConfirm','QuickView', 'EncounterSummaryCommon', 'EncounterAccessor', 'PrefAccessor', 'model','LinkMode','$log','Notification','DashWebSocket','PatientUtils', '$filter',
		 function(PatientAccessor, QConfirm, QuickView, EncounterSummaryCommon, EncounterAccessor, PrefAccessor, model, LinkMode, $log, Notification, DashWebSocket, PatientUtils, $filter){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/pat/patientDSQ.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				var patient = scope.patient;
				var ieFormLoadDocWritten = false;

				var dsqComm = {
					sendGetHtml: function(){
						var cdsqRequest = {patientId : patient.id};
						DashWebSocket.sendRequest("/dashboard/dsq/ws/html", cdsqRequest);
					},
					getHtml : function(res){
						if(!scope.formWindow){
							scope.formWindow = $('#patientDsqiframe')[0].contentWindow;
						}
						scope.form = {html: res.html};
						if(!ieFormLoadDocWritten){
							ieFormLoadFix(scope.formWindow);
						}
					},
					dsqRequest: function(res, params){
						var cdsqRequest = $.extend({patientId : patient.id, method: res}, params);
						DashWebSocket.sendRequest("/dashboard/dsq/ws/request", cdsqRequest);
					}
				};

				var dsqSqimCacheResponseHandlerId = Notification.registerHandler('dsqSqimCacheResponse', function(msg){
					if(msg.data.status.severity === "OK"){
						//Patients dsq
						var date = msg.data.obj;
						var k =  Object.keys(date);
						for(var i = 0; i < k.length; i++){
							date[k[i]] = $filter('translate')('DSQResultsobtainedOn', {received: date[k[i]]});
						}
						scope.formWindow.setDate(date);
					}else{
						//Make normal automatic call since the patients data is not already included in the cache
						scope.formWindow.getConsent();
					}
				}, scope);

				var dsqResponseHandlerId = Notification.registerHandler('dsqResponseUpdate', function(wsTarget){
					var msg = wsTarget.data;
					if (msg.response && msg.response.response && msg.response.response.qrr) {
						var qrr = msg.response.response.qrr;
//						List<IPrescriptionSummary> lstDm;
//						List<OtherMedicationSummary> lstDmOtherRx;
//						List<PrescriptionDrugSummary> lstOeRx;
//						List<PrescriptionDeviceSummary> lstOeDev;
//						List<DispenseSummary> lstDisp;
						if (qrr.lstDm && qrr.lstDm.length>0) {
							scope.patient.viewbag.patData.dsqDmList = qrr.lstDm;
						}
						if (qrr.lstDmOtherRx && qrr.lstDmOtherRx.length>0) {
							scope.patient.viewbag.patData.dsqDmOtherRxList = qrr.lstDmOtherRx;
						}
						if (qrr.lstOeRx && qrr.lstOeRx.length>0) {
							scope.patient.viewbag.patData.dsqOeRxList = qrr.lstOeRx;
						}
						if (qrr.lstOeDev && qrr.lstOeDev.length>0) {
							scope.patient.viewbag.patData.dsqOeDevList = qrr.lstOeDev;
						}
						if (qrr.lstDisp && qrr.lstDisp.length>0) {
							scope.patient.viewbag.patData.dsqDispList = qrr.lstDisp;
						}
					}
					if(dsqComm[msg.method] ){
						dsqComm[msg.method](msg.response);
					}else if(scope.formWindow[msg.method]){
						scope.formWindow[msg.method](JSON.stringify(msg.response));
					}
				}, scope);
				
				scope.setupIframe = function(elem){
					scope.formWindow = elem[0].contentWindow;
					if(scope.qv){
						var b = scope.formWindow.document.getElementsByTagName("body");
						b[0].style.zoom = "0.85";
					}
					if(ieFormLoadDocWritten){
						// console.log("iframe ready for setup");
						setFormApi(scope.formWindow);
						scope.adjustIFrame(elem);
						var cdsqRequest = {patientId: patient.id};
						DashWebSocket.sendRequest("/dashboard/dsq/ws/sqim/search", cdsqRequest);
						// scope.formWindow.getConsent();
					}
				};
				dsqComm.sendGetHtml();
				
				var reloadAfter = 1;
				var ieFormLoadFixLoadCount = 0;
				function ieFormLoadFix(iframe, crdsDirect){
					if(scope.form && !ieFormLoadDocWritten){
						ieFormLoadDocWritten = true;
						//Internet explorer hack since srcdoc in iframe does not work
						//Inject html. this method 'setFormHtml' is created in form_proxy.html
						//when eform is loaded the frame containing this function is loaded, calling this method rewrites the frame content.
						var iframedoc = iframe.document;
						iframedoc.open();
				        iframedoc.write(scope.form.html);
						iframedoc.close();

						ieFormLoadFixLoadCount = 0;
						reloadAfter = 1;
					}else if(ieFormLoadFixLoadCount < 10 && !ieFormLoadDocWritten){
						ieFormLoadFixLoadCount += 1;
						if(ieFormLoadFixLoadCount > 5) {
							reloadAfter = ieFormLoadFixLoadCount * 10;
						}
						$timeout(function(){
							ieFormLoadFix(iframe, crdsDirect);
						}, reloadAfter);
					}else if(ieFormLoadFixLoadCount >= 10){
						model.notice().fail($filter('translate')('FailedIELoadingForm'));
					}
				}

				scope.adjustIFrame = function(elem){
					//Resize the iframe to fit parent remaining space
					var parentSection = $(elem[0]).parents("section")[0];
					var headerHeight = $(parentSection).find(".header").outerHeight();
					if(headerHeight === undefined){
						headerHeight = 0;
					}
					var height = $(parentSection).outerHeight() - headerHeight;
					elem[0].style.height = 0;
					var heightDemoAdjustment = model.prefSettings('user_settings_ShowMoreDemoData')===true ? 0 : 72;
					heightDemoAdjustment += model.prefSettings('user_settings_AlwaysShowOtherProv')===true ? 0 : 24;
					var heightAdj = (model.isMobile()?100:110) - heightDemoAdjustment;

					elem[0].style.height = (height-heightAdj) + "px";
				};

				function setFormApi(wx){
					wx.setDate = function(date){
						//find element and set date
						date.dispenses && $(wx.document).find('.table-list-info-dispenses')[0].prepend(date.dispenses);
						date.listMedicationsDM && $(wx.document).find('.table-list-info-listMedicationsDM')[0].prepend(date.listMedicationsDM);
						date.listPrescriptionsOE && $(wx.document).find('.table-list-info-listPrescriptionsOE')[0].prepend(date.listPrescriptionsOE);
					};

					wx.importFinalDispense = function(){
						// console.log("importFinalDispense not yet implemented::::::::::::::");
						model.notice().warn("Fonctionnalité à venir...");
						return false;
						//Importation requires a prescription controller in the backen that has to be created.
						// dsqComm.dsqRequest("importFinalDispense", {dispenseId: dispenseId});
					};
					
					function isInReprescribeMode() {
						if (scope.quickViewData && scope.quickViewData.linkModeOn != undefined) {
							mode = scope.quickViewData.linkModeOn;
							if (!(mode === LinkMode.REPRESCRIBEMODE || mode === LinkMode.DEVICEREPRESCRBE)){							
								model.notice().warn("Veuillez activer le mode de represcription avant de lancer l'importation!");
								return false;
							} else {
								return true;
							}
						}
						return false
					}
					
					function saveSummaryImportDsq(pat, sumImp) {
						var sum = pat.viewbag.patData.sum;
						return EncounterAccessor.saveSummaryImportDsq(sumImp, function(res){
							for (let rx of res.lstPrescription) {
								sum.lstPrescription.unshift(rx);
								sum.lstAllPrescription.unshift(rx);								
							}
							for (let rx of res.lstDevice) {
								sum.lstDevice.unshift(rx);
							}
							model.notice().success($filter('translate')('successfulImport'));
							model.patientSumUpdated(true);
						}, function(res){
							model.notice().fail(res.status + ' : ' + $filter('translate')('failedSave'));
						});
					}
					
					wx.importDm = function(){
						var ids = [];
						$(wx.document).find('.chk-dm').each(function(i, obj) {
							if (obj.checked===true) {
								var id = obj.id.split('~')[1];
								ids.push(id);
							}
						});
						if (ids.length==0) {
							model.notice().warn($filter('translate')('SELECT_RX_TO_IMPORT'));
						} else {
							if (isInReprescribeMode() && scope.quickViewData.linkModeOn === LinkMode.REPRESCRIBEMODE) {
								if (scope.quickViewData && scope.quickViewData.represcribe){
									var rxToImport = EncounterSummaryCommon.represcribe(scope.getPatient().viewbag.patData, ids, 'dm');
									for (let prescription of rxToImport) {
										scope.quickViewData.represcribe(prescription);									
									}
								}
							} else if (scope.quickViewData==undefined) { // si on est en quickview et pas en mode de represcription, je ne le permets pas.
								var pt = scope.getPatient();
								if (pt.viewbag && pt.viewbag.patData) {
									var sum = {
											idProfAnchor:model.user().profil.id,
											idPatientAnchor:pt.id,
											lstPrescription:[],
											lstDevice:[]					
									};
									EncounterSummaryCommon.represcribe(pt.viewbag.patData, ids, 'dm', sum);
									var rxName = [];
									for (let rx of sum.lstPrescription) {
										rxName.push(rx.name);
									}
									for (let rx of sum.lstDevice) {
										rxName.push(rx.name);
									}
									var txtInput =  {rx: rxName.join(', '), nb:rxName.length};
									var qconfirmOptions = {title: $filter('translate')('CONFIRM_RX_TO_IMPORT', txtInput)};
									QConfirm.open(qconfirmOptions).then(proceedWithImport);
									function proceedWithImport(proceed){
										if(proceed){
											saveSummaryImportDsq(pt, sum);
										}
									}
								}
							}
						}
						return false;
					}
					wx.importOe = function(){
						var ids = [];
						if (isInReprescribeMode()) {
							if (scope.quickViewData.linkModeOn === LinkMode.REPRESCRIBEMODE) {
								$(wx.document).find('.chk-oe-rx').each(function(i, obj) {
									if (obj.checked===true) {
										var id = obj.id.split('~')[1];
										ids.push(id);
									} 
								});
							} else if (scope.quickViewData.linkModeOn === LinkMode.DEVICEREPRESCRBE) {
								$(wx.document).find('.chk-oe-dev').each(function(i, obj) {
									if (obj.checked===true) {
										var id = obj.id.split('~')[1];
										ids.push(id);
									}
								});
							}			
							if (ids.length==0) {
								model.notice().warn($filter('translate')('SELECT_RX_TO_IMPORT'));					
							} else if (scope.quickViewData && scope.quickViewData.represcribe){
								var rxToImport = EncounterSummaryCommon.represcribe(scope.getPatient().viewbag.patData, ids, 'oe');
								for (let prescription of rxToImport) {
									scope.quickViewData.represcribe(prescription);									
								}
							}
						} else if (scope.quickViewData==undefined) { // si on est en quickview et pas en mode de represcription, je ne le permets pas.
							var pt = scope.getPatient();
							if (pt.viewbag && pt.viewbag.patData) {
								var sum = {
									idProfAnchor:model.user().profil.id,
									idPatientAnchor:pt.id,
									lstPrescription:[],
									lstDevice:[]					
								};
								$(wx.document).find('.chk-oe-rx').each(function(i, obj) {
									if (obj.checked===true) {
										var id = obj.id.split('~')[1];
										ids.push(id);
									} 
								});
								$(wx.document).find('.chk-oe-dev').each(function(i, obj) {
									if (obj.checked===true) {
										var id = obj.id.split('~')[1];
										ids.push(id);
									}
								});
								if (ids.length==0) {
									model.notice().warn($filter('translate')('SELECT_RX_TO_IMPORT'));					
								} else {
									EncounterSummaryCommon.represcribe(pt.viewbag.patData, ids, 'oe', sum);
									var rxName = [];
									for (let rx of sum.lstPrescription) {
										rxName.push(rx.name);
									}
									for (let rx of sum.lstDevice) {
										rxName.push(rx.name);
									}
									var txtInput =  {rx: rxName.join(', '), nb:rxName.length};
									var qconfirmOptions = {title: $filter('translate')('CONFIRM_RX_TO_IMPORT', txtInput)};
									QConfirm.open(qconfirmOptions).then(proceedWithImport);
									function proceedWithImport(proceed){
										if(proceed){
											saveSummaryImportDsq(pt, sum);
										}
									}								
								}
							}
						}
						return false;
					}
					wx.importDisp = function(){
						var ids = [];
						$(wx.document).find('.chk-disp').each(function(i, obj) {
							if (obj.checked===true) {
								var id = obj.id.split('~')[1];
								ids.push(id);
							} 
						});
						if (ids.length==0) {
							model.notice().warn($filter('translate')('SELECT_RX_TO_IMPORT'));					
						} else {
							if (isInReprescribeMode() && scope.quickViewData.linkModeOn === LinkMode.REPRESCRIBEMODE) {
								if (scope.quickViewData && scope.quickViewData.represcribe){
									var rxToImport = EncounterSummaryCommon.represcribe(scope.getPatient().viewbag.patData, ids, 'disp');
									for (let prescription of rxToImport) {
										scope.quickViewData.represcribe(prescription);									
									}
								}
							} else if (scope.quickViewData==undefined) { // si on est en quickview et pas en mode de represcription, je ne le permets pas.
								var pt = scope.getPatient();
								if (pt.viewbag && pt.viewbag.patData) {
									var sum = {
										idProfAnchor:model.user().profil.id,
										idPatientAnchor:pt.id,
										lstPrescription:[],
										lstDevice:[]					
									};
									EncounterSummaryCommon.represcribe(scope.getPatient().viewbag.patData, ids, 'disp', sum);
									var rxName = [];
									for (let rx of sum.lstPrescription) {
										rxName.push(rx.name);
									}
									for (let rx of sum.lstDevice) {
										rxName.push(rx.name);
									}
									var txtInput =  {rx: rxName.join(', '), nb:rxName.length};
									var qconfirmOptions = {title: $filter('translate')('CONFIRM_RX_TO_IMPORT', txtInput)};
									QConfirm.open(qconfirmOptions).then(proceedWithImport);
									function proceedWithImport(proceed){
										if(proceed){
											saveSummaryImportDsq(pt, sum);
										}
									}
								}
							}
						}
						return false;
					}
					wx.importMedocs = function(){
						model.notice().warn("Fonctionnalité à venir...");
						return false;
					}
					wx.toggleSelectedDm = function(){
						$(wx.document).find('.chk-dm').each(function(i, obj) {
							obj.checked = obj.checked ? false:true;
						});
						return;
					}
					wx.toggleSelectedOe = function(){
						$(wx.document).find('.chk-oe-rx').each(function(i, obj) {
							obj.checked = obj.checked ? false:true;
						});
						$(wx.document).find('.chk-oe-dev').each(function(i, obj) {
							obj.checked = obj.checked ? false:true;
						});
						return;
					}
					wx.toggleSelectedDisp = function(){
						$(wx.document).find('.chk-disp').each(function(i, obj) {
							obj.checked = obj.checked ? false:true;
						});
						return;
					}
					wx.getConsent = function(){
						dsqComm.dsqRequest("getConsent");
					};
					wx.listPrescriptionsOE = function(){
						$(wx.document).find('.table-list-info-listPrescriptionsOE').empty();
						dsqComm.dsqRequest("listPrescriptionsOE");
					};
					wx.listMedicationsDM = function(){
						$(wx.document).find('.table-list-info-listMedicationsDM').empty();
						dsqComm.dsqRequest("listMedicationsDM");
					};
					wx.listDispenses = function(){
						$(wx.document).find('.table-list-info-dispenses').empty();
						dsqComm.dsqRequest("listDispenses");
					};
					wx.GDDispenses = function(dispenseId){
						dsqComm.dsqRequest("GDDispenses", {dispenseId: dispenseId});
					};
					wx.IDDispenses = function(dispenseId){
						model.notice().warn("Fonctionnalité à venir...");
						// console.log(dispenseId+"::::::::::::::");
						//Requieres the prescription list to be sure the importations was not already done.
						// dsqComm.dsqRequest("IDDispenses", {dispenseId: dispenseId});
					};
					wx.getDetailForImport = function(dId,dispenseId, idRx ){
						model.notice().warn("Fonctionnalité à venir...");
						return false;
						// dsqComm.dsqRequest("getDetailForImport", {dId: dId, dispenseId: dispenseId, idRx: idRx});
					};
					wx.GDDrugDispenses = function(value, version, context){
						dsqComm.dsqRequest("GDDrugDispenses", {version: version, value: value, context:context});
					};
					wx.listMedication_GDMedication = function(value, version){
						dsqComm.dsqRequest("listMedication_GDMedication", {version: version, value: value});
					};
					wx.listMedication_GDPrescription = function(value, version, context){
						dsqComm.dsqRequest("listMedication_GDPrescription", {version: version, value: value, context:context});
					};
					wx.GDDrug = function(value, version, context){
						dsqComm.dsqRequest("GDDrug", {version: version, value: value, context:context});
					};
					wx.GDDrugOE = function(value, version){
						dsqComm.dsqRequest("GDDrugOE", {version: version, value: value});
					};
					wx.updateParameter = function(type, vx){
						var data = {type: type};
						if(typeof vx === 'boolean'){
							data.actif = vx;
						}else{
							data.value = vx;
						}
						dsqComm.dsqRequest("updateParameter", data);
					};
					wx.getDDevice = function(value, version){
						dsqComm.dsqRequest("getDDevice", {version: version, value: value});
					};
					wx.retractDrug = function(value, version){
						dsqComm.dsqRequest("retractDrug", {version: version, value: value});
					};
				}
			}
		};
	}]);
	
	patient.directive('editSummary', [ 'model',
		 function(model){
		return {
			restrict: 'EA',
			template: '<div class="full-height-autoscroll"><patient-med-summary pat-id="patient.id" patient="patient" options="{mode:\'e\'}"></patient-med-summary></div>',
			scope: {
				origPatient: '=editSummary',
				editOnOpen: '=',
			},
			link: function(scope, element, attrs){
				scope.update = function(){
					//Doit être copié pour éviter d'affecter les deux ui(edition et lectur) a mm temps.
					scope.patient = angular.copy(scope.origPatient);
					scope.model = model;
					if(scope.editOnOpen && scope.editOnOpen.item){
						scope.patient.viewbag.patData.sum[scope.editOnOpen.type].forEach(function(e){
							// if(e.id === scope.editOnOpen.item.id){
							if(scope.editOnOpen.item.id === e.id){
								if(e.viewbag){
									e.viewbag.editOnOpen = true;
								}else{
									e.viewbag = {editOnOpen: true};
								}
							}
						});
						delete scope.editOnOpen.item;
					}
				}

				scope.$watch(scope.origPatient, scope.update);
			}
		}
	}]);

	patient.directive('summaryDoc', ['patientShowTitles', function(patientShowTitles){
		return {
			restrict: 'EA',
			scope:true,
			link: function (scope, element, attrs){
				if(scope.doc){
					scope.data = getDocData(scope.doc).quickViewData
				}
				scope.title = "PatientMedSummary"
				function getDocData(doc){
					return patientShowTitles.getQVPayLoad(doc, {hasHeader: false}, scope.patient)
				}
			}
		}
	}]);
	
	/**
	 * COMMENT: PAT SUMMARY DIRECTIVE
	 *
	 * SUMMARY: Gére le sommaire du patient
	 */
	patient.directive('patientMedSummary',
		['DocAccessor', 'LabAccessor', 'model', '$timeout', '$q', 'ModificationStatus', 'patientShowTitles', 'LinkMode', 'Markdown','Rights',
		'encEnumList','QConfirm','$filter','EncounterAccessor','QValidation','utils','EncounterSummaryCommon','QuickView','SuiviPrevAccessor',
		function(DocAccessor, LabAccessor, model, $timeout, $q, ModificationStatus, patientShowTitles, LinkMode,Markdown, Rights,
			encEnumList, QConfirm, $filter, EncounterAccessor, QValidation, utils, EncounterSummaryCommon, QuickView, SuiviPrevAccessor){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/pat/patientMedSummary.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				scope.model = model;
				scope.actOptions = scope.$eval(attrs.options);
				scope.editOnOpenOptions = {};
				scope.onlyActive = model.onlyActive();
				scope.onlyActive.spToDo = model.prefSettings('suiviPrev4Pt');
				scope.patientShowTitles = patientShowTitles;
				if (typeof scope.inLinked == 'undefined') {
					scope.inLinked = false;
				}
				scope.resetData = function(){
					if (!scope.patient && scope.quickViewData) {	// donc on a ouvert un quickview
						scope.patient = scope.quickViewData.pat;
					}
				};
				scope.resetData();

				var activateExternalSummary = QuickView.externaliseFeatureActive()  ;
				scope.externaliseActive = function () {
					return activateExternalSummary &&
					scope.actOptions.mode !== 'e' &&
					scope.actOptions.mode !== 'ext';
				}
				scope.newPlan = function(){
				    var newPl = {
				    		idPatientAnchor:scope.patient.id,
				    		isNew: true,
							isPrivate: false,
							isDoneB: false,
							isDeletedB: false,
				    		createDateS: nowDateTime()
				    	};
				    if (angular.isUndefined(scope.patient.viewbag.patData.sum.lstPlan)) {
				    	scope.patient.viewbag.patData.sum.lstPlan = [];
				    }
				    scope.patient.viewbag.patData.sum.lstPlan.push(newPl);
				};
				scope.showOptions = {};
				scope.showOptions.activePlan = true;

				scope.scrollTo = function(p) {
					var o = $(p)[0];
					if (o) {
						o.scrollIntoView(true);
					}
				};

				function saving(isSaving){
					if(isSaving){
						scope.saving = true;
					}else{
						$timeout(function(){
							scope.saving = false;
						}, 2000);
					}
				}

				scope.saving = false;

				scope.prepForSave = function(sum){
					//Clean notes array to encounternote object.
					EncounterAccessor.sumNotesObj.forEach(function(i){
						var arrayObj = i + 'Arr';
						if(sum[arrayObj]){
							sum[i] = sum[arrayObj][0];
							if (sum[i]) {	// undefined si ajoute puis supprime un item.
								delete sum[i].viewbag
								delete sum[arrayObj];
							}
						}
					});
					sum.idPatientAnchor = scope.patient.id;
					sum.idProfAnchor = model.user().profil.id;
					return sum;
				}

				function elemInEdit(){
					return (scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0);
				}
				function elemsValid(){
					var isValid = true;
					for( var i = 0; i < scope.formOptions.inEditMode; i++){
						if(!scope.formOptions.inEditItems[i].viewbag.okToClose()){
							isValid = false;
						}else{
							scope.formOptions.inEditItems[i].viewbag.save();
							i--;//reduce i because saving i reduces the number of items in edit.
						}
					};
					return isValid;
				}
				scope.closeView = function(){
					// if(scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0){
					// 	model.notice().fail($filter('translate')('SummarySaveEditModeForm'));
					// 	return;
					// }
					if(scope.formOptions.dirty  || elemInEdit()){
						return QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
						.then(function(save){
							if(registeredDirtyId){
								unregisterDirty();
							}
							if(save){
								return scope.saveSummary().then(toggleSummaryViewMode); //should change the dirty state to make sure that the second time closing goes through
							}else{
								scope.formOptions.inEditMode = 0;
								return toggleSummaryViewMode();
							}
						});
					}else{
						return toggleSummaryViewMode();
					}
				};
				scope.popoverMedSumEdit = function(){
					return toggleSummaryViewMode();
				}

				scope.externalSummary = function() {
					var p;
					if(scope.actOptions.mode === 'e' && scope.origPatient){
						p = scope.origPatient
					}else{
						p = scope.patient;
					}
					patientShowTitles.externalSummary(p);
				}

				scope.printSummary = function() {
					var toPrint = {idPt:scope.patient.id}
					return EncounterAccessor.printSummary(toPrint, angular.noop);
				}
				
				scope.patientMedSummaryInEditMode = function(){
					var summaryEditBtn = angular.element('#btn-med-sum-edit');
					if(summaryEditBtn[0].open === undefined){
						summaryEditBtn[0].open = false;//
					}
					return summaryEditBtn[0].open
				};
				scope.patSumPopover = {
					onShow:function(api){
						utils.showPopoverOverlay(true);
						scope.patSumPopover.api = api;
						if(scope.origPatient !== undefined){
							updateSummaryExternalFunctions();
						}
					},
					onHide: function(){
						utils.showPopoverOverlay(false);
					},
					close: function(){
						scope.patSumPopover.api && 
						scope.patSumPopover.api.hide && 
						scope.patSumPopover.api.hide();
						clearPopoverInExternalSummary();
					}
				}

				function clearPopoverInExternalSummary(){
					// fixes overlay showing in external view. when canceling a save state in parent window.
					if(window.ofysPayload && utils.popoverOverlayActive()){
						utils.showPopoverOverlay(false);
					};
				}

				function toggleSummaryViewMode(){
					return $q(function(resolve, reject){
						var currMode = scope.patientMedSummaryInEditMode();
						var summaryEditBtn = angular.element('#btn-med-sum-edit');
						summaryEditBtn[0].open = !currMode;
						$timeout(function() {
							//Clear overlay
							scope.patient.viewbag.patData.sum.editMode = scope.model.isSumEdit(scope.patientMedSummaryInEditMode());
							if(window.ofysPayload){
								//this seems to be the only way that the edit mode variable is updated in the parent window also.
								var m = window.ofysPayload();
								if(m.quickViewData.qvActData.className == "CSummary"){
									m.quickViewData.qvActData.isDirty = scope.formDirty()
								}
								m.fromExternalView = true;
							}
							scope.model.closeSummary = scope.closeView;
							//toggle the modal popover
							summaryEditBtn.triggerHandler('click');
							resolve()
						});
					})
				}

				var registeredDirtyId;

				function registerDirty(){
					registeredDirtyId = "patMedSum_"+scope.patient.id;
					QValidation.registerDirty(registeredDirtyId, function(){
						return scope.saveSummary().then(function(){
							scope.closeView();
						});
					}, function(){
						unregisterDirty();
						toggleSummaryViewMode();
						return true;
					});
				}

				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				
				function cancelSummary(){
					model.summaryExternalViewer.quickViewData.qvActData.isDirty = false;
				}

				scope.$watch(function(){
					if(scope.origPatient){					
						return scope.origPatient.id + "-" + scope.formOptions.inEditMode
					}
				}, function(){
					if(scope.origPatient !== undefined){
						updateSummaryExternalFunctions()
					}
				})

				function updateSummaryExternalFunctions(){
					if(window.ofysPayload){
						//this seems to be the only way that the edit mode variable is updated in the parent window also.
						var m = window.ofysPayload();
						if(m.quickViewData.qvActData.className == "CSummary"){
							m.quickViewData.qvActData.isDirty = scope.formDirty();
							m.quickViewData.qvActData.save = scope.saveSummaryAndClose;
							m.quickViewData.qvActData.cancel = cancelSummary;
							m.quickViewData.qvActData.close = scope.patSumPopover.close;
						}
						m.fromExternalView = true;
					}
				}
					
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.formOptions.dirty || (scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0);
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					if(window.ofysPayload){
						//this seems to be the only way that the edit mode variable is updated in the parent window also.
						var m = window.ofysPayload();
						if(m.quickViewData.qvActData.className == "CSummary"){
							m.quickViewData.qvActData.isDirty = dirty;
						}
					}
					model.closeSummary = scope.closeView;
					return isFormDirty;
				};

				function planInEdit(){
					for (let i = 0; i < scope.patient.viewbag.patData.sum.lstPlan.length; i++) {
						if(scope.patient.viewbag.patData.sum.lstPlan[i].localModel){
							return true;
						}
					}
					return false;
				}
				scope.saveSummaryAndClose = function(){
					return scope.saveSummary().then(function () {
						scope.closeView();
					})
				}

				function applyFilter (lf) {
					for(var i = 0; i < scope.patient.viewbag.laboFollow.length; i++){ 
				        if ( scope.patient.viewbag.laboFollow[i] === lf) { 
				            scope.patient.viewbag.laboFollow.splice(i, 1); 
				            i--; 
				        }
					}
					model.patientSumUpdated(true);					
				}
				scope.addLaboFilter = function(lf){
					var idProf =  model.user().profil &&  model.user().profil.id ?  model.user().profil.id : undefined;
					var idPt = scope.patient.id;
					if (idPt && idProf) {
						LabAccessor.doAddLaboFilter(lf, idProf, idPt, applyFilter);
					}
				}

				scope.addLaboFollow = function(lf){
					var idProf =  model.user().profil &&  model.user().profil.id ?  model.user().profil.id : undefined;
					var idPt = scope.patient.id;
					if (idPt && idProf) {
						var laboTypes = [lf.c, '', lf.n];
						LabAccessor.doAddLaboFollow(laboTypes, idProf, idPt);
					}
				}

				scope.delLaboFollow = function(lf){
					var idProf =  model.user().profil &&  model.user().profil.id ?  model.user().profil.id : undefined;
					var idPt = scope.patient && scope.patient.id ? scope.patient.id : undefined;
					if (idPt && idProf) {
						LabAccessor.delLaboFollow({code:lf.c, loinc:lf.l, idPat:scope.patient.id, idProf: idProf}, 
						function(e){
							if (e.data && e.data.success===false) {
								model.notice().warn($filter('translate')(e.data.ms));
							} else {
								applyFilter(lf);
							}
						}, function(e){
							model.notice().warn(e);	
						});
					}
				}

				scope.saveSummary = function(){
					var sum = scope.patient.viewbag.patData.sum;					
					if(sum){
						if(!scope.saving){
							if(elemInEdit()){
								if(!elemsValid()){
									return $q.reject("La validation du sommaire a échoué");
								}
							}
							saving(true);
							// les lastXYZ ne sont pas modifiés dans un sommaire. On garde ceux qu'on avait.
							var lastMesure = null;
							if (sum.lastMesure) {
								lastMesure = sum.lastMesure;
							}
							var lastBloodPres = null;
							if (sum.lastBloodPres) {
								lastBloodPres = sum.lastBloodPres;
							}
							var lstHxRx = null;
							if (sum.lstHxPrescription) {
								lstHxRx = sum.lstHxPrescription;
							}
							var lstPlan = null;
							//If a plan is in edit mode to make sure the plan is not lost on save summary
							if (sum.lstPlan && planInEdit()) {
								lstPlan = sum.lstPlan;
							}
							var savable = scope.prepForSave(angular.copy(sum));
							// console.log(savable);
							// scope.saving = false
							// return ;
							return EncounterAccessor.saveSummary(savable, function(res){
								var savedElem = res;
								EncounterAccessor.convSumToArr(savedElem);
								if (lastMesure!=null) {
									savedElem.lastMesure = lastMesure;
								}
								if (lastBloodPres!=null) {
									savedElem.lastBloodPres = lastBloodPres;
								}
								if (lstPlan != null) {
									savedElem.lstPlan = lstPlan;
								}
								savedElem.suiviPrev = sum.suiviPrev;
								savedElem.suiviPrevToDo = sum.suiviPrevToDo;
								
								//update edit summary version
								OfysUtils.update(scope.patient.viewbag.patData.sum, savedElem);

								// update read summary version.
								OfysUtils.update(scope.origPatient.viewbag.patData.sum, angular.copy(savedElem));

								if (lstHxRx!=null) {
									scope.origPatient.viewbag.patData.loaded.hxrx = 0;
								}
								scope.formOptions.setFormStatus();//Certain cases the dirty state is not remove. Must be called to reset.
								model.notice().success($filter('translate')('successfulSave'));
								// model.encounterUpdated(true);
								//unlock savingPatient function
								saving();
								model.patientSumUpdated(true);

								if(model.summaryExternalViewer != null && model.summaryExternalViewer !== undefined){
									scope.externalSummary();
								}
								updateSummaryExternalFunctions();
							}, function(res){
								//unlock savingPatient function
								saving();
								// model.notice().fail(res.status + ' : ' + $filter('translate')('failedSave'));
							});
						}
					}
					return $q(function(resolve,reject){reject()});
				};

				scope.addItemToLinks = function(type, item, fctDesc) {
					if (scope.quickViewData && scope.quickViewData.linkModeOn > 0) {
						var m = scope.quickViewData.linkModeOn;
						if( m === 3 || m == 5){
							handleReprescriptionAttachementLinking(type, item)
						}else if(m === 4 || m === 6){
							handleMedStopLinking(type, item)
						}else{
							linkByDescription(type, item, fctDesc);
						}
					}
				};

				function handleReprescriptionAttachementLinking(type,item){
					if(scope.quickViewData && scope.quickViewData.qvActData &&
						scope.quickViewData.qvActData.viewbag &&
						scope.quickViewData.qvActData.viewbag.represcribe){
							scope.quickViewData.qvActData.viewbag.represcribe(item);
					}
				}
				function handleMedStopLinking(type,item){
					if(scope.quickViewData && scope.quickViewData.qvActData &&
						scope.quickViewData.qvActData.viewbag &&
						scope.quickViewData.qvActData.viewbag.medStopLink){
							scope.quickViewData.qvActData.viewbag.medStopLink(item);
					}
				}
				function linkByDescription(type, item, fctDesc){
					var idDesc;
					if (fctDesc) {
						idDesc = fctDesc();
					}
					var description = "";
					if (idDesc) {
						for(var j=0;j<idDesc.length;j++) {
							if (item.descr[idDesc[j]]) {
								description += item.descr[idDesc[j]] + " ";
							}
						}
					} else {
						description += item + " ";
					}
					if (description.trim().length>0) {
						// ajouter le lien.
						var itemToAdd = {
								t: type,
								d: Markdown.mdToTxt(description).trim()
								};
						if (item.id) {
							itemToAdd.id = item.id;
						}
						modSumLink(itemToAdd);
					}
				}

				function nowDateTime(){
					return moment().format("YYYY-MM-DD HH:mm");
				}
				function nowDateOnly(){
					return moment().format("YYYY-MM-DD");
				}

				function summaryInEdit(){
					return scope.actOptions.mode === 'e'
				}
				function sectionHasElements(obj){
					return scope.patient.viewbag &&
					scope.patient.viewbag.patData &&
					scope.patient.viewbag.patData.sum[obj] &&
					scope.patient.viewbag.patData.sum[obj].length
				}
				function isMain(obj, m){
					if((m === LinkMode.REPRESCRIBEMODE || m === LinkMode.MED_STOP_MODE) && obj === 'lstAllPrescription'){
						return true;
					}
					if((m === LinkMode.DEVICEREPRESCRBE || m === LinkMode.DEVICEMED_STOP_MODE) && obj === 'lstDevice'){
						return true;
					}
					return false;
				}
				//Hides sections that should not be visible in resprescription mode
				function inReprescriptionMode(obj){
					if(!scope.quickViewData)return false;
					if(isMain(obj, scope.quickViewData.linkModeOn)|| obj === 'lstAllergy' || obj === 'lstIntolerance' || obj === 'lstHxPrescription') return false;

					return scope.quickViewData &&
						(scope.quickViewData.linkModeOn > 2 &&
							scope.quickViewData.linkModeOn < 7 );
				}

				//Options that affect every item
				var medSumListOptions = {
					hasDelete: scope.actOptions.mode==='e',
					hasAdd: scope.actOptions.mode==='e',
					hasEdit: scope.actOptions.mode==='e',
					editReady: model.user().isClinician(),
					isHx:false,
					showSection: function(){
						return (!inReprescriptionMode(this.obj)) && ( summaryInEdit() || sectionHasElements(this.obj));
					},
					onSelect: function(item, options){//when table item is selected.
						// if(scope.actOptions.mode === 'ext') {// bloquer la modif lorsque le sommair est externalisé
						// 	model.notice().info($filter("translate")("ExternalSummaryIsReadOnly"), { attributes: { x: 'left', y: 'bottom'}});
						// 	return;
						// }
						if (options.editReady===true){ // pour non clinicien, on ne veut pas éditer le sommaire
							if (scope.quickViewData && scope.quickViewData.linkModeOn > 0) {
								//Ajout de lien pour les formulaire ou pour la rencontre. ne rien faire.
							}else if(scope.actOptions.mode !=='e'){
								//Ouvrir l'item en edition.
								scope.editOnOpenOptions.item = item;
								scope.editOnOpenOptions.type = options.obj;
								toggleSummaryViewMode();//Click on edit button.
							}else if(scope.actOptions.mode ==='e'){
								options.editElement(item);
							}
						}
					}
				}

				//Per item options
				scope.formOptions = {
					inEditMode: 0,
					editReady:  model.user().isClinician(),
					dirty: false,
					addItemToLinks: scope.addItemToLinks,
					showAddLinkButton: function() {
						var b = false;
						if (scope.quickViewData && angular.isDefined(scope.quickViewData.linkModeOn)) {
							b = scope.quickViewData.linkModeOn > 0;
						}
						return b;
					},
					linkDescr: {
						// les descr qu'on veut dans la description qui sera le nom du lien ajouté. On n'a pas tjrs de id...
						getAll: function() {
							return [0,1,2,3];
						},
						getMs: function() {
							return [0,1,2];
						},
						getRx: function() {
							return [0,1];
						},
						getDx: function() {
							return [0,1];
						},
						getIt: function() {
							return [0,1];
						},
						getImm: function() {
							return [0,1,2];
						},
						getRap: function() {
							return [0,1];
						},
						getTxt: function(){
							return [0,2];
						}
					},
					//Sets state of the CSummary object as dirty
					setFormStatus: function(state){
						this.dirty = (state === 'dirty');
						scope.formDirty()
					},
					inLinked: scope.inLinked
				}


				var allOptions = [
					"suiviprevOptions",
					"concernOptions",
					"allergyOptions",
					"intolerenceOptions",
					"prescriptionOptions",
					"prescriptionHxOptions",
					"atcdMedOptions",
					"atcdCxOptions",
					"mdHistOptions",
					"habitusOptions",
					"immunizationOptions",
					"reminderOptions",
					"hxFamOptions",
					"hxSocOptions"
				];
				var sliderOptions = {
						floor: 0, ceil: 100,
						onEnd: function(sliderId, modelValue, highValue, pointerType) {
							//console.log("onChange called for obj ");
						}
					};

				//To make Patient Edit listTable directive compatible with encounter edit views since both are already written.
				//this function allows transforming the "selected" item to be accessed via "item" in views
				// No time to make both of them standard
				function formatForEncounter(data, options){
					data.item = data.selected;
					if(data.item.viewbag){
						data.item.viewbag.item = angular.copy(data.selected);
						if(this.addToViewbag){
							this.addToViewbag(data.item, options.dataEdit.def);
						}
					}
				}

				scope.dxStatus = [];
				Object.keys(EncounterAccessor.allDxStatus).forEach(function(key){
					scope.dxStatus.push({val:key*1, name:EncounterAccessor.allDxStatus[key]});
				});

//				for(var dxStatusI = 0; dxStatusI < encEnumList.dxStatus.length; dxStatusI++){
//					scope.dxStatus.push({val: dxStatusI, name: encEnumList.dxStatus[dxStatusI]+'_dxStatus'})
//				}
				scope.severityStatus = [];
				for(var severityStatusI = 0; severityStatusI < encEnumList.allergyServerity.length; severityStatusI++){
					scope.severityStatus.push({val: severityStatusI, name: encEnumList.allergyServerity[severityStatusI]+'_severity'})
				}
				scope.allergyStatus = [];
				for(var allergyStatusI = 0; allergyStatusI < encEnumList.allAllergyProbability.length; allergyStatusI++){
//					scope.allergyStatus.push({val: encEnumList.allAllergyProbability[allergyStatusI], name: 'alProb_' + encEnumList.allAllergyProbability[allergyStatusI]})
					scope.allergyStatus.push({val: allergyStatusI, name: 'alProb_' + encEnumList.allAllergyProbability[allergyStatusI]})
				}
				scope.habitTypes = [];
				scope.frequencyOptions = [];
				for(var habitTypeI = 0; habitTypeI < encEnumList.typeHabit.length; habitTypeI++){
					scope.habitTypes.push({val: habitTypeI, name: encEnumList.typeHabit[habitTypeI]})
					scope.frequencyOptions[habitTypeI] = [];
					for(var frequencyI = 0; frequencyI < encEnumList.lstLifeHabitFrequency.length; frequencyI++){
						scope.frequencyOptions[habitTypeI].push({
							val: frequencyI,
							name: encEnumList.typeHabit[habitTypeI] + "." + encEnumList.lstLifeHabitFrequency[frequencyI] })
					}
				}

				scope.partialDateOptions = {
					hasCalendar: false
				};


				function getSortActions(d, alphabet){

					return [
						{
							//Sort by declared date
							action: function(options){
								this.options = options;
								var sA = options.actions.find(function(a){return a.name === 'sortAlphabetically'});
								if(sA.state !== 1){
									sA.setState(1);
								}
								this.setState(this.state === 3?1: this.state +1);
							},
							setState: function(state){
								if(state === 1){
									this.options.orderListBy = "";
									this.aIcon = 'fa-sort-numeric-asc dim';
									this.title = 'SORT_REMOVE';
									this.state = 1;
								}else if(state === 2){
									this.options.orderListBy = d;
									this.aIcon = 'fa-sort-numeric-asc';
									this.title = 'SORT_DATE_ASC';
									this.state = 2;
								}else if(state === 3){
									this.options.orderListBy = "-"+d;
									this.aIcon = 'fa-sort-numeric-desc';
									this.title = 'SORT_DATE_DESC';
									this.state = 3;
								}
							},
							state: 1,
							title:"SORT_REMOVE",
							aIcon: 'fa-sort-numeric-asc dim',
							name:"sortByDate"
						},
						{
							//Sort by alphabetic order
							action: function(options){
								this.options = options;
								var sA = options.actions.find(function(a){return a.name === 'sortByDate'});
								if(sA.state !== 1){
									sA.setState(1);
								}
								this.setState(this.state === 3?1: this.state +1);
							},
							setState: function(state){
								if(state === 1){
									this.options.orderListBy = "";
									this.aIcon = 'fa-sort-alpha-asc dim';
									this.title = '';
									this.state = 1;
								}else if(state === 2){
									this.options.orderListBy = alphabet;
									this.aIcon = 'fa-sort-alpha-asc';
									this.title = 'SORT_ALPHA_ASC';
									this.state = 2;
								}else if(state === 3){
									this.options.orderListBy = "-"+alphabet;
									this.aIcon = 'fa-sort-alpha-desc';
									this.title = 'SORT_ALPHA_DESC';
									this.state = 3;
								}
							},
							state: 1,
							title:"SORT_REMOVE",
							aIcon: 'fa-sort-alpha-asc dim',
							name:"sortAlphabetically"
						},
					];
				}

				function getToggleList(type, on, off){
					return {
							//Sort by declared date
							action: function(s){
								scope.onlyActive[type] = !s;
								this.setState(scope.onlyActive[type]);
							},
							setState: function(state){
								this.onlyActive = state;
								if(state === true){
									this.aIcon = 'fa-minus';
									this.title = on;
								}else {
									this.aIcon = 'fa-plus';
									this.title = off;
								}
							},
							aIcon: scope.onlyActive[type] ? 'fa-minus' : 'fa-plus',
							title: scope.onlyActive[type] ? on : off,
							onlyActive: scope.onlyActive[type]
						};
				}
				function getToggleAllList(type, on, off){
					return {
							//Sort by declared date
							action: function(s){
								scope.onlyActive[type] = !s;
								this.setState(scope.onlyActive[type]);
							},
							setState: function(state){
								this.onlyActive = state;
								if(state === true){
									this.aIcon = '';
									this.title = on;
								}else {
									this.aIcon = 'dim';
									this.title = off;
								}
							},
							aIcon: scope.onlyActive[type] ? '' : 'dim',
							title: scope.onlyActive[type] ? on : off,
							onlyActive: scope.onlyActive[type]
						};
				}
				scope.hxSocOptions  =  $.extend({
					title: 'HX_SOC',
					tIcon: 'fa-user reverse-color-sum',
					isObject: true,
					addObject: false,
					obj: 'socialHistoryObjArr',
					dataEdit: {
						defaultItem :{
							noteType:102
						},
						addToViewbag: function(item){
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusNote){
									item.viewbag.focusNote()
								}
							};
						},
						def:{
							hideNoteTypes: true,
							completeType: 9,
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstNote_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.hxFamOptions  =  $.extend({
					title: 'HX_FAM',
					tIcon: 'fa-users reverse-color-sum',
					isObject: true,
					addObject: false,
					obj: 'familyHistoryObjArr',
					dataEdit: {
						defaultItem :{
							noteType:103
						},
						addToViewbag: function(item){
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusNote){
									item.viewbag.focusNote()
								}
							};
						},
						def:{
							hideNoteTypes: true,
							completeType: 12,
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstNote_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.suiviprevOptions  = {
					title: 'SUIVI_PREV',
					tIcon: 'fa-hourglass-half reverse-color-sum',
					showCount: true,
					hasDelete: true,
					hasAdd: false,
					hasEdit: false,
					editReady: true,
					isHx:false,
					showDetails: false,
					showPatHisto:false,
					showBaseHisto:false,
					obj: 'suiviPrev',
					showSection: function(){
						return (!inReprescriptionMode(this.obj)) && model.user().isProf && ( summaryInEdit() || sectionHasElements(this.obj));
					},
					onSelect: function(item, options){},
					hideSuiviPrevTitle: 'TOGGLE_SHOW_SUIVI_PREV',
					toggleHideSuiviPrev: function() {
						model.prefSettings('hideSuiviPrev', !(model.prefSettings('hideSuiviPrev')));
					},
					toggleSuiviPrev4Pt: function() {
						model.prefSettings('suiviPrev4Pt', !(model.prefSettings('suiviPrev4Pt')));
					},
					showPat: function(item) {
						return item.idSuiviPrevPat || (item.usage!=undefined && _.findWhere(model.suiviPrevs().pat[scope.patient.id], {idSuiviPrev:item.id}));
					},
					nextSuiviDate: function(sp) {
						if (sp.nextScheduledDate) {
							return OfysUtils.daysFrom1970ToStr(sp.nextScheduledDate);							
						}
						return undefined;
					},
					recentData: function(sp) {
						// un facilitateur de suivis préventifs
						if (sp.folMonths!==9999 && scope.patient.viewbag && scope.patient.viewbag.patData) {
							if (sp.idSuiviPrev===13 && scope.patient.viewbag.patData.sum.lastBloodPres && scope.patient.viewbag.patData.sum.lastBloodPres.systolic) {
								// id 13 = BP
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.patData.sum.lastBloodPres;
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.timeVitalSignS);
									sp.lastData.note = $filter("translate")('TA') +' ' + sp.lastData.systolic + (sp.lastData.diastolic ? '/' + sp.lastData.diastolic : '');
									//sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths)
								}
							} else if (sp.idSuiviPrev===14 && scope.patient.viewbag.patData.sum.lastMesure && scope.patient.viewbag.patData.sum.lastMesure.weightS2) {
								// id 14 = Obésité
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.patData.sum.lastMesure;
									// sp.lastMesuer.IMC est mis ds CEncounter
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.timeVitalSignS);
									var imc = sp.lastData.IMC ? Math.round( sp.lastData.IMC * 10 ) / 10 : undefined;
									sp.lastData.note = sp.lastData.weightS2 +'kg' + (imc ? ' (' + $filter("translate")('IMC') +' ' + imc + ')' : '');
									//sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths)
								}
							} else if (sp.idSuiviPrev===2 && scope.patient.viewbag.psa) {
								// id 2 = cancer prostage - recherche de PSA
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.psa;
									// sp.lastMesuer.IMC est mis ds CEncounter
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.date);
									sp.lastData.note = 'PSA ' + sp.lastData.value;
									sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths) +1;
								}
							} else if (sp.idSuiviPrev===3 && scope.patient.viewbag.rsos) {
								// id 3 = cancer colo rectal - recherche de RSOS (on a RSOSi et RSOSI...)
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.rsos;
									// sp.lastMesuer.IMC est mis ds CEncounter
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.date);
									sp.lastData.note = 'RSOSi ' + sp.lastData.value;
									sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths) +1;
								}
							} else if (sp.idSuiviPrev===11 && scope.patient.viewbag.hba1c) {
								// id 11 = hba1c
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.hba1c;
									// sp.lastMesuer.IMC est mis ds CEncounter
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.date);
									sp.lastData.note = 'HbA1c ' + sp.lastData.value;
									sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths) +1;
								}
							} else if (sp.idSuiviPrev===12 && scope.patient.viewbag.chol) {
								// id 12 Dyslipidémie en prévention primaire
								if (sp.lastData == undefined) {
									sp.lastData = scope.patient.viewbag.chol;
									// sp.lastMesuer.IMC est mis ds CEncounter
									sp.lastData.doneDate = OfysUtils.stringToLocalDate(sp.lastData.date);
									sp.lastData.note = sp.lastData.name + ' ' + sp.lastData.value;
									sp.lastData.nextScheduledDate = sp.lastData.doneDate + (30.4375 * sp.folMonths) +1;
								}
							}
						}
						return sp.lastData!==undefined;
					},
					patIconColor: function(item) {
						var spp = _.findWhere(model.suiviPrevs().pat[scope.patient.id], {idSuiviPrev:(item.idSuiviPrev?item.idSuiviPrev:item.id)});// item peut être un CSummarySuiviPrev ou CSuiviPrev
						if (spp) {
							if (spp.usage===1) {
								return 'red';
							} else if (spp.usage===2) {
								return 'lightgreen';
							} else {
								return 'blue';
							}
						}
						return '';						
					},
					showProf: function(item) {
						return item.idSuiviPrevProf || (item.usage!=undefined && _.findWhere(model.suiviPrevs().prof, {idSuiviPrev:item.id }));
					},
					profIconColor: function(item) {
						var spp = _.findWhere(model.suiviPrevs().prof, {idSuiviPrev:(item.idSuiviPrev?item.idSuiviPrev:item.id)});
						if (spp) {
							if (spp.doNotUse===true) {
								return 'red';
							} else {
								return 'blue';
							}
						}
						return '';
					},
					getDones: function(item) {if (item.dones) {return item.dones[scope.patient.id]}},
					hideSuiviPrev: function () {return model.prefSettings('hideSuiviPrev')},
					hideSuiviPrevIcon: function() {return model.prefSettings('hideSuiviPrev') ? 'fa-angle-down':'fa-angle-up'},
					toggleAllList: getToggleAllList('spToDo','SHOW_ALL_SUIVI_PREV_4_PT','SHOW_ALL_SUIVI_PREV_4_PT'),
					toggleList: getToggleList('spAll','TOGGLE_SUIVI_PREV','SHOW_ALL_SUIVI_PREV'),
					refresh: function(){
						if (scope.patient && scope.patient.viewbag && scope.patient.viewbag.suiviPrevsPat) delete scope.patient.viewbag.suiviPrevsPat;
						model.suiviPrevs().profFetched = false; if (model.suiviPrevs().prof) delete model.suiviPrevs().prof;
						model.suiviPrevs().patFetched = false; if (model.suiviPrevs().pat[scope.patient.id]) delete model.suiviPrevs().pat[scope.patient.id];
						updateSuiviPrev(scope.patient, scope.patient.viewbag.patData);
					},
					itemActions:[{
						title: 'ADD_SUIVI_PREV_DONE',
						patient: function() { 
							return scope.patient; 
						},
						show: function(item) {
							return item.idPatient!=undefined && item.usage==undefined;
						},
						class: 'fa-plus-square-o',
						classForItem: function(item) { 
							return item.toDo?' red':'';
						},
						onShow:function(){
							utils.showPopoverOverlay(true);
						},
						onHide: function(){
							utils.showPopoverOverlay(false);
						},
						type: 'popover',
						popoverUrl: "/dashboard/resources/ofys/encounter/entry/suiviPrevAdd_popover.html?v=bl",
					},
					{ // TODO POUR LES SUIVISPREV-BASE, IL FAUT RETIRER LES DONE DES ITEMS OU TROUVER UNE MANIÈRE POUR LES A/A LE PATIENT AUSSI. 
						title: 'SHOW_SUIVIS_HISTO',
						show: function(item) {
							return item.doneDate!==undefined || item.usage!==undefined;
						},
						class: 'fa-code-fork',
						classForItem: function(item) { return '';},
						act: function(item){
							var mustShow = true;
							if (item.usage!=undefined) {	//liste prevsBase
								if (item.dones && item.dones[scope.patient.id]) {
									delete item.dones[scope.patient.id];
									mustShow = false;
									scope.suiviprevOptions.showBaseHisto = false;
								} else {
									scope.suiviprevOptions.showBaseHisto = true;
								}
							} else if (item.doneDate!==undefined) {
								if (item.dones && item.dones[scope.patient.id]) {
									delete item.dones[scope.patient.id];
									mustShow = false;
									scope.suiviprevOptions.showPatHisto = false;
								} else {
									scope.suiviprevOptions.showPatHisto = true;
								}
							}
							if (mustShow===true) {
								if (scope.patient.viewbag.suiviPrevsPatDone) {
									item.dones = {};
									item.dones[scope.patient.id] = _.where(scope.patient.viewbag.suiviPrevsPatDone, {idSuiviPrev:(item.idSuiviPrev?item.idSuiviPrev:item.id)})
										.sort(function(a,b) {return b.doneDate-a.doneDate;});
									if (item.dones[scope.patient.id].length==0) {
										item.dones[scope.patient.id].push({note: $filter("translate")('NONE_SUIVIS_HISTO')});
									}
								} else {
									SuiviPrevAccessor.suiviPrevsPatDone(scope.patient.id, function(d){
										scope.patient.viewbag.suiviPrevsPatDone = d;
										item.dones = {};
										item.dones[scope.patient.id] = _.where(d, {idSuiviPrev:(item.idSuiviPrev?item.idSuiviPrev:item.id)}).sort(function(a,b) {
											return b.doneDate-a.doneDate;
										});
										if (item.dones[scope.patient.id].length==0) {
											item.dones[scope.patient.id].push({note: $filter("translate")('NONE_SUIVIS_HISTO')});
										}
									}, function(ms) {
										console.log(ms);
									});
								}
								model.patientSumUpdated(true);
							}
						}
					},
					{
						title: 'EDIT_SUIVI_PREV_DONE',
						patient: function() { 
							return scope.patient; 
						},
						isEditing: true,
						show: function(item) {
						  return item.doneDate;
						},
						class: 'fa-pencil',
						classForItem: function(item) { 
							return '';
						},
						onShow:function(){
							utils.showPopoverOverlay(true);
						},
						onHide: function(){
							utils.showPopoverOverlay(false);
						},
						type: 'popover',
						popoverUrl: "/dashboard/resources/ofys/encounter/entry/suiviPrevAdd_popover.html?v=bl",
					},
					{
						title: 'RETIRER_DES_SUIVIS',
						patient: function() { 
							return scope.patient; 
						},
						isEditing: false,
						isDeleting: true,
						show: function(item) {
							return item.idPatient!=undefined && item.usage==undefined;
						},
						class: 'fa-trash',
						classForItem: function(item) { 
							return ' red';
						},
						onShow:function(){
							utils.showPopoverOverlay(true);
						},
						onHide: function(){
							utils.showPopoverOverlay(false);
						},
						type: 'popover',
						popoverUrl: "/dashboard/resources/ofys/encounter/entry/suiviPrevAdd_popover.html?v=bl",
					},
					{
						title: 'MOD_SUIVIPREV',
						patient: function() { 
							return scope.patient; 
						},
						isEditing: false,
						show: function(item) {
						  return item.usage!=undefined;	//liste prevsBase
						},
						class: 'fa-pencil',
						classForItem: function(item) { 
							return ' blue';
						},
						onShow:function(){
							utils.showPopoverOverlay(true);
						},
						onHide: function(){
							utils.showPopoverOverlay(false);
						},
						type: 'popover',
						popoverUrl: "/dashboard/resources/ofys/encounter/entry/suiviPrevData_popover.html?v=bl",
					}
					],
				};

				function updateSuiviPrev(pt, pd){
					var idProf;
					if (model.user().profil) {
						idProf = model.user().profil.id;
					} else {
						idProf = pt.treatingProfessionnal;
					}
					SuiviPrevAccessor.suiviPrevsPat(pt.id);	// juste pour charger la liste
					if (idProf!=undefined) {
						SuiviPrevAccessor.suiviPrevsProf(idProf);	// juste pour charger la liste
						SuiviPrevAccessor.suiviPrevPatProf({idPat:pt.id, idProf:idProf} , function(res){
							pd.sum.suiviPrev = res.data;
							pd.sum.suiviPrevToDo = res.data.filter(function(a) {return a.toDo===true;});
							pd.loaded.suiviPrev=1;
							model.patientSumUpdated(true);
						}, function(ms) {
							console.log(ms);
						});
					}
				}

				scope.concernOptions  = $.extend({
					title: 'PREOCCUPATIONS',
					tIcon: 'fa-bomb reverse-color-sum',
					isObject: true,
					addObject: false,
					obj: 'ongoingConcernsObjArr',
					dataEdit: {
						defaultItem :{
							noteType:105
						},
						addToViewbag: function(item){
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusNote){
									item.viewbag.focusNote()
								}
							};
						},
						def:{
							hideNoteTypes: true,
							completeType: 18,
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstNote_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.otherrxOptions  =  $.extend({
					title: 'OTHER_RX',
					tIcon: 'fa-plus-square reverse-color-sum',
					isObject: true,
					addObject: false,
					obj: 'otherMedicationsObjArr',
					dataEdit: {
						defaultItem :{
							noteType:107
						},
						addToViewbag: function(item){
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusNote){
									item.viewbag.focusNote()
								}
							};
						},
						def:{
							hideNoteTypes: true,
							completeType: 10,
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstNote_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.mdHistOptions  =  $.extend({
					title: 'MD_HIST',
					tIcon: 'fa-star-o reverse-color-sum',
					isObject: true,
					addObject: false,
					obj: 'medicalHistoryObjArr',
					dataEdit: {
						defaultItem :{
							noteType:104
						},
						addToViewbag: function(item){
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusNote){
									item.viewbag.focusNote()
								}
							};
						},
						def:{
							hideNoteTypes: true,
							completeType: 11,
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstNote_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.atcdMedOptions  =  $.extend({
					title: 'ATCD_MED',
					tIcon: 'fa-star reverse-color-sum',
					showCount: true,
					showImportance:false,
					showImportanceButton:scope.actOptions.mode!=='e',
					idPatient: function() {
						return getPatient().id;
					},
					sliderOptions: sliderOptions,
					obj: 'lstDx',
					actions: getSortActions('sinceDateSP', 'descr[1]'),
					itemActions: scope.actOptions.mode==='e'?[{
						title: 'ATCD_ASPROB',
						class: 'fa-star-half-o',
						classForItem: function(item) { return '';},
						act: function(item){
							var currIdx = scope.patient.viewbag.patData.sum.lstDx.indexOf(item);
							item.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.patient.viewbag.patData.sum.lstProb.push(item);
							scope.patient.viewbag.patData.sum.lstDx.splice(currIdx, 1);
							scope.formOptions.setFormStatus('dirty');
						}
					}]:[],
					dataEdit: {
						defaultItem :{
							status: 0
						},
						addToViewbag: function(item){
							item.viewbag.solvedDynaDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.dateDynaDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.selectDx = function(dx){
								item.viewbag.item.classificationDiagnostic = dx.classification.toLowerCase();
								item.viewbag.item.descrShort = dx.descriptionShort;
								item.viewbag.item.descrLong = dx.descriptionLong;
								item.viewbag.item.code = dx.code;
								item.viewbag.item.codeId = dx.id;
							}
							if(item.code){
								item.viewbag.searchDxCode = item.code;
								item.viewbag.searchDxType = {ref:item.classificationDiagnostic};
							}
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusDetail){
									item.viewbag.focusDetail()
								}
							};
						},
						def: {
							dxStatus: scope.dxStatus,
							removeCode: function(viewbag){
								delete viewbag.searchDxCode;
								delete viewbag.item.classificationDiagnostic;
								delete viewbag.item.code;
								delete viewbag.item.codeId;
								delete viewbag.item.descrLong;
								delete viewbag.item.descrShort
							}
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstDx_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.atcdProbOptions  =  $.extend({
					title: 'ATCD_PROB',
					tIcon: 'fa-star-half-o reverse-color-sum',
					showCount: true,
					showImportance:false,
					showImportanceButton:scope.actOptions.mode!=='e',
					idPatient: function() {
						return getPatient().id;
					},
					sliderOptions: sliderOptions,
					obj: 'lstProb',
					actions: getSortActions('sinceDateSP', 'descr[1]'),
					dataEdit: angular.copy(scope.atcdMedOptions.dataEdit),
					itemActions: scope.actOptions.mode==='e'?[{
						title: 'ATCD_ASDX',
						class: 'fa-star',
						classForItem: function(item) { return '';},
						act: function(item){
							var currIdx = scope.patient.viewbag.patData.sum.lstProb.indexOf(item);
							item.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.patient.viewbag.patData.sum.lstDx.push(item);
							scope.patient.viewbag.patData.sum.lstProb.splice(currIdx, 1);
							scope.formOptions.setFormStatus('dirty');
						}
					}]:[],
				}, angular.copy(medSumListOptions));

				var allergyActions = getSortActions('declaredDateSP', 'descr[1]');
				var flagNoAllergy = {
					//Sort by declared date
					action: function(options, list){
						//Aucune Allergie Connue
						var noAllergy = angular.copy(options.dataEdit.defaultItem);
						noAllergy.note = $filter("translate")('NO_ALLERGY');
						noAllergy.noKnownAllergy = true;
						noAllergy.declaredDateSP = moment().format("YYYY-MM-DD");
						noAllergy.modificationStatus = ModificationStatus.STATUS_UPDATED;
						list.push(noAllergy)
						scope.formOptions.setFormStatus('dirty');
					},
					hide: function(options, list){
						return list && list.filterFast(function(i){
							return i.modificationStatus !== ModificationStatus.STATUS_DELETED;
						}).length > 0;
					},
					translateText: "DECLARE_NO_ALLERGY",
					title:"DECLARE_NO_ALLERGY",
					aIcon: 'fa-ban',
					aBtn: 'btn noAllergyBtn sm',
					name:"noAllergy"
				}

				allergyActions.push(flagNoAllergy);
				scope.allergyOptions  =  $.extend({
					title: 'ALLERGIES',
					tIcon: 'fa-exclamation-triangle red',
					showCount: true,
					obj: 'lstAllergy',
					actions: allergyActions,
					onEdit: function(elem, list){
						if(!elem && list.length === 1 && list[0].noKnownAllergy && list[0].modificationStatus!='STATUS_DELETED'){
							model.notice().warn($filter('translate')('RemoveUnkownAllergyBeforeAdd'));
							return false;
						}else if(elem && elem.noKnownAllergy){
							return false;
						}else{
							return true;
						}
					},
					dataEdit: {
						defaultItem :{
							severity: 0
						},
						addToViewbag: function(item){
							item.viewbag.resolutionDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.itemDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.selectDrug = function(drug){
								item.viewbag.item.drugrefId = drug.id;
								item.viewbag.item.drugrefDesc = drug.name;
								item.viewbag.item.drugrefDescType = EncounterAccessor.allRxAllergyTypeCode[drug.category];
							}
							if(item.drugrefDesc){
								item.viewbag.searchDrugCode = item.drugrefDesc;
							}
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusSubstance){
									item.viewbag.focusSubstance()
								}
							};
						},
						def: {
							severityStatus: scope.severityStatus,
							removeCode: function(viewbag){
								delete viewbag.searchDrugCode;
								delete viewbag.item.drugrefId;
								delete viewbag.item.drugrefDesc;
								delete viewbag.item.drugrefDescType;
							},
						},
						onload: formatForEncounter,
						formReady: function(frm){},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstAllergy_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.intolerenceOptions  =  $.extend({
					title: 'INTOLERANCES',
					tIcon: 'fa-exclamation-circle gold',
					showCount: true,
					obj: 'lstIntolerance',
					actions: getSortActions('declaredDateSP', 'descr[1]'),
					dataEdit: {
						defaultItem :{
							severity: 0
						},
						addToViewbag: function(item){
							item.viewbag.resolutionDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.itemDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.selectDrug = function(drug){
								item.viewbag.item.drugrefId = drug.id;
								item.viewbag.item.drugrefDesc = drug.name;
								item.viewbag.item.drugrefDescType = EncounterAccessor.allRxAllergyTypeCode[drug.category];
								EncounterAccessor.selectDrug({id: drug.id, current: item.viewbag.item}, function(res){
									item.viewbag.item.din = res.data.din;
								});
							}
							if(item.drugrefDesc){
								item.viewbag.searchDrugCode = item.drugrefDesc;
							}
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusSubstance){
									item.viewbag.focusSubstance()
								}
							};
						},
						def: {
							severityStatus: scope.severityStatus,
							removeCode: function(viewbag){
								delete viewbag.searchDrugCode;
								delete viewbag.item.drugrefId;
								delete viewbag.item.drugrefDesc;
								delete viewbag.item.drugrefDescType;
							}
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstAllergy_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				function getPatient(){
					if(scope.patient)return scope.patient;
					if(scope.quickViewData)return scope.quickViewData.pat;
					if(scope.origPatient)return scope.origPatient;
				};

				scope.prescriptionOptions  =  $.extend({
					title: 'PRESCRIPTIONS',
					tIcon: 'fa-medkit reverse-color-sum prescr-button-sum',
					positionClass: 'prescr-button-sum',
					showCount: true,
					obj: 'lstAllPrescription',
					actions: getSortActions('startDate', 'descr[1]'),
					toggleAllList: getToggleAllList('prescr', 'SHOW_ALL_RX', 'SHOW_ONLY_ACTIVE_RX'),
//					cWithReason
					itemActions: scope.actOptions.mode==='e'?[{
						title: 'MedStop_Stop',
						class: 'fa-ban',
						classForItem: function(item) { return '';},
						type: 'popover',
						popoverUrl: "/dashboard/resources/ofys/encounter/entry/stopPrescription_popover.html?v=bl",
					},
					EncounterSummaryCommon.favActionBtn,
					]:[],
					dataEdit: {
						def: {
							model: model,
							inSummary: true,
							rxTypes: _.omit(EncounterAccessor.allRxType, 3),
							patient: getPatient(),
							isPrescription: true
						},
						defaultItem: EncounterSummaryCommon.prescriptionDefaultItem(),
						addToViewbag: EncounterSummaryCommon.prescriptionOnEdit,
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstPrescription_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.prescriptionHxOptions = {
					title: 'HX_PRESCRIPTIONS',
					tIcon: 'fa-history reverse-color-sum prescr-button-sum',
					showCount: true,
					obj: 'lstHxPrescription',
					hasDelete: false,
					hasAdd: false,
					hasEdit: false,
					editReady: false,
					showDownload: true,
					isHx:true,
					toggleAllList: getToggleAllList('hxPrescr', 'SHOW_ALL_HX_RX', 'SHOW_ONLY_ACTIVE_HX_RX'),
					showSection: function(){
						return !inReprescriptionMode(this.obj) && !summaryInEdit();
					},
					onSelect: function(item, options){//when table item is selected.
						//console.log(item);							
					},
					manualUpdateData: function(update, t){
						var pt = scope.patient;
						if (pt.id) {
							pt.viewbag.patData.loaded[t]=2;
							model.patientSumUpdated(true);
							eval(update+"()");	// une des fonctions d'update.
						}
					}
				};

				scope.deviceOptions  =  $.extend({
					title: 'DEVICE',
					tIcon: 'fa-briefcase reverse-color-sum',
					showCount: true,
					obj: 'lstDevice',
					actions: getSortActions('startDate', 'descr[1]'),
					itemActions: scope.actOptions.mode==='e'?[EncounterSummaryCommon.deviceFavActionBtn]:[],
					dataEdit: {
						def: {
							inSummary: true,
							patient: getPatient(),
							isDevice: true
						},
						defaultItem : EncounterSummaryCommon.deviceDefaultItem(),
						addToViewbag: EncounterSummaryCommon.deviceOnEdit,
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstDevice_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.atcdCxOptions  =  $.extend({
					title: 'ATCD_CX',
					tIcon: 'fa-hand-scissors-o reverse-color-sum',
					showCount: true,
					showImportance:false,
					showImportanceButton:scope.actOptions.mode!=='e',
					idPatient: function() {
						return getPatient().id;
					},
					sliderOptions: sliderOptions,
					obj: 'lstIntervention',
					actions: getSortActions('sinceDateSP', 'descr[1]'),
					dataEdit: {
						defaultItem :{
						},
						addToViewbag: function(item){
							item.viewbag.adateDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.selectDx = function(dx){
								item.viewbag.item.classificationDiagnostic = dx.classification;
								item.viewbag.item.descrShort = dx.descriptionShort;
								item.viewbag.item.descrLong = dx.descriptionLong;
								item.viewbag.item.code = dx.code;
								item.viewbag.item.codeId = dx.id;
							}
							if(item.code){
								item.viewbag.searchDxCode = item.code;
							}
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusDetail){
									item.viewbag.focusDetail()
								}
							};
						},
						def: {
							removeCode: function(viewbag){
								delete viewbag.searchDxCode;
								delete viewbag.item.classificationDiagnostic;
								delete viewbag.item.code;
								delete viewbag.item.codeId;
								delete viewbag.item.descrLong;
								delete viewbag.item.descrShort
							}
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstIntervention_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.habitusOptions  =  $.extend({
					title: 'HABITUS',
					tIcon: 'fa-bicycle reverse-color-sum',
					showCount: true,
					obj: 'lstLifeHabit',
					actions: getSortActions('startDate', 'descr[1]'),
					dataEdit: {
						defaultItem :{
							typeHabit:5,
							frequency: 0
						},
						addToViewbag: function(item){
							item.viewbag.startDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.endDateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusHabits){
									item.viewbag.focusHabits()
								}
							};
						},
						def: {
							habitTypes: scope.habitTypes,
							frequencyOptions: function(i){
								return scope.frequencyOptions[i];
							}
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstLifeHabit_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.immunizationOptions  =  $.extend({
					title: 'IMMUNISATIONS',
					tIcon: 'fa-bug reverse-color-sum',
					showCount: true,
					obj: 'lstAllImmunization',
					actions: getSortActions('vaccinationDateSP', 'descr[1]'),
					toggleAllList: getToggleAllList('immun', 'SHOW_ALL_IMMUN', 'SHOW_SUMM_IMMUN'),
					dataEdit: {
						defaultItem :{
							showInPatientSummary: true,
							refused: false,
						},
						addToViewbag: function(item){
							item.viewbag.dateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.selectDx = function(dx){
								item.viewbag.item.classificationDiagnostic = dx.classification;
								item.viewbag.item.descrShort = dx.descriptionShort;
								item.viewbag.item.descrLong = dx.descriptionLong;
								item.viewbag.item.code = dx.code;
								item.viewbag.item.codeId = dx.id;
							}
							if(item.code){
								item.viewbag.searchDxCode = item.code;
							}
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusCode){
									item.viewbag.focusCode()
								}
							};
						},
						def: {
							removeCode: function(viewbag){
								delete viewbag.searchDxCode;
								delete viewbag.item.classificationDiagnostic;
								delete viewbag.item.code;
								delete viewbag.item.codeId;
								delete viewbag.item.descrLong;
								delete viewbag.item.descrShort
							}
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstImmunization_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.reminderOptions =  $.extend({
					title: 'RemindersAndHisto',
					tIcon: 'fa-hand-pointer-o reverse-color-sum',
					showCount: true,
					obj: 'lstRappel',
					actions: getSortActions('rappelDateSP', 'descr[1]'),
					dataEdit: {
						defaultItem :{
						},
						addToViewbag: function(item){
							item.viewbag.dateOptions = angular.copy(scope.partialDateOptions);
							item.viewbag.dateOptions.acceptFutureDate = true;
							item.viewbag.onChangeEditState = function(item, def){
								if(item.viewbag.focusReminderDate){
									item.viewbag.focusReminderDate()
								}
							};
						},
						onload: formatForEncounter,
						formReady: function(frm){
						},
						editFormUrl: '/dashboard/resources/ofys/encounter/entry/lstRappel_enc_entry_edit.html?v=bl',
						onsave: function (savedItem) {
						},
					},
				}, angular.copy(medSumListOptions));

				scope.growthChart = "";
				scope.closeGrowthView = function(){
					$timeout(function() {
						angular.element('#btn-show-growth-curve').triggerHandler('click');
					});
				};
				scope.getGrowthChart = function(){
					var growthChartData = {
						blackAndWhite: false
					}
					var Gender = {
						"I":'INCONNU',
						"M":'MASCULIN',
						"F": 'FEMININ'
					}
					growthChartData.pat = _.omit(scope.patient,
							['viewbag','lstConsentement','lstPatientIdentifier','lstPatientProfessionnal','bloodType','messageAppointment','lastVerificationDate','lastActivityDate',
								'expirationCAM','fatherName','spouseName','motherName','motherHin','fatherHin','tutorName','lastProfileVersion','treatingProfessionnal','txProfName',
								'isSensible','isScanned','custodyTerms','lstPatientAlerts','mother','father','tutor','inactiveDate','inactiveRaison',
								'b2bInformation','sofyAuthorized','className','user','searchLastName','searchFirstName','race','maritalStatus','note',
								'age','oAge','ageStr','citizenship','decorators','lstContactInformation','lstAddress','lstSites']);
					growthChartData.gender = Gender[growthChartData.pat.gender];
					if(scope.patient.viewbag.patData.sum.lstMeasurement){
						var mesures = angular.copy(scope.patient.viewbag.patData.sum.lstMeasurement);
						growthChartData.measurementsForGraph = [];
						for(var i=0; i < mesures.length; i++){
							mesures[i].entryDatetime = mesures[i].timeVitalSign;
							growthChartData.measurementsForGraph.push(mesures[i]);
						}
						DocAccessor.growthChart(growthChartData,function(res){
							scope.growthChart = res.data? res.data: res;
						});
					}
				}

				//Appeler par le manual update. avec un eval
				function updateHxRx(){
					scope.patient.viewbag.patData.loaded.hxrx = 2;
					model.patientSumUpdated(true);
					EncounterAccessor.searchInactiveRx(scope.patient.id, function(res){
						var pd = scope.patient.viewbag.patData;
						var arr = [];
						var arrWithReason = [];
						Object.keys(res.data[0]).forEach(function(e) {
						    // Get the key and assign it to `connector`
							var newObj = {key:e, val:res.data[0][e]};
						    arr.push(newObj);
						});
						Object.keys(res.data[1]).forEach(function(e) {
							// Get the key and assign it to `connector`
							var newObj = {key:e, val:res.data[1][e]};
							arrWithReason.push(newObj);
						});
						pd.sum.lstHxPrescription = arr;
						pd.sum.lstHxPrescriptionWithReason = arrWithReason;
						pd.loaded.hxrx = 1;
						model.patientSumUpdated(true);
					});
				}

				scope.resizeGrowChart = angular.noop;

				scope.activeRemindersCount = function() {
					var cpt = scope.patient;
					if (cpt && cpt.viewbag && cpt.viewbag.patData) {
						return cpt.viewbag.patData.counts.sumActReminders;
					}
				};

				scope.filterActivePlan = function(l) {
					return !l.isDoneB && !l.isDeletedB;
				};
				scope.filterAllPlan = function(l) {
					return true;
				};

				if (typeof scope.inLinked == 'undefined') {
					scope.inLinked = false;
				}
				scope.showAddLinkButton = function() {
					var b = false;
					if (scope.quickViewData && angular.isDefined(scope.quickViewData.linkModeOn)) {
						b = scope.quickViewData.linkModeOn > 0;
					}
					return b;
				};

				scope.addItemToLinks = function(type, item, fctDesc) {

					if (scope.quickViewData && scope.quickViewData.linkModeOn>0) {
						var idDesc;
						if (fctDesc) {
							idDesc = fctDesc();
						}
						var description = "";
						if (idDesc) {
							for(var j=0;j<idDesc.length;j++) {
								if (item.descr[idDesc[j]]) {
									description += item.descr[idDesc[j]] + " ";
								}
							}
						} else {
							description += item + " ";
						}
						if (description.trim().length>0) {
							// ajouter le lien.
							var itemToAdd = {t:type, d: description.trim()};
							if (item.id) {
								itemToAdd.id = item.id;
							}
							modSumLink(itemToAdd);
						}
					}
				};



				scope.addAllItemsToLinks = function() {
					if (scope.patient.oAge && scope.patient.oAge.totalMonths < 253) {
						scope.addItemsToLinks('ak', scope.patient.viewbag.patData.sum.lastMesure, scope.getMs);
					}
					scope.addItemsToLinks('al', scope.patient.viewbag.patData.sum.lstAllergy, scope.getAll);
					scope.addItemsToLinks('ao', scope.patient.viewbag.patData.sum.lstIntolerance, scope.getAll);
					scope.addItemsToLinks('bx', scope.patient.viewbag.patData.sum.lstPrescription, scope.getRx);
					scope.addItemsToLinks('by', scope.patient.viewbag.patData.sum.lstDevice, scope.getRx);
					scope.addItemsToLinks('db', scope.patient.viewbag.patData.sum.lstProb, scope.getDx);
					scope.addItemsToLinks('dx', scope.patient.viewbag.patData.sum.lstDx, scope.getDx);
					scope.addItemsToLinks('fx', scope.patient.viewbag.patData.sum.lstIntervention, scope.getIt);
					scope.addItemsToLinks('hm', scope.patient.viewbag.patData.sum.medicalHistoryArr);
					scope.addItemsToLinks('im', scope.patient.viewbag.patData.sum.lstImmunization, scope.getImm);
					scope.addItemsToLinks('iq', scope.patient.viewbag.patData.sum.lstHisto, scope.getRap);
					scope.addItemsToLinks('ir', scope.patient.viewbag.patData.sum.lstRappel, scope.getRap);
					scope.addItemsToLinks('sf', scope.patient.viewbag.patData.sum.familyHistoryArr);
					scope.addItemsToLinks('sh', scope.patient.viewbag.patData.sum.socialHistoryArr);
				};

				scope.addItemsToLinks = function(type, items, fctDesc) {
					if (scope.quickViewData && scope.quickViewData.linkModeOn > 0 && items) {
							if (items.length != undefined) {
								if (items.length>0) {
									var idDesc;
									if (fctDesc) {
										idDesc = fctDesc();
									}
									for(var i=0;i<items.length;i++) {
										var description = "";
										if (idDesc) {
											for(var j=0;j<idDesc.length;j++) {
												if (items[i].descr[idDesc[j]]) {
													description += items[i].descr[idDesc[j]] + " ";
												}
											}
										} else {
											description += items[i] + " ";
										}
										if (description.trim().length>0) {
											var itemToAdd = {t:type, d: description.trim()};
											if (items[i].id) {
												itemToAdd.id = items[i].id;
											}
											modSumLink(itemToAdd);
										}
									}
								}
							} else {
								// un objet et non une liste
								var idDesc;
								if (fctDesc) {
									idDesc = fctDesc();
								}
								var description = "";
								if (idDesc) {
									for(var j=0;j<idDesc.length;j++) {
										if (items.descr[idDesc[j]]) {
											description += items.descr[idDesc[j]] + " ";
										}
									}
								} else {
									description += items + " ";
								}
								if (description.trim().length>0) {
									var itemToAdd = {t:type, d: description.trim()};
									if (items.id) {
										itemToAdd.id = items.id;
									}
									if (itemToAdd && itemToAdd.t && itemToAdd.t === 'ak') {
										itemToAdd.d += $filter('translate')("linkGrowthChart")
									}
									modSumLink(itemToAdd);
								}
							}
						}
				};

				// ajout du lien du sommaire
				function modSumLink(itemToMod) {
					function getActivity(){
						if(scope.quickViewData.qvActData.delegateActivity){
							return scope.quickViewData.qvActData.delegateActivity();
						}else{
							return scope.quickViewData.qvActData;
						}
					}
					var iToMod = itemToMod.t +'Į'+(itemToMod.id?itemToMod.id:'')+'Į'+ itemToMod.d;
					if (!scope.inLinked) {	// ne peut être appelé que de la liste Sum (liste de gauche)
						if (angular.isUndefined(getActivity().objAddedLinks)) {
							getActivity().objAddedLinks = [];
						}
						if (angular.isUndefined(getActivity().addedLinksUid)) {
							getActivity().addedLinksUid = [];
						}
						if (angular.isUndefined(getActivity().sumAddedLinks)) {
							getActivity().sumAddedLinks = [];
						}
						if(!angular.isUndefined(getActivity().initLinking)){
							getActivity().initLinking(['addedLinksUid', 'sumAddedLinks', 'objAddedLinks'])
						}
						var idx = $.inArray(iToMod, getActivity().addedLinksUid);
						if (idx==-1) {
							getActivity().addedLinksUid.push(iToMod);
							getActivity().sumAddedLinks.push(itemToMod);
							getActivity().sumAddedLinks.sort(function(a,b) {
								if (a.t < b.t)
									  return -1;
									if (a.t > b.t)
									  return 1;
									return 0;
							});
							// tenir à jour l'objet qui sera sauvé dans la bd.
							idx = -1;
							if (getActivity().addedLinks===undefined) {
								getActivity().addedLinks = [];
							}
							for(var i=0;i<getActivity().addedLinks.length; i++) {
								if ('sum'==getActivity().addedLinks[i].substr(0, 3)) {
									idx = i;
									break;
								}
							}
							// le key of domain valeur est ajouté dans le presave form.
							if (idx===-1) {
								getActivity().addedLinks.push('sumı' + iToMod);
							} else {
								getActivity().addedLinks[idx] += '˜' + iToMod;
							}
							model.formLinkUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
						}
					}
				}
				// les descr qu'on veut dans la description qui sera le nom du lien ajouté. On n'a pas tjrs de id...
				scope.getAll = function() {
					return [0,1,2,3];
				};
				scope.getMs = function() {
					return [0,1,2];
				};
				scope.getRx = function() {
					return [0,1];
				};
				scope.getDx = function() {
					return [0,1];
				};
				scope.getIt = function() {
					return [0,1];
				};
				scope.getImm = function() {
					return [0,1,2];
				};
				scope.getRap = function() {
					return [0,1];
				};

				// function filterNotInArray(a) {
				// 	var b = true;
				// 	if (scope.quickViewData.addedLinksUid) {
				// 		b = $.inArray(a.uid, scope.quickViewData.addedLinksUid)>-1;
				// 	}
				// 	return b;
				// }
				model.formLinkUpdated(true);	// il faut caller l'update ici au cas ou en mode true et qu'a changé de tab

			}
		};
	}]);

	patient.directive('dsqallpt', ['$timeout', 'Notification','DashWebSocket', 'DashAPI', 'model','PatientUtils',
		function($timeout, Notification, DashWebSocket, DashAPI, model, PatientUtils){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				scope.closeView = function(){
					$timeout(function() {
						angular.element('#search-dsq-all-pt').triggerHandler('click');
					});
				};
				
				scope.neededSignFirst = false;
				scope.sendingPtSearchRequest = false;
				scope.searchCriteria = { start: moment().subtract(2, 'years').format("YYYY-MM-DD"), end: moment().format("YYYY-MM-DD")};

				scope.hasStatusMessages = function() {					
					var status = scope.getStatus();
					return status !== undefined && (status.warnings.length > 0 || status.errors.length > 0 || status.infos.length > 0);
				}
				
				scope.getStatus = function() {
					var patData = getPatientData();
					if (patData.dsqStatus === undefined) {
						patData.dsqStatus = DashAPI.newSimpleStatus();
					}
					return patData.dsqStatus;
				};

				function getPatientData() {
					var patData = scope.patient.viewbag.patData;
					return patData;
				}

				function setStatus(v) {
					var patData = getPatientData();
					if (patData !== undefined) {
						patData.dsqStatus = v;
					}
				}

				Notification.registerHandler('dsqPtAllSearch', function(msg){
					scope.sendingPtSearchRequest = false;
					
//					var status = DashAPI.getSimpleStatus(msg.data.status);
//					setStatus(status);
					
					var statusError = DashAPI.handleReturnObject(msg.data.status);
					
					if (statusError=='ERROR') {
												
					} else if (statusError=='WARNING') {
						// signature demandé? Si oui et succès, on aura OK ensuite
//						scope.sendingPtSearchRequest = true;
//						scope.neededSignFirst = true;
					} else if (statusError=='OK') {
//						if (scope.neededSignFirst==true) {
//							// donc a réussi le call, incluant l'obtentino des signature
//							scope.searchAllDsq();
//						}
					}
					
					model.actUpdated(true);
				}, scope);

				Notification.registerHandler('dsqPtAllSearchProgress', function(msg){
					scope.sendingPtSearchRequest = false;
				}, scope);

				Notification.registerHandler('dsqAllSearchConsent', function(msg){
					var status = DashAPI.handleReturnObject(msg.data.status);
				}, scope);

				function updateLab(dsqList){
					if(dsqList){
						scope.patient.viewbag.patData.lab = scope.patient.viewbag.patData.lab.concat(dsqList);
						model.actUpdated(true);
					}
					// var showList = scope.patient.viewbag.patData.lab.filterFast(scope.filterAllLab(false));
					// console.log(showList);
				}

				scope.searchAllDsq = function(){
					if (scope.sendingPtSearchRequest===false) {	// il faut empêcher les call répétés quand un est actif
						scope.sendingPtSearchRequest = true;
						scope.neededSignFirst = false;
						scope.searchCriteria.whatToDo = 1;
						scope.searchCriteria.patientId = scope.patient.id;
						DashWebSocket.sendRequest("/dashboard/dsq/ws/pt/search", scope.searchCriteria);
						scope.closeView();
					}
				};
			}
		};
	}]);

	patient.directive('patientRxDsq', ['$filter','$q', 'model', 'Notification', 'DashWebSocket',
		function($filter, $q, model, Notification, DashWebSocket){
		return {
			restrict: 'EA',
			scope: true,
			templateUrl:'/dashboard/resources/ofys/pat/patientRxDsq.html?v=bl',
			link: function(scope, element, attrs){
				scope.actOptions = scope.$eval(attrs.options);
				scope.resetData = function(){
					if (!scope.patient && scope.quickViewData) {	// donc on a ouvert un quickview
						scope.patient = scope.quickViewData.pat;
					}
				};
				scope.resetData();
//				if (scope.activePatientIdForLstDsq !== scope.patient.id && scope.lstDsq) {
//					delete scope.lstDsq;
//				}
//				if (scope.lstDsq===undefined) {
//					DashWebSocket.sendRequest("/dashboard/dsq/ws/enc/favs", {patientId: scope.patient.id});
//				}
				if(scope.patient && scope.patient.niu){
					scope.dsqIdentified = true;
				}

//				var dsqEncFavsResponseHandlerId = Notification.registerHandler('dsqEncFavsResponse', function(msg){
//					if(msg.data.status.severity === "OK"){
//						//Patients dsq
//						scope.lstDsq = msg.data.obj;
//						scope.activePatientIdForLstDsq = scope.patient.id;
//					}
//				}, scope);
			}
		}
	}]);

	patient.directive('srvyView', ['DashAPI', 'model', '$filter','PatientAccessor', '$timeout', '$q', '$log', 'Event','QValidation','patientShowTitles', '$sce',
	                           function(DashAPI, model, $filter, PatientAccessor, $timeout, $q, $log, Event, QValidation, patientShowTitles, $sce){

		function getData(scope, doc){
			if(doc.surveyId != undefined){
				scope.survey.html = $sce.trustAsHtml('<span class=""><i class="fa fa-spinner fa-spin fa-4x"></span>');
				PatientAccessor.responsePatientSurvey({idQuest:doc.surveyId, idResp:doc.responseId}, function success(response){
					if (response.data==undefined || response.data.length==undefined || response.data.length==0 || response.data[0].submitdate==undefined) {
						model.notice().warn($filter('translate')('ERR_GET_SURVEY'));
						return;
					}
					var srvHtml = '<div id = "page_id_to_print">';
					var lastKey = '____';
					for (var i=0; i<response.data.length; i++) {
						var value0 = response.data[i];		
						Object.entries(value0).forEach(([key, value1]) => {
							for (var j=0; j<value1.length; j++) {
								var value1 = value1[j];
								if (key=='submitdate') {
									Object.entries(value1).forEach(([k, v]) => {
										srvHtml += '<div style="margin:0px 0px 15px 5px">' + k + ': ' + v;
//										srvHtml +=  '<span style="float:right"><span style="padding-right: 3px;padding-left: 3px;" onclick="survey.printWindow(\'page_id_to_print\')">Print</span>'
										srvHtml += '</div> ';
									});
								} else {
									// maintenant, on a des key variables , genre G02Q01 ou G02Q01[S001]
									if (lastKey != '____' && !key.startsWith(lastKey) ) {
										srvHtml += "</div>";
										srvHtml += '<div style="border-bottom: 2px solid burlywood; margin: 0px 80px 10px 80px;"> </div>';
									}
									Object.entries(value1).forEach(([k, v]) => {
										if (key.startsWith(lastKey))  {
											var isNotComment = key.indexOf('comment')==-1;
											var resp = isNotComment===false ? '' : '&nbsp;&#8594;&nbsp;';
											if (isNotComment || ''!=v ) {
												srvHtml += '<div style="margin: 0px 0px 5px 25px;">' + k + 
												'<span style="font-weight:800;padding-left:10px;">' + (v&&v!='' ?  resp +v:'') + '</span></div>';						
											}
										} else {
											lastKey = key;
											srvHtml += '<div style="margin: 0 0 5px 0px;">';
											srvHtml += '<div style="margin: 0px 0px 5px 5px;">' + k + 
												'<span style="font-weight:800;padding-left:10px;">' + (v&&v!='' ? '&nbsp;R.&nbsp;'+v:'') + '</span></div>';						
												// '<span style="font-weight:800;padding-left:10px;">' + (v&&v!='' ? '&nbsp;&#8594;&nbsp;'+v:'') + '</span></div>';						
										}
									});
								}
							}
						});
					}
					if (lastKey != '____') {
						srvHtml += '</div>';
						srvHtml += '<div style="border-bottom: 2px solid burlywood; margin: 0px 80px 10px 80px;"> </div>';
					}
					srvHtml += '</div>';
					scope.survey.html = $sce.trustAsHtml(srvHtml);
					
					scope.showPrint = true;
					scope.printWindow = function(pageId) {
						// ne fonctionne pas.
					    var mywindow = window.open('', 'PRINT', 'height=600,width=800');
					    mywindow.document.write('<html><head><title></title>');
					    mywindow.document.write('</head><body >');
					    mywindow.document.write(document.getElementById(pageId).innerHTML);
					    mywindow.document.write('</body></html>');
					
					    mywindow.document.close(); // necessary for IE >= 10
					    mywindow.focus(); // necessary for IE >= 10*/
					
					    mywindow.print();
					    // mywindow.close();
				
					    return true;
				    };
				});
			}
		}

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/srvy_view.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				function setViewOptions(options){
					scope.viewOptions = {};
					if(options){
						$.extend(scope.viewOptions, options)
					}
				}

				function update(n, o, scope){
					// stackCopy = "";
					scope.survey = n;
					scope.titleNoTranslate = n['surveyTitle_'+ DashAPI.lang];				
					setViewOptions(scope.$eval(attrs.options));
					getData(scope, scope.survey);
				}

				scope.$watch(attrs.srvy, update);

				scope.resizeIframe = function(elem){
					elem[0].style.height = 0;
					elem[0].style.height = (elem[0].contentWindow.document.body.scrollHeight + 40)+ 'px';
				};

			}
		};
	}]);



})();