function Mask(input, fnUpdate) {
	this.input = $(input);
	this.regY = /^(1|2|19|20|(19|20)[0-9]{1,2})$/;
	this.regYF = /^(19|20)[0-9]{2}$/;
	this.regM = /^(0|1|0[1-9]|1[0-2])$/;
	this.regMF = /^(0[1-9]|1[0-2])$/;
	this.regD = /^([0-3]|[0-2][1-9]|3[0-1])$/;
	this.regDF = /^([0-2][1-9]|3[0-1])$/;
	this.lastValue = "";
	this.fnUpdate = fnUpdate;
	
	this.init = function() {
		var that = this;
		this.input.keyup(function() {
			try {
				
			var m = $(this);
			var val = m.val();
			var finalValue = "";
			//console.log("keyup: "+val);
			
			var ye = val.length > 0?val.substring(0, Math.min(4,val.length)) : null;
			var me = val.length > 5? val.substring(5, Math.min(7,val.length)) : null;
			var de = val.length > 8? val.substring(8): null;

			if (that.lastValue == val+"/") {
				that.lastValue = val;
				return;
			}
			if (ye != null) {
				//YEAR
				var yv = ""
				if (that.regY.test(ye) ) {
					yv = ye;
					if (that.regYF.test(ye) ) {
						yv = ye+"/";
					}
					finalValue += yv;
				} else {
					finalValue = that.lastValue;
					me=null;
				}
			}
			if (me != null && finalValue.length == 5) {
				//MONTH
				var mv = ""
				if (that.regM.test(me) ) {
					mv = me;
					if (that.regMF.test(me) ) {
						mv = me+"/";
					}
					finalValue += mv;
				} else {
					finalValue = that.lastValue;
					de=null;
				}
			}
			if (de != null && finalValue.length == 8) {
				//DAY
				var dv = ""
				if (that.regD.test(de) ) {
					finalValue += de;
				} else {
					finalValue = that.lastValue;
				}
			}
			that.lastValue = finalValue;
			m.val(finalValue);
			that.fnUpdate();
			}catch(e){alert(e.message)}
		});
	}
	this.init();
}
var alertRX = false;
function buildImportationBox(id, content, idRx) {
	if ($("#"+id).find("#imp-main-div-"+id).size() == 0) {
		var mDiv = $("<div>");
		var ul = $("<ul>");
		var li = $("<li>");
		var a = $("<a>");
		var div = $("<div>");
		var bu = $("<div>");
		var clear1 = $("<div>");
		var clear2 = $("<div>");
		
		bu.text("Confirmer l'importation");
		bu.css( {
			"border":"1px solid rgb(118,195,62)",
			"background-image": "linear-gradient(to bottom, rgba(255,255,255,0.2), rgba(190,190,190,0.3) 40%, rgba(130,130,130,0.4) 60%, rgba(190,190,190,0.3) 75%, rgba(255,255,255,0.2) 100%)",
			"box-shadow": "1px 1px 0 rgba(100, 100, 100, 0.3) inset,-1px -1px 0 rgba(100, 100, 100, 0.3) inset, 1px 1px 2px rgba(0, 0, 0, 0.2), -1px -1px 2px rgba(0, 0, 0, 0.2)",
			"background-color":"rgb(148,235,82)",
			"border-radius":"5px",
			"text-align":"center",
			"padding":"5px",
			"margin":"5px",
			"cursor":"pointer",
			"float":"right",
		}).hover(
			function() {
				$(this).css("background-color","rgb(161,250,92)");
			},
			function() {
				$(this).css("background-color","rgb(148,235,82)");
			}
		).click(function() {
			
			if (importFinalDispense(id)) {
				if (alertRX) {
					alert("idRx: "+idRx)
					alertRX = false;
				}
				importMedocRecall(idRx, id);
/*				var td = $(".table-list-dispenses, .dispense-rx-"+idRx).find(".import-td-"+id+", .import-td-rx-"+idRx);
				td.children().remove();
				td.text("Déjà importé");
				td.css({
					"text-decoration":"none",
					"cursor":"auto",
					"color":"grey",
				});
				td.off('click');
				$("#"+id).find("#imp-main-div-"+id).remove();
				$("#"+id).hide();*/
			} else {
				showError("L'importation a \u00E9chou\u00E9.");
			}
		});
		
		clear1.css("clear","both");
		clear2.css("clear","both");
		
		a.text("Importation - "+id);
		a.attr("href","#imp-div-"+id);
		mDiv.attr("id", "imp-main-div-"+id);
		
		div.attr("id","imp-div-"+id);
		
		li.append(a);
		ul.append(li);
		div.append(content);
		mDiv.append(ul).append(div);
		mDiv.append(clear1).append(bu).append(clear2);
		
		$("#"+id).prepend(mDiv);
		mDiv.tabs();
	}
}

function fixDate(msg, dateS, id) {
	$("#"+id).val(dateS);
	alert(msg);
}
function importMedocRecall(idRx, id) {
	var td = $(".table-list-dispenses, .dispense-rx-"+idRx).find(".import-td-"+id+", .import-td-rx-"+idRx);
	td.children().remove();
	td.text("Déjà importé");
	td.css({
		"text-decoration":"none",
		"cursor":"auto",
		"color":"grey",
	});
	td.off('click');
	$("#"+id).find("#imp-main-div-"+id).remove();
	$("#"+id).hide();

}


function dsqResponse(json) {
	try {
	//log(json)
	//$(document.body).prepend($("<div>").text(json))
	var obj = $.parseJSON(json);
	$(".error").hide();

	log("OBJ.NAME:"+obj.name);
	if (obj.name == "getConsent") {
		if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		} else if (obj.response.hasAccepted){
			$("#consent-bu").hide();
			if (obj.response.hasPastRefusal) {
				$(".table-list-refusal").children().remove();
				$(".table-list-refusal").append(obj.html);
			}
			$(".need-consent>.header").slideUp(200,function() {
				$(".need-consent>.body").slideDown(1000);
				if (firstCall.getConsent) {
					firstCall.getConsent = false;
					listPrescriptionsOE();
					listMedicationsDM();
					listDispenses();
				}
			});
		} else if (typeof(obj.response.hasAccepted) != 'undefined' && !obj.response.hasAccepted) {
			$("#consent-bu").hide();
			listPrescriptionsOE();
			showError("Le patient a refus\u00E9 l'acc\u00E8s \u00E0 ses donn\u00E9es.")
		}
	} else if (obj.name == "retract") {
		if (obj.response.NUI != null && typeof(obj.response.NUI) != 'undefined' && obj.response.boolResponse) {
			$("#detail-oe-"+obj.response.NUI).remove();
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	} else if (obj.name == "listRefusal") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
			$(".table-list-refusal").children().remove();
			$(".table-list-refusal").append(obj.html);
			$(".status-refusal").text("chargement complété.");
			$(".bu-refusal").attr("disabled",true);
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	} else if (obj.name == "importDispenseDetail") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			$(document.body).prepend($("<div>").text(json));
			
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
			var idRx = nh.attr("idRx");
			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				var st = $(document).scrollTop();
				buildImportationBox(idContainer, nh, idRx);
				$("#"+idContainer).show();
				$("#"+idContainer).children(".to-tabulate").tabs("option", "active",1);
				$(document).scrollTop(st);
			}
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	} else if (obj.name == "listDispenses") {
		try {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
			$(".tb-dispenses .loaded").text(obj.response.qrr.originalTotalQuantity - obj.response.qrr.resultRemainingQuantity);
			$(".tb-dispenses .maxsize").text(obj.response.qrr.originalTotalQuantity);

			$(".table-list-dispenses").children().remove();
			$(".table-list-dispenses").append(obj.html);
			$(".table-list-dispenses").find(".to-tabulate").tabs({
				beforeActivate: function(event, ui) { 
					if (ui.newPanel.children("p").size() == 1 && typeof(ui.newPanel.attr("idObj")) != 'undefined' && ui.newPanel.attr("idObj") != null  && ui.newPanel.attr("idObj").trim().length > 0) {
						getDrugDispensedDetail(ui.newPanel.attr("idObj"));
					}
				}
			});

			if (typeof(obj.importationInfo) != 'undefined' && obj.importationInfo != null) {
				for (var i = 0; i < obj.importationInfo.length; i++) {
					var id = obj.importationInfo[i].id;
					var td = $(".table-list-dispenses").find(".import-td-"+id);
					td.attr("idObj",id);
					td.show();
					if (obj.importationInfo[i].canImport) {
						var chk = $("<input type='checkbox'/>")
						chk.addClass("chk-import");
						chk.attr("idObj",id);
						chk.css("margin-right","10px");
						
						var span = td.parent().children().first().next().children();
						if (span.size() == 0) {
							chk.addClass("chk-actif");
						}
						var span = $("<span>");
						td.append(chk).append(span);
						span.text("Importer");
						span.attr("idObj",id);
						span.css({
							"text-decoration":"underline",
							"color":"blue",
							"cursor":"pointer",
						});
						span.click(function() {
							if ($("#"+$(this).attr("idObj")).find("#imp-main-div-"+id).size() == 0) {
								IDDispenses($(this).attr("idObj"));
							} else {
								$("#"+$(this).attr("idObj")).show();
							}
						});
					} else {
						td.text("D\u00E9j\u00E0 import\u00E9");
						td.css({
							"color":"grey",
						});
					}
				}
			}
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
		} catch(e){alert(e.message+"")}
	} else if (obj.name == "getDispenseDetail") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
//			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-dispense-"+idContainer).children().remove();
				$("#detail-dispense-"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-dispenses").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-dispenses").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}
	} else if (obj.name == "listPrescriptionsOE") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
			$(".tb-prescriptionOE .loaded").text(obj.response.qrr.originalTotalQuantity - obj.response.qrr.resultRemainingQuantity);
			$(".tb-prescriptionOE .maxsize").text(obj.response.qrr.originalTotalQuantity);

			$(".table-list-listPrescriptionsOE").children().remove();
			$(".table-list-listPrescriptionsOE").append(obj.html);
			$(".table-list-listPrescriptionsOE").find(".to-tabulate").tabs({
				beforeActivate: function(event, ui) { 
					if (ui.newPanel.children("p").size() == 1 && typeof(ui.newPanel.attr("idObj")) != 'undefined' && ui.newPanel.attr("idObj") != null  && ui.newPanel.attr("idObj").trim().length > 0) {
						if (ui.newPanel.attr("objType") == "drug") {
							getDrugDetailOE(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"));
						} else if ( ui.newPanel.attr("objType") == "device" ) {
							getDeviceDetail(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"));
						}
					}
				}
			});

		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	} else if (obj.name == "listPrescriptionsDM") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
			$(".tb-prescriptionDM .loaded").text(obj.response.qrr.originalTotalQuantity - obj.response.qrr.resultRemainingQuantity);
			$(".tb-prescriptionDM .maxsize").text(obj.response.qrr.originalTotalQuantity);

			$(".table-list-listPrescriptionsDM").children().remove();
			$(".table-list-listPrescriptionsDM").append(obj.html);
			$(".table-list-listPrescriptionsDM").find(".to-tabulate").tabs({
				beforeActivate: function(event, ui) { 
					if (ui.newPanel.children("p").size() == 1 && typeof(ui.newPanel.attr("idObj")) != 'undefined' && ui.newPanel.attr("idObj") != null  && ui.newPanel.attr("idObj").trim().length > 0) {
						if (typeof(ui.newPanel.attr("isDetail")) != 'undefined') {
							getDrugDetail(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"), "#"+ui.newPanel.attr("id"));
						}
						else if (typeof(ui.newPanel.attr("isDispense")) != 'undefined') {
							getDrugDispenses(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"), "#"+ui.newPanel.attr("id"));
						}
					}
				}
			});
			
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	} else if (obj.name == "listMedicationsDM") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
			$(".tb-medicationDM .loaded").text(obj.response.qrr.originalTotalQuantity - obj.response.qrr.resultRemainingQuantity);
			$(".tb-medicationDM .maxsize").text(obj.response.qrr.originalTotalQuantity);

			$(".table-list-listMedicationsDM").children().remove();
			$(".table-list-listMedicationsDM").append(obj.html);
			$(".table-list-listMedicationsDM").find(".to-tabulate").tabs({
				beforeActivate: function(event, ui) { 
					if (ui.newPanel.children("p").size() == 1 && typeof(ui.newPanel.attr("idObj")) != 'undefined' && ui.newPanel.attr("idObj") != null  && ui.newPanel.attr("idObj").trim().length > 0) {
						if (typeof(ui.newPanel.attr("isMed")) != 'undefined') {
							listMedication_getMedicationDetail(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"), "#"+ui.newPanel.attr("id"));
						} else if (typeof(ui.newPanel.attr("isDetail")) != 'undefined') {
							listMedication_getPrescriptionDetail(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"), "#"+ui.newPanel.attr("id"));
						} else if (typeof(ui.newPanel.attr("isDispense")) != 'undefined') {
							getDrugDispenses(ui.newPanel.attr("idObj"),ui.newPanel.attr("idVersion"), "#"+ui.newPanel.attr("id"));
						}
					}
				}
			});
			
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}	
	} else if (obj.name == "listSummaryForPrescriptionDM") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			log("context received: "+obj.context);
//			log("context qrr: "+JSON.stringify(obj.response.qrr));
//			var temp =  $("<div>").html(obj.html);
//			log("context qrr: "+temp.html());
			
			if (obj.context != null && typeof(obj.context) != 'undefined' && obj.context.length > 0 ){
				var rel = $(obj.context);
				rel.children("p").remove();
				rel = rel.find(".table-list-dispenses2");
				log("t? "+rel.size());//+"/"+rel.parent().html())
				rel.children().remove();
				rel.append(obj.html);
				
				rel.find(".to-tabulate").each(function() {
					$(this).children("ul").remove();
					$(this).children("div").last().remove();
				});
				log("divId: "+toDel.attr("id"));
				
				if (
						obj.response != null && typeof(obj.response) != 'undefined' &&  
						obj.response.qrr != null && typeof(obj.response.qrr) != 'undefined' 
				) {
					var div = $("<div>");
					var span = $("<span>");
					span.text(obj.response.qrr.resultCurrentQuantity+"/"+obj.response.qrr.originalTotalQuantity)
					
					div.append(span);
					if (obj.response.qrr.resultCurrentQuantity < obj.response.qrr.originalTotalQuantity) {
						var bu = $("<button>");
						bu.click(function() {
							var newPanel = $(this).parent().parent().parent();
////							var c = "$(this).";
////							while (typeof(newPanel.attr("idVersion")) == 'undefined' || newPanel.attr("idVersion") == null ) {
////								newPanel = newPanel.parent();
////								c += "parent().";
////							}
////							log(c);
//								//
//							log(newPanel.html());
							getDrugDispenses(newPanel.attr("idObj"),newPanel.attr("idVersion"), "#"+newPanel.attr("id"));
						}).attr("title","Obtenir plus d'&eacute;l&eacute;ment").text("+");
						
						div.append(bu);
					}
					
					rel.append(div);
				}
			}
			
		//TODO changer le "en telechargement" par "pas de resultat"	
		} else if (obj.response && obj.response.message) {
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}	
	} else if (obj.name == "getMedicationDMDetail") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
//			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-med-"+idContainer).children().remove();
				$("#detail-med-"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-listMedicationsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-listMedicationsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}
	} else if (obj.name == "getMedicationPrescriptionDMDetail") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
			log("id: "+idContainer+" :: "+$("#detail-dm-med"+idContainer).size());
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-dm-med"+idContainer).children().remove();
				$("#detail-dm-med"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-listMedicationsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-listMedicationsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}		
	} else if (obj.name == "getPrescriptionsDMDetail") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-dm-"+idContainer).children().remove();
				$("#detail-dm-"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-listPrescriptionsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-listPrescriptionsDM").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}
	} else if (obj.name == "getDrugDetailOE") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
//			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-oe-"+idContainer).children().remove();
				$("#detail-oe-"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-listPrescriptionsOE").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-listPrescriptionsOE").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}
	} else if (obj.name == "getDeviceDetailOE") {
		if (obj.html != null && typeof(obj.html) != 'undefined' && obj.html.length > 0 ) {
//			clearLog();
			var nh = $("<div>");
			nh.html(obj.html);
			nh = nh.children();
			var idContainer = nh.attr("idObj");
//			log("id: "+idContainer);
			if (typeof(idContainer) != 'undefined' ) {
				$("#detail-oe-"+idContainer).children().remove();
				$("#detail-oe-"+idContainer).append(nh);
			}
		} else if (obj.response && obj.response.message) {
			$(".table-list-listPrescriptionsOE").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.message);
		} else if (obj.response && obj.response.exception) {
			$(".table-list-listPrescriptionsOE").find(".to-tabulate").tabs("option", "active",0);
			showError( obj.response.exception);
		}
	} else if (obj.name == "importMedocBatch") {
		
		$(".dialog-id-"+obj.response.dId).get(0).fnDetailsReceived(obj.response.idRx, obj.response.id, obj.response.desc, obj.response.exception);
		if (obj.response && obj.response.exception) {
			showError( obj.response.exception);
		}
	}
	ajustTableWidht();
	}catch (e) {log("error:"+e.description)}
}

function clearLog() {
	$("#log").children().remove();
	$(".error").hide();
}


function log(msg) {
//	var p = $("<p>");
//	p.text(msg.replace("\n","<br/>"));
//	$("#log").append(p);
}

var firstCall = {
		getConsent: true
};


function importerWrap(td) {
	td = $(td);
	var rep = importer(td.attr("dm-id"), td.attr("dm-version"));
	if (rep == "true") {
		td.attr("onclick","");
		td.css("cursor","auto");
	} else {
		showError(rep);
	}
}


function showError( txt ) {
	if ($("#error").is(":visible")) {
		$("#error").fadeOut(500, function() {
			subShowErr(txt);
		});
	} else {
		subShowErr(txt);
	}
}
function subShowErr(txt) {
	$("#error").text(txt);
	$("#error").fadeIn(500, function() {
		setTimeout(function(){
			$("#error").fadeOut(300);
		},15000);
	});
}

function hideDsqQuestion(id) {
	$("#"+id).hide();
}
function showDsqQuestion(id) {
	$("#"+id).show();
}
function showHideDiv(id) {
	log("TOGGLE SIZE: "+$("#"+id).size());
	$("#"+id).toggle();
}
function represcrire(){};

function represcrire() {}

function getDrugDispensedDetail(idObj) {
	GDDispenses(idObj);
}
function getDrugDetailOE(idObj, version) {
	GDDrugOE(idObj, version);
}
function getDrugDetail(idObj, version, context) {
	GDDrug(idObj, version, context);
}
function getDrugDispenses(idObj, version, context) {
	log("context: "+context);
	GDDrugDispenses(idObj, version, context);
}
function listMedication_getMedicationDetail(idObj, version) {
	listMedication_GDMedication(idObj, version);
}
function listMedication_getPrescriptionDetail(idObj, version, context) {
	listMedication_GDPrescription(idObj, version, context);
}
function getDeviceDetail(idObj, c2) {
	getDDevice(idObj, c2);
}

function ajustTableWidht(){
	$(".dsq-list-table").each(function(){
		var e = $(this);
		var p = e.parent();
		e.css("width", (p.width()-20)+"px");
	});
}

$(document).ready(function() {
	$(".date").each(function(i,e){
		new Mask(e, function() {
			var id = $(e).attr("id");
			updateParameter(id, $(e).val());
		});
	});
	
//	
//	$(".date").datepicker({
//		dateFormat: "yy/mm/dd",
//		onSelect: function(dText) {
//			var id = $(this).attr("id");
//			updateParameter2(id, dText);
//		},
//		changeMonth: true,
//		changeYear: true
//	});
//	$(".date").attr("readonly","true")
	
	$(".updatable-chk").click(function(){
		updateChk(this);
	}).change(function() {
//		updateChk(this);
	});
	
	$(".updatable-radio").change(function() {
		updateChk(this);
	});
	
	buildMedocsDialog();
//	getConsent();
});


function retract(id, version) {
	retractDrug(id, version);
}
function updateChk(e) {
	var id = $(e).attr("id");
	var chk = $(e).prop("checked");
//	log("CHK:"+chk);
	updateParameter(id, chk);
}

function evalCode() {
	eval($("#code").val());
}

function selectActifMedoc() {
	$(".chk-actif").attr("checked","checked");
}
function importMedocs() {
	var ids = [];
	$(".chk-import:checked").each(function() {
		ids.push($(this).attr("idObj"));
	});
	
	if (ids.length == 0) {
		buildDiag("Importation d'ordonnance", "Aucune ordonnance n'a été sélectionnée.", function(){}, []);
	} else {
		
		var txt = "Vous allez importer "+ids.length+" ordonnance"+(ids.length > 1?"s":"")+"."
			+"  N'oubliez pas de vérifier que l"+(ids.length > 1?"es ":"'")+"ordonnace"
			+(ids.length > 1?"s":"")+" "+(ids.length > 1?"sont":"est")+" correctement importée"
			+(ids.length > 1?"s":"")+".";
		
		
		var fnAjustProgress = function(mDiv) {
			var nb = mDiv.prop("nb");
			var pv = mDiv.prop("progressValue");
			
			var nv = Math.round((100 - pv)/nb)+pv;
			mDiv.prop("nb", nb-1);
			mDiv.prop("progressValue",nv);

			mDiv.find(".dialog-progress-bar").progressbar("value", nv);
			return nv;
		}
		var fnImport = function(obj, mDiv) {
			if (obj.value === true) {
				//Build the progress bar
				mDiv.find(".dialog-button-bar").children().remove();
				mDiv.find(".dialog-question-bar").children().remove();
				mDiv.find(".dialog-question-bar").text("");
				
				
				var id = getRandom(8)
				mDiv.addClass("dialog-id-"+id);
				mDiv.prop("rid",id);
				mDiv.prop("nb", ids.length);
				mDiv.prop("progressValue",0);
				
				var pDiv = $("<div>");
				var eDiv = $("<div>");
				var tDiv = $("<div>");
				
				pDiv.addClass("dialog-progress-bar");
				tDiv.addClass("dialog-progress-text");
				
				mDiv.find(".dialog-question-bar").append(tDiv).append(pDiv).append(eDiv);
				pDiv.progressbar({
					 value: 0
				});
				mDiv.prop("nberr",0);
				mDiv.get(0).fnDetailsReceived = function(idRx, id, desc, exception) {
					var nv = fnAjustProgress(mDiv);
					
					var err = $("<div>");
					err.css("font-size","0.85em");
					err.css("color","rgb(230,50,50)");
					err.css("margin","10px 3px");
					err.css("font-style","italic");

					if (typeof(desc) == 'undefined' || desc == null || desc.length == 0 ) {
						desc = $("#summary-dispense-"+idRx).children().children().children().first().text();
					}
					
					if (exception) {
						err.html("<b>"+desc+"</b> n'a pas \u00E9t\u00E9 transf\u00E9r\u00E9: "+exception);
						mDiv.prop("nberr",mDiv.prop("nberr")+1);
						eDiv.append(err);
					} else if (importFinalDispense(id)) {	//On fait import comme tel
						importMedocRecall(idRx, id);
						mDiv.find(".dialog-progress-text").text(desc+" importé!");
					} else {
						mDiv.prop("nberr",mDiv.prop("nberr")+1);
						err.html("<b>"+desc+"</b> n'a pas \u00E9t\u00E9 transf\u00E9r\u00E9.");
						eDiv.append(err);
					}
					if (nv >= 99) {
						time = 4000 + 2000*mDiv.prop("nberr");
						setTimeout(function() {
							mDiv.remove();
						}, time);
					}
				}
				//Before import, we must getDetails
				for (var i = 0; i < ids.length; i++) {
					getDetailForImport(id,ids[i],ids[i]);
				}
				mDiv.find(".dialog-progress-text").text("Obtentions des d\u00E9tails des ordonnances...");
			} else {
				mDiv.remove();
			}
		}
		buildDiag("Importation d'ordonnance"+(ids.length > 1?"s":""), txt, [{name: "Je vais v\u00E9rifier", value: true, fn: fnImport}]);
	}
}

//FAKE
//function getDetailForImport(dId, id, idx, desc) {
//
//	var t = (Math.round(Math.random()*10)+1)*1000;
//	
//	var fn = function() {
//		dsqResponse(JSON.stringify({
//			name: "importMedocBatch",
//			id: id,
//			dId: dId,
//			idRx: idx,
//			desc: desc
//		}));
//	}
//	setTimeout(fn,t);
//}
////FAKE
//function importFinalDispense() {
//	return Math.random()>=0.5;
//}

function getRandom(nbChar) {
	var p = "0123465789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	
	var v = "";
	for (var i = 0; i < nbChar; i++) {
		v += p.charAt(Math.floor(Math.random()*p.length));
	}
	return v;
}

function buildDiag(title, question, button, takeDefaultBu) {
	var mDiv = $("<div>");
	var cDiv = $("<div>");
	var tDiv = $("<div>");
	var qDiv = $("<div>");
	var bDiv = $("<div>");
	
	if (typeof (title) != 'undifined' && title != null) {
		cDiv.append(tDiv);
		tDiv.text(title);
	}
	
	cDiv.append(qDiv).append(bDiv);
	mDiv.append(cDiv);
	
	qDiv.text(question);
	
	mDiv.addClass("dialog-holder");
	tDiv.addClass("dialog-title");
	bDiv.addClass("dialog-button-bar");
	qDiv.addClass("dialog-question-bar");
	
	var bu = [];
	if (typeof(takeDefaultBu) == 'undefined' || takeDefaultBu == null || takeDefaultBu) {
		bu.push({name:"Fermer", value: -1, fn: function(obj, mDiv){mDiv.remove();}});
	}
	
	for (var i = 0; i < button.length; i++) {
		bu.push(button[i]);
	}
	
	for (var i = bu.length-1; i >= 0; i--) {
		var b = $("<div>");
		b.addClass("dialog-button");
		b.text(bu[i].name);
		b.prop("valObj",bu[i]);
		b.click( function(){
			$(this).prop("valObj").fn($(this).prop("valObj"), mDiv);
		});
		bDiv.append(b);
	}
	var c = $("<div>");
	c.css("clear","both");
	bDiv.append(c);
	
	
	$("body").append(mDiv);
		
	return mDiv;
}

function buildMedocsDialog() {
/*	 var progressTimer,
		 progressbar = $( "#progressbar" ),
		 progressLabel = $( ".progress-label" ),
		 dialogButtons = [{
			 text: "Cancel Download",
			 click: closeDownload
		 }],
	 dialog = $( "#dialog" ).dialog({
		 autoOpen: false,
		 closeOnEscape: false,
		 resizable: false,
		 buttons: dialogButtons,
		 open: function() {
		 	progressTimer = setTimeout( progress, 2000 );
		 },
		 beforeClose: function() {
			 downloadButton.button( "option", {
				 disabled: false,
				 label: "Start Download"
			 });
		 }
	 }),
	 downloadButton = $( "#downloadButton" ).button().on( "click", function() {
		 $( this ).button( "option", {
			 disabled: true,
			 label: "Downloading..."
		 });
		 dialog.dialog( "open" );
	 });
	 progressbar.progressbar({
		 value: false,
		 change: function() {
			 progressLabel.text( "Current Progress: " + progressbar.progressbar( "value" ) + "%" );
		 },
		 complete: function() {
			 progressLabel.text( "Complete!" );
			 dialog.dialog( "option", "buttons", [{
				 text: "Close",
				 click: closeDownload
			 }]);
			 $(".ui-dialog button").last().focus();
		 }
	 });
	 
	 function progress() {
		 var val = progressbar.progressbar( "value" ) || 0;
		 progressbar.progressbar( "value", val + Math.floor( Math.random() * 3 ) );
		 if ( val <= 99 ) {
			 progressTimer = setTimeout( progress, 50 );
		 }
	 }
	 
	 function closeDownload() {
		 clearTimeout( progressTimer );
		 dialog.dialog( "option", "buttons", dialogButtons ).dialog( "close" );
		 progressbar.progressbar( "value", false );
		 progressLabel.text( "Starting download..." );
		 downloadButton.focus();
	 }*/
}