/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCancelledBy;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentTypeStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XCategoryType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentType;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.ofys.util.json.IJsonWriter;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CAppointment
extends CEditableDataObject
implements Serializable {
    private static final Logger logger = Logger.getLogger(CAppointment.class.getName());
    public String className = CAppointment.class.getSimpleName();
    public int uid;
    public Integer id;
    public Integer startTime;
    public Integer endTime;
    public Integer arrivedTime;
    public Integer seenTime;
    public XPatientStatus patientStatus;
    public int[] ptStatColor = null;
    public XAppointmentStatus status;
    public Boolean isAnnualExam;
    public String note;
    public String statusNote;
    public Boolean autoSendReminder;
    public Long timeReminderDone;
    public Integer nbHreBeforeAppt;
    public Boolean isDeleted;
    public Boolean isConfidential;
    public Short categoryType;
    public Long dateCreated;
    public Long dateEntryLast;
    public String nameUser;
    public String notePatient;
    public Integer idAppointmentDate;
    public String date;
    public Integer idProfessional;
    public String profNom;
    public Set<Integer> idProfessionals;
    public List<CPatient> patients;
    public CPatient adhocPatient;
    public Integer typeAppointment;
    public int telmed = 0;
    public int[] apptTypeColor;
    public String apptTypeCode;
    public String apptTypeNom;
    public Integer idSite;
    public String siteNom;
    public Integer professionnalReferer;
    public int when;
    public Integer idService;
    public String availabilityId;
    public Boolean cancelled;
    public Long cancelledDate;
    public XAppointmentCancelledBy cancelledBy;
    public String consultationReason;
    public String contactMethods;
    public static Comparator<CAppointment> compareTodayFirst = new Comparator<CAppointment>(){

        @Override
        public int compare(CAppointment o1, CAppointment o2) {
            return o1.when > o2.when ? 1 : (o1.when < o2.when ? -1 : 0);
        }
    };
    public static Comparator<CAppointment> compareDate = new Comparator<CAppointment>(){

        @Override
        public int compare(CAppointment o1, CAppointment o2) {
            int c = o1.date.compareTo(o2.date);
            if (c == 0) {
                c = o1.seenTime.compareTo(o2.startTime);
            }
            return c;
        }
    };

    public CAppointment() {
    }

    public CAppointment(XAppointment appointment) {
        this.init(appointment);
    }

    private void init(XAppointment appointment) {
        super.init((IEditableDataObject)appointment);
        this.uid = Utils.getNewAtomicInteger();
        this.id = appointment.getId();
        this.startTime = appointment.getStartTime().intValue();
        this.endTime = appointment.getEndTime().intValue();
        this.patientStatus = appointment.getPatientStatus();
        boolean consideredArrived = true;
        if (this.patientStatus != null) {
            try {
                this.ptStatColor = Application.get().getAppointmentPluginController().getColorByPatientStatus(this.patientStatus);
            }
            catch (Exception e) {
                this.ptStatColor = new int[]{255, 255, 255};
            }
            if (this.patientStatus.getValue() == XPatientStatus.CANCEL.getValue() || this.patientStatus.getValue() == XPatientStatus.CANCEL_LESS_24H.getValue() || this.patientStatus.getValue() == XPatientStatus.LEFT_WITHOUT_BEING_SEEN.getValue() || this.patientStatus.getValue() == XPatientStatus.NOT_CAME.getValue()) {
                consideredArrived = false;
            }
        } else {
            this.ptStatColor = new int[]{255, 255, 255};
        }
        if (consideredArrived) {
            this.arrivedTime = appointment.getArrivedTime() == null ? null : Integer.valueOf(appointment.getArrivedTime().intValue());
        }
        this.seenTime = appointment.getSeenTime() == null ? null : Integer.valueOf(appointment.getSeenTime().intValue());
        this.status = appointment.getStatus();
        this.isAnnualExam = appointment.getIsAnnualExam();
        this.note = appointment.getNote();
        this.statusNote = appointment.getStatusNote();
        this.autoSendReminder = appointment.getAutoSendReminder();
        this.timeReminderDone = appointment.getTimeReminderDone();
        this.nbHreBeforeAppt = appointment.getNbHreBeforeAppt() == null ? null : Integer.valueOf(appointment.getNbHreBeforeAppt().intValue());
        this.isDeleted = appointment.getIsDeleted();
        this.isConfidential = appointment.getIsConfidential();
        this.categoryType = appointment.getCategoryType();
        this.dateCreated = appointment.getDateCreated();
        this.dateEntryLast = appointment.getDateEntryLast();
        this.nameUser = appointment.getNameUser();
        this.notePatient = appointment.getNotePatient();
        this.contactMethods = appointment.getContactMethods();
        this.idAppointmentDate = appointment.getIdAppointmentDate();
        this.date = null == appointment.getDate() ? null : appointment.getDate().formatHyphen();
        this.idProfessional = appointment.getIdProfessional();
        if (this.idProfessional != null) {
            try {
                XBaseProfessionnal p = Application.get().getPersonPluginController().getBaseProfessionnal(this.idProfessional);
                if (p != null) {
                    this.profNom = p.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.idProfessionals = appointment.getIdProfessionals();
        this.idService = appointment.getIdService();
        this.availabilityId = appointment.getAvailabilityId();
        this.cancelledDate = appointment.getCancelledDate();
        this.cancelledBy = appointment.getCancelledBy();
        this.patients = Utils.clist(appointment.getPatients(), CPatient.class);
        try {
            this.adhocPatient = CPatient.c(appointment.getAdhocPatient((IJsonReader)Application.get().getGsonProcessor()));
        }
        catch (Exception e) {
            if (appointment.getAdhocPatient() != null) {
                this.adhocPatient = new CPatient();
            }
            logger.log(Level.SEVERE, "Error converting adhocpatient to CPatient: " + appointment.getAdhocPatient(), e);
        }
        this.typeAppointment = appointment.getTypeAppointment();
        this.consultationReason = appointment.getConsultationReason();
        if (this.typeAppointment != null) {
            try {
                CAppointmentType typeAppt = new CAppointmentType(Application.get().getAppointmentPluginController().getAppointmentType(this.typeAppointment));
                if (this.categoryType != null && this.categoryType != 0) {
                    if (this.categoryType == XCategoryType.BY_PHONE.id) {
                        this.telmed = 1;
                    } else if (this.categoryType == XCategoryType.VIRTUAL.id) {
                        this.telmed = 2;
                    } else if (this.categoryType == XCategoryType.HOME.id) {
                        this.telmed = 3;
                    }
                } else if (typeAppt.status.contains(XAppointmentTypeStatus.BY_PHONE)) {
                    this.telmed = 1;
                } else if (typeAppt.status.contains(XAppointmentTypeStatus.TELMED)) {
                    this.telmed = 2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.idSite = appointment.getSite();
        XSite site = Application.get().getSitePluginController().getSite(appointment.getSite());
        this.siteNom = site == null ? null : site.getNameCommon();
        this.professionnalReferer = appointment.getProfessionnalReferer();
        int today = LocalDate.today().dayFrom1970;
        this.when = appointment.getDate().dayFrom1970 - today;
    }

    public static CAppointment c(XAppointment x) {
        return x == null ? null : new CAppointment(x);
    }

    public XAppointment x() {
        XAppointment x = new XAppointment();
        super.x((EditableDataObject)x);
        x.setId(this.id);
        x.setStartTime(this.startTime == null ? null : Short.valueOf(this.startTime.shortValue()));
        x.setEndTime(this.endTime == null ? null : Short.valueOf(this.endTime.shortValue()));
        x.setSeenTime(this.seenTime == null ? null : Short.valueOf(this.seenTime.shortValue()));
        x.setArrivedTime(this.arrivedTime == null ? null : Short.valueOf(this.arrivedTime.shortValue()));
        x.setPatientStatus(this.patientStatus);
        x.setStatus(this.status);
        x.setIsAnnualExam(this.isAnnualExam);
        x.setNote(this.note);
        x.setStatusNote(this.statusNote);
        x.setAutoSendReminder(this.autoSendReminder);
        x.setTimeReminderDone(this.timeReminderDone);
        x.setNbHreBeforeAppt(this.nbHreBeforeAppt == null ? null : Short.valueOf(this.nbHreBeforeAppt.shortValue()));
        x.setIsDeleted(this.isDeleted);
        x.setIsConfidential(this.isConfidential);
        x.setCategoryType(this.categoryType);
        x.setDateCreated(this.dateCreated);
        x.setDateEntryLast(this.dateEntryLast);
        x.setNameUser(this.nameUser);
        x.setNotePatient(this.notePatient);
        x.setContactMethods(this.contactMethods);
        x.setIdAppointmentDate(this.idAppointmentDate);
        x.setDate(Utils.strToLocalDate(this.date));
        x.setIdProfessional(this.idProfessional);
        x.setIdProfessionals(this.idProfessionals);
        EditableDataObject.Property p = new EditableDataObject.Property((EditableDataObject)x);
        p.set(CPatient.cToXList(this.patients));
        x.patients = p;
        x.setAdhocPatient((IJsonWriter)Application.get().getGsonProcessor(), this.adhocPatient == null ? null : this.adhocPatient.x());
        x.setTypeAppointment(this.typeAppointment);
        x.setSite(this.idSite);
        x.setProfessionnalReferer(this.professionnalReferer);
        x.setIdService(this.idService);
        x.setAvailabilityId(this.availabilityId);
        x.setCancelled(this.cancelled);
        x.setCancelledDate(this.cancelledDate);
        x.setCancelledBy(this.cancelledBy);
        x.setConsultationReason(this.consultationReason);
        return x;
    }

    public <T> CEditableDataObject convertc(T type) {
        XAppointment x = (XAppointment)XAppointment.class.cast(type);
        this.init(x);
        return this;
    }

    public XAppointment convertx() {
        return null;
    }

    public static List<XAppointment> cToXList(List<CAppointment> list) {
        if (list != null) {
            ArrayList<XAppointment> xl = new ArrayList<XAppointment>();
            for (CAppointment c : list) {
                xl.add(c.x());
            }
            return xl;
        }
        return null;
    }
}

