/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.impl.ByteAResponseReader;
import ca.infodata.ofys.data.dataaccess.impl.MyMapRequestWriter;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClientHttpResquestRetryHandler;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClientServiceUnavailableRetryStrategy;
import ca.infodata.ofys.data.dataaccess.impl.ReturnObjectResponseReader;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.search.Group;
import ca.infodata.util1.restful.GroupTypeAdapter;
import ca.infodata.util1.restful.RequestWriter;
import ca.infodata.util1.restful.ResponseReader;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class RestfulClient {
    private Client client;
    private CloseableHttpClient apacheClient;
    static Cache<Integer, Integer> cacheTime;
    static Cache<Integer, Integer> cacheCnts;
    static AtomicInteger ai;
    static long lastRequest;

    public RestfulClient() {
        int maxRetries = 5;
        long retryInterval = 2000L;
        RestfulClientHttpResquestRetryHandler retryHandler = new RestfulClientHttpResquestRetryHandler(5, 2000L, TimeUnit.MILLISECONDS);
        RestfulClientServiceUnavailableRetryStrategy unavailableRetryStrategy = new RestfulClientServiceUnavailableRetryStrategy(5, 2000L, TimeUnit.MILLISECONDS);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)retryHandler);
        httpClientBuilder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)unavailableRetryStrategy);
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new IgnoreHostNameVerifier());
        HttpRequestInterceptor reqInt = new HttpRequestInterceptor(){

            public void process(HttpRequest h, HttpContext c) throws HttpException, IOException {
                Header firstHeader = h.getFirstHeader("Content-Length");
                if (firstHeader != null && firstHeader.getValue() != null && Integer.parseInt(firstHeader.getValue()) > 130) {
                    System.out.print("Request : ");
                    System.out.println(firstHeader.getValue() + " bytes");
                }
            }
        };
        HttpResponseInterceptor respInt = new HttpResponseInterceptor(){

            public void process(HttpResponse h, HttpContext c) throws HttpException, IOException {
                Header firstHeader = h.getFirstHeader("Content-Length");
                if (firstHeader != null) {
                    long now = System.currentTimeMillis();
                    int val = Integer.parseInt(firstHeader.getValue());
                    if (now - lastRequest > 5000L) {
                        Integer ifPresentVal = (Integer)cacheTime.getIfPresent((Object)ai.get());
                        if (ifPresentVal != null) {
                            Integer ifPresentCnt = (Integer)cacheCnts.getIfPresent((Object)ai.get());
                            System.out.println("Resp totaux    10 sec:" + ifPresentVal + " bytes");
                            System.out.println("Resp per call  10 sec:" + ifPresentVal / ifPresentCnt + " bytes");
                        }
                        lastRequest = now;
                        cacheTime.put((Object)ai.incrementAndGet(), (Object)val);
                        cacheCnts.put((Object)ai.get(), (Object)1);
                    } else {
                        Integer present = (Integer)cacheTime.getIfPresent((Object)ai.get());
                        Integer presentCnt = (Integer)cacheCnts.getIfPresent((Object)ai.get());
                        int accVal = 0;
                        int accCnt = 0;
                        accVal = present == null ? val : val + present;
                        accCnt = presentCnt == null ? 1 : presentCnt + 1;
                        cacheTime.put((Object)ai.get(), (Object)accVal);
                        cacheCnts.put((Object)ai.get(), (Object)accCnt);
                    }
                }
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new AllowAllTrustManager()}, null);
            httpClientBuilder.setSSLContext(sslContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        requestConfig.setSocketTimeout((int)TimeUnit.MINUTES.toMillis(30L));
        httpClientBuilder.setDefaultRequestConfig(requestConfig.build());
        httpClientBuilder.evictExpiredConnections();
        httpClientBuilder.evictIdleConnections(5L, TimeUnit.SECONDS);
        httpClientBuilder.setMaxConnTotal(200);
        httpClientBuilder.setMaxConnPerRoute(20);
        httpClientBuilder.addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session != null && session.getClient() != null) {
                    String clientCode = session.getClient().getClientCode();
                    request.setHeader("clientCode", clientCode);
                    XUser user = session.getUser();
                    if (user != null) {
                        request.setHeader("userName", user.getName());
                    }
                } else {
                    String value;
                    Header userHeader;
                    String value2;
                    Header clientHeader = request.getFirstHeader("client");
                    if (clientHeader != null && (value2 = clientHeader.getValue()) != null) {
                        request.setHeader("clientCode", value2);
                    }
                    if ((userHeader = request.getFirstHeader("userName")) != null && (value = userHeader.getValue()) != null) {
                        request.setHeader("userName", value);
                    }
                }
            }
        });
        this.apacheClient = httpClientBuilder.build();
        DefaultClientConfig cc = new DefaultClientConfig();
        this.config((ClientConfig)cc);
        ApacheHttpClient4Handler clientHandler = new ApacheHttpClient4Handler((HttpClient)this.apacheClient, (CookieStore)new BasicCookieStore(), false);
        this.client = new Client((ClientHandler)clientHandler, (ClientConfig)cc);
    }

    public Client getJerseyClient() {
        return this.client;
    }

    public CloseableHttpClient getApacheClient() {
        return this.apacheClient;
    }

    public void close() {
        this.client.destroy();
    }

    protected final void config(ClientConfig config) {
        GsonBuilder builder = new GsonBuilder();
        GroupTypeAdapter groupTypeAdapter = new GroupTypeAdapter();
        builder.registerTypeHierarchyAdapter(Group.class, (Object)groupTypeAdapter);
        Gson gson = builder.create();
        groupTypeAdapter.setGson(gson);
        config.getSingletons().add(new ResponseReader(gson));
        config.getSingletons().add(new ByteAResponseReader());
        config.getSingletons().add(new ReturnObjectResponseReader());
        config.getSingletons().add(new MyMapRequestWriter(gson));
        config.getSingletons().add(new RequestWriter(gson));
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.enableBuffering", true);
    }

    static {
        ai = new AtomicInteger();
        lastRequest = 0L;
        cacheTime = Caffeine.newBuilder().maximumSize(50L).build();
        cacheCnts = Caffeine.newBuilder().maximumSize(50L).build();
    }

    protected static class AllowAllTrustManager
    implements X509TrustManager,
    TrustManager {
        protected AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    protected static class IgnoreHostNameVerifier
    implements HostnameVerifier {
        protected IgnoreHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

