/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.RTSSOAuthController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.routes.RequestPredicates;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.IInspqImmunizationAccessor;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqCondition;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqImmunization;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqImmunizationDelete;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqImmunizationOverride;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqImmunizationProfileArg;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqImmunizationSettoforecaststatus;
import ca.infodata.ofys.data.middle.dataobjects.inspq.immunization.XInspqRefusal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.StringUtils;
import java.util.Map;
import java.util.stream.Stream;

public class InspqImmunizationController
extends AbstractWebController {
    private final IInspqImmunizationAccessor accessor;
    private RTSSOAuthController rtssController;

    public InspqImmunizationController(RTSSOAuthController rtssController) {
        this.rtssController = rtssController;
        this.accessor = Application.get().getDataAccessors().getInspqImmunizationRecordsAccessor();
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/inspq/immunization", RouterFunctions.routeReturnObject("/patientGetImmunizationProfile", this::patientGetImmunizationProfile), RouterFunctions.routeReturnObject("/valueSetGet", this::valueSetGet), RouterFunctions.routeReturnObject("/practitionerGet", this::practitionerGet), RouterFunctions.routeReturnObject("/practitionerSearch", this::practitionerSearch), RouterFunctions.routeReturnObject("/locationGet", this::locationGet), RouterFunctions.routeReturnObject("/locationSearch", this::locationSearch), RouterFunctions.routeReturnObject("/medicationGet", this::medicationGet), RouterFunctions.routeReturnObject("/immunizationGet", this::immunizationGet), RouterFunctions.routeReturnObject("/signout", this::signOut), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/immunizationAdd"), this::immunizationAdd), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/immunizationModify"), this::immunizationModify), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/immunizationDelete"), this::immunizationDelete), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/immunizationOverride"), this::immunizationOverride), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/immunizationSettoforecast"), this::immunizationSettoforecast), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/conditionGet"), this::conditionGet), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/conditionAdd"), this::conditionAdd), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/conditionModify"), this::conditionModify), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/refusalGet"), this::refusalGet), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/refusalAdd"), this::refusalAdd), RouterFunctions.routeReturnObject(RequestPredicates.wsp("/refusalModify"), this::refusalModify));
    }

    private ReturnObject conditionGet(IServerRequest req) {
        Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
        String id = req.getRequiredQueryParam("id", String.class);
        return this.accessor.conditionGet(id, idPatient);
    }

    private ReturnObject conditionAdd(IServerRequest req) {
        ConditionModifier post = req.getPostBody(ConditionModifier.class);
        return this.accessor.conditionAdd(post.data, post.idPatient);
    }

    private ReturnObject conditionModify(IServerRequest req) {
        ConditionModifier post = req.getPostBody(ConditionModifier.class);
        return this.accessor.conditionModify(post.data, post.idPatient);
    }

    private ReturnObject refusalGet(IServerRequest req) {
        Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
        String id = req.getRequiredQueryParam("id", String.class);
        return this.accessor.refusalGet(id, idPatient);
    }

    private ReturnObject refusalAdd(IServerRequest req) {
        FlagModifier post = req.getPostBody(FlagModifier.class);
        return this.accessor.refusalAdd(post.data, post.idPatient);
    }

    private ReturnObject refusalModify(IServerRequest req) {
        FlagModifier post = req.getPostBody(FlagModifier.class);
        return this.accessor.refusalModify(post.data, post.idPatient);
    }

    private ReturnObject immunizationGet(IServerRequest req) {
        Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
        String immunizationId = req.getRequiredQueryParam("id", String.class);
        return this.accessor.immunizationGet(immunizationId, idPatient);
    }

    private ReturnObject immunizationAdd(IServerRequest req) {
        ImmunizationModifier post = req.getPostBody(ImmunizationModifier.class);
        return this.accessor.immunizationAdd(post.data, post.idPatient);
    }

    private ReturnObject immunizationModify(IServerRequest req) {
        ImmunizationModifier post = req.getPostBody(ImmunizationModifier.class);
        return this.accessor.immunizationModify(post.data, post.idPatient);
    }

    private ReturnObject immunizationDelete(IServerRequest req) {
        ImmunizationDeleter post = req.getPostBody(ImmunizationDeleter.class);
        return this.accessor.immunizationDelete(post.data, post.idPatient);
    }

    private ReturnObject signOut(IServerRequest req) {
        return this.rtssController.signOut(req);
    }

    private ReturnObject immunizationOverride(IServerRequest req) {
        ImmunizationOverrider post = req.getPostBody(ImmunizationOverrider.class);
        return this.accessor.immunizationOverride(post.data, post.idPatient);
    }

    private ReturnObject immunizationSettoforecast(IServerRequest req) {
        ImmunizationSettoforecaster post = req.getPostBody(ImmunizationSettoforecaster.class);
        return this.accessor.immunizationSettoforecast(post.data, post.idPatient);
    }

    private ReturnObject patientGetImmunizationProfile(IServerRequest req) {
        XInspqImmunizationProfileArg arg = new XInspqImmunizationProfileArg();
        arg.idPatient = req.getRequiredQueryParam("id", Integer.class);
        ReturnObject r = this.accessor.patientImmunizationProfile(arg);
        return r;
    }

    private ReturnObject valueSetGet(IServerRequest req) {
        String domain = req.getRequiredQueryParam("domain", String.class);
        Stream<Map.Entry<String, String>> params = req.getQueryParams().entrySet().stream().filter(e -> !"domain".equals(e.getKey()));
        ReturnObject r = this.accessor.valueSetGet(domain, params);
        return r;
    }

    private ReturnObject practitionerGet(IServerRequest req) {
        String id = req.getRequiredQueryParam("id", String.class);
        ReturnObject r = this.accessor.practitionerGet(id);
        return r;
    }

    private ReturnObject locationGet(IServerRequest req) {
        String id = req.getRequiredQueryParam("id", String.class);
        ReturnObject r = this.accessor.locationGet(id);
        return r;
    }

    private ReturnObject medicationGet(IServerRequest req) {
        String id = req.getRequiredQueryParam("id", String.class);
        ReturnObject r = this.accessor.medicationGet(id);
        return r;
    }

    private ReturnObject practitionerSearch(IServerRequest req) {
        if (req.hasQueryParam("text")) {
            String text = req.getQueryParam("text");
            if (StringUtils.isBlank((CharSequence)text)) {
                return this.accessor.practitionerSearch(null, null, null);
            }
            if (StringUtils.isNumeric((String)text)) {
                return this.accessor.practitionerSearch(null, null, text);
            }
            return this.accessor.practitionerSearch(text, null, null);
        }
        String name = req.getQueryParam("name");
        String role = req.getQueryParam("role");
        String identifier = req.getQueryParam("identifier");
        ReturnObject r = this.accessor.practitionerSearch(name, role, identifier);
        return r;
    }

    private ReturnObject locationSearch(IServerRequest req) {
        String name = req.getQueryParam("name");
        String city = req.getQueryParam("city");
        ReturnObject r = this.accessor.locationSearch(name, city);
        return r;
    }

    public class ImmunizationSettoforecaster {
        Integer idPatient;
        XInspqImmunizationSettoforecaststatus data;
    }

    public class ImmunizationOverrider {
        Integer idPatient;
        XInspqImmunizationOverride data;
    }

    public class ImmunizationDeleter {
        Integer idPatient;
        XInspqImmunizationDelete data;
    }

    public class ImmunizationModifier {
        Integer idPatient;
        XInspqImmunization data;
    }

    public class FlagModifier {
        Integer idPatient;
        XInspqRefusal data;
    }

    public class ConditionModifier {
        Integer idPatient;
        XInspqCondition data;
    }
}

