/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.IAppointmentAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCompleteDataContainer;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateKey;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentObjects;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientHaveAppRecall;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.dashboard.accessor.AppointmentSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CAppointment;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentDateMessage;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentDateTemplate;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentDeGarde;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentEmailMapping;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentPeriodType;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentType;
import ca.infodata.ofys.ui.dashboard.models.CAppointmentWeekTemplate;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CPatientRecall;
import ca.infodata.ofys.ui.dashboard.models.CPatientRecallSearchCriteria;
import ca.infodata.ofys.ui.dashboard.models.CScheduleSaveContainer;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AppointmentController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(AppointmentController.class.getName());
    private final AppointmentSyncAccessorClient appointmentAccessor = new AppointmentSyncAccessorClient();
    private final IAppointmentAccessor appointmentAccessor2 = Application.get().getDataAccessors().getAppointmentAccessor();

    public AppointmentController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XAppointment) {
            CAppointment jMsg = new CAppointment((XAppointment)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "app.update", jMsg);
        } else if (object instanceof XReservedAppointment) {
            ServerResponses.sendJsonToClient(notification.getClientId(), "app.reserved", object);
        } else if (object instanceof XBaseAppointmentDate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XBaseAppointmentDate " + object);
            XBaseAppointmentDate xdate = (XBaseAppointmentDate)object;
            ServerResponses.sendJsonToClient(notification.getClientId(), "schdl.baseappointmentdate.update", xdate);
        } else if (object instanceof XAppointmentDate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentDate " + object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "app.date", object);
        } else if (object instanceof XAppointmentDateKey) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentDateKey " + object);
            XAppointmentDateKey xdatekey = (XAppointmentDateKey)object;
            ServerResponses.sendJsonToClient(notification.getClientId(), "schdl.datekey.update", xdatekey);
        } else if (object instanceof XAppointmentDateTemplate) {
            CAppointmentDateTemplate jMsg = new CAppointmentDateTemplate((XAppointmentDateTemplate)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "schdl.datetemplate.update", (Object)jMsg);
        } else if (object instanceof XAppointmentWeekTemplate) {
            CAppointmentWeekTemplate jMsg = new CAppointmentWeekTemplate((XAppointmentWeekTemplate)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "schdl.weektemplate.update", (Object)jMsg);
        } else if (object instanceof XAppointmentPeriodType) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentPeriodType " + object);
            CAppointmentPeriodType jMsg = new CAppointmentPeriodType((XAppointmentPeriodType)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "schdl.appointmentperiodtype.update", (Object)jMsg);
        } else {
            logger.info("Model" + System.identityHashCode(this) + " handle XXXX " + object);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/apps/ws", RouterFunctions.routeAction("/list", this::handleList), RouterFunctions.routeAction("/patientStatusColor", this::handleListPatientStatusColor), RouterFunctions.routeAction("/setPatientStatus", this::handleSetPatientStatus), RouterFunctions.routeAction("/setAppointmentStatus", this::handleSetAppointmentStatus), RouterFunctions.routeAction("/deleteappointment", this::deleteappointment), RouterFunctions.routeAction("/saveappointment", this::saveAppointment), RouterFunctions.routeAction("/saveschedule", this::saveSchedule), RouterFunctions.routeAction("/reserveappointment", this::reserveAppointment), RouterFunctions.routeAction("/extendReservation", this::extendReservation), RouterFunctions.routeAction("/deleteReservation", this::deleteReservation), RouterFunctions.routeAction("/searchperiod", this::searchPeriod), RouterFunctions.routeAction("/save", this::save), RouterFunctions.routeAction("/edit", req -> {
            Integer id = req.getRequiredQueryParam("id", Integer.class);
            return this.openAppointmentEditor(id) ? ServerResponses.SUCCESS() : ServerResponses.ERROR("Could not open view");
        }), RouterFunctions.routeAction("/recall/list", req -> {
            XPatientRecallSearchCriteria criteria = this.getXRecall(req.getPostBody(CPatientRecallSearchCriteria.class));
            return this.findPatientRecall(criteria);
        }), RouterFunctions.routeAction("/changeAppointmentDateMessage", this::changeAppointmentDateMessage), RouterFunctions.routeAction("/changeAppointmentDateDeGardeType", this::changeAppointmentDateDeGardeTypes), RouterFunctions.routeAction("/deleteAppointmentDateDeGardeType", this::deleteAppointmentDateDeGardeTypes), RouterFunctions.routeReturnObject("/listPeriodTypes", this::handleListPeriodTypes), RouterFunctions.routeReturnObject("/listAppointmentTypes", this::handleListAppointmentTypes), RouterFunctions.routeReturnObject("/getCompleteDate", this::handleGetCompleteDate), RouterFunctions.routeReturnObject("/getDate", this::handleGetDate), RouterFunctions.routeReturnObject("/getBaseDates", this::handleGetBaseDates), RouterFunctions.routeReturnObject("/profIsAbsent", this::handleProfIsAbsent), RouterFunctions.routeReturnObject("/getAppointment", this::handleGetAppointment), RouterFunctions.routeAction("/getProfessionalsWithSchedule", req -> ServerResponses.toJsonActionResult(this.handleGetProfessionalsWithSchedule(req))), RouterFunctions.routeAction("/findFuturAppointmentPatient", this::findFuturAppointmentPatient), RouterFunctions.routeAction("/findPastAppointmentPatient", this::findPastAppointmentPatient), RouterFunctions.routeReturnObject("/sendEmails", this::sendEmails));
    }

    private XPatientRecallSearchCriteria getXRecall(CPatientRecallSearchCriteria cCriteria) {
        XPatientRecallSearchCriteria xCriteria = new XPatientRecallSearchCriteria();
        if (cCriteria.patientId != null) {
            xCriteria.patientId = cCriteria.patientId;
        } else {
            xCriteria = cCriteria.toX();
        }
        return xCriteria;
    }

    private ReturnObject handleListPeriodTypes(IServerRequest request) {
        CEditableDataObjectList<CAppointmentPeriodType> result;
        Integer id = request.getQueryParam("id", Integer.class);
        if (id == null) {
            Integer idClient = Application.get().getGlobalInstances().getSession().getClient().getId();
            Stream<XAppointmentPeriodType> stream = Application.get().getCache().getAppointmentPeriodTypeCache().getList(idClient);
            result = new CEditableDataObjectList<CAppointmentPeriodType>(stream, CAppointmentPeriodType.class);
        } else {
            XAppointmentPeriodType type = Application.get().getCache().getAppointmentPeriodTypeCache().get(id);
            result = new CEditableDataObjectList<CAppointmentPeriodType>();
            if (type != null) {
                result.add(new CAppointmentPeriodType(type));
            }
        }
        return ServerResponses.OKReturnObject(result);
    }

    private ReturnObject handleListAppointmentTypes(IServerRequest request) {
        CEditableDataObjectList<CAppointmentType> result;
        Integer id = request.getQueryParam("id", Integer.class);
        if (id == null) {
            Integer idClient = Application.get().getGlobalInstances().getSession().getClient().getId();
            Stream<XAppointmentType> stream = Application.get().getCache().getAppointmentTypeCache().getList(idClient);
            result = new CEditableDataObjectList<CAppointmentType>(stream, CAppointmentType.class);
        } else {
            XAppointmentType type = Application.get().getCache().getAppointmentTypeCache().get(id);
            result = new CEditableDataObjectList<CAppointmentType>();
            if (type != null) {
                result.add(new CAppointmentType(type));
            }
        }
        return ServerResponses.OKReturnObject(result);
    }

    private ReturnObject handleGetDate(IServerRequest request) throws Exception {
        LocalDate cacheEnd;
        LocalDate cacheStart;
        Integer idProf = request.getQueryParam("idProf", Integer.class);
        LocalDate day = request.getQueryParam("day", LocalDate.class);
        LocalDate start = request.getQueryParam("start", LocalDate.class);
        LocalDate end = request.getQueryParam("end", LocalDate.class);
        if (day != null) {
            cacheStart = day;
            cacheEnd = day;
        } else if (start != null && end != null) {
            cacheStart = start;
            cacheEnd = end;
        } else {
            throw new Exception("Either the day date or start and end dates must be provided");
        }
        List<Integer> professionalIds = Arrays.asList(idProf);
        ReturnObject r = this.appointmentAccessor2.getAppointmentAppointmentDates(cacheStart, cacheEnd, professionalIds);
        XAppointmentCompleteDataContainer c = (XAppointmentCompleteDataContainer)r.getObj();
        return ServerResponses.OKReturnObject(c);
    }

    private ReturnObject handleGetProfessionalsWithSchedule(IServerRequest request) throws Exception {
        LocalDate day = request.getQueryParam("day", LocalDate.class);
        ReturnObject r = this.appointmentAccessor2.getProfessionalsWithSchedule(day);
        return r;
    }

    private ReturnObject handleGetCompleteDate(IServerRequest request) throws Exception {
        LocalDate cacheEnd;
        LocalDate cacheStart;
        Integer idProf = request.getQueryParam("idProf", Integer.class);
        LocalDate day = request.getQueryParam("day", LocalDate.class);
        LocalDate start = request.getQueryParam("start", LocalDate.class);
        LocalDate end = request.getQueryParam("end", LocalDate.class);
        if (day != null) {
            cacheStart = day;
            cacheEnd = day;
        } else if (start != null && end != null) {
            cacheStart = start;
            cacheEnd = end;
        } else {
            throw new Exception("Either the day date or start and end dates must be provided");
        }
        List<Integer> professionalIds = Arrays.asList(idProf);
        ReturnObject r = this.appointmentAccessor2.getAppointmentCompleteDateContainer(cacheStart, cacheEnd, professionalIds);
        XAppointmentCompleteDataContainer c = (XAppointmentCompleteDataContainer)r.getObj();
        return ServerResponses.OKReturnObject(c);
    }

    private ReturnObject handleGetBaseDates(IServerRequest request) {
        LocalDate start = request.getRequiredQueryParam("start", LocalDate.class);
        LocalDate end = request.getRequiredQueryParam("end", LocalDate.class);
        Integer idProf = request.getQueryParam("idProf", Integer.class);
        ReturnObject r = this.appointmentAccessor2.getAppointmentBaseAppointmentDates(start, end, Arrays.asList(idProf));
        XAppointmentCompleteDataContainer c = (XAppointmentCompleteDataContainer)r.getObj();
        return ServerResponses.OKReturnObject(c);
    }

    private ReturnObject handleProfIsAbsent(IServerRequest request) {
        LocalDate start = request.getRequiredQueryParam("start", LocalDate.class);
        LocalDate end = request.getRequiredQueryParam("end", LocalDate.class);
        String csvProfId = request.getQueryParam("idProf", String.class);
        List<Integer> idProf = Arrays.stream(csvProfId.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        ReturnObject r = this.appointmentAccessor2.getAppointmentBaseAppointmentDates(start, end, idProf);
        XAppointmentCompleteDataContainer c = (XAppointmentCompleteDataContainer)r.getObj();
        return ServerResponses.OKReturnObject(c);
    }

    private ReturnObject handleGetAppointment(IServerRequest request) {
        Integer id = request.getRequiredQueryParam("id", Integer.class);
        XAppointmentObjects container = new XAppointmentObjects();
        XAppointment a = new XAppointment();
        a.id.plain_set((Object)id);
        container.getAppointments().add(a);
        ReturnObject ret = this.appointmentAccessor2.getAppointmentObjects(container);
        if (ret == null) {
            return ret;
        }
        if (ret.getObj() instanceof XAppointmentObjects) {
            XAppointmentObjects xAppointmentObjects = (XAppointmentObjects)ret.getObj();
            return ServerResponses.OKReturnObject(xAppointmentObjects.getAppointments().stream().filter(a2 -> id.equals(a2.getId())).collect(Collectors.toList()));
        }
        return ret;
    }

    private ActionResult handleSetPatientStatus(IServerRequest req) {
        XPatientStatus statusId;
        Integer apptId = req.getRequiredQueryParam("apptId", Integer.class);
        IStatus iStatus = this.setPatientStatus(apptId, statusId = req.getQueryParam("statusId", XPatientStatus.NONE, XPatientStatus.class));
        return iStatus == null ? null : ServerResponses.toJsonActionResult(iStatus);
    }

    private ActionResult handleSetAppointmentStatus(IServerRequest req) {
        XAppointmentStatus statusId;
        Integer apptId = req.getRequiredQueryParam("apptId", Integer.class);
        IStatus iStatus = this.setAppointmentStatus(apptId, statusId = req.getQueryParam("statusId", XAppointmentStatus.NORMAL, XAppointmentStatus.class));
        return iStatus == null ? null : ServerResponses.toJsonActionResult(iStatus);
    }

    private ActionResult handleListPatientStatusColor(IServerRequest req) {
        Map<String, int[]> mapPtSt = this.listPatientStatusColor();
        return ServerResponses.toJsonActionResult(mapPtSt);
    }

    private ActionResult handleList(IServerRequest req) {
        if (req.hasQueryParam("day")) {
            LocalDate day = req.getRequiredQueryParam("day", LocalDate.class);
            Integer idProf = req.getQueryParam("idProf", Integer.class);
            return this.findAppointmentsByProfessional(day, idProf);
        }
        if (req.hasQueryParam("patient")) {
            Integer id = req.getRequiredQueryParam("patient", Integer.class);
            String type = req.getQueryParam("type");
            if ("FF".equals(type)) {
                return this.findFutureFamillyAppointmentsByPatient(id);
            }
            if ("CFA".equals(type)) {
                return this.countPatientRecallAndFutureAppointment(id);
            }
            return this.getAllAppointmentsByPatient(id);
        }
        return ServerResponses.ERROR("Invalid arguments. Missing required parameters.");
    }

    private ActionResult changeAppointmentDateMessage(IServerRequest req) {
        CAppointmentDateMessage criteria = req.getPostBody(CAppointmentDateMessage.class);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.changeAppointmentDateMessage(criteria.getLocalDates(), criteria.profs, criteria.message, criteria.getAppoitmentDateMessageType()));
    }

    private ActionResult changeAppointmentDateDeGardeTypes(IServerRequest req) {
        CAppointmentDeGarde criteria = req.getPostBody(CAppointmentDeGarde.class);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.changeAppointmentDateDeGardeTypes(criteria.getLocalDates(), criteria.profs, criteria.getAppoitmentDeGardeTypes()));
    }

    private ActionResult deleteAppointmentDateDeGardeTypes(IServerRequest req) {
        CAppointmentDeGarde criteria = req.getPostBody(CAppointmentDeGarde.class);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.changeAppointmentDateDeGardeType(criteria.getLocalDates(), criteria.profs, null));
    }

    private ActionResult searchPeriod(IServerRequest req) {
        XSearchPeriodCriteria criteria = req.getPostBody(XSearchPeriodCriteria.class);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor.findPeriod(criteria));
    }

    private ActionResult reserveAppointment(IServerRequest req) {
        XReservedAppointment reservedAppointment = req.getPostBody(XReservedAppointment.class);
        ArrayList<Serializable> container = new ArrayList<Serializable>();
        container.add((Serializable)reservedAppointment);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.saveReservedAppt(container));
    }

    private ActionResult deleteReservation(IServerRequest req) {
        XReservedAppointment reservedAppointment = req.getPostBody(XReservedAppointment.class);
        ArrayList<Serializable> container = new ArrayList<Serializable>();
        container.add((Serializable)reservedAppointment);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.deleteReservedAppt(container));
    }

    private ActionResult extendReservation(IServerRequest req) {
        XReservedAppointment reservedAppointment = req.getPostBody(XReservedAppointment.class);
        ArrayList<Serializable> container = new ArrayList<Serializable>();
        container.add((Serializable)reservedAppointment);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.extendsReservedAppt(container));
    }

    private ActionResult deleteappointment(IServerRequest req) {
        CAppointment c = req.getPostBody(CAppointment.class);
        XAppointment x = c.x();
        x.setIsDeleted(Boolean.TRUE);
        if (x.getTag() == null) {
            x.setTag();
        }
        ArrayList<XAppointment> xlist = new ArrayList<XAppointment>(1);
        xlist.add(x);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor.saveAppointment(xlist));
    }

    private ActionResult saveAppointment(IServerRequest req) {
        CAppointment[] clist = req.getPostBody(CAppointment[].class);
        ArrayList<XAppointment> xlist = new ArrayList<XAppointment>(clist.length);
        for (CAppointment c : clist) {
            xlist.add(c.x());
        }
        return ServerResponses.toJsonActionResult(this.appointmentAccessor.saveAppointment(xlist));
    }

    private ActionResult saveSchedule(IServerRequest req) {
        CScheduleSaveContainer schedule = req.getPostBody(CScheduleSaveContainer.class);
        return ServerResponses.toJsonActionResult(this.appointmentAccessor2.save(schedule.savable(), false));
    }

    private ActionResult findPatientRecall(XPatientRecallSearchCriteria criteria) {
        if (criteria != null) {
            List<CPatientRecall> list = CPatientRecall.xToCList(this.appointmentAccessor.findPatientRecall(criteria));
            if (criteria.patientId == null) {
                for (CPatientRecall x : list) {
                    x.isShowPatient = Boolean.TRUE;
                }
            }
            return ServerResponses.toJsonActionResult(list);
        }
        return ServerResponses.ERROR("Invalid arguments");
    }

    private IStatus setPatientStatus(Integer apptId, XPatientStatus status) {
        IStatus iStatus = this.appointmentAccessor.setPatientStatus(apptId, status);
        return iStatus;
    }

    private IStatus setAppointmentStatus(Integer apptId, XAppointmentStatus status) {
        IStatus iStatus = this.appointmentAccessor.setAppointmentStatus(apptId, status);
        return iStatus;
    }

    private Map<String, int[]> listPatientStatusColor() {
        HashMap<String, int[]> mapPtSt = new HashMap<String, int[]>(8);
        for (XPatientStatus ps : XPatientStatus.values()) {
            int[] color = Application.get().getAppointmentPluginController().getColorByPatientStatus(ps);
            mapPtSt.put(ps.name(), color);
        }
        return mapPtSt;
    }

    private ActionResult getAllAppointmentsByPatient(Integer idPatient) {
        List<XAppointment> res = this.appointmentAccessor.getAllAppointmentsByPatient(idPatient);
        CEditableDataObjectList<CAppointment> appList = new CEditableDataObjectList<CAppointment>(res, CAppointment.class);
        return ServerResponses.toJsonActionResult(appList);
    }

    private ActionResult findFutureFamillyAppointmentsByPatient(Integer idPatient) {
        List<XAppointment> res = this.appointmentAccessor.findFutureFamillyAppointmentsByPatient(idPatient);
        CEditableDataObjectList<CAppointment> appList = new CEditableDataObjectList<CAppointment>(res, CAppointment.class);
        return ServerResponses.toJsonActionResult(appList);
    }

    private ActionResult countPatientRecallAndFutureAppointment(Integer idPatient) {
        XPatientHaveAppRecall res = this.appointmentAccessor.countPatientRecallAndFutureAppointment(idPatient);
        return ServerResponses.toJsonActionResult(res);
    }

    private ActionResult findAppointmentsByProfessional(LocalDate day, Integer idProf) {
        if (idProf == null) {
            XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
            if (sessionProfessionnal != null) {
                idProf = sessionProfessionnal.getId();
            } else {
                return ServerResponses.ERROR("invalid arguments");
            }
        }
        List<XAppointment> lstAppt = this.appointmentAccessor.findAppointmentsByProfessional(idProf, day);
        return ServerResponses.toJsonActionResult(new CEditableDataObjectList<CAppointment>(AppointmentController.orderByStartTime(lstAppt), CAppointment.class));
    }

    public boolean openAppointmentEditor(Integer idProfessionnal) {
        if (Integer.valueOf(-1).equals(idProfessionnal)) {
            return Application.get().getApplicationUiPlugin().openAppointmentMultiProfEditor();
        }
        if (idProfessionnal == null || idProfessionnal == 0) {
            XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
            return Application.get().getApplicationUiPlugin().openAppointmentEditor(sessionProfessionnal);
        }
        XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getBaseProfessionnal(idProfessionnal);
        return Application.get().getApplicationUiPlugin().openAppointmentEditor(professionnal);
    }

    public ActionResult save(IServerRequest req) {
        if (req.hasPostBody() && req.hasQueryParam("type")) {
            if ("CPatientRecall".equals(req.getQueryParam("type"))) {
                CPatientRecall data = req.getPostBody(CPatientRecall.class);
                ReturnObject obj = this.appointmentAccessor.save((Serializable)data.x());
                obj.setObj((Object)new CPatientRecall((XPatientRecall)obj.getObj()));
                return ServerResponses.toJsonActionResult(obj);
            }
            return ServerResponses.ERROR("Sauvegarde non implementer");
        }
        return ServerResponses.ERROR("Invalid arguments");
    }

    public ActionResult findFuturAppointmentPatient(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPatient", Integer.class);
        List<XAppointment> lstAppt = this.appointmentAccessor.findFutureAppointmentsByPatient(id);
        return ServerResponses.toJsonActionResult(new CEditableDataObjectList<CAppointment>(AppointmentController.orderByStartTime(lstAppt), CAppointment.class));
    }

    public ActionResult findPastAppointmentPatient(IServerRequest req) {
        Integer id = req.getRequiredQueryParam("idPatient", Integer.class);
        List<XAppointment> lstAppt = this.appointmentAccessor.findPastAppointmentsByPatient(id);
        return ServerResponses.toJsonActionResult(new CEditableDataObjectList<CAppointment>(AppointmentController.orderByStartTime(lstAppt), CAppointment.class));
    }

    public ReturnObject sendEmails(IServerRequest req) {
        CAppointmentEmailMapping[] data = req.getPostBody(CAppointmentEmailMapping[].class);
        HashMap<String, Map<String, Serializable>> params = new HashMap<String, Map<String, Serializable>>(data.length);
        for (CAppointmentEmailMapping map : data) {
            params.put(map.key, map.getDataMap());
        }
        ReturnObject ret = this.appointmentAccessor.sendEmails(params);
        if (ret.getObj() instanceof List) {
            List lstAppt = (List)ret.getObj();
            return ServerResponses.OKReturnObject(new CEditableDataObjectList<CAppointment>(AppointmentController.orderByStartTime(lstAppt), CAppointment.class));
        }
        return ret;
    }

    public static List<XAppointment> orderByStartTime(List<XAppointment> list) {
        Collections.sort(list, new Comparator<XAppointment>(){

            @Override
            public int compare(XAppointment o1, XAppointment o2) {
                int i = 0;
                try {
                    Short d1 = o1.getStartTime();
                    Short d2 = o2.getStartTime();
                    i = d1.compareTo(d2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return i;
            }
        });
        return list;
    }
}

