/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.autocomplete.input;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.autocomplete.AutoCompleteFix;
import ca.infodata.ofys.client.modules.eform.autocomplete.EFormAutoComplete;
import ca.infodata.ofys.client.modules.eform.autocomplete.ObjectFormatter;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.util1.JoinList;

public class SiteAdressWithContactAC
extends AutoCompleteFix {
    public SiteAdressWithContactAC(EFormAutoComplete eformAutoComplete) {
        super("context_site_address_withcontact", eformAutoComplete);
    }

    @Override
    public String complete() {
        XSite site = Application.get().getSitePluginController().getContextSite();
        if (site != null) {
            String postalCode;
            JoinList list = new JoinList(", ", 5);
            list.setTrim(true);
            list.setAllowBlank(false);
            list.add((CharSequence)site.getStreet());
            if (site.getCity() != null) {
                list.add((CharSequence)site.getCity().getName());
            }
            if (site.getProvince() != null) {
                list.add((CharSequence)site.getProvince().getName());
            }
            if ((postalCode = site.getPostalCode()) != null && postalCode.length() == 6) {
                postalCode = postalCode.substring(0, 3) + " " + postalCode.substring(3);
            }
            list.add((CharSequence)postalCode);
            list.add("t\u00e9l.: ", ObjectFormatter.format10DigitPhoneNumber(site.getPhonenumber1()));
            list.add("t\u00e9l\u00e9c.: ", ObjectFormatter.format10DigitPhoneNumber(site.getPhonenumber2()));
            return list.toString();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Met l'adresse \u00e0 n'import quel input ayant le name et le id commen\u00e7eant par le suffix.";
    }

    @Override
    public boolean toComplete(String inputName) {
        XSite site = Application.get().getSitePluginController().getContextSite();
        boolean complete = super.toComplete(inputName);
        return complete && site != null;
    }
}

