/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.commons.lang3.math.NumberUtils;

public class EmptyStringToNumberXTypeAdapter<T extends Number>
extends TypeAdapter<T> {
    private Class<?> clazz;
    private boolean nullable = true;

    public EmptyStringToNumberXTypeAdapter(Class<T> clazz) {
        this.clazz = clazz;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public EmptyStringToNumberXTypeAdapter<T> setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public void write(JsonWriter jsonWriter, T number) throws IOException {
        if (number == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(number);
    }

    public T read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            if (this.isNullable()) {
                return null;
            }
            throw new JsonSyntaxException("null value is not supported. " + jsonReader.getPath());
        }
        try {
            String value = jsonReader.nextString();
            if ("".equals(value)) {
                if (this.isNullable()) {
                    return null;
                }
                throw new JsonSyntaxException("null value is not supported. " + jsonReader.getPath());
            }
            if (this.clazz.equals(Float.class)) {
                return (T)NumberUtils.createFloat((String)value);
            }
            if (this.clazz.equals(Double.class)) {
                return (T)NumberUtils.createDouble((String)value);
            }
            if (this.clazz.equals(Integer.class)) {
                return (T)NumberUtils.createInteger((String)value);
            }
            return (T)NumberUtils.createNumber((String)value);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

