/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.convert;

import ca.infodata.ofys.client.convert.CharacterSequenceToClassAsJson;
import ca.infodata.ofys.client.convert.IConvertProcessor;
import ca.infodata.ofys.client.convert.IConverter;
import ca.infodata.ofys.client.convert.IdentityConverter;
import ca.infodata.ofys.client.convert.ObjectToString;
import ca.infodata.ofys.client.convert.StringMapToClassAsJson;
import ca.infodata.ofys.client.convert.StringToBase64DecodedString;
import ca.infodata.ofys.client.convert.StringToBoolean;
import ca.infodata.ofys.client.convert.StringToEnum;
import ca.infodata.ofys.client.convert.StringToEnumWithValues;
import ca.infodata.ofys.client.convert.StringToIntAVLTreeSet;
import ca.infodata.ofys.client.convert.StringToInteger;
import ca.infodata.ofys.client.convert.StringToIntegerArray;
import ca.infodata.ofys.client.convert.StringToLocalDate;
import ca.infodata.ofys.client.convert.StringToString;
import ca.infodata.ofys.client.convert.StringToStringArray;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConvertProcessor
implements IConvertProcessor {
    private final CopyOnWriteArrayList<IConverter> list = new CopyOnWriteArrayList();

    public ConvertProcessor() {
        this.list.add(new StringToString());
        this.list.add(new IdentityConverter());
        this.list.add(new StringToBoolean());
        this.list.add(new StringToInteger());
        this.list.add(new StringToIntAVLTreeSet());
        this.list.add(new StringToIntegerArray());
        this.list.add(new StringToStringArray());
        this.list.add(new StringToBase64DecodedString());
        this.list.add(new StringToLocalDate());
        this.list.add(new StringToEnumWithValues());
        this.list.add(new StringToEnum());
        this.list.add(new CharacterSequenceToClassAsJson());
        this.list.add(new StringMapToClassAsJson());
        this.list.add(new ObjectToString());
    }

    @Override
    public <A, B> B convert(A a, Class<B> b) throws Exception {
        if (b == null) {
            throw new IllegalArgumentException("To type is required");
        }
        for (IConverter c : this.list) {
            if (!c.canConvert(a, b)) continue;
            return c.convert(a, b);
        }
        throw new Exception(String.format("No converter found for from value %s of type %s and converting to type %s", a, a == null ? "null" : a.getClass().getName(), b.getName()));
    }

    @Override
    public void dispose() {
    }
}

