/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class Ranges {
    @NotNull
    private Range rootRange;

    public Ranges(int minId, int maxId) {
        this.rootRange = new Range(minId, maxId + 1);
    }

    public int getId() {
        if (this.rootRange.start == this.rootRange.end) {
            return -1;
        }
        int id = this.rootRange.start++;
        if (this.rootRange.start == this.rootRange.end && this.rootRange.next != null) {
            this.rootRange = this.rootRange.next;
        }
        return id;
    }

    public void returnId(int id) {
        Range current = this.rootRange;
        if (id < current.start - 1) {
            this.rootRange = new Range(id, id + 1, current);
            return;
        }
        Range prev = current;
        current = this.returnId(current, id);
        while (current != null) {
            if (id < current.start - 1) {
                prev.next = new Range(id, id + 1, current);
                return;
            }
            prev = current;
            current = this.returnId(current, id);
        }
    }

    @Nullable
    private Range returnId(@NotNull Range range, int id) {
        Range next = range.next;
        if (id == range.start - 1) {
            range.start = id;
            return null;
        }
        if (id < range.end) {
            throw new IllegalStateException("The id was already returned. This must not happen and is a bug.");
        }
        if (id == range.end) {
            if (next == null) {
                throw new IllegalStateException("The id is greater than maxId. This must not happen and is a bug.");
            }
            ++range.end;
            if (range.end == next.start) {
                range.end = next.end;
                range.next = next.next;
            }
            return null;
        }
        if (next == null) {
            throw new IllegalStateException("The id is greater than maxId. This must not happen and is a bug.");
        }
        return next;
    }

    public int resize(int maxId) {
        Range range = this.rootRange;
        while (range.end <= maxId) {
            Range next = range.next;
            if (next == null) {
                range.end = maxId + 1;
                return 0;
            }
            range = next;
        }
        int count = range.start - (maxId + 1);
        if (count < 0) {
            count = 0;
        }
        while (range.next != null) {
            Range next = range.next;
            count += next.start - range.end;
            range = next;
        }
        if (count == 0) {
            range.end = maxId + 1;
        }
        return count;
    }

    private static class Range {
        int start;
        int end;
        @Nullable
        Range next;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        Range(int start, int end, @NotNull Range next) {
            this.start = start;
            this.end = end;
            this.next = next;
        }
    }
}

