/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.JoinList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PojoDiff<E> {
    private E o1;
    private E o2;

    public static void main(String[] args) {
        Patient patient = new Patient();
        Appointment a1 = new Appointment();
        a1.patient = patient;
        a1.note = "note1";
        a1.startTime = 600;
        Appointment a2 = new Appointment();
        a2.patient = patient;
        a2.note = "salut";
        a2.startTime = 400;
        PojoDiff<Appointment> diff = new PojoDiff<Appointment>(a1, a2);
        List<Diff> diffs = diff.compute();
        System.out.println(new JoinList("\n", diffs));
    }

    public PojoDiff(E o1, E o2) {
        if (o1 == null) {
            throw new NullPointerException("o1");
        }
        if (o2 == null) {
            throw new NullPointerException("o2");
        }
        this.o1 = o1;
        this.o2 = o2;
    }

    public List<Diff> compute() {
        Method[] methods;
        ArrayList<Diff> list = new ArrayList<Diff>();
        for (Method method : methods = this.o1.getClass().getMethods()) {
            Object value2;
            Object value1;
            String name = method.getName();
            if (!name.startsWith("get") || method.getReturnType().equals(Void.class) || method.getParameterTypes().length != 0 || PojoDiff.areObjectsEquals(value1 = this.invoke(method, this.o1), value2 = this.invoke(method, this.o2))) continue;
            Diff diff = new Diff();
            diff.field = name.substring("get".length());
            diff.value1 = value1;
            diff.value2 = value2;
            list.add(diff);
        }
        return list;
    }

    private Object invoke(Method m, Object o) {
        try {
            return m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean areObjectsEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static class Diff {
        public String field;
        public Object value1;
        public Object value2;

        public String toString() {
            return String.format("Diff [field=%s, value1=%s, value2=%s]", this.field, this.value1, this.value2);
        }
    }

    private static class Patient {
        String name;

        private Patient() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class Appointment {
        Integer startTime;
        String note;
        Patient patient;

        private Appointment() {
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public String getNote() {
            return this.note;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public Patient getPatient() {
            return this.patient;
        }

        public void setPatient(Patient patient) {
            this.patient = patient;
        }
    }
}

