/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.DateUtils;
import ca.infodata.readhl7.Doit;
import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.infodata.readhl7.tools.JoinList;
import ca.infodata.readhl7.tools.Utils;
import ca.infodata.util1.StringUtils;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.model.v251.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v251.message.ORU_R01;
import ca.uhn.hl7v2.parser.CanonicalModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.ga.log.ro.SimpleLogger;

public class ORU_R01v251Handler
implements MessageHandler {
    private final boolean isTest = false;
    ORU_R01 msg = null;
    private Terser terser;
    protected static final SimpleLogger logger = new SimpleLogger(ORU_R01v251Handler.class);

    @Override
    public void init(String hl7Body) throws HL7Exception {
        DefaultHapiContext context = new DefaultHapiContext();
        CanonicalModelClassFactory mcf = new CanonicalModelClassFactory("2.5.1");
        context.setModelClassFactory(mcf);
        PipeParser pp = new PipeParser(mcf);
        this.msg = hl7Body.indexOf("\r\n") == -1 ? (ORU_R01)pp.parse(hl7Body.replaceAll("\n", "\r\n")) : (ORU_R01)pp.parse(hl7Body);
        pp.getParserConfiguration().setValidating(false);
        this.msg = hl7Body.indexOf("\r\n") == -1 ? (ORU_R01)pp.parse(hl7Body) : (ORU_R01)pp.parse(hl7Body);
        this.terser = new Terser(this.msg);
        try {
            context.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMsgType() {
        return "ORU_R01";
    }

    @Override
    public String getMsgDate() {
        try {
            int i;
            String obrDate = null;
            String date = null;
            int max = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            for (i = 0; !(i >= max || StringUtils.isNotEmpty(obrDate = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getResultsRptStatusChngDateTime().getTime().getValue()) && StringUtils.isNotEmpty(date = this.formatDateTime(obrDate))); ++i) {
            }
            if (StringUtils.isEmpty(date)) {
                for (i = 0; !(i >= max || StringUtils.isNotEmpty(obrDate = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObservationDateTime().getTime().getValue()) && StringUtils.isNotEmpty(date = this.formatDateTime(obrDate))); ++i) {
                }
            }
            if (StringUtils.isEmpty(date)) {
                date = DateUtils.getDateTime();
            }
            return date;
        }
        catch (Exception e) {
            logger.error("Could not retrieve message date : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        return this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
    }

    @Override
    public int getOBXCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATIONReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            String status = "";
            try {
                status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (status.equalsIgnoreCase("I")) {
                return "";
            }
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr7_ObservationDateTime().getTime().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            String flag = this.getOBXAbnormalFlag(i, j);
            return flag.equals("A") || flag.startsWith("H") || flag.startsWith("L");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            IS[] af = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags();
            StringBuilder sb = new StringBuilder();
            for (IS is : af) {
                sb.append(is.getValue()).append(" ");
            }
            return this.getString(sb.toString().trim());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getDiagnosticServSectID().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        String result = "";
        try {
            StringBuilder sb = new StringBuilder();
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationValue().length;
            for (int k = 0; k < m; ++k) {
                String s = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 1, 1);
                String ss = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 2, 1);
                if (ss != null) {
                    s = s != null && s.matches("[+#><A-Z0-9,]*") ? ss : s + " " + ss;
                }
                if (s == null) continue;
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            return "";
        }
        return result;
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        String status = "";
        try {
            status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            if (status.equalsIgnoreCase("I")) {
                status = "Attente";
            } else if (status.equalsIgnoreCase("F")) {
                status = "Final";
            } else if (status.equalsIgnoreCase("C")) {
                status = "Comm.";
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving obx result status : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return status;
        }
        return status;
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                if (!this.getOBXResultStatus(i, j).equals("Final")) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                if (headers.contains(currentHeader)) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            logger.error("Could not create header list : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return null;
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTEReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment().length;
            StringBuilder sb = new StringBuilder();
            for (int l = 0; l < m; ++l) {
                String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment(l).getValue());
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        int count = 0;
        try {
            String comment;
            count = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTEReps();
            if (count == 1 && (comment = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE().getComment(0).getValue()) == null) {
                count = 0;
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving obx comment count : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
        }
        return count;
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment().length;
            StringBuilder sb = new StringBuilder();
            for (int l = 0; l < m; ++l) {
                String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment(l).getValue());
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        String name = null;
        try {
            this.getClass();
            name = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0).getGivenName().getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    @Override
    public String getLastName() {
        String name = null;
        try {
            this.getClass();
            name = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0).getFamilyName().getSurname().getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getDateTimeOfBirth().getTime().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            logger.error("Could not get age : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAdministrativeSex().getValue());
    }

    @Override
    public String getHealthNum() {
        try {
            String id;
            int i;
            String nam = null;
            for (i = 0; i < 4 && (id = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIdentifierTypeCode().getValue()) != null; ++i) {
                if ("RAMQNUMBER".equals(id) || "CANQC".equals(id)) {
                    nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                    break;
                }
                id = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getAssigningAuthority().getHd1_NamespaceID().getValue();
                if (!"RAMQNUMBER".equals(id) && !"CANQC".equals(id)) continue;
                nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                break;
            }
            if (nam != null) {
                return nam;
            }
            for (i = 0; i < 4 && (id = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID(i).getIdentifierTypeCode().getValue()) != null; ++i) {
                if (!"RAMQNUMBER".equals(id) && !"CANQC".equals(id)) continue;
                nam = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID(i).getIDNumber().getValue();
                break;
            }
            if (nam != null) {
                return nam;
            }
            return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID()[0].getIDNumber().getValue());
        }
        catch (Exception e) {
            try {
                return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientID().getIDNumber().getValue());
            }
            catch (Exception e1) {
                logger.error("Exception finding health number : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
                return "";
            }
        }
    }

    @Override
    public String getFileNum() {
        try {
            int i;
            String no = null;
            String nam = this.getHealthNum();
            ArrayList<String> lst = new ArrayList<String>();
            int len = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList().length;
            for (i = 0; i < len; ++i) {
                no = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientIdentifierList(i).getIDNumber().getValue();
                if (!StringUtils.isNotEmpty(no) || no.equals(nam)) continue;
                lst.add(no);
            }
            int lenAlt = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID().length;
            for (i = 0; i < lenAlt; ++i) {
                no = this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAlternatePatientIDPID(i).getIDNumber().getValue();
                if (!StringUtils.isNotEmpty(no) || no.equals(nam)) continue;
                lst.add(no);
            }
            if (no != null) {
                return new JoinList(", ", lst).toString();
            }
        }
        catch (Exception e) {
            try {
                return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientID().getIDNumber().getValue());
            }
            catch (Exception e1) {
                logger.error("Exception finding health number : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
                return "";
            }
        }
        return "";
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).getTelephoneNumber().getValue()).equals(""); ++i) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).getTelephoneNumber().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).getTelephoneNumber().getValue());
            }
            return phone;
        }
        catch (Exception e) {
            logger.error("Could not return phone number : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).getTelephoneNumber().getValue()).equals(""); ++i) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).getTelephoneNumber().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).getTelephoneNumber().getValue());
            }
            return phone;
        }
        catch (Exception e) {
            logger.error("Could not return phone number : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        String loc;
        try {
            loc = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc13_EntererSLocation().getFacility().getNamespaceID().getValue();
            if (StringUtils.isEmpty(loc)) {
                loc = this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
            }
        }
        catch (Exception e) {
            loc = this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
        }
        return loc;
    }

    @Override
    public String getServiceDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getDateTimeOfTransaction().getTime().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            String status = "F";
            int obrCount = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            for (int i = 0; i < obrCount; ++i) {
                String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getResultStatus().getValue());
                if (s.equals("C")) {
                    status = "C";
                    break;
                }
                if (s.equals("F") || s.equals("X")) continue;
                status = "P";
                break;
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Exception retrieving order status : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals(""); ++i) {
                docNum = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue());
            }
            return docNum;
        }
        catch (Exception e) {
            logger.error("Could not return doctor id numbers : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        String accessionNum = "";
        try {
            accessionNum = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getPlacerOrderNumber().getEntityIdentifier().getValue());
            String fillOrder = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getFillerOrderNumber().getEntityIdentifier().getValue());
            if (StringUtils.isNotEmpty(fillOrder) && !accessionNum.equals(fillOrder)) {
                String comma = StringUtils.isNotEmpty(accessionNum) && StringUtils.isNotEmpty(fillOrder) ? ", " : "";
                accessionNum = accessionNum + comma + fillOrder;
            }
            return accessionNum;
        }
        catch (Exception e) {
            logger.error("Could not return accession number : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return "";
        }
    }

    @Override
    public String getDocName() {
        String docName = "";
        try {
            if (this.msg != null && this.msg.getPATIENT_RESULT() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR() != null) {
                for (int i = 0; i < 10 && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i) != null && !"".equals(this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i))); ++i) {
                    String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getOrderingProvider(0));
                    if (temp == null) continue;
                    if (i == 0) {
                        docName = temp;
                        continue;
                    }
                    if (docName.indexOf(temp) != -1) continue;
                    docName = docName + ", " + temp;
                }
            }
            return docName;
        }
        catch (Exception e) {
            logger.error("Could not return doctor names : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return docName;
        }
    }

    @Override
    public String getCCDocs() {
        String docName = "";
        try {
            for (int i = 0; i < 10 && !"".equals(this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i))); ++i) {
                String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
                if (temp == null) continue;
                if (i == 0) {
                    docName = temp;
                    continue;
                }
                if (docName.indexOf(temp) != -1) continue;
                docName = docName + ", " + temp;
            }
            return docName;
        }
        catch (Exception e) {
            logger.error("Could not return cc'ed doctors : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
            return docName;
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> docNums = new ArrayList<String>();
        try {
            String id;
            String providerId = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(0).getIDNumber().getValue();
            docNums.add(providerId);
            for (int i = 0; i < 10 && (id = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getResultCopiesTo(i).getIDNumber().getValue()) != null; ++i) {
                if (docNums.contains(id)) continue;
                docNums.add(id);
            }
        }
        catch (Exception e) {
            logger.error("Could not return doctor nums : " + e.getMessage() + (e.getCause() != null ? e.getCause().getMessage() : ""));
        }
        return docNums;
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(XCN docSeg) {
        String docName = "";
        if (docSeg.getGivenName().getValue() != null) {
            docName = "".equals(docName) ? docSeg.getGivenName().getValue() : docName + " " + docSeg.getGivenName().getValue();
        }
        if (docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue() != null) {
            docName = "".equals(docName) ? docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue() : docName + " " + docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue();
        }
        if (docSeg.getFamilyName().getSurname() != null) {
            docName = "".equals(docName) ? docSeg.getFamilyName().getSurname().getValue() : docName + " " + docSeg.getFamilyName().getSurname().getValue();
        }
        if (docSeg.getSuffixEgJRorIII().getValue() != null) {
            docName = "".equals(docName) ? docSeg.getSuffixEgJRorIII().getValue() : docName + " " + docSeg.getSuffixEgJRorIII().getValue();
        }
        if (docSeg.getDegreeEgMD().getValue() != null) {
            docName = "".equals(docName) ? docSeg.getDegreeEgMD().getValue() : docName + " " + docSeg.getDegreeEgMD().getValue();
        }
        return docName;
    }

    private String formatDateTime(String plain) {
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            retrieve.replaceAll("^", " ");
            return retrieve.trim();
        }
        return "";
    }

    @Override
    public String getPrelDate() {
        try {
            ArrayList<String> lst = new ArrayList<String>();
            List<ORU_R01_ORDER_OBSERVATION> orderObserv = this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONAll();
            for (ORU_R01_ORDER_OBSERVATION ord : orderObserv) {
                String s = this.getString(ord.getOBR().getObr7_ObservationDateTime().encode());
                boolean b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
                s = this.getString(ord.getORC().getOrc9_DateTimeOfTransaction().encode());
                b = StringUtils.isNotEmpty(s) ? lst.add(s) : false;
            }
            Collections.sort(lst);
            return this.formatDateTime((String)lst.get(0));
        }
        catch (Exception e) {
            logger.errorException(new Exception("Could not retrieve message date", e));
            return "";
        }
    }

    @Override
    public String getOBRSpecimen(int i) {
        try {
            String collMethod = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSpecimenCollectionMethod().getValue());
            String source = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSpecimenSourceNameOrCode().getCwe2_Text().getValue());
            String site = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr15_SpecimenSource().getSps4_BodySite().getCwe2_Text().getValue());
            String spec = new JoinList(" - ", source, site, collMethod).toString().trim();
            if (spec.toLowerCase().equals("whole blood") || spec.toLowerCase().equals("urine")) {
                return "";
            }
            return spec;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        String s = "";
        try {
            EI[] equipmentInstanceIdentifier = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getEquipmentInstanceIdentifier();
            if (equipmentInstanceIdentifier != null && equipmentInstanceIdentifier.length > 0) {
                s = equipmentInstanceIdentifier[0].getEi2_NamespaceID().getValue();
                s = StringUtils.isBlank(s) ? equipmentInstanceIdentifier[0].getEntityIdentifier().getValue() : s;
            }
        }
        catch (Exception e) {
            logger.errorException(new Exception("Error retrieving obx result status", e));
            return s;
        }
        return s;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        try {
            String userAccCheck = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUserDefinedAccessChecks().getValue();
            if (StringUtils.isBlank(userAccCheck) || userAccCheck.length() < 4) {
                return "";
            }
            if (userAccCheck.length() > 80) {
                userAccCheck = WordUtils.wrap(userAccCheck, 70);
            }
            return Utils.replaceCharToHtmlChar(userAccCheck);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getSpecimenName(int j) {
        return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getSPECIMEN().getSPM().getSpm7_SpecimenCollectionMethod().getCwe2_Text().getValue());
    }

    @Override
    public String[] getDspLines() {
        String[] lines = null;
        try {
            String ln;
            String s = this.msg.getMessage().encode();
            int l = 0;
            StringReader reader = new StringReader(s);
            BufferedReader br = new BufferedReader(reader);
            ArrayList<String> lst = new ArrayList<String>();
            while ((ln = br.readLine()) != null) {
                if (!ln.startsWith("DSP")) continue;
                String dsp = "DSP|" + ++l + "||";
                lst.add(ln.substring(dsp.length()).replaceAll("(  )", "&nbsp;"));
            }
            lines = lst.toArray(new String[0]);
        }
        catch (Exception e) {
            logger.errorException(new Exception("Could not return dsp lines", e));
        }
        return lines;
    }

    @Override
    public String getPdfFromObx55(int j) {
        String s = "";
        try {
            String t = "/.SPECIMEN(" + j + ")/OBX-5-5";
            s = this.terser.get(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }

    static {
        logger.setDebugLevel(Doit.LOG_LEVEL);
    }
}

