/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultGenericHandler
implements MessageHandler {
    Logger logger = Logger.getLogger(DefaultGenericHandler.class.getName());
    protected Message msg = null;
    protected Terser terser;
    protected ArrayList<List<? extends Segment>> obrGroups = null;

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = ((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
        this.terser = new Terser(this.msg);
        int obrCount = this.getOBRCount();
        String[] segments = this.terser.getFinder().getRoot().getNames();
        System.out.println("segments: " + segments.toString());
        this.obrGroups = new ArrayList();
        for (int i = 0; i < obrCount; ++i) {
            ArrayList<Segment> obxSegs = new ArrayList<Segment>();
            int obrNum = i + 1;
            boolean obrFlag = false;
            for (String segment : segments) {
                String segmentName = segment.substring(0, 3);
                if (obrFlag && segmentName.equals("OBX")) {
                    Structure[] segs;
                    for (Structure seg : segs = this.terser.getFinder().getRoot().getAll(segment)) {
                        Segment obxSeg = (Segment)seg;
                        obxSegs.add(obxSeg);
                    }
                    continue;
                }
                if (obrFlag && segmentName.equals("OBR")) break;
                if (!segment.equals("OBR" + obrNum) && (obrNum != 1 || !segment.equals("OBR"))) continue;
                obrFlag = true;
            }
            this.obrGroups.add(obxSegs);
        }
    }

    @Override
    public String getMsgType() {
        return null;
    }

    @Override
    public String getMsgDate() {
        try {
            String dateString = this.formatDateTime(this.getString(this.terser.get("/.MSH-7-1")));
            return dateString;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        if (this.obrGroups != null) {
            return this.obrGroups.size();
        }
        int i = 1;
        try {
            Segment test = this.terser.getSegment("/.OBR");
            while (test != null) {
                test = (Segment)this.terser.getFinder().getRoot().get("OBR" + ++i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i - 1;
    }

    @Override
    public String getOBRName(int i) {
        ++i;
        try {
            String obrName;
            if (i == 1) {
                obrName = this.getString(this.terser.get("/.OBR-4-2"));
                if (obrName.equals("")) {
                    obrName = this.getString(this.terser.get("/.OBR-4-1"));
                }
            } else {
                Segment obrSeg = (Segment)this.terser.getFinder().getRoot().get("OBR" + i);
                obrName = this.getString(Terser.get(obrSeg, 4, 0, 2, 1));
                if (obrName.equals("")) {
                    obrName = this.getString(Terser.get(obrSeg, 4, 0, 1, 1));
                }
            }
            return obrName;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        ++i;
        try {
            String timeStamp;
            if (i == 1) {
                timeStamp = this.formatDateTime(this.getString(this.terser.get("/.OBR-7-1")));
            } else {
                Segment obrSeg = (Segment)this.terser.getFinder().getRoot().get("OBR" + i);
                timeStamp = this.formatDateTime(this.getString(Terser.get(obrSeg, 7, 0, 1, 1)));
            }
            return timeStamp;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        String abnormalFlag = this.getOBXAbnormalFlag(i, j);
        return !abnormalFlag.equals("") && !abnormalFlag.equals("N");
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        return this.getOBXField(i, j, 8, 0, 1);
    }

    @Override
    public String getObservationHeader(int i, int j) {
        return "";
    }

    @Override
    public int getOBXCount(int i) {
        if (this.obrGroups != null) {
            List<? extends Segment> obxSegs = this.obrGroups.get(i);
            return obxSegs.size();
        }
        return 0;
    }

    @Override
    public String getOBXValueType(int i, int j) {
        return this.getOBXField(i, j, 2, 0, 1);
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        return this.getOBXField(i, j, 3, 0, 1);
    }

    @Override
    public String getOBXName(int i, int j) {
        return this.getOBXField(i, j, 3, 0, 2);
    }

    @Override
    public String getOBXResult(int i, int j) {
        return this.getOBXField(i, j, 5, 0, 1);
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        return this.getOBXField(i, j, 7, 0, 1);
    }

    @Override
    public String getOBXUnits(int i, int j) {
        return this.getOBXField(i, j, 6, 0, 1);
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        return this.getOBXField(i, j, 11, 0, 1);
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                String status = this.getOBXResultStatus(i, j);
                if (!status.startsWith("F") && !status.startsWith("f")) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("");
        return headers;
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            String[] segments = this.terser.getFinder().getRoot().getNames();
            int k = this.getNTELocation(i, -1);
            int count = 0;
            if (k < segments.length && segments[k].substring(0, 3).equals("NTE")) {
                Structure[] nteSegs = this.terser.getFinder().getRoot().getAll(segments[k]);
                count = nteSegs.length;
            }
            return count;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "OBR Comment count error", e);
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            String[] segments = this.terser.getFinder().getRoot().getNames();
            int k = this.getNTELocation(i, -1);
            Structure[] nteSegs = this.terser.getFinder().getRoot().getAll(segments[k]);
            Segment nteSeg = (Segment)nteSegs[j];
            return this.getString(Terser.get(nteSeg, 3, 0, 1, 1));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve OBX comments", e);
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        try {
            String[] segments = this.terser.getFinder().getRoot().getNames();
            int k = this.getNTELocation(i, j);
            int count = 0;
            if (k < segments.length && segments[k].substring(0, 3).equals("NTE")) {
                Structure[] nteSegs = this.terser.getFinder().getRoot().getAll(segments[k]);
                count = nteSegs.length;
            }
            return count;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "OBR Comment count error", e);
            return 0;
        }
    }

    @Override
    public String getOBXComment(int i, int j, int nteNum) {
        try {
            String[] segments = this.terser.getFinder().getRoot().getNames();
            int k = this.getNTELocation(i, j);
            Structure[] nteSegs = this.terser.getFinder().getRoot().getAll(segments[k]);
            Segment nteSeg = (Segment)nteSegs[nteNum];
            return this.getString(Terser.get(nteSeg, 3, 0, 1, 1));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve OBX comments", e);
            return "";
        }
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        try {
            return this.getString(this.terser.get("/.PID-5-2"));
        }
        catch (HL7Exception ex) {
            return "";
        }
    }

    @Override
    public String getLastName() {
        try {
            return this.getString(this.terser.get("/.PID-5-1"));
        }
        catch (HL7Exception ex) {
            return "";
        }
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.terser.get("/.PID-7-1"))).substring(0, 10);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        try {
            return this.getString(this.terser.get("/.PID-8-1"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getHealthNum() {
        try {
            String healthNum = this.getString(this.terser.get("/.PID-2-1"));
            if (healthNum.length() == 12) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-4-1"));
            if (healthNum.length() == 12) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-3-1"));
            if (healthNum.length() == 12) {
                return healthNum;
            }
            healthNum = this.getString(this.terser.get("/.PID-19-1"));
            if (healthNum.length() == 12) {
                return healthNum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String getFileNum() {
        return "";
    }

    @Override
    public String getHomePhone() {
        try {
            return this.getString(this.terser.get("/.PID-13-1"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        return "";
    }

    @Override
    public String getPatientLocation() {
        try {
            return this.getString(this.terser.get("/.MSH-4-1"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getServiceDate() {
        return "";
    }

    @Override
    public String getOrderStatus() {
        return "";
    }

    @Override
    public String getClientRef() {
        try {
            return this.getString(this.terser.get("/.OBR-16-1"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        return "";
    }

    @Override
    public String getDocName() {
        try {
            return this.getFullDocName("/.OBR-16-");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getCCDocs() {
        try {
            int i = 0;
            String docs = this.getFullDocName("/.OBR-28(" + i + ")-");
            String nextDoc = this.getFullDocName("/.OBR-28(" + ++i + ")-");
            while (!nextDoc.equals("")) {
                docs = docs + ", " + nextDoc;
                nextDoc = this.getFullDocName("/.OBR-28(" + ++i + ")-");
            }
            return docs;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> nums = new ArrayList<String>();
        try {
            String docNum = this.terser.get("/.OBR-16-1");
            if (docNum != null) {
                nums.add(docNum);
            }
            int i = 0;
            while ((docNum = this.terser.get("/.OBR-28(" + i + ")-1")) != null) {
                nums.add(docNum);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nums;
    }

    @Override
    public String audit() {
        return "";
    }

    protected String getOBXField(int i, int j, int field, int rep, int comp) {
        List<? extends Segment> obxSegs = this.obrGroups.get(i);
        try {
            Segment obxSeg = obxSegs.get(j);
            return this.getString(Terser.get(obxSeg, field, rep, comp, 1));
        }
        catch (Exception e) {
            return "";
        }
    }

    private int getNTELocation(int i, int j) throws HL7Exception {
        int k;
        int obrCount = 0;
        int obxCount = 0;
        String[] segments = this.terser.getFinder().getRoot().getNames();
        for (k = 0; k != segments.length && obrCount != i + 1; ++k) {
            if (!segments[k].substring(0, 3).equals("OBR")) continue;
            ++obrCount;
        }
        while (k != segments.length && obxCount != j + 1) {
            if (segments[k].substring(0, 3).equals("OBX")) {
                Structure[] obxSegs = this.terser.getFinder().getRoot().getAll(segments[k]);
                obxCount += obxSegs.length;
            }
            ++k;
        }
        return k;
    }

    private String getFullDocName(String docSeg) throws HL7Exception {
        String docName = "";
        String temp = this.terser.get(docSeg + "6");
        if (temp != null) {
            docName = temp;
        }
        if ((temp = this.terser.get(docSeg + "3")) != null) {
            docName = docName.equals("") ? temp : docName + " " + temp;
        }
        if (this.terser.get(docSeg + "4") != null) {
            docName = docName + " " + this.terser.get(docSeg + "4");
        }
        if (this.terser.get(docSeg + "2") != null) {
            docName = docName + " " + this.terser.get(docSeg + "2");
        }
        if (this.terser.get(docSeg + "5") != null) {
            docName = docName + " " + this.terser.get(docSeg + "5");
        }
        if (this.terser.get(docSeg + "7") != null) {
            docName = docName + " " + this.terser.get(docSeg + "7");
        }
        return docName;
    }

    protected String formatDateTime(String plain) {
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    protected String getString(String retrieve) {
        if (retrieve != null) {
            retrieve.replaceAll("^", " ");
            return retrieve.trim().replaceAll("\\\\\\.br\\\\", "<br />");
        }
        return "";
    }

    public String toString() {
        return "DefaultGenericHandler{terser=" + this.terser + "obrGroups=" + this.obrGroups + '}';
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

