/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.preparser;

import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.preparser.DatumPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ER7 {
    static final String segmentSeparators = "\r\n\f";

    private ER7() {
    }

    public static boolean parseMessage(Properties props, List<DatumPath> msgMask, String message) {
        boolean ok = false;
        if (message != null) {
            String firstSegment;
            EncodingCharacters encodingChars;
            StringTokenizer messageTokenizer;
            if (props == null) {
                props = new Properties();
            }
            if ((messageTokenizer = new StringTokenizer(message, segmentSeparators)).hasMoreTokens() && ER7.parseMSHSegmentWhole(props, msgMask, encodingChars = new EncodingCharacters('0', "0000"), firstSegment = messageTokenizer.nextToken())) {
                ok = true;
                TreeMap<String, Integer> segmentId2nextRepIdx = new TreeMap<String, Integer>();
                segmentId2nextRepIdx.put(new String("MSH"), 1);
                while (messageTokenizer.hasMoreTokens()) {
                    ER7.parseSegmentWhole(props, segmentId2nextRepIdx, msgMask, encodingChars, messageTokenizer.nextToken());
                }
            }
        }
        return ok;
    }

    protected static boolean parseMSHSegmentWhole(Properties props, List<DatumPath> msgMask, EncodingCharacters encodingChars, String segment) {
        boolean ret = false;
        try {
            ER7SegmentHandler handler = new ER7SegmentHandler();
            handler.m_props = props;
            handler.m_encodingChars = encodingChars;
            handler.m_segmentId = "MSH";
            handler.m_segmentRepIdx = 0;
            if (msgMask != null) {
                handler.m_msgMask = msgMask;
            } else {
                handler.m_msgMask = new ArrayList<DatumPath>();
                handler.m_msgMask.add(new DatumPath());
            }
            encodingChars.setFieldSeparator(segment.charAt(3));
            ArrayList<Integer> nodeKey = new ArrayList<Integer>();
            nodeKey.add(new Integer(0));
            handler.putDatum(nodeKey, String.valueOf(encodingChars.getFieldSeparator()));
            encodingChars.setComponentSeparator(segment.charAt(4));
            encodingChars.setRepetitionSeparator(segment.charAt(5));
            encodingChars.setEscapeCharacter(segment.charAt(6));
            encodingChars.setSubcomponentSeparator(segment.charAt(7));
            nodeKey.set(0, new Integer(1));
            handler.putDatum(nodeKey, encodingChars.toString());
            if (segment.charAt(8) == encodingChars.getFieldSeparator()) {
                ret = true;
                nodeKey.clear();
                nodeKey.add(new Integer(2));
                ER7.parseSegmentGuts(handler, segment.substring(9), nodeKey);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ret;
    }

    protected static void parseSegmentWhole(Properties props, Map<String, Integer> segmentId2nextRepIdx, List<DatumPath> msgMask, EncodingCharacters encodingChars, String segment) {
        try {
            String segmentId = segment.substring(0, 3);
            int currentSegmentRepIdx = 0;
            currentSegmentRepIdx = segmentId2nextRepIdx.containsKey(segmentId) ? segmentId2nextRepIdx.get(segmentId) : 0;
            segmentId2nextRepIdx.put(segmentId, new Integer(currentSegmentRepIdx + 1));
            boolean parseThisSegment = false;
            DatumPath segmentIdAsDatumPath = new DatumPath().add(segmentId);
            Iterator<DatumPath> maskIt = msgMask.iterator();
            while (!parseThisSegment && maskIt.hasNext()) {
                parseThisSegment = segmentIdAsDatumPath.startsWith(maskIt.next());
            }
            maskIt = msgMask.iterator();
            while (!parseThisSegment && maskIt.hasNext()) {
                parseThisSegment = maskIt.next().startsWith(segmentIdAsDatumPath);
            }
            if (parseThisSegment && segment.charAt(3) == encodingChars.getFieldSeparator()) {
                ER7SegmentHandler handler = new ER7SegmentHandler();
                handler.m_props = props;
                handler.m_encodingChars = encodingChars;
                handler.m_segmentId = segmentId;
                handler.m_msgMask = msgMask;
                handler.m_segmentRepIdx = currentSegmentRepIdx;
                ArrayList<Integer> nodeKey = new ArrayList<Integer>();
                nodeKey.add(new Integer(0));
                ER7.parseSegmentGuts(handler, segment.substring(4), nodeKey);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected static void parseSegmentGuts(Handler handler, String guts, List<Integer> nodeKey) {
        char thisDepthsDelim = handler.delim(nodeKey.size() - 1);
        StringTokenizer gutsTokenizer = new StringTokenizer(guts, String.valueOf(thisDepthsDelim), true);
        while (gutsTokenizer.hasMoreTokens()) {
            String gutsToken = gutsTokenizer.nextToken();
            if (gutsToken.charAt(0) == thisDepthsDelim) {
                int oldvalue = nodeKey.get(nodeKey.size() - 1);
                nodeKey.set(nodeKey.size() - 1, new Integer(oldvalue + gutsToken.length()));
                continue;
            }
            if (nodeKey.size() < handler.specDepth()) {
                nodeKey.add(new Integer(0));
                ER7.parseSegmentGuts(handler, gutsToken, nodeKey);
                nodeKey.remove(nodeKey.size() - 1);
                continue;
            }
            handler.putDatum(nodeKey, gutsToken);
        }
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            System.out.println(args[0]);
            Properties props = new Properties();
            ArrayList<DatumPath> msgMask = new ArrayList<DatumPath>();
            msgMask.add(new DatumPath());
            System.err.println("ER7.parseMessage returned " + ER7.parseMessage(props, msgMask, args[0]));
            props.list(System.out);
        }
    }

    protected static class ER7SegmentHandler
    implements Handler {
        Properties m_props;
        EncodingCharacters m_encodingChars;
        String m_segmentId;
        int m_segmentRepIdx;
        List<DatumPath> m_msgMask;

        protected ER7SegmentHandler() {
        }

        @Override
        public int specDepth() {
            return 4;
        }

        @Override
        public char delim(int level) {
            if (level == 0) {
                return this.m_encodingChars.getFieldSeparator();
            }
            if (level == 1) {
                return this.m_encodingChars.getRepetitionSeparator();
            }
            if (level == 2) {
                return this.m_encodingChars.getComponentSeparator();
            }
            if (level == 3) {
                return this.m_encodingChars.getSubcomponentSeparator();
            }
            if (level == 4) {
                return this.m_encodingChars.getTruncationCharacter();
            }
            throw new Error();
        }

        @Override
        public void putDatum(List<Integer> valNodeKey, String value) {
            DatumPath valDatumPath = new DatumPath();
            valDatumPath.add(this.m_segmentId).add(this.m_segmentRepIdx);
            for (int i = 0; i < valNodeKey.size(); ++i) {
                int itval = valNodeKey.get(i);
                valDatumPath.add(new Integer(i == 1 ? itval : itval + 1));
            }
            boolean valDatumPathPassesMask = false;
            Iterator<DatumPath> maskIt = this.m_msgMask.iterator();
            while (!valDatumPathPassesMask && maskIt.hasNext()) {
                valDatumPathPassesMask = valDatumPath.startsWith(maskIt.next());
            }
            if (valDatumPathPassesMask) {
                this.m_props.setProperty(valDatumPath.toString(), value);
            }
        }
    }

    protected static interface Handler {
        public int specDepth();

        public char delim(int var1);

        public void putDatum(List<Integer> var1, String var2);
    }
}

