/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.CP;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.NULLDT;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DG1
extends AbstractSegment {
    public DG1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 0, new Object[]{this.getMessage()}, "Set ID - DG1");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Coding Method");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Code - DG1");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Description");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Date/Time");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Type");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Major Diagnostic Category");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnostic Related Group");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "DRG Approval Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Grouper Review Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Type");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Days");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Cost");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Grouper Version And Type");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Priority");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Diagnosing Clinician");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Classification");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Confidential Indicator");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Attestation Date/Time");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnosis Identifier");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(206)}, "Diagnosis Action Code");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Diagnosis");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG CCL Value Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "DRG Grouping Usage");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Diagnosis Determination Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Present On Admission (POA) Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DG1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDDG1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getDg11_SetIDDG1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getDiagnosisCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getDg12_DiagnosisCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getDiagnosisCodeDG1() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getDg13_DiagnosisCodeDG1() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getDiagnosisDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getDg14_DiagnosisDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getDiagnosisDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getDg15_DiagnosisDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getDiagnosisType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getDg16_DiagnosisType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getMajorDiagnosticCategory() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getDg17_MajorDiagnosticCategory() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getDiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public CNE getDg18_DiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getDRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getDg19_DRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getDRGGrouperReviewCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getDg110_DRGGrouperReviewCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getOutlierType() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getDg111_OutlierType() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getOutlierDays() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getDg112_OutlierDays() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getDg113_OutlierCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public NULLDT getGrouperVersionAndType() {
        NULLDT retVal = (NULLDT)this.getTypedField(14, 0);
        return retVal;
    }

    public NULLDT getDg114_GrouperVersionAndType() {
        NULLDT retVal = (NULLDT)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getDiagnosisPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getDg115_DiagnosisPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getDiagnosingClinician() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getDg116_DiagnosingClinician() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getDiagnosingClinicianReps() {
        return this.getReps(16);
    }

    public XCN getDiagnosingClinician(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getDg116_DiagnosingClinician(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getDg116_DiagnosingClinicianReps() {
        return this.getReps(16);
    }

    public XCN insertDiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertDg116_DiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeDiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeDg116_DiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public CWE getDiagnosisClassification() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getDg117_DiagnosisClassification() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDg118_ConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getAttestationDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getDg119_AttestationDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public EI getDiagnosisIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public EI getDg120_DiagnosisIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getDiagnosisActionCode() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getDg121_DiagnosisActionCode() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public EI getParentDiagnosis() {
        EI retVal = (EI)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getDg122_ParentDiagnosis() {
        EI retVal = (EI)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getDRGCCLValueCode() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getDg123_DRGCCLValueCode() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDRGGroupingUsage() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getDg124_DRGGroupingUsage() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getDRGDiagnosisDeterminationStatus() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getDg125_DRGDiagnosisDeterminationStatus() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getPresentOnAdmissionIndicator() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getDg126_PresentOnAdmissionIndicator() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NULLDT(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new NULLDT(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
            case 7: {
                return new CNE(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new NULLDT(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new EI(this.getMessage());
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 21: {
                return new EI(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

