/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIG
extends AbstractSegment {
    public AIG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 0, new Object[]{this.getMessage()}, "Set ID - AIG");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource ID");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Resource Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Resource Group");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource Quantity");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource Quantity Units");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Duration");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Duration Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allow Substitution Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIG - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDAIG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAig1_SetIDAIG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAig2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getResourceID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAig3_ResourceID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getResourceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAig4_ResourceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE[] getResourceGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(5, new CWE[0]);
        return retVal;
    }

    public CWE[] getAig5_ResourceGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(5, new CWE[0]);
        return retVal;
    }

    public int getResourceGroupReps() {
        return this.getReps(5);
    }

    public CWE getResourceGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getAig5_ResourceGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getAig5_ResourceGroupReps() {
        return this.getReps(5);
    }

    public CWE insertResourceGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertAig5_ResourceGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeResourceGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeAig5_ResourceGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public NM getResourceQuantity() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getAig6_ResourceQuantity() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getResourceQuantityUnits() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getAig7_ResourceQuantityUnits() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getAig8_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAig9_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CNE getStartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getAig10_StartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getAig11_Duration() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE getDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(12, 0);
        return retVal;
    }

    public CNE getAig12_DurationUnits() {
        CNE retVal = (CNE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getAllowSubstitutionCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getAig13_AllowSubstitutionCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getFillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getAig14_FillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CNE(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CNE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

