/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.segment.PSG;
import ca.uhn.hl7v2.model.v281.segment.PSL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E02_PSG
extends AbstractGroup {
    public EHC_E02_PSG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false, true);
            this.add(PSL.class, false, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E02_PSG - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PSG getPSG() {
        PSG retVal = this.getTyped("PSG", PSG.class);
        return retVal;
    }

    public PSL getPSL() {
        PSL retVal = this.getTyped("PSL", PSL.class);
        return retVal;
    }

    public PSL getPSL(int rep) {
        PSL retVal = this.getTyped("PSL", rep, PSL.class);
        return retVal;
    }

    public int getPSLReps() {
        return this.getReps("PSL");
    }

    public List<PSL> getPSLAll() throws HL7Exception {
        return this.getAllAsList("PSL", PSL.class);
    }

    public void insertPSL(PSL structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL", structure, rep);
    }

    public PSL insertPSL(int rep) throws HL7Exception {
        return (PSL)super.insertRepetition("PSL", rep);
    }

    public PSL removePSL(int rep) throws HL7Exception {
        return (PSL)super.removeRepetition("PSL", rep);
    }
}

