/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.model.v28.datatype.XON;
import ca.uhn.hl7v2.model.v28.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IAM
extends AbstractSegment {
    public IAM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - IAM");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allergen Type Code");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Allergen Code/Mnemonic/Description");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allergy Severity Code");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Allergy Reaction Code");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Allergy Action Code");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Allergy Unique Identifier");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Action Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Sensitivity to Causative Agent Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allergen Group Code/Mnemonic/Description");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Onset Date");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Onset Date Text");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Reported Date/Time");
            this.add(XPN.class, false, 1, 0, new Object[]{this.getMessage()}, "Reported By");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Relationship to Patient Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Alert Device Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allergy Clinical Status Code");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Statused by Person");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Statused by Organization");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Statused at Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivated by Person");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivated Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Initially Recorded by Person");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Initially Recorded Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Modified by Person");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Modified Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Clinician Identified Code");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Initially Recorded by Organization");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Modified by Organization");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivated by Organization");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IAM - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDIAM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIam1_SetIDIAM() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAllergenTypeCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIam2_AllergenTypeCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAllergenCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getIam3_AllergenCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getIam4_AllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getAllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getIam5_AllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getAllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST getAllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getIam5_AllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getIam5_AllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST insertAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertIam5_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeIam5_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public CNE getAllergyActionCode() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getIam6_AllergyActionCode() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getAllergyUniqueIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getIam7_AllergyUniqueIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getActionReason() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIam8_ActionReason() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getSensitivityToCausativeAgentCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getIam9_SensitivityToCausativeAgentCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getAllergenGroupCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getIam10_AllergenGroupCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getOnsetDate() {
        DT retVal = (DT)this.getTypedField(11, 0);
        return retVal;
    }

    public DT getIam11_OnsetDate() {
        DT retVal = (DT)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getOnsetDateText() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getIam12_OnsetDateText() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getReportedDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getIam13_ReportedDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public XPN getReportedBy() {
        XPN retVal = (XPN)this.getTypedField(14, 0);
        return retVal;
    }

    public XPN getIam14_ReportedBy() {
        XPN retVal = (XPN)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getRelationshipToPatientCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getIam15_RelationshipToPatientCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getAlertDeviceCode() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getIam16_AlertDeviceCode() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getAllergyClinicalStatusCode() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getIam17_AllergyClinicalStatusCode() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public XCN getStatusedByPerson() {
        XCN retVal = (XCN)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN getIam18_StatusedByPerson() {
        XCN retVal = (XCN)this.getTypedField(18, 0);
        return retVal;
    }

    public XON getStatusedByOrganization() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public XON getIam19_StatusedByOrganization() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getStatusedAtDateTime() {
        DTM retVal = (DTM)this.getTypedField(20, 0);
        return retVal;
    }

    public DTM getIam20_StatusedAtDateTime() {
        DTM retVal = (DTM)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getInactivatedByPerson() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    public XCN getIam21_InactivatedByPerson() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getInactivatedDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public DTM getIam22_InactivatedDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public XCN getInitiallyRecordedByPerson() {
        XCN retVal = (XCN)this.getTypedField(23, 0);
        return retVal;
    }

    public XCN getIam23_InitiallyRecordedByPerson() {
        XCN retVal = (XCN)this.getTypedField(23, 0);
        return retVal;
    }

    public DTM getInitiallyRecordedDateTime() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public DTM getIam24_InitiallyRecordedDateTime() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public XCN getModifiedByPerson() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public XCN getIam25_ModifiedByPerson() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public DTM getModifiedDateTime() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public DTM getIam26_ModifiedDateTime() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getClinicianIdentifiedCode() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getIam27_ClinicianIdentifiedCode() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public XON getInitiallyRecordedByOrganization() {
        XON retVal = (XON)this.getTypedField(28, 0);
        return retVal;
    }

    public XON getIam28_InitiallyRecordedByOrganization() {
        XON retVal = (XON)this.getTypedField(28, 0);
        return retVal;
    }

    public XON getModifiedByOrganization() {
        XON retVal = (XON)this.getTypedField(29, 0);
        return retVal;
    }

    public XON getIam29_ModifiedByOrganization() {
        XON retVal = (XON)this.getTypedField(29, 0);
        return retVal;
    }

    public XON getInactivatedByOrganization() {
        XON retVal = (XON)this.getTypedField(30, 0);
        return retVal;
    }

    public XON getIam30_InactivatedByOrganization() {
        XON retVal = (XON)this.getTypedField(30, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new DT(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new XPN(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new XCN(this.getMessage());
            }
            case 18: {
                return new XON(this.getMessage());
            }
            case 19: {
                return new DTM(this.getMessage());
            }
            case 20: {
                return new XCN(this.getMessage());
            }
            case 21: {
                return new DTM(this.getMessage());
            }
            case 22: {
                return new XCN(this.getMessage());
            }
            case 23: {
                return new DTM(this.getMessage());
            }
            case 24: {
                return new XCN(this.getMessage());
            }
            case 25: {
                return new DTM(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new XON(this.getMessage());
            }
            case 28: {
                return new XON(this.getMessage());
            }
            case 29: {
                return new XON(this.getMessage());
            }
        }
        return null;
    }
}

