/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXR
extends AbstractSegment {
    public RXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Route");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Administration Site");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Administration Device");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Administration Method");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Routing Instruction");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Administration Site Modifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXR - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getRoute() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRxr1_Route() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAdministrationSite() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRxr2_AdministrationSite() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAdministrationDevice() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRxr3_AdministrationDevice() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAdministrationMethod() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRxr4_AdministrationMethod() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRoutingInstruction() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRxr5_RoutingInstruction() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getAdministrationSiteModifier() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRxr6_AdministrationSiteModifier() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

