/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DR;
import ca.uhn.hl7v2.model.v27.datatype.DT;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.model.v27.datatype.XAD;
import ca.uhn.hl7v2.model.v27.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EDU
extends AbstractSegment {
    public EDU(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - EDU");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Academic Degree");
            this.add(DR.class, false, 1, 0, new Object[]{this.getMessage()}, "Academic Degree Program Date Range");
            this.add(DR.class, false, 1, 0, new Object[]{this.getMessage()}, "Academic Degree Program Participation Date Range");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Academic Degree Granted Date");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "School");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "School Type Code");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "School Address");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Major Field of Study");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EDU - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDEDU() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getEdu1_SetIDEDU() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAcademicDegree() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getEdu2_AcademicDegree() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public DR getAcademicDegreeProgramDateRange() {
        DR retVal = (DR)this.getTypedField(3, 0);
        return retVal;
    }

    public DR getEdu3_AcademicDegreeProgramDateRange() {
        DR retVal = (DR)this.getTypedField(3, 0);
        return retVal;
    }

    public DR getAcademicDegreeProgramParticipationDateRange() {
        DR retVal = (DR)this.getTypedField(4, 0);
        return retVal;
    }

    public DR getEdu4_AcademicDegreeProgramParticipationDateRange() {
        DR retVal = (DR)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getAcademicDegreeGrantedDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getEdu5_AcademicDegreeGrantedDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public XON getSchool() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public XON getEdu6_School() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getSchoolTypeCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getEdu7_SchoolTypeCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public XAD getSchoolAddress() {
        XAD retVal = (XAD)this.getTypedField(8, 0);
        return retVal;
    }

    public XAD getEdu8_SchoolAddress() {
        XAD retVal = (XAD)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getMajorFieldOfStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public CWE[] getEdu9_MajorFieldOfStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public int getMajorFieldOfStudyReps() {
        return this.getReps(9);
    }

    public CWE getMajorFieldOfStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getEdu9_MajorFieldOfStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getEdu9_MajorFieldOfStudyReps() {
        return this.getReps(9);
    }

    public CWE insertMajorFieldOfStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertEdu9_MajorFieldOfStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeMajorFieldOfStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeEdu9_MajorFieldOfStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new DR(this.getMessage());
            }
            case 3: {
                return new DR(this.getMessage());
            }
            case 4: {
                return new DT(this.getMessage());
            }
            case 5: {
                return new XON(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new XAD(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

