/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v27.group.CCQ_I19_PROVIDER_CONTACT;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.REL;
import ca.uhn.hl7v2.model.v27.segment.RF1;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCQ_I19
extends AbstractMessage {
    public CCQ_I19() {
        this(new DefaultModelClassFactory());
    }

    public CCQ_I19(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(RF1.class, true, false);
            this.add(CCQ_I19_PROVIDER_CONTACT.class, false, true);
            this.add(REL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCQ_I19 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public RF1 getRF1() {
        return this.getTyped("RF1", RF1.class);
    }

    public CCQ_I19_PROVIDER_CONTACT getPROVIDER_CONTACT() {
        return this.getTyped("PROVIDER_CONTACT", CCQ_I19_PROVIDER_CONTACT.class);
    }

    public CCQ_I19_PROVIDER_CONTACT getPROVIDER_CONTACT(int rep) {
        return this.getTyped("PROVIDER_CONTACT", rep, CCQ_I19_PROVIDER_CONTACT.class);
    }

    public int getPROVIDER_CONTACTReps() {
        return this.getReps("PROVIDER_CONTACT");
    }

    public List<CCQ_I19_PROVIDER_CONTACT> getPROVIDER_CONTACTAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER_CONTACT", CCQ_I19_PROVIDER_CONTACT.class);
    }

    public void insertPROVIDER_CONTACT(CCQ_I19_PROVIDER_CONTACT structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER_CONTACT", structure, rep);
    }

    public CCQ_I19_PROVIDER_CONTACT insertPROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CCQ_I19_PROVIDER_CONTACT)super.insertRepetition("PROVIDER_CONTACT", rep);
    }

    public CCQ_I19_PROVIDER_CONTACT removePROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CCQ_I19_PROVIDER_CONTACT)super.removeRepetition("PROVIDER_CONTACT", rep);
    }

    public REL getREL() {
        return this.getTyped("REL", REL.class);
    }

    public REL getREL(int rep) {
        return this.getTyped("REL", rep, REL.class);
    }

    public int getRELReps() {
        return this.getReps("REL");
    }

    public List<REL> getRELAll() throws HL7Exception {
        return this.getAllAsList("REL", REL.class);
    }

    public void insertREL(REL structure, int rep) throws HL7Exception {
        super.insertRepetition("REL", structure, rep);
    }

    public REL insertREL(int rep) throws HL7Exception {
        return (REL)super.insertRepetition("REL", rep);
    }

    public REL removeREL(int rep) throws HL7Exception {
        return (REL)super.removeRepetition("REL", rep);
    }
}

