/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.SID;
import ca.uhn.hl7v2.model.v27.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R23_RESULT
extends AbstractGroup {
    public OUL_R23_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBX.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(TCD.class, false, false, false);
            this.add(SID.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R23_RESULT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public TCD getTCD() {
        TCD retVal = this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public SID getSID() {
        SID retVal = this.getTyped("SID", SID.class);
        return retVal;
    }

    public SID getSID(int rep) {
        SID retVal = this.getTyped("SID", rep, SID.class);
        return retVal;
    }

    public int getSIDReps() {
        return this.getReps("SID");
    }

    public List<SID> getSIDAll() throws HL7Exception {
        return this.getAllAsList("SID", SID.class);
    }

    public void insertSID(SID structure, int rep) throws HL7Exception {
        super.insertRepetition("SID", structure, rep);
    }

    public SID insertSID(int rep) throws HL7Exception {
        return (SID)super.insertRepetition("SID", rep);
    }

    public SID removeSID(int rep) throws HL7Exception {
        return (SID)super.removeRepetition("SID", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

