/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.SN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class TCD
extends AbstractSegment {
    public TCD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Auto-Dilution Factor");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Rerun Dilution Factor");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Pre-Dilution Factor");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Endogenous Content of Pre-Dilution Diluent");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Automatic Repeat Allowed");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Reflex Allowed");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Analyte Repeat Status");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TCD - this is probably a bug in the source code generator.", e);
        }
    }

    public CE getUniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getTcd1_UniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public SN getAutoDilutionFactor() {
        SN retVal = (SN)this.getTypedField(2, 0);
        return retVal;
    }

    public SN getTcd2_AutoDilutionFactor() {
        SN retVal = (SN)this.getTypedField(2, 0);
        return retVal;
    }

    public SN getRerunDilutionFactor() {
        SN retVal = (SN)this.getTypedField(3, 0);
        return retVal;
    }

    public SN getTcd3_RerunDilutionFactor() {
        SN retVal = (SN)this.getTypedField(3, 0);
        return retVal;
    }

    public SN getPreDilutionFactor() {
        SN retVal = (SN)this.getTypedField(4, 0);
        return retVal;
    }

    public SN getTcd4_PreDilutionFactor() {
        SN retVal = (SN)this.getTypedField(4, 0);
        return retVal;
    }

    public SN getEndogenousContentOfPreDilutionDiluent() {
        SN retVal = (SN)this.getTypedField(5, 0);
        return retVal;
    }

    public SN getTcd5_EndogenousContentOfPreDilutionDiluent() {
        SN retVal = (SN)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAutomaticRepeatAllowed() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getTcd6_AutomaticRepeatAllowed() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getReflexAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getTcd7_ReflexAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAnalyteRepeatStatus() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getTcd8_AnalyteRepeatStatus() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new SN(this.getMessage());
            }
            case 2: {
                return new SN(this.getMessage());
            }
            case 3: {
                return new SN(this.getMessage());
            }
            case 4: {
                return new SN(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 7: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

