/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBX
extends AbstractSegment {
    public OBX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - OBX");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(125)}, "Value Type");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Observation Identifier");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Observation Sub-ID");
            this.add(Varies.class, false, 0, 99999, new Object[]{this.getMessage()}, "Observation Value");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Units");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "References Range");
            this.add(IS.class, false, 0, 5, new Object[]{this.getMessage(), new Integer(78)}, "Abnormal Flags");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Probability");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(80)}, "Nature of Abnormal Test");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(85)}, "Observation Result Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Date of Reference Range");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "User Defined Access Checks");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of the Observation");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Producer's ID");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Responsible Observer");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Observation Method");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Equipment Instance Identifier");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of the Analysis");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBX - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObx1_SetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getObx2_ValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getObservationIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getObx3_ObservationIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getObx4_ObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public Varies[] getObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, new Varies[0]);
        return retVal;
    }

    public Varies[] getObx5_ObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, new Varies[0]);
        return retVal;
    }

    public int getObservationValueReps() {
        return this.getReps(5);
    }

    public Varies getObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public Varies getObx5_ObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public int getObx5_ObservationValueReps() {
        return this.getReps(5);
    }

    public Varies insertObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies insertObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies removeObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public Varies removeObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public CE getUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getObx6_Units() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getObx7_ReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public IS[] getAbnormalFlags() {
        IS[] retVal = (IS[])this.getTypedField(8, new IS[0]);
        return retVal;
    }

    public IS[] getObx8_AbnormalFlags() {
        IS[] retVal = (IS[])this.getTypedField(8, new IS[0]);
        return retVal;
    }

    public int getAbnormalFlagsReps() {
        return this.getReps(8);
    }

    public IS getAbnormalFlags(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public IS getObx8_AbnormalFlags(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public int getObx8_AbnormalFlagsReps() {
        return this.getReps(8);
    }

    public IS insertAbnormalFlags(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS insertObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS removeAbnormalFlags(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public IS removeObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public NM getProbability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getObx9_Probability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID[] getNatureOfAbnormalTest() {
        ID[] retVal = (ID[])this.getTypedField(10, new ID[0]);
        return retVal;
    }

    public ID[] getObx10_NatureOfAbnormalTest() {
        ID[] retVal = (ID[])this.getTypedField(10, new ID[0]);
        return retVal;
    }

    public int getNatureOfAbnormalTestReps() {
        return this.getReps(10);
    }

    public ID getNatureOfAbnormalTest(int rep) {
        ID retVal = (ID)this.getTypedField(10, rep);
        return retVal;
    }

    public ID getObx10_NatureOfAbnormalTest(int rep) {
        ID retVal = (ID)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObx10_NatureOfAbnormalTestReps() {
        return this.getReps(10);
    }

    public ID insertNatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(10, rep);
    }

    public ID insertObx10_NatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(10, rep);
    }

    public ID removeNatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(10, rep);
    }

    public ID removeObx10_NatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(10, rep);
    }

    public ID getObservationResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObx11_ObservationResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getEffectiveDateOfReferenceRange() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getObx12_EffectiveDateOfReferenceRange() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getUserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObx13_UserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getDateTimeOfTheObservation() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObx14_DateTimeOfTheObservation() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getProducerSID() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getObx15_ProducerSID() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getResponsibleObserver() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getObx16_ResponsibleObserver() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getResponsibleObserverReps() {
        return this.getReps(16);
    }

    public XCN getResponsibleObserver(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getObx16_ResponsibleObserver(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObx16_ResponsibleObserverReps() {
        return this.getReps(16);
    }

    public XCN insertResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertObx16_ResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeObx16_ResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public CE[] getObservationMethod() {
        CE[] retVal = (CE[])this.getTypedField(17, new CE[0]);
        return retVal;
    }

    public CE[] getObx17_ObservationMethod() {
        CE[] retVal = (CE[])this.getTypedField(17, new CE[0]);
        return retVal;
    }

    public int getObservationMethodReps() {
        return this.getReps(17);
    }

    public CE getObservationMethod(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public CE getObx17_ObservationMethod(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObx17_ObservationMethodReps() {
        return this.getReps(17);
    }

    public CE insertObservationMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE insertObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE removeObservationMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CE removeObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public EI[] getEquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(18, new EI[0]);
        return retVal;
    }

    public EI[] getObx18_EquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(18, new EI[0]);
        return retVal;
    }

    public int getEquipmentInstanceIdentifierReps() {
        return this.getReps(18);
    }

    public EI getEquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(18, rep);
        return retVal;
    }

    public EI getObx18_EquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(18, rep);
        return retVal;
    }

    public int getObx18_EquipmentInstanceIdentifierReps() {
        return this.getReps(18);
    }

    public EI insertEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(18, rep);
    }

    public EI insertObx18_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(18, rep);
    }

    public EI removeEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(18, rep);
    }

    public EI removeObx18_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(18, rep);
    }

    public TS getDateTimeOfTheAnalysis() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public TS getObx19_DateTimeOfTheAnalysis() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(78));
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(80));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(85));
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new EI(this.getMessage());
            }
            case 18: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

