/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CP;
import ca.uhn.hl7v2.model.v24.datatype.EI;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.PL;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FT1
extends AbstractSegment {
    public FT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - FT1");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction ID");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Transaction Batch ID");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Transaction Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Transaction Posting Date");
            this.add(IS.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(17)}, "Transaction Type");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction Description");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Transaction Description - Alt");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Transaction Quantity");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction Amount - Extended");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction Amount - Unit");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Department Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Insurance Plan ID");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Insurance Amount");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(24)}, "Fee Schedule");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient Type");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Diagnosis Code - FT1");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Performed By Code");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Ordered By Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Unit Cost");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Entered By Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Procedure Code Modifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDFT1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getFt11_SetIDFT1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getTransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getFt12_TransactionID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getFt13_TransactionBatchID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getTransactionDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getFt14_TransactionDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getTransactionPostingDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getFt15_TransactionPostingDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getTransactionType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getFt16_TransactionType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getTransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getFt17_TransactionCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getTransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getFt18_TransactionDescription() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getTransactionDescriptionAlt() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getFt19_TransactionDescriptionAlt() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getTransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getFt110_TransactionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CP getTransactionAmountExtended() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getFt111_TransactionAmountExtended() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getFt112_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getDepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getFt113_DepartmentCode() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getInsurancePlanID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getFt114_InsurancePlanID() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CP getInsuranceAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public CP getFt115_InsuranceAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public PL getAssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(16, 0);
        return retVal;
    }

    public PL getFt116_AssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getFeeSchedule() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getFt117_FeeSchedule() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getPatientType() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getFt118_PatientType() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public CE[] getDiagnosisCodeFT1() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public CE[] getFt119_DiagnosisCodeFT1() {
        CE[] retVal = (CE[])this.getTypedField(19, new CE[0]);
        return retVal;
    }

    public int getDiagnosisCodeFT1Reps() {
        return this.getReps(19);
    }

    public CE getDiagnosisCodeFT1(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public CE getFt119_DiagnosisCodeFT1(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public int getFt119_DiagnosisCodeFT1Reps() {
        return this.getReps(19);
    }

    public CE insertDiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE insertFt119_DiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE removeDiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public CE removeFt119_DiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public XCN[] getPerformedByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(20, new XCN[0]);
        return retVal;
    }

    public XCN[] getFt120_PerformedByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(20, new XCN[0]);
        return retVal;
    }

    public int getPerformedByCodeReps() {
        return this.getReps(20);
    }

    public XCN getPerformedByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(20, rep);
        return retVal;
    }

    public XCN getFt120_PerformedByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(20, rep);
        return retVal;
    }

    public int getFt120_PerformedByCodeReps() {
        return this.getReps(20);
    }

    public XCN insertPerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN insertFt120_PerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN removePerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XCN removeFt120_PerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XCN[] getOrderedByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(21, new XCN[0]);
        return retVal;
    }

    public XCN[] getFt121_OrderedByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(21, new XCN[0]);
        return retVal;
    }

    public int getOrderedByCodeReps() {
        return this.getReps(21);
    }

    public XCN getOrderedByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(21, rep);
        return retVal;
    }

    public XCN getFt121_OrderedByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getFt121_OrderedByCodeReps() {
        return this.getReps(21);
    }

    public XCN insertOrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(21, rep);
    }

    public XCN insertFt121_OrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(21, rep);
    }

    public XCN removeOrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(21, rep);
    }

    public XCN removeFt121_OrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(21, rep);
    }

    public CP getUnitCost() {
        CP retVal = (CP)this.getTypedField(22, 0);
        return retVal;
    }

    public CP getFt122_UnitCost() {
        CP retVal = (CP)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getFt123_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public XCN[] getEnteredByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(24, new XCN[0]);
        return retVal;
    }

    public XCN[] getFt124_EnteredByCode() {
        XCN[] retVal = (XCN[])this.getTypedField(24, new XCN[0]);
        return retVal;
    }

    public int getEnteredByCodeReps() {
        return this.getReps(24);
    }

    public XCN getEnteredByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(24, rep);
        return retVal;
    }

    public XCN getFt124_EnteredByCode(int rep) {
        XCN retVal = (XCN)this.getTypedField(24, rep);
        return retVal;
    }

    public int getFt124_EnteredByCodeReps() {
        return this.getReps(24);
    }

    public XCN insertEnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(24, rep);
    }

    public XCN insertFt124_EnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(24, rep);
    }

    public XCN removeEnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(24, rep);
    }

    public XCN removeFt124_EnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(24, rep);
    }

    public CE getProcedureCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getFt125_ProcedureCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE[] getProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(26, new CE[0]);
        return retVal;
    }

    public CE[] getFt126_ProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(26, new CE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(26);
    }

    public CE getProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(26, rep);
        return retVal;
    }

    public CE getFt126_ProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(26, rep);
        return retVal;
    }

    public int getFt126_ProcedureCodeModifierReps() {
        return this.getReps(26);
    }

    public CE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE insertFt126_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    public CE removeFt126_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(17));
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CP(this.getMessage());
            }
            case 11: {
                return new CP(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new CP(this.getMessage());
            }
            case 15: {
                return new PL(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(24));
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XCN(this.getMessage());
            }
            case 21: {
                return new CP(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
            case 23: {
                return new XCN(this.getMessage());
            }
            case 24: {
                return new CE(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

