/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_DLD;
import ca.uhn.hl7v2.model.v22.datatype.CM_FINANCE;
import ca.uhn.hl7v2.model.v22.datatype.CM_INTERNAL_LOCATION;
import ca.uhn.hl7v2.model.v22.datatype.CM_PAT_ID;
import ca.uhn.hl7v2.model.v22.datatype.CM_PAT_ID_0192;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV1
extends AbstractSegment {
    public PV1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Patient Visit");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(4)}, "Patient Class");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(7)}, "Admission Type");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Preadmit Number");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Prior Patient Location");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Attending Doctor");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Referring Doctor");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage()}, "Consulting Doctor");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(69)}, "Hospital Service");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Temporary Location");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(87)}, "Preadmit Test Indicator");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(92)}, "Readmission indicator");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(23)}, "Admit Source");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP Indicator");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Admitting Doctor");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient type");
            this.add(CM_PAT_ID.class, false, 1, 15, new Object[]{this.getMessage()}, "Visit Number");
            this.add(CM_FINANCE.class, false, 4, 50, new Object[]{this.getMessage()}, "Financial Class");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(32)}, "Charge Price Indicator");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(45)}, "Courtesy Code");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(46)}, "Credit Rating");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(44)}, "Contract Code");
            this.add(DT.class, false, 0, 8, new Object[]{this.getMessage()}, "Contract Effective Date");
            this.add(NM.class, false, 0, 12, new Object[]{this.getMessage()}, "Contract Amount");
            this.add(NM.class, false, 0, 3, new Object[]{this.getMessage()}, "Contract Period");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(73)}, "Interest Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(110)}, "Transfer to bad debt - code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Transfer to bad debt - date");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(21)}, "Bad Debt Agency Code");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Transfer Amount");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Recovery Amount");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(111)}, "Delete Account Indicator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Delete Account Date");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(112)}, "Discharge Disposition");
            this.add(CM_DLD.class, false, 1, 25, new Object[]{this.getMessage()}, "Discharged to Location");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(114)}, "Diet Type");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(115)}, "Servicing Facility");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(116)}, "Bed Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(117)}, "Account Status");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Pending Location");
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Prior Temporary Location");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Admit date / time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Discharge date / time");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Current Patient Balance");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Charges");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Adjustments");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Payments");
            this.add(CM_PAT_ID_0192.class, false, 1, 20, new Object[]{this.getMessage()}, "Alternate Visit ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDPatientVisit() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPv11_SetIDPatientVisit() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getPatientClass() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPv12_PatientClass() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getAssignedPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(3, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv13_AssignedPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getAdmissionType() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPv14_AdmissionType() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPreadmitNumber() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getPv15_PreadmitNumber() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPriorPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(6, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv16_PriorPatientLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(6, 0);
        return retVal;
    }

    public CN getAttendingDoctor() {
        CN retVal = (CN)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getPv17_AttendingDoctor() {
        CN retVal = (CN)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getReferringDoctor() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN getPv18_ReferringDoctor() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN[] getConsultingDoctor() {
        CN[] retVal = (CN[])this.getTypedField(9, new CN[0]);
        return retVal;
    }

    public CN[] getPv19_ConsultingDoctor() {
        CN[] retVal = (CN[])this.getTypedField(9, new CN[0]);
        return retVal;
    }

    public int getConsultingDoctorReps() {
        return this.getReps(9);
    }

    public CN getConsultingDoctor(int rep) {
        CN retVal = (CN)this.getTypedField(9, rep);
        return retVal;
    }

    public CN getPv19_ConsultingDoctor(int rep) {
        CN retVal = (CN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPv19_ConsultingDoctorReps() {
        return this.getReps(9);
    }

    public CN insertConsultingDoctor(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(9, rep);
    }

    public CN insertPv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(9, rep);
    }

    public CN removeConsultingDoctor(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(9, rep);
    }

    public CN removePv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(9, rep);
    }

    public ID getHospitalService() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPv110_HospitalService() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getTemporaryLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv111_TemporaryLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPreadmitTestIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPv112_PreadmitTestIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getReadmissionIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getPv113_ReadmissionIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getAdmitSource() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getPv114_AdmitSource() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID[] getAmbulatoryStatus() {
        ID[] retVal = (ID[])this.getTypedField(15, new ID[0]);
        return retVal;
    }

    public ID[] getPv115_AmbulatoryStatus() {
        ID[] retVal = (ID[])this.getTypedField(15, new ID[0]);
        return retVal;
    }

    public int getAmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public ID getAmbulatoryStatus(int rep) {
        ID retVal = (ID)this.getTypedField(15, rep);
        return retVal;
    }

    public ID getPv115_AmbulatoryStatus(int rep) {
        ID retVal = (ID)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPv115_AmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public ID insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(15, rep);
    }

    public ID insertPv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(15, rep);
    }

    public ID removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(15, rep);
    }

    public ID removePv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(15, rep);
    }

    public ID getVIPIndicator() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPv116_VIPIndicator() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public CN getAdmittingDoctor() {
        CN retVal = (CN)this.getTypedField(17, 0);
        return retVal;
    }

    public CN getPv117_AdmittingDoctor() {
        CN retVal = (CN)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getPv118_PatientType() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public CM_PAT_ID getVisitNumber() {
        CM_PAT_ID retVal = (CM_PAT_ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CM_PAT_ID getPv119_VisitNumber() {
        CM_PAT_ID retVal = (CM_PAT_ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CM_FINANCE[] getFinancialClass() {
        CM_FINANCE[] retVal = (CM_FINANCE[])this.getTypedField(20, new CM_FINANCE[0]);
        return retVal;
    }

    public CM_FINANCE[] getPv120_FinancialClass() {
        CM_FINANCE[] retVal = (CM_FINANCE[])this.getTypedField(20, new CM_FINANCE[0]);
        return retVal;
    }

    public int getFinancialClassReps() {
        return this.getReps(20);
    }

    public CM_FINANCE getFinancialClass(int rep) {
        CM_FINANCE retVal = (CM_FINANCE)this.getTypedField(20, rep);
        return retVal;
    }

    public CM_FINANCE getPv120_FinancialClass(int rep) {
        CM_FINANCE retVal = (CM_FINANCE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getPv120_FinancialClassReps() {
        return this.getReps(20);
    }

    public CM_FINANCE insertFinancialClass(int rep) throws HL7Exception {
        return (CM_FINANCE)super.insertRepetition(20, rep);
    }

    public CM_FINANCE insertPv120_FinancialClass(int rep) throws HL7Exception {
        return (CM_FINANCE)super.insertRepetition(20, rep);
    }

    public CM_FINANCE removeFinancialClass(int rep) throws HL7Exception {
        return (CM_FINANCE)super.removeRepetition(20, rep);
    }

    public CM_FINANCE removePv120_FinancialClass(int rep) throws HL7Exception {
        return (CM_FINANCE)super.removeRepetition(20, rep);
    }

    public ID getChargePriceIndicator() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getPv121_ChargePriceIndicator() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getCourtesyCode() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPv122_CourtesyCode() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getCreditRating() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getPv123_CreditRating() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID[] getContractCode() {
        ID[] retVal = (ID[])this.getTypedField(24, new ID[0]);
        return retVal;
    }

    public ID[] getPv124_ContractCode() {
        ID[] retVal = (ID[])this.getTypedField(24, new ID[0]);
        return retVal;
    }

    public int getContractCodeReps() {
        return this.getReps(24);
    }

    public ID getContractCode(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public ID getPv124_ContractCode(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public int getPv124_ContractCodeReps() {
        return this.getReps(24);
    }

    public ID insertContractCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID insertPv124_ContractCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID removeContractCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public ID removePv124_ContractCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public DT[] getContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public DT[] getPv125_ContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public int getContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT getContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public DT getPv125_ContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public int getPv125_ContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT insertContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT insertPv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT removeContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public DT removePv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public NM[] getContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public NM[] getPv126_ContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public int getContractAmountReps() {
        return this.getReps(26);
    }

    public NM getContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public NM getPv126_ContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPv126_ContractAmountReps() {
        return this.getReps(26);
    }

    public NM insertContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM insertPv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM removeContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM removePv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM[] getContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public NM[] getPv127_ContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public int getContractPeriodReps() {
        return this.getReps(27);
    }

    public NM getContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public NM getPv127_ContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public int getPv127_ContractPeriodReps() {
        return this.getReps(27);
    }

    public NM insertContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM insertPv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM removeContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public NM removePv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public ID getInterestCode() {
        ID retVal = (ID)this.getTypedField(28, 0);
        return retVal;
    }

    public ID getPv128_InterestCode() {
        ID retVal = (ID)this.getTypedField(28, 0);
        return retVal;
    }

    public ID getTransferToBadDebtCode() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getPv129_TransferToBadDebtCode() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getTransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getPv130_TransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getBadDebtAgencyCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getPv131_BadDebtAgencyCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public NM getBadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getPv132_BadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getBadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getPv133_BadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public ID getDeleteAccountIndicator() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getPv134_DeleteAccountIndicator() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public DT getDeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public DT getPv135_DeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getDischargeDisposition() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getPv136_DischargeDisposition() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public CM_DLD getDischargedToLocation() {
        CM_DLD retVal = (CM_DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public CM_DLD getPv137_DischargedToLocation() {
        CM_DLD retVal = (CM_DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getDietType() {
        ID retVal = (ID)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getPv138_DietType() {
        ID retVal = (ID)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getServicingFacility() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getPv139_ServicingFacility() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getBedStatus() {
        ID retVal = (ID)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getPv140_BedStatus() {
        ID retVal = (ID)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getAccountStatus() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getPv141_AccountStatus() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPendingLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(42, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv142_PendingLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(42, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPriorTemporaryLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(43, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv143_PriorTemporaryLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(43, 0);
        return retVal;
    }

    public TS getAdmitDateTime() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS getPv144_AdmitDateTime() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS getDischargeDateTime() {
        TS retVal = (TS)this.getTypedField(45, 0);
        return retVal;
    }

    public TS getPv145_DischargeDateTime() {
        TS retVal = (TS)this.getTypedField(45, 0);
        return retVal;
    }

    public NM getCurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getPv146_CurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getTotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getPv147_TotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getTotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getPv148_TotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getTotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public NM getPv149_TotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public CM_PAT_ID_0192 getAlternateVisitID() {
        CM_PAT_ID_0192 retVal = (CM_PAT_ID_0192)this.getTypedField(50, 0);
        return retVal;
    }

    public CM_PAT_ID_0192 getPv150_AlternateVisitID() {
        CM_PAT_ID_0192 retVal = (CM_PAT_ID_0192)this.getTypedField(50, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(4));
            }
            case 2: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(7));
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 6: {
                return new CN(this.getMessage());
            }
            case 7: {
                return new CN(this.getMessage());
            }
            case 8: {
                return new CN(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(69));
            }
            case 10: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(87));
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(92));
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(23));
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(9));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(99));
            }
            case 16: {
                return new CN(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CM_PAT_ID(this.getMessage());
            }
            case 19: {
                return new CM_FINANCE(this.getMessage());
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(32));
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(45));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(46));
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(44));
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new ID(this.getMessage(), new Integer(73));
            }
            case 28: {
                return new ID(this.getMessage(), new Integer(110));
            }
            case 29: {
                return new DT(this.getMessage());
            }
            case 30: {
                return new ID(this.getMessage(), new Integer(21));
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new ID(this.getMessage(), new Integer(111));
            }
            case 34: {
                return new DT(this.getMessage());
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(112));
            }
            case 36: {
                return new CM_DLD(this.getMessage());
            }
            case 37: {
                return new ID(this.getMessage(), new Integer(114));
            }
            case 38: {
                return new ID(this.getMessage(), new Integer(115));
            }
            case 39: {
                return new ID(this.getMessage(), new Integer(116));
            }
            case 40: {
                return new ID(this.getMessage(), new Integer(117));
            }
            case 41: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 42: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 43: {
                return new TS(this.getMessage());
            }
            case 44: {
                return new TS(this.getMessage());
            }
            case 45: {
                return new NM(this.getMessage());
            }
            case 46: {
                return new NM(this.getMessage());
            }
            case 47: {
                return new NM(this.getMessage());
            }
            case 48: {
                return new NM(this.getMessage());
            }
            case 49: {
                return new CM_PAT_ID_0192(this.getMessage());
            }
        }
        return null;
    }
}

