/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSA
extends AbstractSegment {
    public MSA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(8)}, "ACKNOWLEDGMENT CODE");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "MESSAGE CONTROL ID");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "TEXT MESSAGE");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "EXPECTED SEQUENCE NUMBER");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(102)}, "DELAYED ACKNOWLEDGMENT TYPE");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MSA - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getACKNOWLEDGMENTCODE() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMsa1_ACKNOWLEDGMENTCODE() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMESSAGECONTROLID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsa2_MESSAGECONTROLID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTEXTMESSAGE() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getMsa3_TEXTMESSAGE() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getEXPECTEDSEQUENCENUMBER() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getMsa4_EXPECTEDSEQUENCENUMBER() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getDELAYEDACKNOWLEDGMENTTYPE() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getMsa5_DELAYEDACKNOWLEDGMENTTYPE() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(8));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(102));
            }
        }
        return null;
    }
}

