/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class LocalDateRange
extends Range<LocalDate> {
    private static final long serialVersionUID = 1L;

    public static LocalDateRange fromCollection(Collection<LocalDate> dates, RangeNotation notation) {
        return LocalDateRange.fromCollection(dates, notation, true);
    }

    public static LocalDateRange fromCollection(Collection<LocalDate> dates, RangeNotation notation, boolean returnNullOnGap) {
        if (dates == null || notation == null) {
            return null;
        }
        if (dates.isEmpty()) {
            return null;
        }
        ArrayList<LocalDate> list = new ArrayList<LocalDate>(dates);
        Collections.sort(list);
        if (returnNullOnGap) {
            LocalDate prev = null;
            for (LocalDate date : list) {
                if (prev != null && date.dayFrom1970 != prev.dayFrom1970 + 1) {
                    return null;
                }
                prev = date;
            }
        }
        return new LocalDateRange(list.get(0), list.get(list.size() - 1), notation);
    }

    public LocalDateRange() {
    }

    public LocalDateRange(IRelativeDate start, IRelativeDate end, RangeNotation notation) {
        this(start == null ? null : start.toAbsoluteDate(), end == null ? null : end.toAbsoluteDate(), notation);
    }

    public LocalDateRange(LocalDate start, LocalDate end, RangeNotation notation) {
        super(start, end, notation);
    }

    @Override
    public boolean intersect(Range<LocalDate> range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        LocalDate start1 = this.toClosedStart((LocalDate)this.start, this.notation);
        LocalDate end1 = this.toClosedEnd((LocalDate)this.end, this.notation);
        LocalDate start2 = this.toClosedStart((LocalDate)range.start, range.notation);
        LocalDate end2 = this.toClosedEnd((LocalDate)range.end, range.notation);
        return RangeNotation.CLOSED.inRange(start2, start1, end1) || RangeNotation.CLOSED.inRange(end2, start1, end1) || RangeNotation.CLOSED.inRange(start1, start2, end2) || RangeNotation.CLOSED.inRange(end1, start2, end2);
    }

    @Override
    public void valid() {
        super.valid();
        if (this.start != null && !(this.start instanceof LocalDate)) {
            throw new IllegalStateException("start should be a LocalDate");
        }
        if (this.end != null && !(this.end instanceof LocalDate)) {
            throw new IllegalStateException("end should be a LocalDate");
        }
    }

    private LocalDate toClosedEnd(LocalDate end, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case RIGHT_CLOSED: {
                return end;
            }
            case OPEN: 
            case LEFT_CLOSED: {
                return end.plusDay(-1);
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private LocalDate toClosedStart(LocalDate start, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case LEFT_CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return start.plusDay(1);
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    public TimeRange toTimeRange() {
        Long lstart = this.start == null ? null : Long.valueOf(((LocalDate)this.start).toTimeInMillisUTC());
        Long lend = this.end == null ? null : Long.valueOf(((LocalDate)this.end).toTimeInMillisUTC() + TimeUnit.HOURS.toMillis(23L) + TimeUnit.MINUTES.toMillis(59L));
        return new TimeRange(lstart, lend, this.notation);
    }
}

