/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentHashSet(int size) {
        this.map = new ConcurrentHashMap(size);
    }

    public ConcurrentHashSet(int size, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(size, 0.75f, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean b = true;
        for (Object o : c) {
            if (!(b &= this.map.containsKey(o))) break;
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean b = false;
        for (E e : c) {
            b = this.add(e) | b;
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll operation is not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll operation is not supported");
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

