/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.site.ISitePluginController;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.ofys.ui.site.ContextSiteProvider;
import ca.infodata.ofys.ui.site.SitesLoadedProvider;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.ISourceProviderService;
import org.osgi.framework.BundleContext;

public class SitePlugin
extends AbstractUIPlugin
implements CompletionComboAccessorClient.CompletionComboListener,
ContextSiteProvider,
ISitePluginController {
    private static final Logger logger = Logger.getLogger(SitePlugin.class.getName());
    private static final String AUCUN_SITE_DE_TRAVAIL_NEST_SELECTIONNE = Messages.getString((String)"AUCUN_SITE_DE_TRAVAIL_NEST_SELECTIONNE", (String[])new String[0]);
    private static SitePlugin plugin;
    private final GlobalInstancesListener globalInstancesListener;
    private final Map<Integer, XSite> idMapSite;
    private XSite contextSite;
    private String codeClient;

    public SitePlugin() {
        plugin = this;
        this.idMapSite = new ConcurrentHashMap<Integer, XSite>();
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                String newCodeClient = this.getNewCodeClient();
                Log.logOperation((String)"SitePlugin.sessionChanged", (Object[])new Object[]{"actualCodeClient", SitePlugin.this.codeClient, "newCodeClient", newCodeClient});
                if (!MiscUtil.areObjectsEquals((Object)SitePlugin.this.codeClient, (Object)newCodeClient)) {
                    SitePlugin.this.codeClient = newCodeClient;
                    SitePlugin.this.internalSetContextSite(null);
                    SitePlugin.this.loadClientSites();
                } else {
                    XSession session = Application.get().getGlobalInstances().getSession();
                    XSite site = SitePlugin.this.getSite(session.getSite());
                    System.out.println("SitePlugin. sessionChanged called ds le else: " + (site == null ? "site null" : site.nameCommon));
                    SitePlugin.this.internalSetContextSite(site);
                }
            }

            private String getNewCodeClient() {
                try {
                    XSession session = Application.get().getGlobalInstances().getSession();
                    if (session != null) {
                        return session.getClient().getClientCode();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
                }
                return null;
            }
        };
        Log.registerLogContextProvider((LogContextProvider)new LogContextProvider(){

            public String getContextElement() throws Exception {
                return "Sites \n" + new JoinList(",", SitePlugin.this.idMapSite.keySet());
            }
        });
        MyDialogSettings.tryDeleteSettingFile((String)".facility");
    }

    private void loadClientSites() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            this.loadClientSites(null);
        } else {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT_DES_SITES", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    Object o = response.getObj();
                    List list = o instanceof byte[] ? (List)LZMAClientSerialiser.deserialize((byte[])((byte[])o), (boolean)true) : (List)response.getObj();
                    SitePlugin.this.loadClientSites(list);
                }

                public void exception(Exception e) {
                    logger.log(Level.WARNING, "Failed to load sites list", e);
                    SitePlugin.this.loadClientSites(null);
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(session, (ICallback)callback, XSite.type);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load sites list", e);
                callback.kill();
            }
        }
    }

    private void loadClientSites(List<XSite> list) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loading sites list");
        }
        if (list == null) {
            Log.logOperation((String)"SitePlugin.loadClientSites", (Object[])new Object[]{"list", null});
        } else {
            JoinList joinList = new JoinList(",");
            for (XSite xSite : list) {
                joinList.add(xSite.id.intValue());
            }
            Log.logOperation((String)"SitePlugin.loadClientSites", (Object[])new Object[]{"list", joinList});
        }
        if (list != null) {
            for (XSite site : list) {
                XSite x = this.idMapSite.get(site.getId());
                if (x != null && x.getVersion().intValue() == site.getVersion().intValue()) continue;
                this.idMapSite.put(site.getId(), site);
            }
        }
        ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        final SitesLoadedProvider sitesLoadedProvider = (SitesLoadedProvider)service.getSourceProvider("ca.infodata.ofys.ui.sitesLoaded");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                sitesLoadedProvider.refresh();
            }
        });
        if (list == null || list.isEmpty()) {
            logger.info("sites is empty.");
            this.internalSetContextSite(null);
        } else {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                this.internalSetContextSite(this.getSite(session.getSite()));
            }
        }
        logger.info("context site is " + this.contextSite);
    }

    public void start(BundleContext context) throws Exception {
        System.out.println("SitePlugin.start()");
        super.start(context);
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.globalInstancesListener);
        Application.get().setSitePluginController((ISitePluginController)this);
        CompletionComboAccessorClient.addListener((String)XSite.type, (CompletionComboAccessorClient.CompletionComboListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        Application.get().getGlobalInstances().removeGlobalInstancesListener(this.globalInstancesListener);
        CompletionComboAccessorClient.removeListener((String)XSite.type, (CompletionComboAccessorClient.CompletionComboListener)this);
        super.stop(context);
    }

    public static SitePlugin getDefault() {
        return plugin;
    }

    public Stream<XSite> getSites() {
        ArrayList<XSite> list = new ArrayList<XSite>();
        list.addAll(this.idMapSite.values());
        list.sort(new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return o1.getNameCommon().compareToIgnoreCase(o2.getNameCommon());
            }
        });
        return list.stream();
    }

    public List<XSite> getWorkSites() {
        ArrayList<XSite> list = new ArrayList<XSite>();
        for (XSite s : this.idMapSite.values()) {
            if (!Boolean.TRUE.equals(s.getIsWorkSite())) continue;
            list.add(s);
        }
        list.sort(new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return o1.getNameCommon().compareToIgnoreCase(o2.getNameCommon());
            }
        });
        return list;
    }

    public List<XSite> getDrugStoreSites() {
        ArrayList<XSite> list = new ArrayList<XSite>();
        for (XSite s : this.idMapSite.values()) {
            if (!Boolean.TRUE.equals(s.getIsDrugStore())) continue;
            list.add(s);
        }
        list.sort(new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return o1.getNameCommon().compareToIgnoreCase(o2.getNameCommon());
            }
        });
        return list;
    }

    @Override
    public XSite getContextSite() {
        return this.contextSite;
    }

    public XSite getContextSiteChecked() {
        if (this.contextSite == null) {
            MessageUtil.warningMsg((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AUCUN_SITE_DE_TRAVAIL_NEST_SELECTIONNE);
            return null;
        }
        return this.contextSite;
    }

    public void setContextSite(XSite site) {
        if (site == null) {
            throw new IllegalArgumentException("invalid site. site is null");
        }
        this.internalSetContextSite(site);
        this.saveContextSiteToSession();
    }

    private void internalSetContextSite(XSite site) {
        if (site != null && !this.idMapSite.containsKey(site.getId())) {
            throw new IllegalArgumentException("invalid site. site is not in list " + site);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("setting context site to " + site);
        }
        XSite xSite = this.contextSite = site == null ? null : this.idMapSite.get(site.getId());
        if (site != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("PropertyListenerManager.firePropertyChanged 1");
                    }
                    PropertyListenerManager.firePropertyChanged((Object)SitePlugin.this, (int)1);
                }
            });
        }
    }

    private void saveContextSiteToSession() {
        block4: {
            try {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session == null || this.contextSite == null) break block4;
                logger.info("storing context site " + this.contextSite + " to session");
                Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance());
                try {
                    CompletionComboAccessorClient.getInstance().findAllAsync(session, (ICallback)callback, XSite.type);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "", e);
                    callback.kill();
                }
                session.setSite(this.contextSite == null ? null : this.contextSite.getId());
                LoginAccessorClient.getInstance().setSessionSite(this.contextSite, session, (ICallback)callback);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to store context site in session " + this.contextSite, e);
            }
        }
    }

    public void shouldRefresh(ICompletionComboItem item) {
        this.loadClientSites();
    }

    public XSite getSite(Integer idSite) {
        if (idSite == null) {
            return null;
        }
        XSite site = null;
        if (idSite != null) {
            site = this.idMapSite.get(idSite);
        }
        if (idSite != null && site == null && Application.get().getGlobalInstances().getSession() != null) {
            try {
                site = (XSite)Application.get().getDataAccessors().getFacilityAccessor().getSite(idSite.intValue()).getObj();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to get XSite for idSite " + idSite, e);
            }
        }
        return site;
    }

    public List<XSite> getSites(List<Integer> ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<XSite> list = new ArrayList<XSite>(ids.size());
        for (Integer id : ids) {
            list.add(this.idMapSite.get(id));
        }
        list.sort(new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return o1.getNameCommon().compareToIgnoreCase(o2.getNameCommon());
            }
        });
        return list;
    }

    public void dispose() {
    }
}

