/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.singleview;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.controls.middle.interfaces.IDocumentsEditor;
import ca.infodata.ofys.ui.scan.ImageUtils;
import ca.infodata.ofys.ui.scan.scan.ImageRotation;
import ca.infodata.ofys.ui.scan.singleview.IScanSingleViewEditorSection;
import ca.infodata.ofys.ui.scan.singleview.InfoSection;
import ca.infodata.ofys.ui.scan.singleview.NoteSection;
import ca.infodata.swt.layout.MyFormAttachment;
import ca.infodata.swt.layout.MyFormData;
import ca.infodata.swt.layout.MyFormLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseScanSingleViewEditor
extends BaseEditor
implements IDocumentsEditor {
    static final String AVERTISSEMENT = Messages.getString((String)"BaseScanEditor.AVERTISSEMENT", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(BaseScanSingleViewEditor.class.getName());
    protected BrowserComposite browser;
    protected boolean boolStopThread = false;
    protected List<File> lstCreatedFiles = new ArrayList<File>();
    protected List<IScanSingleViewEditorSection> sections;

    public void createMyControl(Composite parent) {
        MyFormData data;
        MyFormLayout layout = new MyFormLayout();
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginBottom = 5;
        layout.marginRight = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 2;
        layout.excludeInvisibleChildren = true;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                BaseScanSingleViewEditor.this.boolStopThread = true;
                for (File f : BaseScanSingleViewEditor.this.lstCreatedFiles) {
                    if (!f.exists()) continue;
                    f.delete();
                }
            }
        });
        this.sections = this.createSections(this, parent, this.toolkit);
        this.browser = new BrowserComposite(parent, this.toolkit);
        new OpenPdfExternFunction(this.browser.getInnerBrowser());
        new RotateFunction(this.browser.getInnerBrowser());
        Control lastControl = null;
        for (IScanSingleViewEditorSection section : this.sections) {
            data = new MyFormData();
            data.top = lastControl != null ? new MyFormAttachment(lastControl) : new MyFormAttachment(0);
            data.left = new MyFormAttachment(0);
            data.right = new MyFormAttachment(100);
            section.getControl().setLayoutData((Object)data);
            lastControl = section.getControl();
        }
        data = new MyFormData();
        data.top = new MyFormAttachment(lastControl);
        data.left = new MyFormAttachment(0);
        data.right = new MyFormAttachment(100);
        data.bottom = new MyFormAttachment(100);
        this.browser.setLayoutData((Object)data);
    }

    protected List<IScanSingleViewEditorSection> createSections(BaseScanSingleViewEditor editor, Composite parent, FormToolkit toolkit) {
        ArrayList<IScanSingleViewEditorSection> list = new ArrayList<IScanSingleViewEditorSection>();
        list.add(new NoteSection(this, parent, toolkit));
        list.add(new InfoSection(this, parent, toolkit));
        return list;
    }

    protected abstract XPatientImage getPatientImage();

    protected abstract void onImageRotated();

    public void rotateImage(ImageRotation rotation) {
        XPatientImage patientImage = this.getPatientImage();
        byte[] picture = patientImage.getPicture();
        ImageData srcData = new ImageData((InputStream)new ByteArrayInputStream(picture));
        ImageData newData = ImageUtils.rotateImage(srcData, rotation);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(picture.length);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{newData};
        imageLoader.save((OutputStream)bos, srcData.type);
        patientImage.setPicture(bos.toByteArray());
        this.showAllDataObject();
    }

    protected class OpenPdfExternFunction
    extends BrowserFunction {
        OpenPdfExternFunction(Browser browser) {
            super(browser, "openPdfExtern");
        }

        public Object function(Object[] arguments) {
            String str = null;
            try {
                str = (String)arguments[0];
                Program.launch((String)str);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to open external pdf: " + str, e);
            }
            return null;
        }
    }

    protected class RotateFunction
    extends BrowserFunction {
        RotateFunction(Browser browser) {
            super(browser, "rotate");
        }

        public Object function(Object[] arguments) {
            try {
                ImageRotation rotation = ImageRotation.fromInt(Double.valueOf(String.valueOf(arguments[0])).intValue());
                logger.info("rotation " + (Object)((Object)rotation));
                BaseScanSingleViewEditor.this.rotateImage(rotation);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to rotate image", e);
            }
            return null;
        }
    }
}

