/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.scan.ZxingCodeReader;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.preferences.PreferencesPlugin;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.LocalDate;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class CodeReader {
    private static final Logger logger = Logger.getLogger(CodeReader.class.getName());
    private final File scannedFolder;
    private final Map<File, XPatientImage> images;
    private final List<File> failedFiles;
    private ZxingCodeReader reader;

    public CodeReader(File scannedFolder) {
        this.scannedFolder = scannedFolder;
        this.images = new HashMap<File, XPatientImage>();
        this.failedFiles = new ArrayList<File>();
        this.reader = new ZxingCodeReader();
    }

    public void clear() {
        this.images.clear();
        this.failedFiles.clear();
    }

    public int peekNbProcessableFileCount() {
        return this.getProcessableFiles().length;
    }

    public File[] getProcessableFiles() {
        File folder = this.getScannedFolder();
        File[] fileArray = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String n = name.toLowerCase();
                return !n.startsWith("nc_") && (n.endsWith(".bmp") || n.endsWith(".jpg") || n.endsWith(".png") || n.endsWith(".gif") || n.endsWith(".tif") || n.endsWith(".tiff") || n.endsWith(".pdf"));
            }
        });
        return fileArray;
    }

    public void readCode(IProgressMonitorWithLog monitor) {
        monitor.log(Level.INFO, "Lecture du dossier " + this.getScannedFolder().getPath());
        List files = MiscUtil.asList((Object[])this.getProcessableFiles());
        String s = files.size() > 1 ? "s" : "";
        monitor.log(Level.INFO, String.valueOf(files.size()) + String.format(" fichier%s \u00e0 lire", s));
        if (files.size() > 0) {
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long l2;
                    long l1 = o1.lastModified();
                    return l1 > (l2 = o2.lastModified()) ? 1 : (l1 < l2 ? -1 : 0);
                }
            });
            for (File file : files) {
                if (monitor.isCanceled()) continue;
                try {
                    String dossierArchive = null;
                    monitor.log(Level.INFO, "Lecture de " + file.getName());
                    List<Object> barCodes = new ArrayList();
                    try {
                        barCodes = this.readCodes(file);
                    }
                    catch (Exception e) {
                        monitor.log(Level.WARNING, "\tErreur de lecture du code", (Throwable)e);
                    }
                    monitor.worked(1);
                    XPatientImage ximage = null;
                    block5: for (String string : barCodes) {
                        if (string == null || (ximage = this.buildXImagesFromBarCode(monitor, string)) == null || ximage.getPatient() == null || ximage.getLabels() == null || ximage.getLabels().size() <= 0) continue;
                        for (XLabelDef def : ximage.getLabels()) {
                            if (!XLabelDef.ARCHIVE.equals(def.getId())) continue;
                            dossierArchive = ximage.getPatient().getPatientRecordNumber();
                            monitor.log(Level.INFO, "\tDossier archive " + dossierArchive + " d\u00e9tect\u00e9");
                            continue block5;
                        }
                    }
                    if (dossierArchive != null) {
                        monitor.log(Level.INFO, "\tAssociation au dossier archive " + dossierArchive);
                        ximage = this.buildXImagesFromBarCode(monitor, dossierArchive);
                    }
                    if (ximage == null) {
                        this.failedFiles.add(file);
                        if (barCodes != null && !barCodes.isEmpty()) continue;
                        monitor.log(Level.WARNING, "\tAucun code reconnu, fichier non-class\u00e9");
                        continue;
                    }
                    this.images.put(file, ximage);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error building pre-assign data from code from file " + file.getName(), e);
                    monitor.log(Level.SEVERE, "\tErreur", (Throwable)e);
                }
            }
        }
    }

    public List<String> readCodes(File file) throws IOException {
        ArrayList<String> barCodes = new ArrayList<String>();
        boolean isPdf = file.getName().toLowerCase().endsWith(".pdf");
        if (isPdf) {
            PDDocument document = PDDocument.load((File)file);
            int[] resolutions = new int[]{150, 100, 96, 200};
            int i = 0;
            while (i < resolutions.length && (barCodes == null || barCodes.isEmpty())) {
                BufferedImage monochromeImage;
                BufferedImage processedImage;
                String code;
                ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                int page = 0;
                if (page < document.getNumberOfPages()) {
                    images.add(pdfRenderer.renderImageWithDPI(page, (float)resolutions[i], ImageType.RGB));
                }
                if (images.isEmpty()) {
                    throw new IOException("Could not load image(s) from pdf file " + file);
                }
                for (BufferedImage image : images) {
                    code = this.reader.betterDecode(image);
                    if (code != null) {
                        barCodes.add(code);
                        continue;
                    }
                    processedImage = ZxingCodeReader.processBufferedImage((BufferedImage)image);
                    code = this.reader.betterDecode(processedImage);
                    if (code != null) {
                        barCodes.add(code);
                        continue;
                    }
                    monochromeImage = this.convertToMonochrome(processedImage);
                    code = this.reader.betterDecode(monochromeImage);
                    if (code == null) continue;
                    barCodes.add(code);
                }
                if (barCodes.isEmpty() || barCodes == null) {
                    for (BufferedImage image : images) {
                        code = this.reader.decode(image, file.getPath());
                        if (code != null) {
                            barCodes.add(code);
                            continue;
                        }
                        processedImage = ZxingCodeReader.processBufferedImage((BufferedImage)image);
                        code = this.reader.decode(processedImage, file.getPath());
                        if (code != null) {
                            barCodes.add(code);
                            continue;
                        }
                        monochromeImage = this.convertToMonochrome(processedImage);
                        code = this.reader.decode(monochromeImage, file.getPath());
                        if (code == null) continue;
                        barCodes.add(code);
                    }
                }
                ++i;
            }
            document.close();
        } else {
            BufferedImage image = ImageIO.read(file.toURI().toURL());
            barCodes.add(this.reader.betterDecode(image));
        }
        return barCodes == null ? new ArrayList<String>(0) : barCodes;
    }

    private BufferedImage convertToMonochrome(BufferedImage image) throws IOException {
        BufferedImage binarized = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        int whiteThreshold = 235;
        int blackThreshold = 225;
        int i = 0;
        while (i < image.getWidth()) {
            int j = 0;
            while (j < image.getHeight()) {
                int red = new Color(image.getRGB(i, j)).getRed();
                int alpha = new Color(image.getRGB(i, j)).getAlpha();
                int newPixel = red > whiteThreshold ? 255 : (red < blackThreshold ? 0 : red);
                newPixel = this.colorToRGB(alpha, newPixel, newPixel, newPixel);
                binarized.setRGB(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return binarized;
    }

    private int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }

    private XPatientImage buildXImagesFromBarCode(IProgressMonitorWithLog monitor, String barCode) {
        XBaseProfessionnal onCallProfessionnal;
        XPatient patient;
        ArrayList<XLabelDef.XLabelDefStaticType> imageLabels = new ArrayList<XLabelDef.XLabelDefStaticType>();
        ArrayList<XBaseProfessionnal> imageProfs = new ArrayList<XBaseProfessionnal>();
        String patientRecordNumber = null;
        String encounterProfId = null;
        XBaseProfessionnal encounterProf = null;
        String encounterDateString = null;
        LocalDate encounterDate = null;
        if (barCode.startsWith("VIS:")) {
            String[] split = StringUtils.split((String)barCode, (char)':');
            if (split.length == 4) {
                patientRecordNumber = split[1];
                encounterProfId = split[2];
                encounterDateString = split[3];
            }
            imageLabels.add(XLabelDef.XLabelDefStaticType.IS_ENCOUNTER);
        } else if (barCode.startsWith("SOM:")) {
            patientRecordNumber = StringUtils.split((String)barCode, (char)':')[1].trim();
            imageLabels.add(XLabelDef.XLabelDefStaticType.IS_SOMMAIRE);
        } else if (barCode.startsWith("ARC:")) {
            patientRecordNumber = StringUtils.split((String)barCode, (char)':')[1].trim();
            imageLabels.add(XLabelDef.XLabelDefStaticType.IS_ARCHIVE);
        } else {
            patientRecordNumber = StringUtils.trim((String)barCode);
        }
        if (StringUtils.isBlank((CharSequence)patientRecordNumber)) {
            monitor.log(Level.WARNING, "\tAucun no de dossier patient trouv\u00e9");
            return null;
        }
        if (StringUtils.isNotBlank(encounterDateString)) {
            Date date = CodeReader.parseDateOrReturnNull(encounterDateString, "yyyy-MM-dd");
            if (date == null) {
                date = CodeReader.parseDateOrReturnNull(encounterDateString, "yyyy/MM/dd");
            }
            LocalDate localDate = encounterDate = date == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)date.getTime());
        }
        if (encounterProfId != null && NumberUtils.isNumber((String)encounterProfId)) {
            encounterProf = PersonUiPlugin.getDefault().getBaseProfessionnal(Integer.valueOf(Integer.parseInt(encounterProfId)));
            if (encounterProf == null) {
                monitor.log(Level.SEVERE, "\tErreur lors du chargement du professionnel de la rencontre");
                return null;
            }
            imageProfs.add(encounterProf);
        }
        if ((patient = this.resolvePatient(patientRecordNumber)) == null) {
            monitor.log(Level.WARNING, "\tAucun patient trouv\u00e9 avec le no dossier " + patientRecordNumber);
            return null;
        }
        monitor.log(Level.INFO, "\tPatient : " + patient.getNameBirthdateSex());
        if (imageLabels.contains(XLabelDef.XLabelDefStaticType.IS_ARCHIVE)) {
            monitor.log(Level.INFO, "\tLe document est une archive");
        } else if (imageLabels.contains(XLabelDef.XLabelDefStaticType.IS_SOMMAIRE)) {
            monitor.log(Level.INFO, "\tLe document est un sommaire");
        } else if (imageLabels.contains(XLabelDef.XLabelDefStaticType.IS_ENCOUNTER)) {
            monitor.log(Level.INFO, "\tLe document est une rencontre");
            if (encounterDate == null) {
                monitor.log(Level.WARNING, "\tDate : inconnue");
            } else {
                monitor.log(Level.INFO, "\tDate : " + encounterDate.formatHyphen());
            }
            if (encounterProf == null) {
                monitor.log(Level.WARNING, "\tDispensateur : inconnu");
            } else {
                monitor.log(Level.INFO, "\tDispensateur : " + encounterProf.getText());
            }
            if (encounterDate == null || encounterProf == null || patient == null) {
                return null;
            }
        }
        if (patient.getTreatingProfessionnal() != null) {
            XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(patient.getTreatingProfessionnal());
            if (prof == null) {
                monitor.log(Level.SEVERE, "\tErreur lors du chargement du professionnel traitant du patient");
                return null;
            }
            if (!imageProfs.contains(prof)) {
                imageProfs.add(prof);
                monitor.log(Level.INFO, "\tCopie au professionnel traitant : " + prof.getText());
            }
        }
        if (imageProfs.isEmpty() && (onCallProfessionnal = CodeReader.getOnCallProfessionnal()) != null && !imageProfs.contains(onCallProfessionnal)) {
            imageProfs.add(onCallProfessionnal);
            monitor.log(Level.INFO, "\tCopie au professionnel de garde : " + onCallProfessionnal.getText());
        }
        if (imageProfs.isEmpty()) {
            monitor.log(Level.SEVERE, "\tNe peut \u00eatre assign\u00e9 automatiquement \u00e0 un professionnel");
            return null;
        }
        XPatientImage ximage = new XPatientImage();
        ximage.setEncounterProfessionnal(encounterProf);
        ximage.setDocumentDate(encounterDate);
        ximage.setLabels(new ArrayList());
        for (XLabelDef.XLabelDefStaticType xLabelDefStaticType : imageLabels) {
            XLabelDef label = PreferencesPlugin.getDefault().getLabel(Integer.valueOf(xLabelDefStaticType.id));
            if (label == null) continue;
            ximage.getLabels().add(label);
        }
        ximage.setPatient((IPatient)patient);
        IEditableDataObjectList ximageProfs = ximage.getProfessionnals();
        for (XBaseProfessionnal prof : imageProfs) {
            XPatientImageProfessionnal imageProf = new XPatientImageProfessionnal();
            imageProf.setProfessionnal(prof.getId());
            ximageProfs.add((IMinimalEditableDataObject)imageProf);
        }
        return ximage;
    }

    private static XBaseProfessionnal getOnCallProfessionnal() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            return session.getClientPreferences().getOnCallProfessionnal();
        }
        return null;
    }

    private static Date parseDateOrReturnNull(String dateString, String pattern) {
        block5: {
            block4: {
                try {
                    if (dateString != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (dateString.trim().length() == pattern.length()) break block5;
            return null;
        }
        FastDateFormat sdf = FastDateFormat.getInstance((String)pattern);
        return sdf.parse(dateString);
    }

    private XPatient resolvePatient(String patientRecordNumber) {
        XPatient[] patient;
        block4: {
            patient = new XPatient[1];
            Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    XPatient pts = (XPatient)response.getObj();
                    if (pts != null) {
                        patient[0] = pts;
                    }
                }

                public void exception(Exception e) {
                    super.exception(e);
                }
            };
            try {
                String noDossier = patientRecordNumber;
                PatientAccessorClient.getInstance().findPatientExactNoDossier((ICallback)callback, noDossier);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
        return patient[0];
    }

    public File getScannedFolder() {
        return this.scannedFolder;
    }

    public Map<File, XPatientImage> getXPatientImages() {
        return this.images;
    }

    public List<File> getFailedFiles() {
        return this.failedFiles;
    }
}

