/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.logs;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.client.dataaccess.LogAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.log.XLog;
import ca.infodata.ofys.data.middle.dataobjects.log.XLogType1;
import ca.infodata.ofys.data.middle.dataobjects.log.XLogType2;
import ca.infodata.ofys.data.middle.dataobjects.log.XSearchLogCriteria;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.CallbackComposite;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MySpinner;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.user.UserComboForSelection;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import com.csvreader.CsvWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LogSearchComposite
extends Composite {
    private static final String DATE_DE_DEBUT = Messages.getString((String)"AccessLogSearchView.DATE_DE_DEBUT", (String[])new String[0]);
    private static final String DATE_DE_FIN = Messages.getString((String)"AccessLogSearchView.DATE_DE_FIN", (String[])new String[0]);
    private static final String NOM_DUTILISATEUR = Messages.getString((String)"AccessLogSearchView.NOM_DUTILISATEUR", (String[])new String[0]);
    private static final String TYPE_DE_LOG = Messages.getString((String)"TYPE_DE_LOG", (String[])new String[0]);
    private static final String TYPE_DE_LOG2 = Messages.getString((String)"TYPE_DE_LOG2", (String[])new String[0]);
    private MyLabel lblUser;
    private UserComboForSelection cmbUser;
    private MyCombo<XLogType1> cmbLogType1;
    private MyCombo<XLogType2> cmbLogType2;
    private MyLabel lblDateStart;
    private MyLabel lblDateEnd;
    private MyCalendarText txtDateStart;
    private MyCalendarText txtDateEnd;
    private MySpinner txtLimit;
    private CallbackComposite tblSearchCallbackComposite;
    private MyTable<XLog> tblSearch;
    private MyLabel lblMessage;
    private MyButton btnSearch;
    public Class<?> myClass;
    private Color colorRed;

    public LogSearchComposite(Composite parent, int style) {
        super(parent, style);
        this.createMyPartControl(null);
    }

    public LogSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, style);
        this.createMyPartControl(toolkit);
    }

    public void createMyPartControl(FormToolkit toolkit) {
        if (toolkit == null) {
            toolkit = UI.createToolKit((Widget)this);
        }
        toolkit.adapt((Composite)this);
        this.lblUser = new MyLabel((Composite)this, NOM_DUTILISATEUR, 64, toolkit);
        this.cmbUser = new UserComboForSelection((Composite)this, 8);
        this.cmbUser.fill(true);
        MyLabel lblLogType = new MyLabel((Composite)this, TYPE_DE_LOG, 64, toolkit);
        this.cmbLogType1 = new MyCombo((Composite)this, 8, toolkit);
        this.cmbLogType1.setLabelProvider((ProviderAR)new ProviderAR<XLogType1, String>(){

            public String get(XLogType1 type) {
                if (type == null) {
                    return "";
                }
                return type.toString();
            }
        });
        ArrayList<Object> types = new ArrayList<Object>();
        types.add(null);
        MiscUtil.addArrayToList((Object[])XLogType1.values(), types);
        this.cmbLogType1.setItems(types);
        MyLabel lblLogTypeData = new MyLabel((Composite)this, TYPE_DE_LOG2, 64, toolkit);
        this.cmbLogType2 = new MyCombo((Composite)this, 8, toolkit);
        this.cmbLogType2.setLabelProvider((ProviderAR)new ProviderAR<XLogType2, String>(){

            public String get(XLogType2 type) {
                if (type == null) {
                    return "";
                }
                return type.toString();
            }
        });
        ArrayList<Object> types2 = new ArrayList<Object>();
        types2.add(null);
        MiscUtil.addArrayToList((Object[])XLogType2.values(), types2);
        this.cmbLogType2.setItems(types2);
        this.lblDateStart = new MyLabel((Composite)this, DATE_DE_DEBUT, 64, toolkit);
        this.txtDateStart = new MyCalendarText((Composite)this, 0, toolkit);
        this.lblDateEnd = new MyLabel((Composite)this, DATE_DE_FIN, 64, toolkit);
        this.txtDateEnd = new MyCalendarText((Composite)this, 0, toolkit);
        MyLabel lblLimit = new MyLabel((Composite)this, "Limite", 64, toolkit);
        this.txtLimit = new MySpinner((Composite)this, 2048, toolkit);
        this.txtLimit.setValues(100, 0, 500, 0, 10, 100);
        this.tblSearchCallbackComposite = new CallbackComposite(this, 0, toolkit){

            protected FontAwareComposite createLoadedComposite(Composite parent, FormToolkit toolkit, ReturnObject response) {
                toolkit.adapt(parent);
                FontAwareComposite c = new FontAwareComposite(parent, 0);
                toolkit.adapt((Composite)c);
                FillLayout layout = new FillLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                c.setLayout((Layout)layout);
                LogSearchComposite.this.tblSearch = new MyTable((Composite)c, 67584);
                LogSearchComposite.this.tblSearch.setHeaderVisible(true);
                LogSearchComposite.this.tblSearch.setLinesVisible(true);
                LogSearchComposite.this.tblSearch.setColumns(new String[]{"Id", "Date / heure", "Type", "Description", "Utilisateur", "R\u00f4le", "Nom du patient", "Nam du patient", "Util. sys.", "Ip", "Mac", "Crise?"});
                TableColumn[] tableColumnArray = LogSearchComposite.this.tblSearch.getControl().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn c2 = tableColumnArray[n2];
                    c2.setMoveable(true);
                    c2.setResizable(true);
                    c2.setData("maxWidth", (Object)150);
                    ++n2;
                }
                LogSearchComposite.this.tblSearch.setLabelProvider((ProviderAR)new ProviderAR<XLog, String[]>(){

                    public String[] get(XLog log) {
                        return this.getLine(log);
                    }
                });
                return c;
            }

            protected String[] getLine(XLog log) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(String.valueOf(log.getId()));
                list.add(DateUtil.nonThreadSafeFormat((Long)log.getDateTime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm:ss")));
                list.add(new JoinList(" - ", new Object[]{log.getType1(), log.getType2()}).toString());
                list.add(log.getText());
                list.add(log.getUserName());
                list.add(log.getUserRoles() == null ? null : new JoinList(",", (Collection)log.getUserRoles()).toString());
                list.add(log.getPatientName());
                list.add(log.getPatientNam());
                list.add(log.getSystemUser());
                list.add(log.getIpAddress());
                list.add(log.getMacAddress());
                list.add(log.isCrisis() ? "\u221a" : "");
                return list.toArray(new String[list.size()]);
            }

            protected void updateLoadedComposite(ReturnObject response) {
                if (response == null || response.getObj() == null) {
                    LogSearchComposite.this.tblSearch.removeAll();
                }
                List list = (List)response.getObj();
                LogSearchComposite.this.tblSearch.setItems((Collection)list);
                try {
                    CsvWriter csv = new CsvWriter(String.valueOf(LibPlugin.OFYS_HOME) + "logins_" + System.currentTimeMillis() + ".csv");
                    csv.writeComment("Id,Date / heure,Type,Description,Utilisateur,Role,Nom du patient,Nam du patient,Util. sys.,Ip,Mac,Crise?");
                    for (XLog xLog : list) {
                        csv.writeRecord(this.getLine(xLog));
                    }
                    csv.flush();
                    csv.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                UI.autoAdjustColumnWidthToContent((Table)LogSearchComposite.this.tblSearch.getControl(), (boolean)true);
            }
        };
        this.tblSearchCallbackComposite.getStackLayout().marginHeight = 0;
        this.tblSearchCallbackComposite.getStackLayout().marginWidth = 0;
        this.tblSearchCallbackComposite.showLoadedCompositeInSwtThread(null);
        this.btnSearch = new MyButton((Composite)this, Messages.getString((String)"RECHERCHER", (String[])new String[0]), 64, toolkit);
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LogSearchComposite.this.search();
            }
        });
        this.btnSearch.setToolTipText(Messages.getString((String)"RETOUR", (String[])new String[0]));
        this.lblMessage = new MyLabel((Composite)this, "", 64, toolkit);
        this.colorRed = ResourceGetter.getColor((int)255, (int)0, (int)0);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.colorRed, (Widget)this);
        this.lblMessage.setForeground(this.colorRed);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(this.txtDateStart.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        this.lblDateStart.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(this.lblDateStart.getControl());
        this.txtDateStart.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateEnd.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(this.txtDateStart.getControl());
        this.lblDateEnd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(this.lblDateEnd.getControl());
        this.txtDateEnd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbLogType1.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblLogType.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateStart.getControl());
        data.left = new FormAttachment(lblLogType.getControl());
        this.cmbLogType1.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbLogType2.getControl(), 0, 0x1000000);
        data.left = new FormAttachment((Control)this.cmbLogType1.getControl());
        lblLogTypeData.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateStart.getControl());
        data.left = new FormAttachment(lblLogTypeData.getControl());
        this.cmbLogType2.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbUser.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        this.lblUser.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbLogType1.getControl());
        data.left = new FormAttachment(this.lblUser.getControl());
        data.width = 100;
        this.cmbUser.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtLimit, 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblLimit.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbUser.getControl());
        data.left = new FormAttachment(lblLimit.getControl());
        this.txtLimit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtLimit);
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(100);
        this.btnSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSearch.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 0;
        this.lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblMessage.getControl());
        data.right = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.tblSearchCallbackComposite.setLayoutData((Object)data);
    }

    protected XSearchLogCriteria getSearchLogCriteria() {
        XSearchLogCriteria criteria = new XSearchLogCriteria();
        criteria.logType1 = (XLogType1)this.cmbLogType1.getSelection();
        criteria.logType2 = (XLogType2)this.cmbLogType2.getSelection();
        criteria.dateRange = new LocalDateRange(this.txtDateStart.getDate(), this.txtDateEnd.getDate(), RangeNotation.CLOSED);
        XBaseUser user = this.cmbUser.getSelection();
        criteria.idUser = user == null ? null : user.getId();
        criteria.limit = this.txtLimit.getSelection();
        return criteria;
    }

    protected void search() {
        try {
            this.tblSearchCallbackComposite.showLoadingComposite();
            XSearchLogCriteria criteria = this.getSearchLogCriteria();
            LogAccessorClient.getInstance().find(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)this.tblSearchCallbackComposite.getCallback(), criteria);
        }
        catch (Exception e) {
            this.tblSearchCallbackComposite.showErrorComposite(null, (Throwable)e);
        }
    }

    public XLogType1 getLogType1() {
        return (XLogType1)this.cmbLogType1.getSelection();
    }

    public XLogType2 getLogType2() {
        return (XLogType2)this.cmbLogType2.getSelection();
    }

    public LocalDate getStartDate() {
        return this.txtDateStart.getDate();
    }

    public LocalDate getEndDate() {
        return this.txtDateEnd.getDate();
    }

    public XBaseUser getUser() {
        return this.cmbUser.getSelection();
    }
}

