/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.labeldef;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCommonContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.preferences.labeldef.LabelDefControl;
import ca.infodata.ofys.ui.preferences.labeldef.TypeDataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class LabelDefEditor
extends BaseEditor {
    private static final Logger logger = Logger.getLogger(LabelDefEditor.class.getName());
    private LabelDefControl control;

    public String getEditorTitle() {
        XLabelResType type = this.getType();
        String s = String.valueOf(Messages.getString((String)"MOTS_CLES", (String[])new String[0])) + " ";
        s = type != null ? String.valueOf(s) + this.getType().toString() : String.valueOf(s) + "?";
        return s;
    }

    public Image getTitleImage() {
        return ResourceGetter.getImage((String)"images/label.gif");
    }

    private XLabelResType getType() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : (input.getDataObject() == null ? null : ((TypeDataObject)input.getDataObject()).type);
    }

    private XCommonContainer<XLabelDef> getContainer() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : (XCommonContainer)input.getCompleteDataObject();
    }

    public void setFocus() {
        this.setToolBarStatus();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/label.gif");
    }

    public void initDataOverride() {
        XCommonContainer<XLabelDef> completeDataObject = this.getContainer();
        TypeDataObject dataObject = (TypeDataObject)((EditorInput)this.getEditorInput()).getDataObject();
        if (completeDataObject != null) {
            this.initializeCompleteDataObject((EditableDataObject)completeDataObject);
        } else {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    if (response != null && response.getObj() instanceof List) {
                        final XCommonContainer container = new XCommonContainer((List)response.getObj());
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LabelDefEditor.this.initializeCompleteDataObject((EditableDataObject)container);
                            }
                        });
                    }
                }
            };
            try {
                CommonAccessorClient.getInstance().findLabelDef(dataObject.type, (ICallback)callback, Application.get().getGlobalInstances().getSession());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                callback.kill();
                logger.log(Level.SEVERE, "Erreur", e);
            }
        }
    }

    public void createMyControl(Composite parent) {
        this.control = new LabelDefControl(parent, (IBaseEditor)this, this.toolkit){

            protected int getInternalSectionStyle() {
                return 64;
            }
        };
        this.control.setFixedType(this.getType());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.control.setLayoutData(data);
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return CommonAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getEditorInput() != null && this.getContainer().isDirty();
    }

    public void setToolBarStatus() {
    }

    public void showDataObject() {
        XCommonContainer<XLabelDef> container = this.getContainer();
        if (container == null) {
            this.control.setStatusList((IEditableDataObjectList<XLabelDef>)new EditableDataObjectList());
        } else {
            this.control.setStatusList((IEditableDataObjectList<XLabelDef>)container.getObjects());
        }
        this.control.setFixedType(this.getType());
    }
}

