/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.labeldef;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.ui.controls.BaseSectionSwitchTable;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.controls.form.MySearchText;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.plugins.searchview.SimpleSearchShell;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.preferences.PreferencesPlugin;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LabelDefControl
extends BaseSectionSwitchTable<XLabelDef>
implements IPreValidator,
ListTable.IListTableModificationListener<XLabelDef> {
    private static final String OUI = Messages.getString((String)"OUI", (String[])new String[0]);
    private static final String NON = Messages.getString((String)"NON", (String[])new String[0]);
    protected MyText txtName;
    protected XLabelDef current;
    protected String error;
    private XLabelResType fixedType;
    private MySearchText txtFusions;
    private MyList<Integer> listFusions;
    private MyButton chkDeleted;

    public LabelDefControl(Composite parent, IBaseEditor parentEditor, FormToolkit toolkit) {
        super(parent, (IBaseEditor2)parentEditor, ListTable.HIDE_UP_DOWN | ListTable.TOP, toolkit);
        this.addTableModificationListener(this);
    }

    protected void createEditionControl(Composite parent) {
        MyLabel lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384, this.toolkit);
        this.txtName = new MyText(parent, this.toolkit, 4);
        ControlDecorator.decorateWithRequiredField((Control)this.txtName.getControl());
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.addColumn(100, "ID");
        }
        this.addColumn(200, "Nom");
        this.addColumn(100, "Est actif");
        this.addColumn(400, "Remplace...");
        this.setLabelProvider((ProviderAR)new ProviderAR<XLabelDef, String[]>(){

            public String[] get(XLabelDef a) {
                ArrayList<String> list = new ArrayList<String>(4);
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    list.add(String.valueOf(a.getId()));
                }
                list.add(a.getName());
                list.add(Boolean.TRUE.equals(a.getIsDeleted()) ? NON : OUI);
                if (a.getFusions().isEmpty()) {
                    list.add("");
                } else {
                    JoinList list2 = new JoinList(", ");
                    for (Integer id : a.getFusions()) {
                        list2.add((CharSequence)PreferencesPlugin.getDefault().getLabel(id).getName());
                    }
                    list.add(list2.toString());
                }
                return list.toArray(new String[list.size()]);
            }
        });
        MyLabel lblFusions = new MyLabel(parent, "Remplace les \u00e9tiquettes suivantes ... (fusion)", 0, this.toolkit);
        this.txtFusions = new MySearchText(parent, 45056, this.toolkit);
        this.txtFusions.setGroup((Object)1);
        this.txtFusions.setSearchOnFocusLost(false);
        this.txtFusions.setReferenceControl(new IReferenceControl(){

            public void callback(Object o) {
                System.out.println(o);
                XLabelDef e = this.parseResponse(o);
                this.processToGui(e);
            }

            void processToGui(XLabelDef e) {
                LabelDefControl.this.txtFusions.getMyText().clear();
                boolean add = LabelDefControl.this.current.getFusions().add(e.getId());
                LabelDefControl.this.current.setUpdated();
                if (add) {
                    LabelDefControl.this.listFusions.refresh();
                }
            }

            XLabelDef parseResponse(Object o) {
                if (o instanceof XLabelDef) {
                    return (XLabelDef)o;
                }
                return null;
            }
        });
        this.listFusions = new MyList(parent, 2562);
        this.listFusions.setLabelProvider((ProviderAR)new ProviderAR<Integer, String>(){

            public String get(Integer p) {
                return PreferencesPlugin.getDefault().getLabel(p).getName();
            }
        });
        this.listFusions.setComparator((Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                String name1 = PreferencesPlugin.getDefault().getLabel(o1).getName();
                String name2 = PreferencesPlugin.getDefault().getLabel(o2).getName();
                return StringUtils.compareAscii((String)name1, (String)name2);
            }
        });
        this.txtFusions.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject o) {
                if (o == null && LabelDefControl.this.listFusions.getSelectionCount() > 0) {
                    List selection = LabelDefControl.this.listFusions.getSelection2();
                    LabelDefControl.this.current.getFusions().removeAll(selection);
                    LabelDefControl.this.listFusions.refresh();
                }
            }
        });
        this.txtFusions.getMyText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    LabelDefControl.this.txtFusions.doSearch();
                }
            }
        });
        this.txtFusions.getBtnSearch().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSearchShell<XLabelDef> simpleSearchShell = new SimpleSearchShell<XLabelDef>(LabelDefControl.this.getShell()){

                    public List<XLabelDef> search(String s) {
                        List<XLabelDef> list = PreferencesPlugin.getDefault().findLabel(LabelDefControl.this.getFixedType());
                        Collections.sort(list, new Comparator<XLabelDef>(){

                            @Override
                            public int compare(XLabelDef o1, XLabelDef o2) {
                                String name1 = o1.getName();
                                String name2 = o2.getName();
                                return StringUtils.compareAscii((String)name1, (String)name2);
                            }
                        });
                        Iterator<XLabelDef> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            XLabelDef e = iterator.next();
                            if (e.getFusions().size() > 0) {
                                iterator.remove();
                            }
                            if (PreferencesPlugin.getDefault().getLabelReplacement(e) != null) {
                                iterator.remove();
                            }
                            if (e.equals((Object)(this).LabelDefControl.this.current)) {
                                iterator.remove();
                            }
                            if (!(this).LabelDefControl.this.current.getFusions().contains(e.getId())) continue;
                            iterator.remove();
                        }
                        return list;
                    }
                };
                simpleSearchShell.setLabelProvider((ProviderAR)new ProviderAR<XLabelDef, String>(){

                    public String get(XLabelDef e) {
                        return e.getName();
                    }
                });
                simpleSearchShell.hideTextControl();
                simpleSearchShell.setReferenceControl((Object)LabelDefControl.this.txtFusions.getReferenceControl());
                simpleSearchShell.open();
                simpleSearchShell.setSearchText(LabelDefControl.this.txtFusions.getMyText().getText());
                simpleSearchShell.doSearch();
            }
        });
        this.chkDeleted = new MyButton(parent, "Est actif", 32, this.toolkit);
        this.txtName.addModifyListener((ModifyListener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                LabelDefControl.this.current.setName(LabelDefControl.this.txtName.getText());
            }
        });
        this.chkDeleted.addSelectionListener((SelectionListener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                LabelDefControl.this.current.setIsDeleted(Boolean.valueOf(!LabelDefControl.this.chkDeleted.getSelection()));
            }
        });
        this.addListSelectionChangeListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLabelDef xtw = (XLabelDef)LabelDefControl.this.getFirstSelectedItem();
                if (xtw != null && xtw.getId() != null && xtw.getId() > -1 && Boolean.FALSE.equals(xtw.getIsDeleted())) {
                    LabelDefControl.this.setBtnDeleteEnabled(true);
                } else {
                    LabelDefControl.this.setBtnDeleteEnabled(false);
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblName.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.txtName.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        this.chkDeleted.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkDeleted.getControl());
        data.left = new FormAttachment(0);
        lblFusions.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblFusions.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.height = 100;
        this.listFusions.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblFusions.getControl());
        data.left = new FormAttachment(this.listFusions.getControl());
        this.txtFusions.setLayoutData((Object)data);
    }

    protected void showDataObject(XLabelDef a) {
        this.current = a;
        if (a == null) {
            this.txtName.clear();
            this.txtName.setToolTipText("");
            this.listFusions.setItems(null);
            this.chkDeleted.setSelection(false);
        } else {
            boolean readOnly = a.getId() != null && a.getId() < 0;
            this.txtName.setText(a.getName());
            this.listFusions.setItems((Collection)a.getFusions());
            this.chkDeleted.setSelection(!Boolean.TRUE.equals(a.getIsDeleted()));
            this.txtName.setEditable(!readOnly);
            if (Application.get().getGlobalInstances().inDebugMode() && a.getId() != null) {
                this.txtName.setToolTipText("eid=" + a.getId());
            }
            this.chkDeleted.setEnabled(!readOnly);
        }
    }

    protected XLabelDef initializeNewDataObject() {
        XLabelDef def = new XLabelDef();
        def.setType(this.fixedType);
        return def;
    }

    protected String getTitle() {
        return Messages.getString((String)"MOTS_CLES", (String[])new String[0]);
    }

    protected void setFirstFocus() {
        this.txtName.setFocus();
    }

    protected IPreValidator getPreValidatorNewInstance() {
        return this;
    }

    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XLabelDef def = (XLabelDef)dataObject;
        this.error = "";
        if (StringUtils.isBlank((CharSequence)def.getName())) {
            this.error = Messages.getString((String)"LabelDef.ENTREZ_LE_NOM_DU_MOT_CLE", (String[])new String[0]);
            return false;
        }
        if (def.getType() == null) {
            this.error = Messages.getString((String)"LabelDef.ENTREZ_LE_CONTEXTE_DU_MOT_CLE", (String[])new String[0]);
            return false;
        }
        if (def.getFusions().contains(def.getId())) {
            this.error = Messages.getString((String)"LabelDef.LE_MOT_CLE_0_NE_PEUT_ETRE_REMPLACER_PAR_LUI_MEME", (String[])new String[]{def.getName()});
            return false;
        }
        if (def.getFusions().size() > 0 && PreferencesPlugin.getDefault().getLabelReplacement(def) != null) {
            this.error = Messages.getString((String)"LabelDef.LE_MOT_CLE_0_FAIT_DEJA_PARTI_DUN_REMPLACEMENT", (String[])new String[]{def.getName()});
            return false;
        }
        if (def.getFusions().size() > 0) {
            for (Integer id : def.getFusions()) {
                XLabelDef d = PreferencesPlugin.getDefault().getLabel(id);
                XLabelDef replacedBy = PreferencesPlugin.getDefault().getLabelReplacement(d);
                if (replacedBy == null || replacedBy == def) continue;
                this.error = Messages.getString((String)"LabelDef.LE_MOT_CLE_0_FAIT_DEJA_PARTI_DUN_REMPLACEMENT", (String[])new String[]{d.getName()});
                return false;
            }
        }
        return true;
    }

    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        this.error = "";
        return dataObject.getId() == null || dataObject.getId() > -1;
    }

    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        boolean valid = dataObject.getId() == null || dataObject.getId() > -1;
        this.error = valid ? "" : Messages.getString((String)"CANNOT_MODIFY_THIS_LABEL", (String[])new String[0]);
        return valid;
    }

    public String getError() {
        return this.error;
    }

    public void saved(List<XLabelDef> lstBefore, List<XLabelDef> lstAfter, XLabelDef dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void updated(List<XLabelDef> lstBefore, List<XLabelDef> lstAfter, XLabelDef dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void orderUpdated(XLabelDef dataObject) {
        this.getParentEditor().checkDirty();
    }

    public void deleted(List<XLabelDef> lstBefore, List<XLabelDef> lstAfter, XLabelDef labo) {
        this.getParentEditor().checkDirty();
    }

    public XLabelResType getFixedType() {
        return this.fixedType;
    }

    public void setFixedType(XLabelResType fixedType) {
        this.fixedType = fixedType;
    }

    public void setStatusList(IEditableDataObjectList<XLabelDef> statusList) {
        Collections.sort(statusList, new Comparator<XLabelDef>(){

            @Override
            public int compare(XLabelDef o1, XLabelDef o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 != null && name1.startsWith("\u2606 ")) {
                    name1 = name1.substring(2);
                }
                if (name2 != null && name2.startsWith("\u2606 ")) {
                    name2 = name2.substring(2);
                }
                boolean deleted1 = Boolean.TRUE.equals(o1.getIsDeleted());
                boolean deleted2 = Boolean.TRUE.equals(o2.getIsDeleted());
                if (deleted1 && deleted2) {
                    return StringUtils.compareAscii((String)name1, (String)name2);
                }
                if (deleted1) {
                    return 1;
                }
                if (deleted2) {
                    return -1;
                }
                return StringUtils.compareAscii((String)name1, (String)name2);
            }
        });
        super.setStatusList(statusList);
    }
}

