/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.DsqFormatter;
import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.ui.encounter.medication.editor.PrescriptionByGroupContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ActivePrescriptionByGroupLabelProvider
extends ColumnLabelProvider {
    public String getText(Object element) {
        String text = null;
        if (element instanceof PrescriptionByGroupContentProvider.GroupItem) {
            PrescriptionByGroupContentProvider.GroupItem group = (PrescriptionByGroupContentProvider.GroupItem)element;
            if (group.children.size() > 0) {
                XPrescription prescription = group.children.get((int)0).prescription;
                text = XPrescriptionFormatter.getFormattedText((XPrescription)group.children.get((int)0).prescription, (boolean)this.isPrescriptionActive(prescription), (CPrescriptionFormatter.ShowMedFileDetail)CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM);
            } else {
                text = XPrescriptionFormatter.formatDrugNameWithBrackets((XDrugStrength)group.xPresription.getStrength());
            }
            if (group.children != null && group.children.size() > 0) {
                XPrescription p = group.children.get((int)0).prescription;
                text = String.valueOf(DsqFormatter.formatDsqPrefix((XPrescription)p)) + text;
            }
        } else if (element instanceof PrescriptionByGroupContentProvider.PrescriptionItem) {
            PrescriptionByGroupContentProvider.PrescriptionItem item = (PrescriptionByGroupContentProvider.PrescriptionItem)element;
            text = XPrescriptionFormatter.formatActive((XPrescription)((PrescriptionByGroupContentProvider.PrescriptionItem)element).prescription, (CPrescriptionFormatter.ShowMedFileDetail)CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM);
            text = String.valueOf(DsqFormatter.formatDsqPrefix((XPrescription)item.prescription)) + text;
            if (Application.get().getGlobalInstances().inDebugMode()) {
                text = item.prescription.getIdAnchor() + ", " + item.prescription.getId() + ", " + text;
            }
        }
        return text;
    }

    private boolean isPrescriptionActive(XPrescription prescription) {
        return prescription.isActiveNow();
    }
}

