/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.simple;

import ca.infodata.ofys.data.middle.dataobjects.XAddress;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.person.simple.IPatientController;
import ca.infodata.ofys.ui.person.simple.PatientProvider;
import ca.infodata.util1.ProviderR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;

public class PatientController
implements IPatientController {
    private ProviderR<XPatient> provider;

    public PatientController(XPatient patient) {
        this.provider = new PatientProvider(patient);
    }

    public PatientController(ProviderR<XPatient> provider) {
        this.provider = provider;
    }

    private XPatient getXPatient() {
        return (XPatient)this.provider.get();
    }

    @Override
    public IPatient getPatient() {
        return (IPatient)this.provider.get();
    }

    @Override
    public void setPatientRecordNumber(String text) {
        this.getXPatient().setPatientRecordNumber(text);
    }

    @Override
    public void setHealthInsuranceNumber(String text) {
        if (text != null) {
            text = text.replaceAll(" ", "");
        }
        this.getXPatient().setHealthInsuranceNumber(text);
    }

    @Override
    public void setExpirationCAM(String text) {
        this.getXPatient().setExpirationCAM(text);
    }

    @Override
    public void setTreatingProfessionnal(Integer idProfessionnal) {
        this.getXPatient().setTreatingProfessionnal(idProfessionnal);
    }

    @Override
    public void setLastName(String text) {
        this.getXPatient().setLastName(text);
    }

    @Override
    public void setFirstName(String text) {
        this.getXPatient().setFirstName(text);
    }

    @Override
    public void setBirthDate(LocalDate date) {
        this.getXPatient().setBirthDate(date);
    }

    @Override
    public void setGender(String gender) {
        this.getXPatient().setGender(gender);
    }

    @Override
    public void setNote(String text) {
        this.getXPatient().setNote(text);
    }

    private XContactInformation getOrCreateContact1() {
        XPatient xPatient = this.getXPatient();
        XContactInformation contactInformation1 = xPatient.getContactInformation1();
        if (contactInformation1 == null) {
            contactInformation1 = new XContactInformation();
            contactInformation1.initialize();
            xPatient.getLstContactInformation().add((IMinimalEditableDataObject)contactInformation1);
        }
        return contactInformation1;
    }

    private XAddress getOrCreateAddress1() {
        XPatient xPatient = this.getXPatient();
        XAddress address1 = xPatient.getAddress1();
        if (address1 == null) {
            address1 = new XAddress();
            address1.initialize();
            xPatient.getLstAddress().add((IMinimalEditableDataObject)address1);
        }
        return address1;
    }

    @Override
    public void deleteFirstContact() {
        XPatient xPatient = this.getXPatient();
        XContactInformation c = xPatient.getFirstContactInformation();
        if (c != null) {
            c.setDeleted();
            xPatient.setUpdated();
        }
    }

    public void deleteFirstAddress() {
        XPatient xPatient = this.getXPatient();
        XAddress c = xPatient.getAddress1();
        if (c != null) {
            c.setDeleted();
            xPatient.setUpdated();
        }
    }

    @Override
    public void setFirstContactInformation(String contact) {
        XPatient xPatient = this.getXPatient();
        if (StringUtils.isBlank((CharSequence)contact)) {
            if (xPatient.getContactInformation1() != null) {
                this.deleteFirstContact();
            }
        } else {
            XContactInformation c = this.getOrCreateContact1();
            c.setContact(contact);
            xPatient.setUpdated();
        }
    }

    @Override
    public void setFirstContactInformationType(Integer type) {
        XContactInformation c = this.getOrCreateContact1();
        boolean statusDeleted = c.isStatusDeleted();
        c.setTypeContact(type);
        if (statusDeleted) {
            c.setDeleted();
        }
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstContactInformationNote(String note) {
        XContactInformation c = this.getOrCreateContact1();
        boolean statusDeleted = c.isStatusDeleted();
        c.setNote(note);
        if (statusDeleted) {
            c.setDeleted();
        }
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstAddressStreet(String text) {
        XPatient xPatient = this.getXPatient();
        if (StringUtils.isBlank((CharSequence)text)) {
            if (xPatient.getAddress1() != null) {
                this.deleteFirstAddress();
            }
        } else {
            XAddress a = this.getOrCreateAddress1();
            a.setStreet(text);
            this.getXPatient().setUpdated();
        }
    }

    @Override
    public void setFirstAddressCountry(XCountry country) {
        XAddress a = this.getOrCreateAddress1();
        a.setCountry(country);
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstAddressProvince(XProvince province) {
        XAddress a = this.getOrCreateAddress1();
        a.setProvince(province);
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstAddressPostalCode(String text) {
        XAddress a = this.getOrCreateAddress1();
        a.setPostalCode(text);
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstAddressNote(String text) {
        XAddress a = this.getOrCreateAddress1();
        a.setNote(text);
        this.getXPatient().setUpdated();
    }

    @Override
    public void setFirstAddressCity(XCity city) {
        XAddress a = this.getOrCreateAddress1();
        a.setCity(city);
        this.getXPatient().setUpdated();
    }
}

